/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jitsimeet;

import org.jetbrains.annotations.NotNull;
import org.jitsi.xmpp.extensions.SafeParseIqProvider;
import org.jitsi.xmpp.extensions.jitsimeet.AbstractMuteIq;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public abstract class AbstractMuteIqProvider<T extends AbstractMuteIq>
extends SafeParseIqProvider<T> {
    @NotNull
    private final String namespace;

    public AbstractMuteIqProvider(@NotNull String namespace) {
        this.namespace = namespace;
    }

    protected abstract T createMuteIq();

    @Override
    protected T doParse(XmlPullParser parser) throws Exception {
        T iq;
        String namespace = parser.getNamespace();
        if (!this.namespace.equals(namespace)) {
            return null;
        }
        String rootElement = parser.getName();
        if ("mute".equals(rootElement)) {
            String actorStr;
            iq = this.createMuteIq();
            String jidStr = parser.getAttributeValue("", "jid");
            if (jidStr != null) {
                Jid jid = JidCreate.from((String)jidStr);
                ((AbstractMuteIq)((Object)iq)).setJid(jid);
            }
            if ((actorStr = parser.getAttributeValue("", "actor")) != null) {
                Jid actor = JidCreate.from((String)actorStr);
                ((AbstractMuteIq)((Object)iq)).setActor(actor);
            }
        } else {
            return null;
        }
        boolean done = false;
        while (!done) {
            switch (parser.next()) {
                case END_ELEMENT: {
                    String name = parser.getName();
                    if (!rootElement.equals(name)) break;
                    done = true;
                    break;
                }
                case TEXT_CHARACTERS: {
                    Boolean mute = Boolean.parseBoolean(parser.getText());
                    ((AbstractMuteIq)((Object)iq)).setMute(mute);
                    break;
                }
            }
        }
        return iq;
    }
}

