#
# This package is only kept for compatibility reasons with old software.
# Please use the real INN::Config Perl module instead.
#
# Author:       James Brister <brister@vix.com> -- berkeley-unix --
# Start Date:   Sat, 24 Aug 1996 22:08:19 +0200
# Project:      INN
# File:         innshellvars.pl
# Description:  Set up any and all variables that an INN perl script
#               might need.  Also sets umask.
#
# Various bug fixes, code and documentation improvements since then
# in 1998-2003, 2005, 2007-2010, 2013, 2018, 2021, 2022, 2024.

package inn;

# Tons of variables, also coming from innconfval run through an eval below.
no strict;    ## no critic (ProhibitProlongedStrictureOverride)

$ENV{'LC_CTYPE'} = "C";

$prefix = '/usr/pkg';
$exec_prefix = "${prefix}";
eval qx(/usr/pkg/libexec/inn/innconfval -p);

$newshome = $pathnews;
$spooldir = $pathspool;
$most_logs = $pathlog;
$ENV{'NEWSHOME'} = $pathnews;
$ENV{'SPOOLDIR'} = $spooldir;
$ENV{'MOST_LOGS'} = $most_logs;

$newsbin = $pathbin;
$newsetc = $pathetc;
$newslib = "${exec_prefix}/lib";
$innddir = $pathrun;
$locks = $pathrun;
$ENV{'NEWSBIN'} = $newsbin;
$ENV{'NEWSETC'} = $newsetc;
$ENV{'NEWSLIB'} = $newslib;
$ENV{'INNDDIR'} = $innddir;
$ENV{'LOCKS'} = $locks;

$errlog = "${most_logs}/errlog";
$log = "${most_logs}/news";

$archivedir = $patharchive;
$spool = $patharticles;
$batch = $pathoutgoing;
$incoming = $pathincoming;
$overviewdir = $pathoverview;
$spoolnews = $pathincoming;
$badnews = "$pathincoming/bad";

$active = "${pathdb}/active";
$activetimes = "${pathdb}/active.times";
$ctlfile = "${newsetc}/control.ctl";
$ctlwatch = "${newsetc}/innwatch.ctl";
$history = "${pathdb}/history";
$newactive = "${pathdb}/active.tmp";
$newsfeeds = "${newsetc}/newsfeeds";
$newsgroups = "${pathdb}/newsgroups";
$oldactive = "${pathdb}/active.old";
$path_motd_innd = "${newsetc}/motd.innd";
$path_motd_nnrpd = "${newsetc}/motd.nnrpd";
$path_motd = "${path_motd_nnrpd}";
$expirectl = "${newsetc}/expire.ctl";
$localgroups = "$newsetc/localgroups";

$controlprogs = $pathcontrol;
$innconfval = "${newsbin}/innconfval";
$innd = "${newsbin}/innd";
$innwatch = "${newsbin}/innwatch";
$inews = "${newsbin}/inews";
$rnews = "${newsbin}/rnews";
$perl_startup_innd = "$pathfilter/startup_innd.pl";
$perl_filter_innd = "$pathfilter/filter_innd.pl";
$perl_filter_nnrpd = "$pathfilter/filter_nnrpd.pl";
$python_filter_innd = "$pathfilter/filter_innd.py";
$path_python_inn_module = "$pathfilter/INN.py";
$path_tcl_startup = "$pathfilter/startup.tcl";
$path_tcl_filter = "$pathfilter/filter.tcl";

$daily = "${locks}/LOCK.news.daily";

$newscontrol = "${innddir}/control";
$nntpconnect = "${innddir}/nntpin";
$serverpid = "${innddir}/innd.pid";
$innwstatus = "${innddir}/innwatch.status";
$watchpid = "${innddir}/innwatch.pid";

$awk = '/usr/bin/awk';
$sed = '/usr/bin/sed';
$inndf = "${newsbin}/inndf";
$egrep = '/usr/bin/egrep';
$perl = '/usr/pkg/bin/perl';
$gpgv = '/usr/pkg/bin/gpgv2';
$gpg = '/usr/pkg/bin/gpg2';
$pgp = '';
$sort = '/usr/bin/sort';
$getftp = "/usr/pkg/libexec/inn/simpleftp";
$gethttp = "/usr/pkg/libexec/inn/simpleftp";
$uustat = '';
$uux = 'uux';

$bzip2 = '/usr/bin/bzip2';
$compress = '/usr/bin/compress';
$gzip = '/usr/bin/gzip';
$uncompress = '/usr/bin/gzip -d';
$log_compress = '/usr/bin/gzip';
$z = '.gz';

if ($ovmethod && $ovmethod eq "ovdb") {
    $ENV{'DB_HOME'} = $pathoverview;
}

($tempsock = "${innddir}/ctlinndXXXXXX") =~ s!.*/(.*)XXXXXX$!$1*!;
($tempsockdir = "${innddir}/ctlinndXXXXXX") =~ s!/[^/]*$!!;

$newsmaster = 'usenet';
$newsuser = ${runasuser};
$newsgroup = ${runasgroup};

#<<V  code skipping because perltidy expects numbers.
$filemode = 0664;
$inewsmode = 02555;
$rnewsmode = 0500;
#>>V

$do_dbz_tagged_hash = 'DONT';
#<<V  code skipping because perltidy expects numbers.
$gpg_has_allow_weak_digest_algos_flag
  = 1;
#>>V

$tmpdir = ${pathtmp};
$ENV{'TMPDIR'} = ${pathtmp};

$spooltemp = ${pathtmp};

$newslbin = "${newshome}/local";
$ENV{'NEWSLBIN'} = ${newslbin};

#<<V  code skipping because perltidy expects numbers.
umask 02;
$umask = 02;
#>>V

$syslog_facility = lc("LOG_NEWS");
$syslog_facility =~ s/log_//;

$path = $ENV{'PATH'} || '';
$path = "${newslbin}:${newsbin}:${path}:/bin:/usr/bin";
$ENV{'PATH'} = $path;

$home = ${pathnews};

##  Load another script that can override or add variables.
if (-x "${pathetc}/innshellvars.pl.local") {
    do "${pathetc}/innshellvars.pl.local";
}

1;
