/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.LocalVariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalVariantMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;

public final class DefaultLocalVariantGraphResolveMetadata
implements LocalVariantGraphResolveMetadata,
LocalVariantArtifactGraphResolveMetadata {
    private final String name;
    private final String description;
    private final ComponentIdentifier componentId;
    private final boolean transitive;
    private final ImmutableAttributes attributes;
    private final boolean deprecatedForConsumption;
    private final ImmutableCapabilities capabilities;
    private final CalculatedValue<VariantDependencyMetadata> dependencies;
    private final Set<LocalVariantMetadata> variants;
    private final CalculatedValueContainerFactory factory;
    private final CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>> artifacts;

    public DefaultLocalVariantGraphResolveMetadata(String name, String description, ComponentIdentifier componentId, boolean transitive, ImmutableAttributes attributes, ImmutableCapabilities capabilities, boolean deprecatedForConsumption, CalculatedValue<VariantDependencyMetadata> dependencies, Set<LocalVariantMetadata> variants, CalculatedValueContainerFactory factory, CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>> artifacts) {
        this.name = name;
        this.description = description;
        this.componentId = componentId;
        this.transitive = transitive;
        this.attributes = attributes;
        this.capabilities = capabilities;
        this.deprecatedForConsumption = deprecatedForConsumption;
        this.dependencies = dependencies;
        this.variants = variants;
        this.factory = factory;
        this.artifacts = artifacts;
    }

    @Override
    public LocalVariantGraphResolveMetadata copyWithTransformedArtifacts(Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer) {
        ImmutableSet.Builder copiedVariants = ImmutableSet.builder();
        for (LocalVariantMetadata oldVariant : this.variants) {
            CalculatedValueContainer newArtifacts = this.factory.create(Describables.of((Object)oldVariant.asDescribable(), (Object)"artifacts"), context -> (ImmutableList)oldVariant.prepareToResolveArtifacts().getArtifacts().stream().map(arg_0 -> ((Transformer)artifactTransformer).transform(arg_0)).collect(ImmutableList.toImmutableList()));
            copiedVariants.add((Object)new LocalVariantMetadata(oldVariant.getName(), oldVariant.getIdentifier(), oldVariant.asDescribable(), oldVariant.getAttributes(), oldVariant.getCapabilities(), (CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>>)newArtifacts));
        }
        CalculatedValueContainer transformedArtifacts = this.factory.create(Describables.of((Object)this.description, (Object)"artifacts"), context -> (ImmutableList)this.prepareToResolveArtifacts().getArtifacts().stream().map(arg_0 -> ((Transformer)artifactTransformer).transform(arg_0)).collect(ImmutableList.toImmutableList()));
        return new DefaultLocalVariantGraphResolveMetadata(this.name, this.description, this.componentId, this.transitive, this.attributes, this.capabilities, this.deprecatedForConsumption, this.dependencies, (Set<LocalVariantMetadata>)copiedVariants.build(), this.factory, (CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>>)transformedArtifacts);
    }

    public String toString() {
        return Describables.of((Object)this.componentId, (Object)"variant", (Object)this.name).getDisplayName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getConfigurationName() {
        return this.name;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.attributes;
    }

    public Set<LocalVariantMetadata> getArtifactVariants() {
        return this.variants;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecatedForConsumption;
    }

    public List<? extends LocalOriginDependencyMetadata> getDependencies() {
        this.dependencies.finalizeIfNotAlready();
        return ((VariantDependencyMetadata)this.dependencies.get()).dependencies;
    }

    @Override
    public Set<LocalFileDependencyMetadata> getFiles() {
        this.dependencies.finalizeIfNotAlready();
        return ((VariantDependencyMetadata)this.dependencies.get()).files;
    }

    public ImmutableList<ExcludeMetadata> getExcludes() {
        this.dependencies.finalizeIfNotAlready();
        return ((VariantDependencyMetadata)this.dependencies.get()).excludes;
    }

    @Override
    public LocalVariantArtifactGraphResolveMetadata prepareToResolveArtifacts() {
        this.artifacts.finalizeIfNotAlready();
        for (LocalVariantMetadata variant : this.variants) {
            variant.prepareToResolveArtifacts();
        }
        return this;
    }

    public ImmutableList<LocalComponentArtifactMetadata> getArtifacts() {
        return (ImmutableList)this.artifacts.get();
    }

    @Override
    public ImmutableCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public boolean isExternalVariant() {
        return false;
    }

    public static class VariantDependencyMetadata {
        public final List<LocalOriginDependencyMetadata> dependencies;
        public final Set<LocalFileDependencyMetadata> files;
        public final ImmutableList<ExcludeMetadata> excludes;

        public VariantDependencyMetadata(List<LocalOriginDependencyMetadata> dependencies, Set<LocalFileDependencyMetadata> files, List<ExcludeMetadata> excludes) {
            this.dependencies = dependencies;
            this.files = files;
            this.excludes = ImmutableList.copyOf(excludes);
        }
    }
}

