/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.store;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.Store;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.internal.time.Timer;

public class CachedStoreFactory<T>
implements Closeable {
    private static final Logger LOG = Logging.getLogger(CachedStoreFactory.class);
    private static final int CACHE_SIZE = Integer.getInteger("org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.cacheSize", 100);
    private static final int CACHE_EXPIRY = Integer.getInteger("org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.cacheExpiryMs", 10000);
    private final Cache<Object, T> cache;
    private final Stats stats;
    private final String displayName;

    public CachedStoreFactory(String displayName) {
        this.displayName = displayName;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)CACHE_SIZE).expireAfterAccess((long)CACHE_EXPIRY, TimeUnit.MILLISECONDS).build();
        this.stats = new Stats();
    }

    public Store<T> createCachedStore(Object id) {
        return new SimpleStore<T>(this.cache, id, this.stats);
    }

    @Override
    public void close() {
        LOG.debug(this.displayName + " cache closed. Cache reads: " + this.stats.readsFromCache + ", disk reads: " + this.stats.readsFromDisk + " (avg: " + TimeFormatting.formatDurationVerbose((long)this.stats.getDiskReadsAvgMs()) + ", total: " + TimeFormatting.formatDurationVerbose((long)this.stats.diskReadsTotalMs.get()) + ")");
    }

    private static class SimpleStore<T>
    implements Store<T> {
        private final Cache<Object, T> cache;
        private final Object id;
        private final Stats stats;

        public SimpleStore(Cache<Object, T> cache, Object id, Stats stats) {
            this.cache = cache;
            this.id = id;
            this.stats = stats;
        }

        public T load(Supplier<T> createIfNotPresent) {
            Object out = this.cache.getIfPresent(this.id);
            if (out != null) {
                this.stats.readFromCache();
                return (T)out;
            }
            Timer timer = Time.startTimer();
            T value = createIfNotPresent.get();
            this.stats.readFromDisk(timer.getElapsedMillis());
            this.cache.put(this.id, value);
            return value;
        }
    }

    private static class Stats {
        private final AtomicLong diskReadsTotalMs = new AtomicLong();
        private final AtomicLong readsFromCache = new AtomicLong();
        private final AtomicLong readsFromDisk = new AtomicLong();

        private Stats() {
        }

        public void readFromDisk(long duration) {
            this.readsFromDisk.incrementAndGet();
            this.diskReadsTotalMs.addAndGet(duration);
        }

        public void readFromCache() {
            this.readsFromCache.incrementAndGet();
        }

        public long getDiskReadsAvgMs() {
            if (this.readsFromDisk.get() == 0L) {
                return 0L;
            }
            return this.diskReadsTotalMs.get() / this.readsFromDisk.get();
        }
    }
}

