/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationContainer;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentProvider;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveStateFactory;
import org.gradle.internal.model.ModelContainer;

public class DefaultProjectLocalComponentProvider
implements LocalComponentProvider {
    private final LocalComponentGraphResolveStateFactory resolveStateFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public DefaultProjectLocalComponentProvider(LocalComponentGraphResolveStateFactory resolveStateFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.resolveStateFactory = resolveStateFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    @Override
    public LocalComponentGraphResolveState getComponent(ProjectState projectState) {
        projectState.ensureConfigured();
        return (LocalComponentGraphResolveState)projectState.fromMutableState(p -> this.getLocalComponentState(projectState, (ProjectInternal)p));
    }

    private LocalComponentGraphResolveState getLocalComponentState(ProjectState projectState, ProjectInternal project) {
        Module module = ((DependencyMetaDataProvider)project.getServices().get(DependencyMetaDataProvider.class)).getModule();
        ModuleVersionIdentifier moduleVersionIdentifier = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
        ProjectComponentIdentifier componentIdentifier = projectState.getComponentIdentifier();
        AttributesSchemaInternal schema = (AttributesSchemaInternal)project.getDependencies().getAttributesSchema();
        DefaultConfigurationContainer configurations = (DefaultConfigurationContainer)project.getConfigurations();
        return this.resolveStateFactory.stateFor((ModelContainer<?>)projectState, (ComponentIdentifier)componentIdentifier, moduleVersionIdentifier, configurations, module.getStatus(), schema);
    }
}

