/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.thumbnail;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtils;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gui.GuiBoardDrawer;
import net.sf.gogui.gui.GuiField;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.utils.FileUtils;
import net.sf.gogui.utils.Platform;
import net.sf.gogui.version.Version;

public final class Thumbnail {
    private final boolean m_verbose;
    private String m_description;
    private String m_lastError;
    private File m_lastThumbnail;
    private final GuiBoardDrawer m_drawer;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Thumbnail(boolean bl) {
        this.m_verbose = bl;
        this.m_drawer = new GuiBoardDrawer(false);
    }

    public static boolean checkThumbnailSupport() {
        File file = Thumbnail.getNormalDir();
        if (!file.exists() && Platform.isWindows()) {
            file.mkdirs();
        }
        return file.exists();
    }

    public boolean create(File file) {
        return this.create(file, null, 128, true);
    }

    public boolean create(File file, File file2, int n, boolean bl) {
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        this.m_lastThumbnail = null;
        this.m_lastError = "";
        try {
            long l;
            Object object;
            Object object2;
            int n2;
            int n3;
            this.log("File: " + file);
            URI uRI = FileUtils.getURI(file);
            if (uRI == null) {
                this.m_lastError = "Invalid file name";
                return false;
            }
            this.log("URI: " + uRI);
            String string = Thumbnail.getMD5(uRI.toString());
            if (this.m_verbose) {
                this.log("MD5: " + string);
            }
            ArrayList arrayList = new ArrayList();
            this.m_description = "";
            Board board = this.readFile(file, arrayList);
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                board.play((Move)arrayList.get(n3));
            }
            n3 = board.getSize();
            GuiField[][] guiFieldArray = new GuiField[n3][n3];
            for (n2 = 0; n2 < n3; ++n2) {
                for (int i = 0; i < n3; ++i) {
                    guiFieldArray[n2][i] = new GuiField();
                    object2 = board.getColor(GoPoint.get(n2, i));
                    guiFieldArray[n2][i].setColor((GoColor)object2);
                }
            }
            n2 = n;
            if (bl) {
                n2 = Math.min(n * n3 / 19, n);
            }
            if (n2 < 256) {
                object = this.getImage(guiFieldArray, 2 * n2, 2 * n2);
                object2 = this.createImage(n2, n2);
                Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
                Image image = ((Image)object).getScaledInstance(n2, n2, 4);
                graphics2D.drawImage(image, 0, 0, null);
                object = object2;
            } else {
                object = this.getImage(guiFieldArray, n2, n2);
            }
            if (file2 == null) {
                file2 = new File(Thumbnail.getNormalDir(), string + ".png");
            }
            if ((l = file.lastModified() / 1000L) == 0L) {
                System.err.println("Could not get last modification time: " + file);
                return false;
            }
            this.writeImage((BufferedImage)object, file2, uRI, l);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_lastError = "File not found: " + file;
            this.log(this.m_lastError);
        }
        catch (IOException iOException) {
            this.m_lastError = iOException.getMessage();
            this.log(this.m_lastError);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.m_lastError = "No MD5 message digest found";
            this.log(this.m_lastError);
        }
        catch (SgfReader.SgfError sgfError) {
            this.m_lastError = sgfError.getMessage();
            this.log(this.m_lastError);
        }
        return false;
    }

    public String getLastDescription() {
        return this.m_description;
    }

    public String getLastError() {
        return this.m_lastError;
    }

    public File getLastThumbnail() {
        return this.m_lastThumbnail;
    }

    private BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 1);
    }

    private void addMeta(org.w3c.dom.Node node, String string, String string2) {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
        iIOMetadataNode2.setAttribute("value", string2);
        iIOMetadataNode2.setAttribute("keyword", string);
        iIOMetadataNode2.setAttribute("encoding", Locale.getDefault().toString());
        iIOMetadataNode2.setAttribute("language", "en");
        iIOMetadataNode2.setAttribute("compression", "none");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        node.appendChild(iIOMetadataNode);
    }

    private Board readFile(File file, ArrayList arrayList) throws FileNotFoundException, SgfReader.SgfError {
        FileInputStream fileInputStream = new FileInputStream(file);
        SgfReader sgfReader = new SgfReader(fileInputStream, file.toString(), null, 0L);
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            this.log(iOException.getMessage());
        }
        GameTree gameTree = sgfReader.getGameTree();
        GameInformation gameInformation = gameTree.getGameInformation();
        int n = gameInformation.m_boardSize;
        this.m_description = gameInformation.suggestGameName();
        if (this.m_description == null) {
            this.m_description = "";
        }
        Board board = new Board(n);
        for (Node node = gameTree.getRoot(); node != null; node = node.getChild()) {
            arrayList.addAll(NodeUtils.getAllAsMoves(node));
            if (node.getNumberAddBlack() > 0 && node.getNumberAddWhite() > 0) break;
        }
        return board;
    }

    private BufferedImage getImage(GuiField[][] guiFieldArray, int n, int n2) {
        BufferedImage bufferedImage = this.createImage(n, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GuiUtils.setAntiAlias(graphics2D);
        this.m_drawer.draw(graphics2D, guiFieldArray, n, false);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static String getMD5(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = messageDigest.digest(string.getBytes("US-ASCII"));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i] >> 4 & 0xF));
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    private void log(String string) {
        if (!this.m_verbose) {
            return;
        }
        System.err.println(string);
    }

    private static File getNormalDir() {
        String string = System.getProperty("user.home", "");
        return new File(new File(string, ".thumbnails"), "normal");
    }

    private void writeImage(BufferedImage bufferedImage, File file, URI uRI, long l) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix("png");
        ImageWriter imageWriter = iterator.next();
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(bufferedImage);
        IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, null);
        String string = "javax_imageio_1.0";
        org.w3c.dom.Node node = iIOMetadata.getAsTree(string);
        this.addMeta(node, "Thumb::URI", uRI.toString());
        this.addMeta(node, "Thumb::MTime", Long.toString(l));
        this.addMeta(node, "Thumb::Mimetype", "application/x-go-sgf");
        if (!this.m_description.equals("")) {
            this.addMeta(node, "Description", this.m_description);
        }
        this.addMeta(node, "Software", "GoGui " + Version.get());
        try {
            iIOMetadata.mergeTree(string, node);
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return;
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(null, new IIOImage(bufferedImage, null, iIOMetadata), null);
        this.m_lastThumbnail = file;
    }

    static {
        $assertionsDisabled = !Thumbnail.class.desiredAssertionStatus();
    }
}

