/*
 NAME
 	tbasic.h - type definition
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(TBASIC_H_INCLUDED)
#define TBASIC_H_INCLUDED

#include <coconut/dconfig.h>
#include <sys/types.h>

/* basic data type 
 */
  typedef u_int8_t	byte ;

  typedef int		boolean ;
  typedef unsigned int	hashkey_t ;

/* pointer <-> integer conversion */
# define PTR2INT(P)	((ptrdiff_t) P)
# define INT2PTR(I)	((void *) I)

/* character
 */
  typedef unsigned char	utf8_char ;

/* error type
 */
# define	ERR(CODE, NO, MSG)	CODE,
  typedef enum {
#	include <coconut/derror.h>
	LAST_err
  } error_code_t ;

  /* the definition of ERR conflicts with ncurses header files */
# undef	ERR

  typedef enum {
  	normal_exit	= 0,
	error_exit,
	error_counter_exit
  } exit_code_t ;

# define error2ExitCode(ERR) ((ERR) == no_error ? normal_exit : error_exit) 

/* basic object types
 */
  /* the status of objects */
  typedef enum {
  	obj_status_unknown		= '?',
	obj_status_uninit		= 'u',
  	obj_status_constant		= 'c',
	obj_status_not_changed		= 'n',
	obj_status_modified		= 'm',
	obj_status_now_changing		= 'x'
  } obj_status_t ;

# define	OBJSTATUS2CHAR(s)	((char) s)
# define	HAS_VALUE_OBJ_STATUS(s)	\
	  (((s) == obj_status_constant) || \
	   ((s) == obj_status_not_changed) || \
	   ((s) == obj_status_modified))

  /* data types */
  typedef enum {
	valtype_unknown	= 0x0000,
	valtype_boolean	= 0x0010,
	valtype_int8	= 0x0080,
	valtype_u_int8	= 0x0081,
	valtype_int16	= 0x0100,
	valtype_u_int16	= 0x0101,
	valtype_int32	= 0x0200,
	valtype_u_int32	= 0x0201,
	valtype_int64	= 0x0400,
	valtype_u_int64	= 0x0401,
	valtype_float	= 0x1000,
	valtype_double	= 0x2000,
	valtype_string	= 0x4000,
	valtype_pointer	= 0x8000
  } valtype_t ;

# define	VALTYPE_INT		valtype_int32
# define	VALTYPE_REAL		valtype_double
# define	IS_LONG_VALUE_TYPE(t)	\
			((t)==valtype_int64 || (t)==valtype_u_int64)
# define	IS_UNSIGNED_VALUE_TYPE(t)	((t) & 0x0001) 

  typedef enum {
	unknown_format	= 0,
	char_format	= 1,	/* treat as a character */
	bin_format	= 2,
	oct_format	= 8,
	dec_format	= 10,
	hex_format	= 16
  } int_format_t ;

/* file handling
 */
  typedef enum {
	not_open		= 0x0000,
	read_open		= 0x0001,
	write_open		= 0x0002,
	read_write_open		= 0x0003,
	append_open		= 0x0012,
	temp_open		= 0x0022
  } open_t ;

#define	IS_READABLE_OPEN(mode)	(((u_int) mode) & ((u_int) read_open))
#define	IS_WRITABLE_OPEN(mode)  (((u_int) mode) & ((u_int) write_open)) 

/* function prototypes */
typedef void * (*malloc_func_t)(size_t size) ;
typedef void * (*realloc_func_t)(void * ptr, size_t size) ;
typedef void (*dealloc_func_t)(void * data) ;
typedef void (*print_func_t)(const void * data, const void * param) ;

/* the NON-NULL result value means do not contiue the loop */
typedef const void * (*foreach_func_t)(const void * data, const void * p1, 
  const void *p2) ;
typedef const void * (*foreach_hash_func_t)(const void * key, const void * data,
  const void * p1, const void *p2) ;

/* misc
 */
  typedef enum {
  	selection_undetermined,
	selection_rejected,
	selection_accepted
  } selection_t ;

  typedef boolean (*condition_func_t)(selection_t sel) ;

# define IS_REJECTED(typ) 	((typ) == selection_rejected)
# define IS_NOT_REJECTED(typ)	((typ) != selection_rejected)
# define IS_ACCEPTED(typ) 	((typ) == selection_accepted)

  typedef enum {
  	note_message,
	warning_message,
	error_message
  } message_t ;

#endif /* defined(TBASIC_H_INCLUDED) */

