#!/usr/bin/python
#
# Find when an ATF test started failing, by running the full
# test suite and extracting the result from a single test.
# Supports noemu.  See find-test-failure-2.py for an faster
# alternative when not using noemu.
#

from bracket import *

use_current_repository()

def find_atf_test_change(tp, tc, begin, end, sense, confirm = False):
    name = re.sub(r'/', '_', tp) + '_' + tc
    print(name)

    def f(ts):
        return atf_test_results(ts)[(tp, tc)]
    
    find_change(begin, end,
		TestOp(f,
		       [test_completed_op],
		       name = name),
                sense,
                confirm)

def find_atf_test_failure(tp, tc, begin, end, confirm = False):
    find_atf_test_change(tp, tc, begin, end, False, confirm)
    
def find_atf_test_fix(tp, tc, begin, end, confirm = False):
    find_atf_test_change(tp, tc, begin, end, True, confirm)

#(tp, tc, begin, end) = sys.argv

#find_atf_test_failure('rump/rumpkern/t_sp', 'stress_long',
#    rcs2ts('2012.01.04.17.26.21'),
#    rcs2ts('2012.02.05.21.46.37'))

#find_atf_test_failure('modules/t_modctl', 'cmd_load',
#    rcs2ts('2015.10.21.09.25.16'),
#    rcs2ts('2015.10.22.23.17.08'))

#2015.10.17.12.02.44/test.log.gz:    cmd_load: [0.522263s] Passed.
#2015.11.05.10.43.42/test.log.gz:    cmd_load: kobj_checksyms, 884: [k_helper]: linker error: symbol `sysctl_teardown' not found

#find_atf_test_failure('fs/puffs/t_fuzz', 'mountfuzz8',
#    rcs2ts('2015.12.06.02.04.10'),
#    rcs2ts('2015.12.06.09.38.21'))

#find_atf_test_failure('usr.bin/vmstat/t_vmstat', 'opt_s',
#    rcs2ts('2015.08.12.07.53.58'),
#    rcs2ts('2015.08.15.20.57.37'))

#find_atf_test_failure('include/t_limits', 'posix',
#    rcs2ts('2016.02.09.08.32.12'),
#    rcs2ts('2016.02.28.16.06.27'))

#find_atf_test_failure('libexec/ld.elf_so/t_ifunc', 'rtld_ifunc',
#    rcs2ts('2017.08.08.01.56.10'),
#    rcs2ts('2017.08.11.00.58.37'),
#    confirm = False)

#find_atf_test_failure('lib/libpthread/t_resolv', 'resolv',
#    rcs2ts('2016.03.01.10.11.07'),
#    rcs2ts('2017.03.01.13.05.11'),
#    confirm = False)

#find_atf_test_failure('lib/libc/sys/t_ptrace_wait3', 'traceme_vfork_crash_bus',
#                      rcs2ts('2018.05.29.14.29.53'),
#                      rcs2ts('2018.06.01.08.04.57'),
#                      confirm = True)

#find_atf_test_failure('usr.bin/cc/t_asan_off_by_one', 'off_by_one',
#                      rcs2ts('2018.06.14.16.17.18'),
#                      rcs2ts('2018.06.15.01.37.40'),
#                      confirm = False)

#find_atf_test_fix('rump/rumpkern/t_sp', 'stress_long',
#    rcs2ts('2018.07.05.13.11.58'),
#    rcs2ts('2018.09.05.06.27.07'),
#    confirm = False)

#find_atf_test_failure(
#    'fs/vfs/t_io', 'zfs_extendfile_append',
#    rcs2ts('2018.09.24.05.47.33'),
#    rcs2ts('2018.09.29.21.53.38'),
#    confirm = False)

#find_atf_test_fix('fs/vfs/t_vnops', 'zfs_create_exist',
#                  rcs2ts('2018.10.21.07.08.40'),
#                  rcs2ts('2018.11.06.06.17.29'),
#                  confirm = False)

# PR 53422
#find_atf_test_fix('fs/vfs/t_renamerace', 'zfs_renamerace',
#                  rcs2ts('2018.11.24.20.31.29'),
#                  rcs2ts('2018.12.01.18.25.39'),
#                  confirm = False)

#find_atf_test_failure('rump/rumpkern/t_sp', 'stress_short',
#                  rcs2ts('2019.03.01.08.15.23'),
#                  rcs2ts('2019.03.01.11.06.57'),
#                  confirm = True)

# PR 54062
#find_atf_test_failure('lib/libc/sys/t_sendmmsg', 'sendmmsg_basic',
#                  rcs2ts('2019.03.10.15.45.26'),
#                  rcs2ts('2019.03.12.11.05.09'),
#                  confirm = True)

#find_atf_test_failure('lib/librumphijack/t_tcpip', 'nfs_autoload',
#                  rcs2ts('2017.04.11.14.30.33'),
#                  rcs2ts('2017.04.11.21.15.57'),
#                  confirm = False)

#find_atf_test_failure('fs/vfs/t_vnops', 'p2k_ffs_rename_reg_nodir',
#                  rcs2ts('2019.06.19.23.35.55'),
#                  rcs2ts('2019.06.20.15.59.40'),
#                  confirm = False)

find_atf_test_failure('rump/rumpkern/t_sp', 'stress_short',
                      rcs2ts('2020.01.09.01.38.34'),
                      rcs2ts('2020.01.17.00.39.27'),
                      confirm = False)
