/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractServletInputStream
extends ServletInputStream {
    private static final Log log = LogFactory.getLog(AbstractServletInputStream.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11.upgrade");
    private volatile boolean closeRequired = false;
    private volatile Boolean ready = Boolean.TRUE;
    private volatile ReadListener listener = null;
    private volatile ClassLoader applicationLoader = null;

    public final boolean isFinished() {
        if (this.listener == null) {
            throw new IllegalStateException(sm.getString("upgrade.sis.isFinished.ise"));
        }
        return false;
    }

    public final boolean isReady() {
        if (this.listener == null) {
            throw new IllegalStateException(sm.getString("upgrade.sis.isReady.ise"));
        }
        if (this.ready != null) {
            return this.ready;
        }
        try {
            this.ready = this.doIsReady();
        }
        catch (IOException e) {
            this.onError(e);
        }
        return this.ready;
    }

    public final void setReadListener(ReadListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sis.readListener.null"));
        }
        if (this.listener != null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sis.readListener.set"));
        }
        this.listener = listener;
        this.applicationLoader = Thread.currentThread().getContextClassLoader();
        this.ready = null;
    }

    public final int read() throws IOException {
        this.preReadChecks();
        return this.readInternal();
    }

    public final int readLine(byte[] b, int off, int len) throws IOException {
        int c;
        this.preReadChecks();
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = this.readInternal()) != -1) {
            b[off++] = (byte)c;
            if (c != 10 && ++count != len) continue;
        }
        return count > 0 ? count : -1;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        this.preReadChecks();
        try {
            return this.doRead(this.listener == null, b, off, len);
        }
        catch (IOException ioe) {
            this.closeRequired = true;
            throw ioe;
        }
    }

    public void close() throws IOException {
        this.closeRequired = true;
        this.doClose();
    }

    private void preReadChecks() {
        if (!(this.listener == null || this.ready != null && this.ready.booleanValue())) {
            throw new IllegalStateException(sm.getString("upgrade.sis.read.ise"));
        }
        this.ready = null;
    }

    private int readInternal() throws IOException {
        int result;
        byte[] b = new byte[1];
        try {
            result = this.doRead(this.listener == null, b, 0, 1);
        }
        catch (IOException ioe) {
            this.closeRequired = true;
            throw ioe;
        }
        if (result == 0) {
            return -1;
        }
        if (result == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onAllDataRead() throws IOException {
        if (this.listener == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader originalClassLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.applicationLoader);
            this.listener.onAllDataRead();
        }
        finally {
            thread.setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onDataAvailable() {
        if (this.listener == null) {
            return;
        }
        this.ready = Boolean.TRUE;
        Thread thread = Thread.currentThread();
        ClassLoader originalClassLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.applicationLoader);
            this.listener.onDataAvailable();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.onError(t);
        }
        finally {
            thread.setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onError(Throwable t) {
        block9: {
            if (this.listener == null) {
                return;
            }
            Thread thread = Thread.currentThread();
            ClassLoader originalClassLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this.applicationLoader);
                this.listener.onError(t);
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable((Throwable)t2);
                log.warn((Object)sm.getString("upgrade.sis.onErrorFail"), t2);
            }
            finally {
                thread.setContextClassLoader(originalClassLoader);
            }
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)sm.getString("upgrade.sis.errorCloseFail"), (Throwable)ioe);
            }
        }
        this.ready = Boolean.FALSE;
    }

    final boolean isCloseRequired() {
        return this.closeRequired;
    }

    protected abstract boolean doIsReady() throws IOException;

    protected abstract int doRead(boolean var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void doClose() throws IOException;
}

