/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate;

import com.datastax.driver.core.TokenRange;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.cassandra.stress.settings.StressSettings;

public class TokenRangeIterator {
    private final Set<TokenRange> tokenRanges;
    private final ConcurrentLinkedQueue<TokenRange> pendingRanges;
    private final boolean wrap;

    public TokenRangeIterator(StressSettings settings, Set<TokenRange> tokenRanges) {
        this.tokenRanges = TokenRangeIterator.maybeSplitRanges(tokenRanges, settings.tokenRange.splitFactor);
        this.pendingRanges = new ConcurrentLinkedQueue<TokenRange>(this.tokenRanges);
        this.wrap = settings.tokenRange.wrap;
    }

    private static Set<TokenRange> maybeSplitRanges(Set<TokenRange> tokenRanges, int splitFactor) {
        if (splitFactor <= 1) {
            return tokenRanges;
        }
        TreeSet<TokenRange> ret = new TreeSet<TokenRange>();
        for (TokenRange range : tokenRanges) {
            ret.addAll(range.splitEvenly(splitFactor));
        }
        return ret;
    }

    public void update() {
        if (this.wrap && this.pendingRanges.isEmpty()) {
            this.pendingRanges.addAll(this.tokenRanges);
        }
    }

    public TokenRange next() {
        return this.pendingRanges.poll();
    }

    public boolean exhausted() {
        return this.pendingRanges.isEmpty();
    }
}

