/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.align;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JDialog;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.omegat.gui.align.EditingPanel;
import org.omegat.util.Java8Compat;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;

public class PatternPanelController {
    private final Pattern initialPattern;
    private Pattern result;

    public PatternPanelController(Pattern pattern) {
        this.initialPattern = pattern;
    }

    public Pattern show(Window parent) {
        final JDialog dialog = new JDialog(parent, OStrings.getString("ALIGNER_DIALOG_PATTERN"), Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PatternPanelController.this.doCancel(dialog);
            }
        });
        StaticUIUtils.setEscapeClosable(dialog);
        final EditingPanel panel = new EditingPanel();
        panel.editorPane.setText(this.initialPattern == null ? null : this.initialPattern.pattern());
        StaticUIUtils.makeCaretAlwaysVisible(panel.editorPane);
        panel.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        panel.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternPanelController.this.doCancel(dialog);
            }
        });
        panel.editorPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && (e.getModifiersEx() & Java8Compat.getMenuShortcutKeyMaskEx()) != 0) {
                    panel.okButton.doClick();
                }
            }
        });
        panel.editorPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                PatternPanelController.this.updatePattern(panel);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PatternPanelController.this.updatePattern(panel);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PatternPanelController.this.updatePattern(panel);
            }
        });
        panel.helpText.setForeground(Color.RED);
        this.updatePattern(panel);
        dialog.add(panel);
        dialog.getRootPane().setDefaultButton(panel.okButton);
        dialog.setMinimumSize(new Dimension(450, 200));
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return this.result;
    }

    private void updatePattern(EditingPanel panel) {
        try {
            this.result = Pattern.compile(panel.editorPane.getText());
            panel.helpText.setText(null);
            panel.helpText.setToolTipText(null);
            panel.okButton.setEnabled(true);
        }
        catch (PatternSyntaxException ex) {
            panel.helpText.setText(ex.getLocalizedMessage());
            panel.helpText.setToolTipText(ex.getLocalizedMessage());
            panel.okButton.setEnabled(false);
        }
    }

    private void doCancel(JDialog dialog) {
        this.result = this.initialPattern;
        dialog.dispose();
    }
}

