/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.arnx.jsonic.util.ConstructorInfo;
import net.arnx.jsonic.util.MethodInfo;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanInfo {
    private static final Map<ClassLoader, Map<Class<?>, BeanInfo>> cache = new WeakHashMap();
    private Class<?> type;
    private ConstructorInfo ci;
    private Map<String, PropertyInfo> sprops;
    private Map<String, MethodInfo> smethods;
    private Map<String, PropertyInfo> props;
    private Map<String, MethodInfo> methods;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanInfo get(Class<?> clazz) {
        Map<ClassLoader, Map<Class<?>, BeanInfo>> map = cache;
        synchronized (map) {
            BeanInfo beanInfo = null;
            LinkedHashMap linkedHashMap = cache.get(clazz.getClassLoader());
            if (linkedHashMap == null) {
                linkedHashMap = new LinkedHashMap<Class<?>, BeanInfo>(16, 0.75f, true){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Class<?>, BeanInfo> entry) {
                        return this.size() > 1024;
                    }
                };
                cache.put(clazz.getClassLoader(), linkedHashMap);
            } else {
                beanInfo = linkedHashMap.get(clazz);
            }
            if (beanInfo == null) {
                beanInfo = new BeanInfo(clazz);
                linkedHashMap.put(clazz, beanInfo);
            }
            return beanInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<ClassLoader, Map<Class<?>, BeanInfo>> map = cache;
        synchronized (map) {
            cache.clear();
        }
    }

    private BeanInfo(Class<?> clazz) {
        Class<?>[] classArray;
        this.type = clazz;
        for (Constructor<?> accessibleObject : clazz.getConstructors()) {
            if (accessibleObject.isSynthetic()) continue;
            if (this.ci == null) {
                this.ci = new ConstructorInfo(clazz, null);
            }
            accessibleObject.setAccessible(true);
            this.ci.constructors.add(accessibleObject);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (((Field)accessibleObject).isSynthetic()) continue;
            boolean bl = Modifier.isStatic(((Field)accessibleObject).getModifiers());
            classArray = ((Field)accessibleObject).getName();
            ((Field)accessibleObject).setAccessible(true);
            if (bl) {
                if (this.sprops == null) {
                    this.sprops = Collections.synchronizedMap(new LinkedHashMap());
                }
                this.sprops.put((String)classArray, new PropertyInfo(clazz, (String)classArray, (Field)accessibleObject, null, null, bl, -1));
                continue;
            }
            if (this.props == null) {
                this.props = Collections.synchronizedMap(new LinkedHashMap());
            }
            this.props.put((String)classArray, new PropertyInfo(clazz, (String)classArray, (Field)accessibleObject, null, null, bl, -1));
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            Object object;
            MethodInfo methodInfo;
            if (((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge()) continue;
            String string = ((Method)accessibleObject).getName();
            classArray = ((Method)accessibleObject).getParameterTypes();
            Class<?> clazz2 = ((Method)accessibleObject).getReturnType();
            boolean bl = Modifier.isStatic(((Method)accessibleObject).getModifiers());
            if (bl) {
                if (this.smethods == null) {
                    this.smethods = Collections.synchronizedMap(new LinkedHashMap());
                }
                if ((methodInfo = this.smethods.get(string)) == null) {
                    methodInfo = new MethodInfo(clazz, string, null, bl);
                    this.smethods.put(string, methodInfo);
                }
            } else {
                if (this.methods == null) {
                    this.methods = Collections.synchronizedMap(new LinkedHashMap());
                }
                if ((methodInfo = this.methods.get(string)) == null) {
                    methodInfo = new MethodInfo(clazz, string, null, bl);
                    this.methods.put(string, methodInfo);
                }
            }
            ((Method)accessibleObject).setAccessible(true);
            methodInfo.methods.add((Method)accessibleObject);
            int n = -1;
            if (string.startsWith("get") && string.length() > 3 && !Character.isLowerCase(string.charAt(3)) && classArray.length == 0 && !clazz2.equals(Void.TYPE)) {
                n = 1;
                string = string.substring(3);
            } else if (string.startsWith("is") && string.length() > 2 && !Character.isLowerCase(string.charAt(2)) && classArray.length == 0 && !clazz2.equals(Void.TYPE)) {
                n = 1;
                string = string.substring(2);
            } else {
                if (!string.startsWith("set") || string.length() <= 3 || Character.isLowerCase(string.charAt(3)) || classArray.length != 1 || classArray[0].equals(Void.TYPE)) continue;
                n = 2;
                string = string.substring(3);
            }
            if (string.length() < 2 || !Character.isUpperCase(string.charAt(1))) {
                object = string.toCharArray();
                object[0] = Character.toLowerCase(object[0]);
                string = String.valueOf(object);
            }
            if (bl) {
                if (this.sprops == null) {
                    this.sprops = Collections.synchronizedMap(new LinkedHashMap());
                }
                if ((object = (Object)this.sprops.get(string)) == null) {
                    object = new PropertyInfo(clazz, string, null, null, null, bl, -1);
                    this.sprops.put(string, (PropertyInfo)object);
                }
            } else {
                if (this.props == null) {
                    this.props = Collections.synchronizedMap(new LinkedHashMap());
                }
                if ((object = (Object)this.props.get(string)) == null) {
                    object = new PropertyInfo(clazz, string, null, null, null, bl, -1);
                    this.props.put(string, (PropertyInfo)object);
                }
            }
            if (n == 1) {
                object.readMethod = accessibleObject;
                continue;
            }
            object.writeMethod = accessibleObject;
        }
        if (this.sprops == null) {
            this.sprops = Collections.emptyMap();
        }
        if (this.smethods == null) {
            this.smethods = Collections.emptyMap();
        }
        if (this.props == null) {
            this.props = Collections.emptyMap();
        }
        if (this.methods == null) {
            this.methods = Collections.emptyMap();
        }
    }

    public Object newInstance() {
        try {
            Constructor<?> constructor = this.type.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public ConstructorInfo getConstructor() {
        return this.ci;
    }

    public PropertyInfo getStaticProperty(String string) {
        return this.sprops.get(string);
    }

    public MethodInfo getStaticMethod(String string) {
        return this.smethods.get(string);
    }

    public Collection<PropertyInfo> getStaticProperties() {
        return this.sprops.values();
    }

    public Collection<MethodInfo> getStaticMethods() {
        return this.smethods.values();
    }

    public PropertyInfo getProperty(String string) {
        return this.props.get(string);
    }

    public MethodInfo getMethod(String string) {
        return this.methods.get(string);
    }

    public Collection<PropertyInfo> getProperties() {
        return this.props.values();
    }

    public Collection<MethodInfo> getMethods() {
        return this.methods.values();
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BeanInfo beanInfo = (BeanInfo)object;
        return !(this.type == null ? beanInfo.type != null : !this.type.equals(beanInfo.type));
    }

    public String toString() {
        return "BeanInfo [static properties = " + this.sprops + ", static methods = " + this.smethods + ", properties = " + this.props + ", methods = " + this.methods + "]";
    }

    static int calcurateDistance(Class<?>[] classArray, Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                if (classArray[i].isPrimitive()) continue;
                n += 5;
                continue;
            }
            if (classArray[i].equals(objectArray[i].getClass())) {
                n += 10;
                continue;
            }
            if (classArray[i].isAssignableFrom(objectArray[i].getClass())) {
                n += 8;
                continue;
            }
            if (Boolean.TYPE.equals(objectArray[i].getClass()) || Boolean.class.equals(objectArray[i].getClass())) {
                if (!Boolean.TYPE.equals(classArray[i]) && !Boolean.class.equals(classArray[i].getClass())) continue;
                n += 10;
                continue;
            }
            if (Byte.TYPE.equals(objectArray[i].getClass()) || Byte.class.equals(objectArray[i].getClass())) {
                if (!Byte.TYPE.equals(classArray[i]) && !Short.TYPE.equals(classArray[i]) && !Character.TYPE.equals(classArray[i]) && !Integer.TYPE.equals(classArray[i]) && !Long.TYPE.equals(classArray[i]) && !Float.TYPE.equals(classArray[i]) && !Double.TYPE.equals(classArray[i]) && !Byte.class.equals(classArray[i]) && !Short.class.equals(classArray[i]) && !Character.class.equals(classArray[i]) && !Integer.class.equals(classArray[i]) && !Long.class.equals(classArray[i]) && !Float.class.equals(classArray[i]) && !Double.class.equals(classArray[i])) continue;
                n += 10;
                continue;
            }
            if (Short.TYPE.equals(objectArray[i].getClass()) || Short.class.equals(objectArray[i].getClass()) || Character.TYPE.equals(objectArray[i].getClass()) || Character.class.equals(objectArray[i].getClass())) {
                if (!Short.TYPE.equals(classArray[i]) && !Character.TYPE.equals(classArray[i]) && !Integer.TYPE.equals(classArray[i]) && !Long.TYPE.equals(classArray[i]) && !Float.TYPE.equals(classArray[i]) && !Double.TYPE.equals(classArray[i]) && !Short.class.equals(classArray[i]) && !Character.class.equals(classArray[i]) && !Integer.class.equals(classArray[i]) && !Long.class.equals(classArray[i]) && !Float.class.equals(classArray[i]) && !Double.class.equals(classArray[i])) continue;
                n += 10;
                continue;
            }
            if (Integer.TYPE.equals(objectArray[i].getClass()) || Integer.class.equals(objectArray[i].getClass())) {
                if (!Integer.TYPE.equals(classArray[i]) && !Long.TYPE.equals(classArray[i]) && !Float.TYPE.equals(classArray[i]) && !Double.TYPE.equals(classArray[i]) && !Integer.class.equals(classArray[i]) && !Long.class.equals(classArray[i]) && !Float.class.equals(classArray[i]) && !Double.class.equals(classArray[i])) continue;
                n += 10;
                continue;
            }
            if (Long.TYPE.equals(objectArray[i].getClass()) || Long.class.equals(objectArray[i].getClass())) {
                if (!Long.TYPE.equals(classArray[i]) && !Float.TYPE.equals(classArray[i]) && !Double.TYPE.equals(classArray[i]) && !Long.class.equals(classArray[i]) && !Float.class.equals(classArray[i]) && !Double.class.equals(classArray[i])) continue;
                n += 10;
                continue;
            }
            if (Float.TYPE.equals(objectArray[i].getClass()) || Float.class.equals(objectArray[i].getClass())) {
                if (!Float.TYPE.equals(classArray[i]) && !Double.TYPE.equals(classArray[i]) && !Float.class.equals(classArray[i]) && !Double.class.equals(classArray[i])) continue;
                n += 10;
                continue;
            }
            if (!Double.TYPE.equals(objectArray[i].getClass()) && !Double.class.equals(objectArray[i].getClass()) || !Double.TYPE.equals(classArray[i]) && !Double.class.equals(classArray[i])) continue;
            n += 10;
        }
        return n;
    }
}

