/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11;

import com.sun.grizzly.tcp.http11.GrizzlyInputBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class GrizzlyInputStream
extends InputStream {
    protected GrizzlyInputBuffer ib;

    public GrizzlyInputStream(GrizzlyInputBuffer ib) {
        this.ib = ib;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    void clear() {
        this.ib = null;
    }

    public int read() throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Integer result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Integer integer = new Integer(GrizzlyInputStream.this.ib.readByte());
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.readByte();
    }

    public int available() throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Integer result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Integer integer = new Integer(GrizzlyInputStream.this.ib.available());
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.available();
    }

    public int read(final byte[] b) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Integer result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Integer integer = new Integer(GrizzlyInputStream.this.ib.read(b, 0, b.length));
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.read(b, 0, b.length);
    }

    public int read(final byte[] b, final int off, final int len) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Integer result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Integer integer = new Integer(GrizzlyInputStream.this.ib.read(b, off, len));
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.read(b, off, len);
    }

    public void close() throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        GrizzlyInputStream.this.ib.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.ib.close();
        }
    }
}

