/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.jersey;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.jersey.cfg.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperService {
    private static Logger LOG = LoggerFactory.getLogger(ZooKeeperService.class);
    private static Map<String, Endpoint> contextMap = new HashMap<String, Endpoint>();
    private static Map<String, ZooKeeper> zkMap = new HashMap<String, ZooKeeper>();
    private static Map<String, SessionTimerTask> zkSessionTimers = new HashMap<String, SessionTimerTask>();
    private static Timer timer = new Timer();

    public static synchronized void mapContext(String contextPath, Endpoint e) {
        contextMap.put(contextPath, e);
    }

    public static synchronized void resetTimer(String contextPath, String session) {
        if (session != null) {
            String uri = ZooKeeperService.concat(contextPath, session);
            SessionTimerTask t = zkSessionTimers.remove(uri);
            t.cancel();
            zkSessionTimers.put(uri, new SessionTimerTask(t));
        }
    }

    public static void close(String contextPath) {
        ZooKeeperService.close(contextPath, null);
    }

    public static synchronized void close(String contextPath, String session) {
        ZooKeeper zk;
        String uri = ZooKeeperService.concat(contextPath, session);
        TimerTask t = zkSessionTimers.remove(uri);
        if (t != null) {
            t.cancel();
        }
        if ((zk = zkMap.remove(uri)) == null) {
            return;
        }
        try {
            zk.close();
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while closing ZooKeeper connection.", (Throwable)e);
        }
    }

    public static synchronized void closeAll() {
        TreeSet<String> sessions = new TreeSet<String>(zkMap.keySet());
        for (String key : sessions) {
            ZooKeeperService.close(key);
        }
    }

    public static synchronized boolean isConnected(String contextPath, String session) {
        return zkMap.containsKey(ZooKeeperService.concat(contextPath, session));
    }

    public static ZooKeeper getClient(String contextPath) throws IOException {
        return ZooKeeperService.getClient(contextPath, null);
    }

    public static ZooKeeper getClient(String contextPath, String session) throws IOException {
        return ZooKeeperService.getClient(contextPath, session, 5);
    }

    public static synchronized ZooKeeper getClient(String contextPath, String session, int expireTime) throws IOException {
        String connectionId = ZooKeeperService.concat(contextPath, session);
        ZooKeeper zk = zkMap.get(connectionId);
        if (zk == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("creating new connection for : '%s'", connectionId));
            }
            Endpoint e = contextMap.get(contextPath);
            zk = new ZooKeeper(e.getHostPort(), 30000, (Watcher)new MyWatcher(connectionId));
            for (Map.Entry p : e.getZooKeeperAuthInfo().entrySet()) {
                zk.addAuthInfo("digest", String.format("%s:%s", p.getKey(), p.getValue()).getBytes());
            }
            zkMap.put(connectionId, zk);
            if (session != null) {
                zkSessionTimers.put(connectionId, new SessionTimerTask(expireTime, session, contextPath, timer));
            }
        }
        return zk;
    }

    private static String concat(String contextPath, String session) {
        if (session != null) {
            return String.format("%s@%s", contextPath, session);
        }
        return contextPath;
    }

    private static class SessionTimerTask
    extends TimerTask {
        private int delay;
        private String contextPath;
        private String session;
        private Timer timer;

        public SessionTimerTask(int delayInSeconds, String session, String contextPath, Timer timer) {
            this.delay = delayInSeconds * 1000;
            this.contextPath = contextPath;
            this.session = session;
            this.timer = timer;
            this.reset();
        }

        public SessionTimerTask(SessionTimerTask t) {
            this(t.delay / 1000, t.session, t.contextPath, t.timer);
        }

        @Override
        public void run() {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Session '%s' expired after '%d' milliseconds.", this.session, this.delay));
            }
            ZooKeeperService.close(this.contextPath, this.session);
        }

        public void reset() {
            this.timer.schedule((TimerTask)this, this.delay);
        }
    }

    private static class MyWatcher
    implements Watcher {
        final String contextPath;

        public MyWatcher(String contextPath) {
            this.contextPath = contextPath;
        }

        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                ZooKeeperService.close(this.contextPath);
            }
        }
    }
}

