/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.session.properties.SQLResultConfigCtrl;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ResultLimitAndReadOnPanelSmallPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLResultConfigCtrl.class);
    public static final String CBO_LIMIT_ROWS = s_stringMgr.getString("ResultLimitAndReadOnPanelSmallPanel.limitRows");
    public static final String CBO_READ_ON_BLOCK_SIZE = s_stringMgr.getString("ResultLimitAndReadOnPanelSmallPanel.readOnWithBlockSize");
    private JCheckBox _chkLimitRowsEnabled;
    private JComboBox _cboLimitOrReadOn;
    private IntegerField _txtLimitOrBlockSize;
    private SessionProperties _props;
    private boolean _inLoadData = false;
    private boolean _inEvent;

    public ResultLimitAndReadOnPanelSmallPanel() {
        this.createUI();
        this._chkLimitRowsEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultLimitAndReadOnPanelSmallPanel.this.onChkLimitRowsEnabled();
            }
        });
        this._cboLimitOrReadOn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ResultLimitAndReadOnPanelSmallPanel.this.onCboLimitOrReadOnChanged(e);
            }
        });
        this._txtLimitOrBlockSize.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ResultLimitAndReadOnPanelSmallPanel.this.onLimitOrBlockSizeChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ResultLimitAndReadOnPanelSmallPanel.this.onLimitOrBlockSizeChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ResultLimitAndReadOnPanelSmallPanel.this.onLimitOrBlockSizeChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLimitOrBlockSizeChanged() {
        if (this._inLoadData || this._inEvent || 0 >= this._txtLimitOrBlockSize.getInt()) {
            return;
        }
        try {
            this._inEvent = true;
            if (CBO_LIMIT_ROWS == this._cboLimitOrReadOn.getSelectedItem()) {
                this._props.setSQLNbrRowsToShow(this._txtLimitOrBlockSize.getInt());
            } else {
                this._props.setSQLReadOnBlockSize(this._txtLimitOrBlockSize.getInt());
            }
        }
        finally {
            this._inEvent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCboLimitOrReadOnChanged(ItemEvent e) {
        try {
            if (this._inLoadData || this._inEvent || 1 != e.getStateChange()) {
                return;
            }
            this._inEvent = true;
            if (CBO_READ_ON_BLOCK_SIZE == this._cboLimitOrReadOn.getSelectedItem()) {
                this._props.setSQLReadOn(true);
                this._txtLimitOrBlockSize.setInt(this._props.getSQLReadOnBlockSize());
            } else {
                this._props.setSQLReadOn(false);
                this._txtLimitOrBlockSize.setInt(this._props.getSQLNbrRowsToShow());
                if (0 < this._props.getSQLNbrRowsToShow()) {
                    this._props.setSQLLimitRows(true);
                }
            }
        }
        finally {
            this._inEvent = false;
        }
        this.loadData(this._props);
    }

    private void onChkLimitRowsEnabled() {
        if (this._inLoadData || this._inEvent) {
            return;
        }
        this._props.setSQLLimitRows(this._chkLimitRowsEnabled.isSelected());
        this.loadData(this._props);
    }

    private void createUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 2), 0, 0);
        this._chkLimitRowsEnabled = new JCheckBox();
        this.add((Component)this._chkLimitRowsEnabled, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        this._cboLimitOrReadOn = new JComboBox<Object>(new Object[]{CBO_LIMIT_ROWS, CBO_READ_ON_BLOCK_SIZE});
        this.add((Component)this._cboLimitOrReadOn, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0);
        this._txtLimitOrBlockSize = new IntegerField(10);
        this.add((Component)this._txtLimitOrBlockSize, gbc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData(SessionProperties props) {
        if (this._inLoadData || this._inEvent) {
            return;
        }
        try {
            this._inLoadData = true;
            this._props = props;
            if (this._props.getSQLReadOn()) {
                this._cboLimitOrReadOn.setSelectedItem(CBO_READ_ON_BLOCK_SIZE);
                this._chkLimitRowsEnabled.setEnabled(false);
                this._txtLimitOrBlockSize.setEnabled(true);
                this._txtLimitOrBlockSize.setInt(this._props.getSQLReadOnBlockSize());
                this._cboLimitOrReadOn.setToolTipText(s_stringMgr.getString("ResultLimitAndReadOnPanelSmallPanel.readOnWarningHtml"));
            } else {
                this._cboLimitOrReadOn.setSelectedItem(CBO_LIMIT_ROWS);
                this._chkLimitRowsEnabled.setEnabled(true);
                this._chkLimitRowsEnabled.setSelected(this._props.getSQLLimitRows());
                this._txtLimitOrBlockSize.setInt(this._props.getSQLNbrRowsToShow());
                this._txtLimitOrBlockSize.setEnabled(this._props.getSQLLimitRows());
                this._cboLimitOrReadOn.setToolTipText(null);
            }
        }
        finally {
            this._inLoadData = false;
        }
    }

    public void propsChanged(SessionProperties props) {
        this.loadData(props);
    }
}

