/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.client.gui.session.SessionPanel;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.DataSetUpdateableTableModelImpl;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.PleaseWaitDialog;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.BaseTableTab;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.OrderByClausePanel;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.SQLFilterClauses;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.WhereClausePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetUpdateableTableModelListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.dbobj.BestRowIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ContentsTab
extends BaseTableTab
implements IDataSetUpdateableTableModel {
    private final DataSetUpdateableTableModelImpl _dataSetUpdateableTableModel = new DataSetUpdateableTableModelImpl();
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ContentsTab.class);
    String previousTableName = "";
    private final SQLFilterClauses _sqlFilterClauses = new SQLFilterClauses();
    private static final ILogger s_log = LoggerController.createLogger(ContentsTab.class);
    private ObjectTreePanel _treePanel = null;
    private PleaseWaitDialog _waitDialog = null;
    private SquirrelPreferences _prefs = null;

    public ContentsTab(ObjectTreePanel treePanel) {
        this._treePanel = treePanel;
        this._prefs = this._treePanel.getSession().getApplication().getSquirrelPreferences();
    }

    @Override
    public String getTitle() {
        return ContentsTab.getContentsTabTitle();
    }

    public static String getContentsTabTitle() {
        return s_stringMgr.getString("ContentsTab.title");
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("ContentsTab.hint");
    }

    public SQLFilterClauses getSQLFilterClauses() {
        return this._sqlFilterClauses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IDataSet createDataSet() throws DataSetException {
        ISession session = this.getSession();
        ISQLConnection conn = session.getSQLConnection();
        ISQLDatabaseMetaData md = session.getMetaData();
        try {
            ResultSetDataSet resultSetDataSet;
            Statement stmt = conn.createStatement();
            try {
                String pseudoColumn;
                ITableInfo ti;
                block31: {
                    String currentTableName;
                    SessionProperties props = session.getProperties();
                    if (props.getContentsLimitRows()) {
                        try {
                            stmt.setMaxRows(props.getContentsNbrRowsToShow());
                        }
                        catch (Exception ex) {
                            s_log.error("Error on Statement.setMaxRows()", ex);
                        }
                    }
                    if (!(currentTableName = (ti = this.getTableInfo()).getQualifiedName()).equals(this.previousTableName)) {
                        this.previousTableName = currentTableName;
                        this._dataSetUpdateableTableModel.setEditModeForced(false);
                    }
                    pseudoColumn = "";
                    try {
                        BestRowIdentifier[] rowIDs = md.getBestRowIdentifier(ti);
                        for (int i = 0; i < rowIDs.length; ++i) {
                            short pseudo = rowIDs[i].getPseudoColumn();
                            if (pseudo != 2) continue;
                            pseudoColumn = " ," + rowIDs[i].getColumnName();
                            break;
                        }
                    }
                    catch (Throwable th) {
                        if (!s_log.isDebugEnabled()) break block31;
                        s_log.debug("getBestRowIdentifier not supported for table " + currentTableName, th);
                    }
                }
                if (pseudoColumn.length() == 0) {
                    if (DialectFactory.isPostgreSQL(md)) {
                        pseudoColumn = ", oid";
                    }
                    if (DialectFactory.isOracle(md)) {
                        pseudoColumn = ", ROWID";
                    }
                }
                ResultSet rs = null;
                StringBuilder coded = this.gatherColumnsForContentSelect(md, ti);
                try {
                    StringBuffer buf = new StringBuffer();
                    buf.append("select " + coded).append(pseudoColumn).append(" from ").append(ti.getQualifiedName()).append(" tbl");
                    String clause = this._sqlFilterClauses.get(WhereClausePanel.getClauseIdentifier(), ti.getQualifiedName());
                    if (clause != null && clause.length() > 0) {
                        buf.append(" where ").append(clause);
                    }
                    if ((clause = this._sqlFilterClauses.get(OrderByClausePanel.getClauseIdentifier(), ti.getQualifiedName())) != null && clause.length() > 0) {
                        buf.append(" order by ").append(clause);
                    }
                    if (s_log.isDebugEnabled()) {
                        s_log.debug("createDataSet running SQL: " + buf.toString());
                    }
                    this.showWaitDialog(stmt);
                    rs = stmt.executeQuery(buf.toString());
                }
                catch (SQLException ex) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug("createDataSet: exception from pseudocolumn query - " + ex, ex);
                    }
                    if (pseudoColumn.length() == 0) {
                        throw ex;
                    }
                    pseudoColumn = "";
                    StringBuffer buf = new StringBuffer();
                    buf.append("select " + coded).append(" from ").append(ti.getQualifiedName()).append(" tbl");
                    String clause = this._sqlFilterClauses.get(WhereClausePanel.getClauseIdentifier(), ti.getQualifiedName());
                    if (clause != null && clause.length() > 0) {
                        buf.append(" where ").append(clause);
                    }
                    if ((clause = this._sqlFilterClauses.get(OrderByClausePanel.getClauseIdentifier(), ti.getQualifiedName())) != null && clause.length() > 0) {
                        buf.append(" order by ").append(clause);
                    }
                    rs = stmt.executeQuery(buf.toString());
                }
                ResultSetDataSet rsds = new ResultSetDataSet(md.getColumnInfo(this.getTableInfo()));
                rsds.setLimitDataRead(true);
                rsds.setContentsTabResultSet(rs, this._dataSetUpdateableTableModel.getFullTableName(), DialectFactory.getDialectType(md));
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                if (pseudoColumn.length() > 0) {
                    this._dataSetUpdateableTableModel.setRowIDCol(rsds.getColumnCount() - 1);
                }
                resultSetDataSet = rsds;
            }
            catch (Throwable throwable) {
                try {
                    SQLUtilities.closeStatement(stmt);
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new DataSetException(ex);
                }
            }
            SQLUtilities.closeStatement(stmt);
            return resultSetDataSet;
        }
        finally {
            this.disposeWaitDialog();
        }
    }

    private StringBuilder gatherColumnsForContentSelect(ISQLDatabaseMetaData md, ITableInfo ti) throws SQLException {
        DialectType dialectType = DialectFactory.getDialectType(md);
        TableColumnInfo[] columnInfo = md.getColumnInfo(ti);
        StringBuilder coded = new StringBuilder();
        JTable table = (JTable)this.getComponent().getViewer().getComponent();
        for (int i = 0; i < columnInfo.length; ++i) {
            coded.append(CellComponentFactory.getColumnForContentSelect(table, columnInfo[i], dialectType, "tbl."));
            if (i >= columnInfo.length - 1) continue;
            coded.append(',');
        }
        return coded;
    }

    private boolean objectTreeTabIsSelected() {
        SessionPanel sessionPanel;
        boolean result = false;
        ISession session = this._treePanel.getSession();
        if (session != null && (sessionPanel = session.getSessionSheet()) != null) {
            result = sessionPanel.isObjectTreeTabSelected();
        }
        return result;
    }

    private void showWaitDialog(final Statement stmt) {
        if (!this._prefs.getShowPleaseWaitDialog()) {
            return;
        }
        if (this.objectTreeTabIsSelected()) {
            this._treePanel.saveSelectedPaths();
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    ContentsTab.this._waitDialog = new PleaseWaitDialog(stmt, ContentsTab.this._app);
                    ContentsTab.this._waitDialog.showDialog(ContentsTab.this._app);
                    ContentsTab.this._treePanel.restoreSavedSelectedPaths();
                }
            });
        }
    }

    private void disposeWaitDialog() {
        if (!this._prefs.getShowPleaseWaitDialog()) {
            return;
        }
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                if (ContentsTab.this._waitDialog != null) {
                    ContentsTab.this._waitDialog.dispose();
                }
            }
        });
    }

    @Override
    public void setDatabaseObjectInfo(IDatabaseObjectInfo value) {
        super.setDatabaseObjectInfo(value);
        this._dataSetUpdateableTableModel.setTableInfo(this.getTableInfo());
    }

    @Override
    public void setSession(ISession session) throws IllegalArgumentException {
        super.setSession(session);
        this._dataSetUpdateableTableModel.setSession(session);
    }

    public static String getUnambiguousTableName(ISession session, String name) {
        return DataSetUpdateableTableModelImpl.getUnambiguousTableName(session, name);
    }

    @Override
    public String getWarningOnCurrentData(Object[] values, ColumnDisplayDefinition[] colDefs, int col, Object oldValue) {
        return this._dataSetUpdateableTableModel.getWarningOnCurrentData(values, colDefs, col, oldValue);
    }

    @Override
    public String getWarningOnProjectedUpdate(Object[] values, ColumnDisplayDefinition[] colDefs, int col, Object newValue) {
        return this._dataSetUpdateableTableModel.getWarningOnProjectedUpdate(values, colDefs, col, newValue);
    }

    @Override
    public Object reReadDatum(Object[] values, ColumnDisplayDefinition[] colDefs, int col, StringBuffer message) {
        return this._dataSetUpdateableTableModel.reReadDatum(values, colDefs, col, message);
    }

    @Override
    public String updateTableComponent(Object[] values, ColumnDisplayDefinition[] colDefs, int col, Object oldValue, Object newValue) {
        return this._dataSetUpdateableTableModel.updateTableComponent(values, colDefs, col, oldValue, newValue);
    }

    @Override
    public int getRowidCol() {
        return this._dataSetUpdateableTableModel.getRowidCol();
    }

    @Override
    public String deleteRows(Object[][] rowData, ColumnDisplayDefinition[] colDefs) {
        return this._dataSetUpdateableTableModel.deleteRows(rowData, colDefs);
    }

    @Override
    public String[] getDefaultValues(ColumnDisplayDefinition[] colDefs) {
        return this._dataSetUpdateableTableModel.getDefaultValues(colDefs);
    }

    @Override
    public String insertRow(Object[] values, ColumnDisplayDefinition[] colDefs) {
        return this._dataSetUpdateableTableModel.insertRow(values, colDefs);
    }

    @Override
    public void addListener(DataSetUpdateableTableModelListener l) {
        this._dataSetUpdateableTableModel.addListener(l);
    }

    @Override
    public void removeListener(DataSetUpdateableTableModelListener l) {
        this._dataSetUpdateableTableModel.removeListener(l);
    }

    @Override
    public void forceEditMode(boolean mode) {
        this._dataSetUpdateableTableModel.forceEditMode(mode);
    }

    @Override
    public boolean editModeIsForced() {
        return this._dataSetUpdateableTableModel.editModeIsForced();
    }

    @Override
    protected String getDestinationClassName() {
        return this._dataSetUpdateableTableModel.getDestinationClassName();
    }
}

