/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.prefspanel;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxStyle;

public class StylesList
extends JList {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(StylesList.class);
    private static final String[] s_styleTitles = new String[]{s_stringMgr.getString("syntax.cols"), s_stringMgr.getString("syntax.comments"), s_stringMgr.getString("syntax.dataTypes"), s_stringMgr.getString("syntax.errors"), s_stringMgr.getString("syntax.functions"), s_stringMgr.getString("syntax.identifiers"), s_stringMgr.getString("syntax.literals"), s_stringMgr.getString("syntax.operators"), s_stringMgr.getString("syntax.resWords"), s_stringMgr.getString("syntax.separators"), s_stringMgr.getString("syntax.tables"), s_stringMgr.getString("syntax.whiteSpace")};
    private SyntaxStyle[] _styles = new SyntaxStyle[12];

    public StylesList() {
        super(new DefaultListModel());
        this.setSelectionMode(0);
        this.setCellRenderer(new ListRenderer());
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
    }

    public void loadData(SyntaxPreferences prefs) {
        this.removeAll();
        this._styles[0] = new SyntaxStyle(prefs.getColumnStyle());
        this._styles[1] = new SyntaxStyle(prefs.getCommentStyle());
        this._styles[2] = new SyntaxStyle(prefs.getDataTypeStyle());
        this._styles[3] = new SyntaxStyle(prefs.getErrorStyle());
        this._styles[4] = new SyntaxStyle(prefs.getFunctionStyle());
        this._styles[5] = new SyntaxStyle(prefs.getIdentifierStyle());
        this._styles[6] = new SyntaxStyle(prefs.getLiteralStyle());
        this._styles[7] = new SyntaxStyle(prefs.getOperatorStyle());
        this._styles[8] = new SyntaxStyle(prefs.getReservedWordStyle());
        this._styles[9] = new SyntaxStyle(prefs.getSeparatorStyle());
        this._styles[10] = new SyntaxStyle(prefs.getTableStyle());
        this._styles[11] = new SyntaxStyle(prefs.getWhiteSpaceStyle());
        DefaultListModel model = (DefaultListModel)this.getModel();
        for (int i = 0; i < this._styles.length; ++i) {
            model.addElement(this._styles[i]);
        }
        this.setSelectedIndex(0);
    }

    public SyntaxStyle getSelectedSyntaxStyle() {
        return (SyntaxStyle)this.getSelectedValue();
    }

    public SyntaxStyle getSyntaxStyleAt(int idx) {
        return (SyntaxStyle)this.getModel().getElementAt(idx);
    }

    private static final class ListRenderer
    extends JLabel
    implements ListCellRenderer {
        ListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int idx, boolean isSelected, boolean cellHasFocus) {
            SyntaxStyle style = (SyntaxStyle)value;
            this.setForeground(new Color(style.getTextRGB()));
            this.setBackground(new Color(style.getBackgroundRGB()));
            this.setText(s_styleTitles[idx]);
            if (isSelected) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder());
            }
            return this;
        }
    }

    public static interface IStylesListIndices {
        public static final int COLUMNS = 0;
        public static final int COMMENTS = 1;
        public static final int DATA_TYPES = 2;
        public static final int ERRORS = 3;
        public static final int FUNCTIONS = 4;
        public static final int IDENTIFIERS = 5;
        public static final int LITERALS = 6;
        public static final int OPERATORS = 7;
        public static final int RESERVED_WORDS = 8;
        public static final int SEPARATORS = 9;
        public static final int TABLES = 10;
        public static final int WHITE_SPACE = 11;
        public static final int LIST_SIZE = 12;
    }
}

