/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.icon;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class CheckBoxMenuItemIcon
implements Icon,
UIResource {
    private int size;
    private JMenuItem menuItem;
    private static LazyResettableHashMap<Icon> iconMap = new LazyResettableHashMap("CheckBoxMenuItemIcon");

    public CheckBoxMenuItemIcon(JMenuItem menuItem, int size) {
        this.menuItem = menuItem;
        this.size = size;
    }

    private Icon getIconToPaint() {
        if (this.menuItem == null) {
            return null;
        }
        ComponentState currState = ComponentState.getState(this.menuItem.getModel(), this.menuItem, false);
        ComponentState prevState = SubstanceCoreUtilities.getPrevSelComponentState(this.menuItem);
        float checkMarkVisibility = currState.isKindActive(FadeKind.SELECTION) ? 10.0f : 0.0f;
        boolean isCheckMarkFadingOut = false;
        SubstanceColorScheme currFillColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, ColorSchemeAssociationKind.FILL, currState);
        SubstanceColorScheme prevFillColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, ColorSchemeAssociationKind.FILL, prevState);
        SubstanceColorScheme currMarkColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, ColorSchemeAssociationKind.MARK, currState);
        SubstanceColorScheme prevMarkColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, ColorSchemeAssociationKind.MARK, prevState);
        SubstanceColorScheme currBorderColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, ColorSchemeAssociationKind.BORDER, currState);
        SubstanceColorScheme prevBorderColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, ColorSchemeAssociationKind.BORDER, prevState);
        float cyclePos = 0.0f;
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)this.menuItem, FadeKind.SELECTION, FadeKind.ROLLOVER, FadeKind.PRESS, FadeKind.ARM);
        if (fadeState != null) {
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
            if (fadeState.fadeKind == FadeKind.SELECTION) {
                checkMarkVisibility = fadeState.getFadePosition();
                isCheckMarkFadingOut = !fadeState.isFadingIn();
            }
        }
        SubstanceGradientPainter fillPainter = SubstanceCoreUtilities.getGradientPainter(this.menuItem);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(this.menuItem);
        int fontSize = SubstanceSizeUtils.getComponentFontSize(this.menuItem);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(fontSize, currState.name(), prevState.name(), currFillColorScheme.getDisplayName(), prevFillColorScheme.getDisplayName(), currMarkColorScheme.getDisplayName(), prevMarkColorScheme.getDisplayName(), currBorderColorScheme.getDisplayName(), prevBorderColorScheme.getDisplayName(), Float.valueOf(cyclePos), Float.valueOf(checkMarkVisibility), this.size);
        Icon result = iconMap.get(key);
        if (result != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getCheckBox(this.menuItem, fillPainter, borderPainter, this.size + 3, currState, prevState, currFillColorScheme, prevFillColorScheme, currMarkColorScheme, prevMarkColorScheme, currBorderColorScheme, prevBorderColorScheme, cyclePos, checkMarkVisibility / 10.0f, isCheckMarkFadingOut));
        iconMap.put(key, result);
        return result;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon iconToDraw = this.getIconToPaint();
        if (iconToDraw != null) {
            iconToDraw.paintIcon(c, g, x, y);
        }
    }

    @Override
    public int getIconWidth() {
        return this.size + 2;
    }

    @Override
    public int getIconHeight() {
        return this.size + 2;
    }
}

