/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.basic.Resource;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.Sticky;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicJideTabbedPaneUI
extends JideTabbedPaneUI
implements SwingConstants,
DocumentListener {
    protected int _tabRectPadding;
    protected int _closeButtonMarginHorizon;
    protected int _closeButtonMarginVertical;
    protected int _textMarginVertical;
    protected int _noIconMargin;
    protected int _iconMargin;
    protected int _textPadding;
    protected int _buttonSize;
    protected int _buttonMargin;
    protected int _fitStyleBoundSize;
    protected int _fitStyleFirstTabMargin;
    protected int _fitStyleIconMinWidth;
    protected int _fitStyleTextMinWidth;
    protected int _compressedStyleNoIconRectSize;
    protected int _compressedStyleIconMargin;
    protected int _compressedStyleCloseButtonMarginHorizon;
    protected int _compressedStyleCloseButtonMarginVertical;
    protected int _fixedStyleRectSize;
    protected int _closeButtonMargin;
    protected int _gripLeftMargin;
    protected int _closeButtonMarginSize;
    protected int _closeButtonLeftMargin;
    protected int _closeButtonRightMargin;
    protected Component _tabLeadingComponent = null;
    protected Component _tabTrailingComponent = null;
    protected JideTabbedPane _tabPane;
    protected Color _tabBackground;
    protected Color _background;
    protected Color _highlight;
    protected Color _lightHighlight;
    protected Color _shadow;
    protected Color _darkShadow;
    protected Color _focus;
    protected Color _inactiveTabForeground;
    protected Color _activeTabForeground;
    protected Color _tabListBackground;
    protected Color _selectedColor;
    protected int _textIconGap;
    protected int _tabRunOverlay;
    protected boolean _showIconOnTab;
    protected boolean _showCloseButtonOnTab;
    protected int _closeButtonAlignment = 11;
    protected Insets _tabInsets;
    protected Insets _selectedTabPadInsets;
    protected Insets _tabAreaInsets;
    protected boolean _ignoreContentBorderInsetsIfNoTabs;
    protected int[] _tabRuns = new int[10];
    protected int _runCount = 0;
    protected int _selectedRun = -1;
    protected Rectangle[] _rects = new Rectangle[0];
    protected int _maxTabHeight;
    protected int _maxTabWidth;
    protected int _gripperWidth = 6;
    protected int _gripperHeight = 6;
    protected ChangeListener _tabChangeListener;
    protected FocusListener _tabFocusListener;
    protected PropertyChangeListener _propertyChangeListener;
    protected MouseListener _mouseListener;
    protected MouseMotionListener _mousemotionListener;
    protected MouseWheelListener _mouseWheelListener;
    private ContainerListener _containerListener;
    private ComponentListener _componentListener;
    private Insets _currentTabInsets = new Insets(0, 0, 0, 0);
    private Insets _currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets _currentTabAreaInsets = new Insets(2, 4, 0, 4);
    private Insets _currentContentBorderInsets = new Insets(3, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable _mnemonicToIndexMap;
    private InputMap _mnemonicInputMap;
    public ScrollableTabSupport _tabScroller;
    protected transient Rectangle _calcRect = new Rectangle(0, 0, 0, 0);
    protected int _tabCount;
    protected TabCloseButton[] _closeButtons;
    private ThemePainter _painter;
    private Painter _gripperPainter;
    private DropTargetListener _dropListener;
    public DropTarget _dt;
    public static final int DEFAULT_LEFT_MARGIN = 0;
    public static final int OFFICE2003_LEFT_MARGIN = 18;
    public static final int EXCEL_LEFT_MARGIN = 6;
    protected int _rectSizeExtend = 0;
    protected Polygon tabRegion = null;
    protected Color _selectColor1 = null;
    protected Color _selectColor2 = null;
    protected Color _selectColor3 = null;
    protected Color _unselectColor1 = null;
    protected Color _unselectColor2 = null;
    protected Color _unselectColor3 = null;
    protected Color _officeTabBorderColor;
    protected Color _defaultTabBorderShadowColor;
    protected boolean _mouseEnter = false;
    protected int _indexMouseOver = -1;
    protected boolean _alwaysShowLineBorder = false;
    protected boolean _showFocusIndicator = false;
    public static final String BUTTON_NAME_CLOSE = "JideTabbedPane.close";
    public static final String BUTTON_NAME_TAB_LIST = "JideTabbedPane.showList";
    public static final String BUTTON_NAME_SCROLL_BACKWARD = "JideTabbedPane.scrollBackward";
    public static final String BUTTON_NAME_SCROLL_FORWARD = "JideTabbedPane.scrollForward";
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;
    protected TabSpaceAllocator tryTabSpacer = new TabSpaceAllocator();
    protected Color _closeButtonSelectedColor = new Color(255, 162, 165);
    protected Color _closeButtonColor = Color.BLACK;
    protected Color _popupColor = Color.BLACK;
    protected TabEditor _tabEditor;
    protected boolean _isEditing;
    protected int _editingTab = -1;
    protected String _oldValue;
    protected String _oldPrefix;
    protected String _oldPostfix;
    protected final boolean PAINT_TAB = true;
    protected final boolean PAINT_TAB_BORDER = true;
    protected final boolean PAINT_TAB_BACKGROUND = true;
    protected final boolean PAINT_TABAREA = true;
    protected final boolean PAINT_CONTENT_BORDER = true;
    protected final boolean PAINT_CONTENT_BORDER_EDGE = true;

    public static ComponentUI createUI(JComponent c) {
        return new BasicJideTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        if (c == null) {
            return;
        }
        this._tabPane = (JideTabbedPane)c;
        if (this._tabPane.isTabShown() && this._tabPane.getTabLeadingComponent() != null) {
            this._tabLeadingComponent = this._tabPane.getTabLeadingComponent();
        }
        if (this._tabPane.isTabShown() && this._tabPane.getTabTrailingComponent() != null) {
            this._tabTrailingComponent = this._tabPane.getTabTrailingComponent();
        }
        c.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installColorTheme();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void installColorTheme() {
        switch (this.getTabShape()) {
            case 8: {
                this._selectColor1 = this._darkShadow;
                this._selectColor2 = this._lightHighlight;
                this._selectColor3 = this._shadow;
                this._unselectColor1 = this._darkShadow;
                this._unselectColor2 = this._lightHighlight;
                this._unselectColor3 = this._shadow;
                break;
            }
            case 1: 
            case 11: {
                this._selectColor1 = this._lightHighlight;
                this._selectColor2 = this._shadow;
                this._selectColor3 = this._defaultTabBorderShadowColor;
                this._unselectColor1 = this._selectColor1;
                this._unselectColor2 = this._selectColor2;
                this._unselectColor3 = this._selectColor3;
                break;
            }
            case 2: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._shadow;
                this._unselectColor1 = this._selectColor1;
                break;
            }
            case 9: {
                this._selectColor2 = this._selectColor1 = this._shadow;
                this._unselectColor1 = this._selectColor1;
                break;
            }
            case 5: {
                this._unselectColor1 = this._selectColor1 = this._shadow;
                break;
            }
            case 10: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._shadow;
                this._unselectColor1 = this._selectColor1;
                this._unselectColor2 = this._selectColor2;
                break;
            }
            case 3: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._lightHighlight;
                this._unselectColor1 = this.getPainter().getControlShadow();
                this._unselectColor2 = this._lightHighlight;
                break;
            }
            default: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._lightHighlight;
                this._unselectColor1 = this._shadow;
                this._unselectColor2 = null;
                this._unselectColor3 = null;
            }
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallColorTheme();
        this.uninstallDefaults();
        this.uninstallComponents();
        c.setLayout(null);
        this._tabTrailingComponent = null;
        this._tabLeadingComponent = null;
        this._tabPane = null;
    }

    public void uninstallColorTheme() {
        this._selectColor1 = null;
        this._selectColor2 = null;
        this._selectColor3 = null;
        this._unselectColor1 = null;
        this._unselectColor2 = null;
        this._unselectColor3 = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this._tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    protected boolean scrollableTabLayoutEnabled() {
        return this._tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this._tabScroller == null) {
            this._tabScroller = new ScrollableTabSupport(this._tabPane.getTabPlacement());
            this._tabPane.add(this._tabScroller.viewport);
            this._tabPane.add(this._tabScroller.scrollForwardButton);
            this._tabPane.add(this._tabScroller.scrollBackwardButton);
            this._tabPane.add(this._tabScroller.listButton);
            this._tabPane.add(this._tabScroller.closeButton);
            if (this._tabLeadingComponent != null) {
                this._tabPane.add(this._tabLeadingComponent);
            }
            if (this._tabTrailingComponent != null) {
                this._tabPane.add(this._tabTrailingComponent);
            }
        }
    }

    protected void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this._tabPane.remove(this._tabScroller.viewport);
            this._tabPane.remove(this._tabScroller.scrollForwardButton);
            this._tabPane.remove(this._tabScroller.scrollBackwardButton);
            this._tabPane.remove(this._tabScroller.listButton);
            this._tabPane.remove(this._tabScroller.closeButton);
            if (this._tabLeadingComponent != null) {
                this._tabPane.remove(this._tabLeadingComponent);
            }
            if (this._tabTrailingComponent != null) {
                this._tabPane.remove(this._tabTrailingComponent);
            }
            this._tabScroller = null;
        }
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideTabbedPane.gripperPainter");
        LookAndFeel.installColorsAndFont(this._tabPane, "JideTabbedPane.background", "JideTabbedPane.foreground", "JideTabbedPane.font");
        LookAndFeel.installBorder(this._tabPane, "JideTabbedPane.border");
        Font f = this._tabPane.getSelectedTabFont();
        if (f == null || f instanceof UIResource) {
            this._tabPane.setSelectedTabFont(UIDefaultsLookup.getFont("JideTabbedPane.selectedTabFont"));
        }
        this._highlight = UIDefaultsLookup.getColor("JideTabbedPane.light");
        this._lightHighlight = UIDefaultsLookup.getColor("JideTabbedPane.highlight");
        this._shadow = UIDefaultsLookup.getColor("JideTabbedPane.shadow");
        this._darkShadow = UIDefaultsLookup.getColor("JideTabbedPane.darkShadow");
        this._focus = UIDefaultsLookup.getColor("TabbedPane.focus");
        if (this.getTabShape() == 3) {
            this._background = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground");
            this._tabBackground = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground");
            this._inactiveTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.foreground");
            this._activeTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.foreground");
            this._selectedColor = this._lightHighlight;
        } else {
            this._background = UIDefaultsLookup.getColor("JideTabbedPane.background");
            this._tabBackground = UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackground");
            this._inactiveTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.unselectedTabTextForeground");
            this._activeTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabTextForeground");
            this._selectedColor = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground");
        }
        this._tabListBackground = UIDefaultsLookup.getColor("JideTabbedPane.tabListBackground");
        this._textIconGap = UIDefaultsLookup.getInt("JideTabbedPane.textIconGap");
        this._tabInsets = UIDefaultsLookup.getInsets("JideTabbedPane.tabInsets");
        this._selectedTabPadInsets = UIDefaultsLookup.getInsets("TabbedPane.selectedTabPadInsets");
        this._tabAreaInsets = UIDefaultsLookup.getInsets("JideTabbedPane.tabAreaInsets");
        Insets insets = this._tabPane.getContentBorderInsets();
        if (insets == null || insets instanceof UIResource) {
            this._tabPane.setContentBorderInsets(UIDefaultsLookup.getInsets("JideTabbedPane.contentBorderInsets"));
        }
        this._ignoreContentBorderInsetsIfNoTabs = UIDefaultsLookup.getBoolean("JideTabbedPane.ignoreContentBorderInsetsIfNoTabs");
        this._tabRunOverlay = UIDefaultsLookup.getInt("JideTabbedPane.tabRunOverlay");
        this._showIconOnTab = UIDefaultsLookup.getBoolean("JideTabbedPane.showIconOnTab");
        this._showCloseButtonOnTab = UIDefaultsLookup.getBoolean("JideTabbedPane.showCloseButtonOnTab");
        this._closeButtonAlignment = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonAlignment");
        this._gripperWidth = UIDefaultsLookup.getInt("Gripper.size");
        this._tabRectPadding = UIDefaultsLookup.getInt("JideTabbedPane.tabRectPadding");
        this._closeButtonMarginHorizon = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginHorizonal");
        this._closeButtonMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginVertical");
        this._textMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.textMarginVertical");
        this._noIconMargin = UIDefaultsLookup.getInt("JideTabbedPane.noIconMargin");
        this._iconMargin = UIDefaultsLookup.getInt("JideTabbedPane.iconMargin");
        this._textPadding = UIDefaultsLookup.getInt("JideTabbedPane.textPadding");
        this._buttonSize = UIDefaultsLookup.getInt("JideTabbedPane.buttonSize");
        this._buttonMargin = UIDefaultsLookup.getInt("JideTabbedPane.buttonMargin");
        this._fitStyleBoundSize = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleBoundSize");
        this._fitStyleFirstTabMargin = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleFirstTabMargin");
        this._fitStyleIconMinWidth = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleIconMinWidth");
        this._fitStyleTextMinWidth = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleTextMinWidth");
        this._compressedStyleNoIconRectSize = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleNoIconRectSize");
        this._compressedStyleIconMargin = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleIconMargin");
        this._compressedStyleCloseButtonMarginHorizon = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleCloseButtonMarginHorizontal");
        this._compressedStyleCloseButtonMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleCloseButtonMarginVertical");
        this._fixedStyleRectSize = UIDefaultsLookup.getInt("JideTabbedPane.fixedStyleRectSize");
        this._closeButtonMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMargin");
        this._gripLeftMargin = UIDefaultsLookup.getInt("JideTabbedPane.gripLeftMargin");
        this._closeButtonMarginSize = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginSize");
        this._closeButtonLeftMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonLeftMargin");
        this._closeButtonRightMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonRightMargin");
        this._defaultTabBorderShadowColor = UIDefaultsLookup.getColor("JideTabbedPane.defaultTabBorderShadowColor");
        this._alwaysShowLineBorder = UIDefaultsLookup.getBoolean("JideTabbedPane.alwaysShowLineBorder");
        this._showFocusIndicator = UIDefaultsLookup.getBoolean("JideTabbedPane.showFocusIndicator");
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._gripperPainter = null;
        this._highlight = null;
        this._lightHighlight = null;
        this._shadow = null;
        this._darkShadow = null;
        this._focus = null;
        this._inactiveTabForeground = null;
        this._selectedColor = null;
        this._tabInsets = null;
        this._selectedTabPadInsets = null;
        this._tabAreaInsets = null;
        this._defaultTabBorderShadowColor = null;
    }

    protected void installListeners() {
        if (this._propertyChangeListener == null) {
            this._propertyChangeListener = this.createPropertyChangeListener();
            this._tabPane.addPropertyChangeListener(this._propertyChangeListener);
        }
        if (this._tabChangeListener == null) {
            this._tabChangeListener = this.createChangeListener();
            this._tabPane.addChangeListener(this._tabChangeListener);
        }
        if (this._tabFocusListener == null) {
            this._tabFocusListener = this.createFocusListener();
            this._tabPane.addFocusListener(this._tabFocusListener);
        }
        if (this._mouseListener == null) {
            this._mouseListener = this.createMouseListener();
            this._tabPane.addMouseListener(this._mouseListener);
        }
        if (this._mousemotionListener == null) {
            this._mousemotionListener = this.createMouseMotionListener();
            this._tabPane.addMouseMotionListener(this._mousemotionListener);
        }
        if (this._mouseWheelListener == null) {
            this._mouseWheelListener = this.createMouseWheelListener();
            this._tabPane.addMouseWheelListener(this._mouseWheelListener);
        }
        if (this._containerListener == null) {
            this._containerListener = new ContainerHandler();
            this._tabPane.addContainerListener(this._containerListener);
            if (this._tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
        if (this._componentListener == null) {
            this._componentListener = new ComponentHandler();
            this._tabPane.addComponentListener(this._componentListener);
        }
        if (!this._tabPane.isDragOverDisabled() && this._dropListener == null) {
            this._dropListener = this.createDropListener();
            this._dt = new DropTarget(this.getTabPanel(), this._dropListener);
        }
    }

    protected DropListener createDropListener() {
        return new DropListener();
    }

    protected void uninstallListeners() {
        if (this._containerListener != null) {
            this._tabPane.removeContainerListener(this._containerListener);
            this._containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this._componentListener != null) {
            this._tabPane.removeComponentListener(this._componentListener);
            this._componentListener = null;
        }
        if (this._tabChangeListener != null) {
            this._tabPane.removeChangeListener(this._tabChangeListener);
            this._tabChangeListener = null;
        }
        if (this._tabFocusListener != null) {
            this._tabPane.removeFocusListener(this._tabFocusListener);
            this._tabFocusListener = null;
        }
        if (this._mouseListener != null) {
            this._tabPane.removeMouseListener(this._mouseListener);
            this._mouseListener = null;
        }
        if (this._mousemotionListener != null) {
            this._tabPane.removeMouseMotionListener(this._mousemotionListener);
            this._mousemotionListener = null;
        }
        if (this._mouseWheelListener != null) {
            this._tabPane.removeMouseWheelListener(this._mouseWheelListener);
            this._mouseWheelListener = null;
        }
        if (this._propertyChangeListener != null) {
            this._tabPane.removePropertyChangeListener(this._propertyChangeListener);
            this._propertyChangeListener = null;
        }
        if (this._dt != null && this._dropListener != null) {
            this._dt.removeDropTargetListener(this._dropListener);
            this._dropListener = null;
            this._dt = null;
            this.getTabPanel().setDropTarget(null);
        }
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected FocusListener createFocusListener() {
        return new TabFocusListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this._tabPane, 1, km);
        km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this._tabPane, 0, km);
        ActionMap am = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this._tabPane, am);
        this.ensureCloseButtonCreated();
        if (this.scrollableTabLayoutEnabled()) {
            this._tabScroller.scrollForwardButton.setAction(am.get("scrollTabsForwardAction"));
            this._tabScroller.scrollBackwardButton.setAction(am.get("scrollTabsBackwardAction"));
            this._tabScroller.listButton.setAction(am.get("scrollTabsListAction"));
            Action action = this._tabPane.getCloseAction();
            this.updateButtonFromAction(this._tabScroller.closeButton, action);
            this._tabScroller.closeButton.setAction(am.get("closeTabAction"));
        }
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIDefaultsLookup.get("JideTabbedPane.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)UIDefaultsLookup.get("JideTabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIDefaultsLookup.get("JideTabbedPane.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("JideTabbedPane.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("navigateNext", new NextAction());
        map.put("navigatePrevious", new PreviousAction());
        map.put("navigateRight", new RightAction());
        map.put("navigateLeft", new LeftAction());
        map.put("navigateUp", new UpAction());
        map.put("navigateDown", new DownAction());
        map.put("navigatePageUp", new PageUpAction());
        map.put("navigatePageDown", new PageDownAction());
        map.put("requestFocus", new RequestFocusAction());
        map.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        map.put("setSelectedIndex", new SetSelectedIndexAction());
        map.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        map.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        map.put("scrollTabsListAction", new ScrollTabsListAction());
        map.put("closeTabAction", new CloseTabAction());
        return map;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this._tabPane, null);
        SwingUtilities.replaceUIInputMap(this._tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this._tabPane, 0, null);
        if (this._closeButtons != null) {
            for (int i = 0; i < this._closeButtons.length; ++i) {
                this._closeButtons[i] = null;
            }
            this._closeButtons = null;
        }
    }

    protected void updateMnemonics() {
        this.resetMnemonics();
        for (int counter = this._tabPane.getTabCount() - 1; counter >= 0; --counter) {
            int mnemonic = this._tabPane.getMnemonicAt(counter);
            if (mnemonic <= 0) continue;
            this.addMnemonic(counter, mnemonic);
        }
    }

    private void resetMnemonics() {
        if (this._mnemonicToIndexMap != null) {
            this._mnemonicToIndexMap.clear();
            this._mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int index, int mnemonic) {
        if (this._mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this._mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        this._mnemonicToIndexMap.put(mnemonic, index);
    }

    private void initMnemonics() {
        this._mnemonicToIndexMap = new Hashtable();
        this._mnemonicInputMap = new InputMapUIResource();
        this._mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this._tabPane, 1));
        SwingUtilities.replaceUIInputMap(this._tabPane, 1, this._mnemonicInputMap);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int tc = this._tabPane.getTabCount();
        this.paintBackground(g, c);
        if (tc == 0) {
            return;
        }
        if (this._tabCount != tc) {
            this._tabCount = tc;
            this.updateMnemonics();
        }
        int selectedIndex = this._tabPane.getSelectedIndex();
        int tabPlacement = this._tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(g, tabPlacement, selectedIndex, c);
        }
        this.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    public void paintBackground(Graphics g, Component c) {
        if (this._tabPane.isOpaque()) {
            int width = c.getWidth();
            int height = c.getHeight();
            g.setColor(this._background);
            g.fillRect(0, 0, width, height);
        }
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex, Component c) {
        int tabCount = this._tabPane.getTabCount();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle tempR = g.getClipBounds();
        Rectangle clipRect = new Rectangle(tempR.x, tempR.y, c.getWidth(), c.getHeight());
        this.paintTabAreaBackground(g, clipRect, tabPlacement);
        for (int i = this._runCount - 1; i >= 0; --i) {
            int start = this._tabRuns[i];
            int next = this._tabRuns[i == this._runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            for (int j = start; j <= end; ++j) {
                if (!this._rects[j].intersects(clipRect) || j == selectedIndex) continue;
                this.paintTab(g, tabPlacement, this._rects, j, iconRect, textRect);
            }
        }
        if (selectedIndex >= 0 && this.getRunForTab(tabCount, selectedIndex) == 0 && this._rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(g, tabPlacement, this._rects, selectedIndex, iconRect, textRect);
        }
    }

    protected void paintTabAreaBackground(Graphics g, Rectangle rect, int tabPlacement) {
        this.getPainter().paintTabAreaBackground(this._tabPane, g, rect, tabPlacement == 1 || tabPlacement == 3 ? 0 : 1, 0);
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this._tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        Graphics g2 = null;
        Object cropShape = null;
        Shape save = null;
        int cropx = 0;
        int cropy = 0;
        this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        Object savedHints = JideSwingUtilities.setupShapeAntialiasing(g);
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        JideSwingUtilities.restoreShapeAntialiasing(g, savedHints);
        Icon icon = this._tabPane.getIconForTab(tabIndex);
        Rectangle tempTabRect = new Rectangle(tabRect);
        if (this._tabPane.isShowGripper()) {
            tempTabRect.x += this._gripperWidth;
            tempTabRect.width -= this._gripperWidth;
            Rectangle gripperRect = new Rectangle(tabRect);
            gripperRect.x += this._gripLeftMargin;
            gripperRect.width = this._gripperWidth;
            if (this._gripperPainter != null) {
                this._gripperPainter.paint(this._tabPane, g, gripperRect, 0, isSelected ? 3 : 0);
            } else {
                this.getPainter().paintGripper(this._tabPane, g, gripperRect, 0, isSelected ? 3 : 0);
            }
        }
        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this._tabPane.isTabClosableAt(tabIndex) && (!this._tabPane.isShowCloseButtonOnSelectedTab() || isSelected)) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                int buttonWidth = this._closeButtons[tabIndex].getPreferredSize().width + this._closeButtonLeftMargin + this._closeButtonRightMargin;
                if (this._closeButtonAlignment == 10) {
                    tempTabRect.x += buttonWidth;
                    tempTabRect.width -= buttonWidth;
                } else {
                    tempTabRect.width -= buttonWidth;
                }
            } else {
                int buttonHeight = this._closeButtons[tabIndex].getPreferredSize().height + this._closeButtonLeftMargin + this._closeButtonRightMargin;
                if (this._closeButtonAlignment == 10) {
                    tempTabRect.y += buttonHeight;
                    tempTabRect.height -= buttonHeight;
                } else {
                    tempTabRect.height -= buttonHeight;
                }
            }
        }
        String title = this._tabPane.getDisplayTitleAt(tabIndex);
        Font font = null;
        font = isSelected && this._tabPane.getSelectedTabFont() != null ? this._tabPane.getSelectedTabFont() : this._tabPane.getFont();
        if (isSelected && this._tabPane.isBoldActiveTab() && font.getStyle() != 1) {
            font = font.deriveFont(1);
        }
        FontMetrics metrics = g.getFontMetrics(font);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tempTabRect, iconRect, textRect, isSelected);
        this.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
        if (cropShape != null) {
            this.paintCroppedTabEdge(g, tabPlacement, tabIndex, isSelected, cropx, cropy);
            g2.setClip(save);
        }
    }

    private Polygon createCroppedTabClip(int tabPlacement, Rectangle tabRect, int cropline) {
        int rlen = 0;
        int start = 0;
        int end = 0;
        int ostart = 0;
        switch (tabPlacement) {
            case 2: 
            case 4: {
                rlen = tabRect.width;
                start = tabRect.x;
                end = tabRect.x + tabRect.width;
                ostart = tabRect.y;
                break;
            }
            default: {
                rlen = tabRect.height;
                start = tabRect.y;
                end = tabRect.y + tabRect.height;
                ostart = tabRect.x;
            }
        }
        int rcnt = rlen / 12;
        if (rlen % 12 > 0) {
            ++rcnt;
        }
        int npts = 2 + (rcnt << 3);
        int[] xp = new int[npts];
        int[] yp = new int[npts];
        int pcnt = 0;
        xp[pcnt] = ostart;
        yp[pcnt++] = end;
        xp[pcnt] = ostart;
        yp[pcnt++] = start;
        block3: for (int i = 0; i < rcnt; ++i) {
            for (int j = 0; j < this.xCropLen.length; ++j) {
                xp[pcnt] = cropline - this.xCropLen[j];
                yp[pcnt] = start + i * 12 + this.yCropLen[j];
                if (yp[pcnt] >= end) {
                    yp[pcnt] = end;
                    ++pcnt;
                    continue block3;
                }
                ++pcnt;
            }
        }
        if (tabPlacement == 1 || tabPlacement == 3) {
            return new Polygon(xp, yp, pcnt);
        }
        return new Polygon(yp, xp, pcnt);
    }

    private void paintCroppedTabEdge(Graphics g, int tabPlacement, int tabIndex, boolean isSelected, int x, int y) {
        switch (tabPlacement) {
            case 2: 
            case 4: {
                g.setColor(this._shadow);
                for (int xx = x; xx <= x + this._rects[tabIndex].width; xx += 12) {
                    for (int i = 0; i < this.xCropLen.length; i += 2) {
                        g.drawLine(xx + this.yCropLen[i], y - this.xCropLen[i], xx + this.yCropLen[i + 1] - 1, y - this.xCropLen[i + 1]);
                    }
                }
                break;
            }
            default: {
                g.setColor(this._shadow);
                for (int yy = y; yy <= y + this._rects[tabIndex].height; yy += 12) {
                    for (int i = 0; i < this.xCropLen.length; i += 2) {
                        g.drawLine(x - this.xCropLen[i], yy + this.yCropLen[i], x - this.xCropLen[i + 1], yy + this.yCropLen[i + 1] - 1);
                    }
                }
            }
        }
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this._tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this._tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this._textIconGap);
        this._tabPane.putClientProperty("html", null);
        if (tabPlacement == 1 || tabPlacement == 3) {
            if (this.getTabResizeMode() == 4 && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab() && !isSelected) {
                iconRect.width = iconRect.width + this._closeButtons[tabIndex].getPreferredSize().width + this._closeButtonMarginHorizon;
                textRect.width = 0;
            }
        } else {
            iconRect.y = tabRect.y + this._iconMargin;
            textRect.y = icon != null ? iconRect.y + iconRect.height + this._textIconGap : tabRect.y + this._textPadding;
            iconRect.x = tabRect.x + 2;
            textRect.x = tabRect.x + 2;
            textRect.width = tabRect.width - this._textMarginVertical;
            textRect.height = tabRect.height - this._tabRectPadding - iconRect.height - (icon != null ? this._textIconGap + this._iconMargin : this._noIconMargin);
            if (this.getTabResizeMode() == 4 && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab() && !isSelected) {
                iconRect.height = iconRect.height + this._closeButtons[tabIndex].getPreferredSize().height + this._closeButtonMarginVertical;
                textRect.height = 0;
            }
        }
    }

    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (icon != null && iconRect.width >= icon.getIconWidth()) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                icon.paintIcon(this._tabPane, g, iconRect.x, iconRect.y);
            } else if (iconRect.height < this._rects[tabIndex].height - this._gripperHeight) {
                icon.paintIcon(this._tabPane, g, iconRect.x, iconRect.y);
            }
        }
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        View v;
        Graphics2D g2d = (Graphics2D)g.create();
        if (isSelected && this._tabPane.isBoldActiveTab()) {
            g2d.setFont(font.deriveFont(1));
        } else {
            g2d.setFont(font);
        }
        String actualText = title;
        if (tabPlacement == 1 || tabPlacement == 3) {
            if (textRect.width <= 0) {
                return;
            }
            while (SwingUtilities.computeStringWidth(metrics, actualText) > textRect.width) {
                actualText = actualText.substring(0, actualText.length() - 1);
            }
            if (!actualText.equals(title)) {
                actualText = actualText.length() >= 2 ? actualText.substring(0, actualText.length() - 2) + ".." : "";
            }
        } else {
            if (textRect.height <= 0) {
                return;
            }
            while (SwingUtilities.computeStringWidth(metrics, actualText) > textRect.height) {
                actualText = actualText.substring(0, actualText.length() - 1);
            }
            if (!actualText.equals(title)) {
                actualText = actualText.length() >= 2 ? actualText.substring(0, actualText.length() - 2) + ".." : "";
            }
        }
        if ((v = this.getTextViewForTab(tabIndex)) != null) {
            v.paint(g2d, textRect);
        } else {
            int mnemIndex = this._tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            JideTabbedPane.ColorProvider colorProvider = this._tabPane.getTabColorProvider();
            if (this._tabPane.isEnabled() && this._tabPane.isEnabledAt(tabIndex)) {
                if (colorProvider != null) {
                    g2d.setColor(colorProvider.getForegroudAt(tabIndex));
                } else {
                    Color color = this._tabPane.getForegroundAt(tabIndex);
                    if (isSelected && this.showFocusIndicator()) {
                        if (!(color instanceof ColorUIResource)) {
                            g2d.setColor(color);
                        } else {
                            g2d.setColor(this._activeTabForeground);
                        }
                    } else if (!(color instanceof ColorUIResource)) {
                        g2d.setColor(color);
                    } else {
                        g2d.setColor(this._inactiveTabForeground);
                    }
                }
                if (tabPlacement == 1 || tabPlacement == 3) {
                    JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, g2d, actualText, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                } else {
                    AffineTransform old = g2d.getTransform();
                    g2d.translate(textRect.x, textRect.y);
                    if (tabPlacement == 4) {
                        g2d.rotate(1.5707963267948966);
                        g2d.translate(0, -textRect.width);
                    } else {
                        g2d.rotate(-1.5707963267948966);
                        g2d.translate(-textRect.height + 7, 0);
                    }
                    JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, g2d, actualText, mnemIndex, 0, (textRect.width - metrics.getHeight()) / 2 + metrics.getAscent());
                    g2d.setTransform(old);
                }
            } else if (tabPlacement == 1 || tabPlacement == 3) {
                g2d.setColor(this._tabPane.getBackgroundAt(tabIndex).brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, g2d, actualText, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g2d.setColor(this._tabPane.getBackgroundAt(tabIndex).darker());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, g2d, actualText, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            } else {
                AffineTransform old = g2d.getTransform();
                g2d.translate(textRect.x, textRect.y);
                if (tabPlacement == 4) {
                    g2d.rotate(1.5707963267948966);
                    g2d.translate(0, -textRect.width);
                } else {
                    g2d.rotate(-1.5707963267948966);
                    g2d.translate(-textRect.height + 7, 0);
                }
                g2d.setColor(this._tabPane.getBackgroundAt(tabIndex).brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, g2d, actualText, mnemIndex, 0, (textRect.width - metrics.getHeight()) / 2 + metrics.getAscent());
                g2d.setColor(this._tabPane.getBackgroundAt(tabIndex).darker());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, g2d, actualText, mnemIndex, tabPlacement == 4 ? -1 : 1, (textRect.width - metrics.getHeight()) / 2 + metrics.getAscent() - 1);
                g2d.setTransform(old);
            }
        }
        g2d.dispose();
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        switch (this.getTabShape()) {
            case 3: {
                this.paintBoxTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 8: {
                this.paintExcelTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 1: {
                this.paintWindowsTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 11: {
                if (!isSelected) break;
                this.paintWindowsTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 2: {
                this.paintVsnetTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 9: {
                this.paintRoundedVsnetTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 5: {
                this.paintFlatTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 10: {
                this.paintRoundedFlatTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            default: {
                this.paintOffice2003TabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
            }
        }
        int tabShape = this.getTabShape();
        if (tabShape == 1) {
            if (this._mouseEnter && this._tabPane.getColorTheme() == 4 && tabIndex == this._indexMouseOver && !isSelected && this._tabPane.isEnabledAt(this._indexMouseOver)) {
                this.paintTabBorderMouseOver(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
            }
        } else if (tabShape == 11 && this._mouseEnter && tabIndex == this._indexMouseOver && !isSelected && this._tabPane.isEnabledAt(this._indexMouseOver)) {
            this.paintTabBorderMouseOver(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        }
    }

    protected void paintOffice2003TabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                y += 2;
                if (isSelected) {
                    int i;
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y + 3, x, y + h - 5);
                    g.drawLine(x + 1, y + h - 4, x + 1, y + h - 4);
                    g.drawLine(x + 2, y + h - 3, x + w - 1, y + h - 3);
                    g.drawLine(x + 1, y + 2, x + 1, y + 1);
                    g.drawLine(x + 2, y, x + 2, y - 1);
                    for (i = 0; i < w - 4; ++i) {
                        g.drawLine(x + 3 + i, y - 2 - i, x + 3 + i, y - 2 - i);
                    }
                    g.drawLine(x + w - 1, y - w + 1, x + w - 1, y - w + 2);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + 1, y + 3, x + 1, y + h - 5);
                    g.drawLine(x + 2, y + h - 4, x + w - 1, y + h - 4);
                    g.drawLine(x + 2, y + 2, x + 2, y + 1);
                    g.drawLine(x + 3, y, x + 3, y - 1);
                    for (i = 0; i < w - 4; ++i) {
                        g.drawLine(x + 4 + i, y - 2 - i, x + 4 + i, y - 2 - i);
                    }
                    break;
                }
                if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                    int i;
                    g.setColor(this._unselectColor1);
                    g.drawLine(x, y + 3, x, y + h - 5);
                    g.drawLine(x + 1, y + h - 4, x + 1, y + h - 4);
                    g.drawLine(x + 2, y + h - 3, x + w - 1, y + h - 3);
                    g.drawLine(x + 1, y + 2, x + 1, y + 1);
                    g.drawLine(x + 2, y, x + 2, y - 1);
                    for (i = 0; i < w - 4; ++i) {
                        g.drawLine(x + 3 + i, y - 2 - i, x + 3 + i, y - 2 - i);
                    }
                    g.drawLine(x + w - 1, y - w + 1, x + w - 1, y - w + 2);
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + 1, y + 3, x + 1, y + h - 6);
                        g.drawLine(x + 2, y + 2, x + 2, y + 1);
                        g.drawLine(x + 3, y, x + 3, y - 1);
                        for (i = 0; i < w - 4; ++i) {
                            g.drawLine(x + 4 + i, y - 2 - i, x + 4 + i, y - 2 - i);
                        }
                        g.setColor(this.getPainter().getControlDk());
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + 2, y + h - 4, x + w - 1, y + h - 4);
                    g.drawLine(x + 1, y + h - 5, x + 1, y + h - 5);
                    break;
                }
                g.setColor(this._unselectColor1);
                g.drawLine(x, y + 3, x, y + h - 5);
                g.drawLine(x + 1, y + h - 4, x + 1, y + h - 4);
                g.drawLine(x + 2, y + h - 3, x + w - 1, y + h - 3);
                g.drawLine(x + 1, y + 2, x + 1, y + 1);
                g.drawLine(x + 2, y, x + 2, y - 1);
                g.drawLine(x + 3, y - 2, x + 3, y - 2);
                if (this._unselectColor2 != null) {
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + 1, y + 3, x + 1, y + h - 6);
                    g.drawLine(x + 2, y + 2, x + 2, y + 1);
                    g.drawLine(x + 3, y, x + 3, y - 1);
                    g.drawLine(x + 4, y - 2, x + 4, y - 2);
                }
                if (this._unselectColor3 == null) break;
                g.setColor(this._unselectColor3);
                g.drawLine(x + 2, y + h - 4, x + w - 1, y + h - 4);
                g.drawLine(x + 1, y + h - 5, x + 1, y + h - 5);
                break;
            }
            case 4: {
                if (isSelected) {
                    int i;
                    g.setColor(this._selectColor1);
                    g.drawLine(x + w - 1, y + 5, x + w - 1, y + h - 3);
                    g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 3, y + h - 1, x, y + h - 1);
                    g.drawLine(x + w - 2, y + 4, x + w - 2, y + 3);
                    g.drawLine(x + w - 3, y + 2, x + w - 3, y + 1);
                    for (i = 0; i < w - 4; ++i) {
                        g.drawLine(x + w - 4 - i, y - i, x + w - 4 - i, y - i);
                    }
                    g.drawLine(x, y - w + 3, x, y - w + 4);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + w - 2, y + 5, x + w - 2, y + h - 3);
                    g.drawLine(x + w - 3, y + h - 2, x, y + h - 2);
                    g.drawLine(x + w - 3, y + 4, x + w - 3, y + 3);
                    g.drawLine(x + w - 4, y + 2, x + w - 4, y + 1);
                    for (i = 0; i < w - 4; ++i) {
                        g.drawLine(x + w - 5 - i, y - i, x + w - 5 - i, y - i);
                    }
                    break;
                }
                if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                    int i;
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + w - 1, y + 5, x + w - 1, y + h - 3);
                    g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 3, y + h - 1, x, y + h - 1);
                    g.drawLine(x + w - 2, y + 4, x + w - 2, y + 3);
                    g.drawLine(x + w - 3, y + 2, x + w - 3, y + 1);
                    for (i = 0; i < w - 4; ++i) {
                        g.drawLine(x + w - 4 - i, y - i, x + w - 4 - i, y - i);
                    }
                    g.drawLine(x, y - w + 3, x, y - w + 4);
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + w - 2, y + 5, x + w - 2, y + h - 4);
                        g.drawLine(x + w - 3, y + 4, x + w - 3, y + 3);
                        g.drawLine(x + w - 4, y + 2, x + w - 4, y + 1);
                        for (i = 0; i < w - 4; ++i) {
                            g.drawLine(x + w - 5 - i, y - i, x + w - 5 - i, y - i);
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 2, y + h - 3, x + w - 2, y + h - 3);
                    g.drawLine(x + w - 3, y + h - 2, x, y + h - 2);
                    break;
                }
                g.setColor(this._unselectColor1);
                g.drawLine(x + w - 1, y + 5, x + w - 1, y + h - 3);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 3, y + h - 1, x, y + h - 1);
                g.drawLine(x + w - 2, y + 4, x + w - 2, y + 3);
                g.drawLine(x + w - 3, y + 2, x + w - 3, y + 1);
                g.drawLine(x + w - 4, y, x + w - 4, y);
                if (this._unselectColor2 != null) {
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + w - 2, y + 5, x + w - 2, y + h - 4);
                    g.drawLine(x + w - 3, y + 4, x + w - 3, y + 3);
                    g.drawLine(x + w - 4, y + 2, x + w - 4, y + 1);
                    g.drawLine(x + w - 5, y, x + w - 5, y);
                }
                if (this._unselectColor3 == null) break;
                g.setColor(this._unselectColor3);
                g.drawLine(x + w - 2, y + h - 3, x + w - 2, y + h - 3);
                g.drawLine(x + w - 3, y + h - 2, x, y + h - 2);
                break;
            }
            case 3: {
                if (isSelected) {
                    int i;
                    g.setColor(this._selectColor1);
                    g.drawLine(x + w - 1, y + h - 3, x + w - 1, y);
                    g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + 5, y + h - 1, x + w - 3, y + h - 1);
                    g.drawLine(x + 3, y + h - 2, x + 4, y + h - 2);
                    g.drawLine(x + 1, y + h - 3, x + 2, y + h - 3);
                    g.drawLine(x, y + h - 4, x, y + h - 4);
                    for (i = 3; i < h - 2; ++i) {
                        g.drawLine(x + 2 - i, y + h - 2 - i, x + 2 - i, y + h - 2 - i);
                    }
                    g.drawLine(x - h + 3, y, x - h + 4, y);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + 5, y + h - 2, x + w - 3, y + h - 2);
                    g.drawLine(x + w - 2, y, x + w - 2, y + h - 3);
                    g.drawLine(x + 3, y + h - 3, x + 4, y + h - 3);
                    g.drawLine(x + 1, y + h - 4, x + 2, y + h - 4);
                    g.drawLine(x, y + h - 5, x, y + h - 5);
                    for (i = 3; i < h - 2; ++i) {
                        g.drawLine(x + 2 - i, y + h - 3 - i, x + 2 - i, y + h - 3 - i);
                    }
                    break;
                }
                if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                    int i;
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + w - 1, y + h - 3, x + w - 1, y);
                    g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + 5, y + h - 1, x + w - 3, y + h - 1);
                    g.drawLine(x + 3, y + h - 2, x + 4, y + h - 2);
                    g.drawLine(x + 1, y + h - 3, x + 2, y + h - 3);
                    g.drawLine(x, y + h - 4, x, y + h - 4);
                    for (i = 3; i < h - 2; ++i) {
                        g.drawLine(x + 2 - i, y + h - 2 - i, x + 2 - i, y + h - 2 - i);
                    }
                    g.drawLine(x - h + 3, y, x - h + 4, y);
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + 3, y + h - 3, x + 4, y + h - 3);
                        g.drawLine(x + 1, y + h - 4, x + 2, y + h - 4);
                        g.drawLine(x, y + h - 5, x, y + h - 5);
                        for (i = 3; i < h - 2; ++i) {
                            g.drawLine(x + 2 - i, y + h - 3 - i, x + 2 - i, y + h - 3 - i);
                        }
                        g.drawLine(x + 5, y + h - 2, x + w - 4, y + h - 2);
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 3, y + h - 2, x + w - 3, y + h - 2);
                    g.drawLine(x + w - 2, y + h - 3, x + w - 2, y);
                    break;
                }
                g.setColor(this._unselectColor1);
                g.drawLine(x + 5, y + h - 1, x + w - 3, y + h - 1);
                g.drawLine(x + w - 1, y + h - 3, x + w - 1, y);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + 3, y + h - 2, x + 4, y + h - 2);
                g.drawLine(x + 1, y + h - 3, x + 2, y + h - 3);
                g.drawLine(x, y + h - 4, x, y + h - 4);
                if (this._unselectColor2 != null) {
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + 3, y + h - 3, x + 4, y + h - 3);
                    g.drawLine(x + 1, y + h - 4, x + 2, y + h - 4);
                    g.drawLine(x, y + h - 5, x, y + h - 5);
                    g.drawLine(x + 5, y + h - 2, x + w - 4, y + h - 2);
                }
                if (this._unselectColor3 == null) break;
                g.setColor(this._unselectColor3);
                g.drawLine(x + w - 3, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y + h - 3, x + w - 2, y);
                break;
            }
            default: {
                if (isSelected) {
                    int i;
                    g.setColor(this._selectColor1);
                    g.drawLine(x + 3, y + 1, x + 4, y + 1);
                    g.drawLine(x + 1, y + 2, x + 2, y + 2);
                    g.drawLine(x, y + 3, x, y + 3);
                    g.drawLine(x + 5, y, x + w - 3, y);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                    for (i = 3; i < h - 2; ++i) {
                        g.drawLine(x + 2 - i, y + 1 + i, x + 2 - i, y + 1 + i);
                    }
                    g.drawLine(x - h + 3, y + h - 1, x - h + 4, y + h - 1);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + 3, y + 2, x + 4, y + 2);
                    g.drawLine(x + 1, y + 3, x + 2, y + 3);
                    g.drawLine(x, y + 4, x, y + 4);
                    g.drawLine(x + 5, y + 1, x + w - 3, y + 1);
                    g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 1);
                    for (i = 3; i < h - 2; ++i) {
                        g.drawLine(x + 2 - i, y + 2 + i, x + 2 - i, y + 2 + i);
                    }
                    break;
                }
                if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                    int i;
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 3, y + 1, x + 4, y + 1);
                    g.drawLine(x + 1, y + 2, x + 2, y + 2);
                    g.drawLine(x, y + 3, x, y + 3);
                    g.drawLine(x + 5, y, x + w - 3, y);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                    for (i = 3; i < h - 2; ++i) {
                        g.drawLine(x + 2 - i, y + 1 + i, x + 2 - i, y + 1 + i);
                    }
                    g.drawLine(x - h + 3, y + h - 1, x - h + 4, y + h - 1);
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + 3, y + 2, x + 4, y + 2);
                        g.drawLine(x + 1, y + 3, x + 2, y + 3);
                        g.drawLine(x, y + 4, x, y + 4);
                        for (i = 3; i < h - 2; ++i) {
                            g.drawLine(x + 2 - i, y + 2 + i, x + 2 - i, y + 2 + i);
                        }
                        g.drawLine(x + 5, y + 1, x + w - 4, y + 1);
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 3, y + 1, x + w - 3, y + 1);
                    g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 1);
                    break;
                }
                g.setColor(this._unselectColor1);
                g.drawLine(x + 3, y + 1, x + 4, y + 1);
                g.drawLine(x + 1, y + 2, x + 2, y + 2);
                g.drawLine(x, y + 3, x, y + 3);
                g.drawLine(x + 5, y, x + w - 3, y);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                if (this._unselectColor2 != null) {
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + 3, y + 2, x + 4, y + 2);
                    g.drawLine(x + 1, y + 3, x + 2, y + 3);
                    g.drawLine(x, y + 4, x, y + 4);
                    g.drawLine(x + 5, y + 1, x + w - 4, y + 1);
                }
                if (this._unselectColor3 == null) break;
                g.setColor(this._unselectColor3);
                g.drawLine(x + w - 3, y + 1, x + w - 3, y + 1);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 1);
            }
        }
    }

    protected void paintExcelTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y + 5, x, y + h - 5);
                    int i = 0;
                    int j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + 1 + j, y + 4 - i, x + 2 + j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + j, y + h - 4 + i, x + 1 + j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._selectColor2 != null) {
                        g.setColor(this._selectColor2);
                        g.drawLine(x + 1, y + 6, x + 1, y + h - 6);
                        i = 0;
                        j = 0;
                        while (i < w / 2 + 1) {
                            g.drawLine(x + 1 + j, y + 5 - i, x + 2 + j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    g.setColor(this._selectColor3);
                    g.drawLine(x + 1, y + h - 5, x + 1, y + h - 5);
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + 2 + j, y + h - 4 + i, x + 3 + j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                } else if (tabIndex == 0) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x, y + 5, x, y + h - 5);
                    int i = 0;
                    int j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + 1 + j, y + 4 - i, x + 2 + j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + j, y + h - 4 + i, x + 1 + j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + 1, y + 6, x + 1, y + h - 6);
                        i = 0;
                        j = 0;
                        while (i < w / 2) {
                            g.drawLine(x + 1 + j, y + 5 - i, x + 2 + j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + 1, y + h - 5, x + 1, y + h - 5);
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + 2 + j, y + h - 4 + i, x + 3 + j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                } else if (tabIndex == this._tabPane.getSelectedIndex() - 1) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x, y + 5, x, y + h - 5);
                    int i = 0;
                    int j = 0;
                    while (i < 4) {
                        g.drawLine(x + 1 + j, y + 4 - i, x + 2 + j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g.drawLine(x + j, y + h - 4 + i, x + 1 + j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + 1, y + 6, x + 1, y + h - 6);
                        i = 0;
                        j = 0;
                        while (i < 4) {
                            g.drawLine(x + 1 + j, y + 5 - i, x + 2 + j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + 1, y + h - 5, x + 1, y + h - 5);
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g.drawLine(x + 2 + j, y + h - 4 + i, x + 3 + j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                } else {
                    if (tabIndex == this._tabPane.getSelectedIndex() - 1) break;
                    g.setColor(this._unselectColor1);
                    g.drawLine(x, y + 5, x, y + h - 5);
                    int i = 0;
                    int j = 0;
                    while (i < 4) {
                        g.drawLine(x + 1 + j, y + 4 - i, x + 2 + j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + j, y + h - 4 + i, x + 1 + j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + 1, y + 6, x + 1, y + h - 6);
                        i = 0;
                        j = 0;
                        while (i < 4) {
                            g.drawLine(x + 1 + j, y + 5 - i, x + 2 + j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + 1, y + h - 5, x + 1, y + h - 5);
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + 2 + j, y + h - 4 + i, x + 3 + j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                }
                break;
            }
            case 4: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x + w - 1, y + 5, x + w - 1, y + h - 5);
                    int i = 0;
                    int j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + w - 2 - j, y + 4 - i, x + w - 3 - j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + w - 1 - j, y + h - 4 + i, x + w - 2 - j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._selectColor2 != null) {
                        g.setColor(this._selectColor2);
                        g.drawLine(x + w - 2, y + 6, x + w - 2, y + h - 6);
                        i = 0;
                        j = 0;
                        while (i < w / 2 + 1) {
                            g.drawLine(x + w - 2 - j, y + 5 - i, x + w - 3 - j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    g.setColor(this._selectColor3);
                    g.drawLine(x + w - 2, y + h - 5, x + w - 2, y + h - 5);
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + w - 3 - j, y + h - 4 + i, x + w - 4 - j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                } else if (tabIndex == 0) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + w - 1, y + 5, x + w - 1, y + h - 5);
                    int i = 0;
                    int j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + w - 2 - j, y + 4 - i, x + w - 3 - j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + w - 1 - j, y + h - 4 + i, x + w - 2 - j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + w - 2, y + 6, x + w - 2, y + h - 6);
                        i = 0;
                        j = 0;
                        while (i < w / 2 + 1) {
                            g.drawLine(x + w - 2 - j, y + 5 - i, x + w - 3 - j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 2, y + h - 5, x + w - 2, y + h - 5);
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + w - 3 - j, y + h - 4 + i, x + w - 4 - j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                } else if (tabIndex == this._tabPane.getSelectedIndex() - 1) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + w - 1, y + 5, x + w - 1, y + h - 5);
                    int i = 0;
                    int j = 0;
                    while (i < 4) {
                        g.drawLine(x + w - 2 - j, y + 4 - i, x + w - 3 - j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g.drawLine(x + w - 1 - j, y + h - 4 + i, x + w - 2 - j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + w - 2, y + 6, x + w - 2, y + h - 6);
                        i = 0;
                        j = 0;
                        while (i < 4) {
                            g.drawLine(x + w - 2 - j, y + 5 - i, x + w - 3 - j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 2, y + h - 5, x + w - 2, y + h - 5);
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g.drawLine(x + w - 3 - j, y + h - 4 + i, x + w - 4 - j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                } else {
                    if (tabIndex == this._tabPane.getSelectedIndex() - 1) break;
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + w - 1, y + 5, x + w - 1, y + h - 5);
                    int i = 0;
                    int j = 0;
                    while (i < 4) {
                        g.drawLine(x + w - 2 - j, y + 4 - i, x + w - 3 - j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + w - 1 - j, y + h - 4 + i, x + w - 2 - j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + w - 2, y + 6, x + w - 2, y + h - 6);
                        i = 0;
                        j = 0;
                        while (i < 4) {
                            g.drawLine(x + w - 2 - j, y + 5 - i, x + w - 3 - j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 2, y + h - 5, x + w - 2, y + h - 5);
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g.drawLine(x + w - 3 - j, y + h - 4 + i, x + w - 4 - j, y + h - 4 + i);
                        ++i;
                        j += 2;
                    }
                }
                break;
            }
            case 3: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x + 5, y + h - 1, x + w - 5, y + h - 1);
                    int i = 0;
                    int j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + 4 - i, y + h - 2 - j, x + 4 - i, y + h - 3 - j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + w - 4 - 1 + i, y + h - 1 - j, x + w - 4 - 1 + i, y + h - 2 - j);
                        ++i;
                        j += 2;
                    }
                    if (this._selectColor2 != null) {
                        g.setColor(this._selectColor2);
                        g.drawLine(x + 5, y + h - 3, x + 5, y + h - 3);
                        i = 0;
                        j = 0;
                        while (i < h / 2 + 1) {
                            g.drawLine(x + 4 - i, y + h - 4 - j, x + 4 - i, y + h - 5 - j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    g.setColor(this._selectColor3);
                    g.drawLine(x + 5, y + h - 2, x + w - 6, y + h - 2);
                    i = 0;
                    j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + w - 5 + i, y + h - 3 - j, x + w - 5 + i, y + h - 4 - j);
                        ++i;
                        j += 2;
                    }
                } else if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 5, y + h - 1, x + w - 5, y + h - 1);
                    int i = 0;
                    int j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + 4 - i, y + h - 2 - j, x + 4 - i, y + h - 3 - j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + w - 4 - 1 + i, y + h - 1 - j, x + w - 4 - 1 + i, y + h - 2 - j);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        i = 0;
                        j = 0;
                        while (i < h / 2 + 1) {
                            g.drawLine(x + 5 - i, y + h - 2 - j, x + 5 - i, y + h - 3 - j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 6, y + h - 2, x + w - 6, y + h - 2);
                    i = 0;
                    j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + w - 5 + i, y + h - 3 - j, x + w - 5 + i, y + h - 4 - j);
                        ++i;
                        j += 2;
                    }
                } else if (tabIndex == this._tabPane.getSelectedIndex() + (leftToRight ? -1 : 1)) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 5, y + h - 1, x + w - 6, y + h - 1);
                    int i = 0;
                    int j = 0;
                    while (i < 5) {
                        g.drawLine(x + 4 - i, y + h - 2 - j, x + 4 - i, y + h - 3 - j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g.drawLine(x + w - 5 + i, y + h - 1 - j, x + w - 5 + i, y + h - 2 - j);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        i = 0;
                        j = 0;
                        while (i < 5) {
                            g.drawLine(x + 5 - i, y + h - 2 - j, x + 5 - i, y + h - 3 - j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 6, y + h - 2, x + w - 6, y + h - 2);
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g.drawLine(x + w - 5 + i, y + h - 3 - j, x + w - 5 + i, y + h - 4 - j);
                        ++i;
                        j += 2;
                    }
                } else {
                    if (tabIndex == this._tabPane.getSelectedIndex() + (leftToRight ? -1 : 1)) break;
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 5, y + h - 1, x + w - 6, y + h - 1);
                    int i = 0;
                    int j = 0;
                    while (i < 5) {
                        g.drawLine(x + 4 - i, y + h - 2 - j, x + 4 - i, y + h - 3 - j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + w - 5 + i, y + h - 1 - j, x + w - 5 + i, y + h - 2 - j);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        i = 0;
                        j = 0;
                        while (i < 5) {
                            g.drawLine(x + 5 - i, y + h - 2 - j, x + 5 - i, y + h - 3 - j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 6, y + h - 2, x + w - 6, y + h - 2);
                    i = 0;
                    j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + w - 5 + i, y + h - 3 - j, x + w - 5 + i, y + h - 4 - j);
                        ++i;
                        j += 2;
                    }
                }
                break;
            }
            default: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x + 5, y, x + w - 5, y);
                    int i = 0;
                    int j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + 4 - i, y + 1 + j, x + 4 - i, y + 2 + j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + w - 4 - 1 + i, y + j, x + w - 4 - 1 + i, y + 1 + j);
                        ++i;
                        j += 2;
                    }
                    if (this._selectColor2 != null) {
                        g.setColor(this._selectColor2);
                        g.drawLine(x + 6, y + 1, x + w - 7, y + 1);
                        i = 0;
                        j = 0;
                        while (i < h / 2 + 1) {
                            g.drawLine(x + 5 - i, y + 1 + j, x + 5 - i, y + 2 + j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    g.setColor(this._selectColor3);
                    g.drawLine(x + w - 6, y + 1, x + w - 6, y + 1);
                    i = 0;
                    j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + w - 5 + i, y + 2 + j, x + w - 5 + i, y + 3 + j);
                        ++i;
                        j += 2;
                    }
                } else if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 5, y, x + w - 5, y);
                    int i = 0;
                    int j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + 4 - i, y + 1 + j, x + 4 - i, y + 2 + j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + w - 4 - 1 + i, y + j, x + w - 4 - 1 + i, y + 1 + j);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + 6, y + 1, x + w - 7, y + 1);
                        i = 0;
                        j = 0;
                        while (i < h / 2 + 1) {
                            g.drawLine(x + 5 - i, y + 1 + j, x + 5 - i, y + 2 + j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 6, y + 1, x + w - 6, y + 1);
                    i = 0;
                    j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + w - 5 + i, y + 2 + j, x + w - 5 + i, y + 3 + j);
                        ++i;
                        j += 2;
                    }
                } else if (tabIndex == this._tabPane.getSelectedIndex() + (leftToRight ? -1 : 1)) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 5, y, x + w - 5, y);
                    int i = 0;
                    int j = 0;
                    while (i < 5) {
                        g.drawLine(x + 4 - i, y + 1 + j, x + 4 - i, y + 2 + j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g.drawLine(x + w - 4 - 1 + i, y + j, x + w - 4 - 1 + i, y + 1 + j);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + 6, y + 1, x + w - 7, y + 1);
                        i = 0;
                        j = 0;
                        while (i < 5) {
                            g.drawLine(x + 5 - i, y + 1 + j, x + 5 - i, y + 2 + j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 6, y + 1, x + w - 6, y + 1);
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g.drawLine(x + w - 5 + i, y + 2 + j, x + w - 5 + i, y + 3 + j);
                        ++i;
                        j += 2;
                    }
                } else {
                    if (tabIndex == this._tabPane.getSelectedIndex() + (leftToRight ? -1 : 1)) break;
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 5, y, x + w - 5, y);
                    int i = 0;
                    int j = 0;
                    while (i < 5) {
                        g.drawLine(x + 4 - i, y + 1 + j, x + 4 - i, y + 2 + j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + w - 4 - 1 + i, y + j, x + w - 4 - 1 + i, y + 1 + j);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + 6, y + 1, x + w - 7, y + 1);
                        i = 0;
                        j = 0;
                        while (i < 5) {
                            g.drawLine(x + 5 - i, y + 1 + j, x + 5 - i, y + 2 + j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 6, y + 1, x + w - 6, y + 1);
                    i = 0;
                    j = 0;
                    while (i < h / 2 + 1) {
                        g.drawLine(x + w - 5 + i, y + 2 + j, x + w - 5 + i, y + 3 + j);
                        ++i;
                        j += 2;
                    }
                }
                break;
            }
        }
    }

    protected void paintWindowsTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int colorTheme = this.getColorTheme();
        switch (tabPlacement) {
            case 2: {
                if (colorTheme == 2 || colorTheme == 1) {
                    if (isSelected) {
                        g.setColor(this._selectColor1);
                        g.drawLine(x - 2, y + 1, x - 2, y + h - 1);
                        g.drawLine(x - 1, y, x - 1, y);
                        g.drawLine(x, y - 1, x + w - 1, y - 1);
                        g.setColor(this._selectColor2);
                        g.drawLine(x - 1, y + h, x - 1, y + h);
                        g.drawLine(x, y + h + 1, x, y + h + 1);
                        g.drawLine(x + 1, y + h, x + w - 1, y + h);
                        g.setColor(this._selectColor3);
                        g.drawLine(x, y + h, x, y + h);
                        g.drawLine(x + 1, y + h + 1, x + w - 1, y + h + 1);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g.setColor(this._unselectColor1);
                        g.drawLine(x, y + 2, x, y + h - 3);
                        g.drawLine(x + 1, y + 1, x + 1, y + 1);
                        g.drawLine(x + 2, y, x + w - 1, y);
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                        g.drawLine(x + 2, y + h - 1, x + 2, y + h - 1);
                        g.drawLine(x + 3, y + h - 2, x + w - 1, y + h - 2);
                        g.setColor(this._unselectColor3);
                        g.drawLine(x + 2, y + h - 2, x + 2, y + h - 2);
                        g.drawLine(x + 3, y + h - 1, x + w - 1, y + h - 1);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                    g.setColor(this._unselectColor1);
                    g.drawLine(x, y + 3, x, y + h - 2);
                    g.drawLine(x + 1, y + 2, x + 1, y + 2);
                    g.drawLine(x + 2, y + 1, x + w - 1, y + 1);
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
                    g.drawLine(x + 2, y + h, x + 2, y + h);
                    g.drawLine(x + 3, y + h - 1, x + w - 1, y + h - 1);
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + 2, y + h - 1, x + 2, y + h - 1);
                    g.drawLine(x + 3, y + h, x + w - 1, y + h);
                    break;
                }
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x - 2, y + 1, x - 2, y + h - 1);
                    g.drawLine(x - 1, y, x - 1, y);
                    g.drawLine(x, y - 1, x, y - 1);
                    g.drawLine(x - 1, y + h, x - 1, y + h);
                    g.drawLine(x, y + h + 1, x, y + h + 1);
                    g.setColor(this._selectColor2);
                    g.drawLine(x - 1, y + 1, x - 1, y + h - 1);
                    g.drawLine(x, y, x, y + h);
                    g.setColor(this._selectColor3);
                    g.drawLine(x + 1, y - 2, x + w - 1, y - 2);
                    g.drawLine(x + 1, y + h + 2, x + w - 1, y + h + 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x, y + 2, x, y + h - 4);
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    g.drawLine(x + 2, y, x + w - 1, y);
                    g.drawLine(x + 1, y + h - 3, x + 1, y + h - 3);
                    g.drawLine(x + 2, y + h - 2, x + w - 1, y + h - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g.setColor(this._unselectColor1);
                g.drawLine(x, y + 4, x, y + h - 2);
                g.drawLine(x + 1, y + 3, x + 1, y + 3);
                g.drawLine(x + 2, y + 2, x + w - 1, y + 2);
                g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
                g.drawLine(x + 2, y + h, x + w - 1, y + h);
                break;
            }
            case 4: {
                if (colorTheme == 2 || colorTheme == 1) {
                    if (isSelected) {
                        g.setColor(this._selectColor1);
                        g.drawLine(x + w - 1, y - 1, x, y - 1);
                        g.setColor(this._selectColor2);
                        g.drawLine(x + w, y + 1, x + w, y + h - 1);
                        g.drawLine(x + w - 1, y + h, x, y + h);
                        g.setColor(this._selectColor3);
                        g.drawLine(x + w, y, x + w, y);
                        g.drawLine(x + w + 1, y + 1, x + w + 1, y + h - 1);
                        g.drawLine(x + w, y + h, x + w, y + h);
                        g.drawLine(x + w - 1, y + h + 1, x, y + h + 1);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g.setColor(this._unselectColor1);
                        g.drawLine(x + w - 3, y, x, y);
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
                        g.drawLine(x + w - 3, y + h - 2, x, y + h - 2);
                        g.setColor(this._unselectColor3);
                        g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                        g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                        g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                        g.drawLine(x + w - 3, y + h - 1, x, y + h - 1);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + w - 3, y + 1, x, y + 1);
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + w - 2, y + 3, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 3, y + h - 1, x, y + h - 1);
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 2, y + 2, x + w - 2, y + 2);
                    g.drawLine(x + w - 1, y + 3, x + w - 1, y + h - 2);
                    g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
                    g.drawLine(x + w - 3, y + h, x, y + h);
                    break;
                }
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x + w + 1, y + 1, x + w + 1, y + h - 1);
                    g.drawLine(x + w, y, x + w, y);
                    g.drawLine(x + w - 1, y - 1, x + w - 1, y - 1);
                    g.drawLine(x + w, y + h, x + w, y + h);
                    g.drawLine(x + w - 1, y + h + 1, x + w - 1, y + h + 1);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + w, y + 1, x + w, y + h - 1);
                    g.drawLine(x + w - 1, y, x + w - 1, y + h);
                    g.setColor(this._selectColor3);
                    g.drawLine(x + w - 2, y - 2, x, y - 2);
                    g.drawLine(x + w - 2, y + h + 2, x, y + h + 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 4);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + w - 2, y + h - 3, x + w - 2, y + h - 3);
                    g.drawLine(x + w - 3, y, x, y);
                    g.drawLine(x + w - 3, y + h - 2, x, y + h - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g.setColor(this._unselectColor1);
                g.drawLine(x + w - 1, y + 4, x + w - 1, y + h - 2);
                g.drawLine(x + w - 2, y + 3, x + w - 2, y + 3);
                g.drawLine(x + w - 3, y + 2, x, y + 2);
                g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
                g.drawLine(x + w - 3, y + h, x, y + h);
                break;
            }
            case 3: {
                if (colorTheme == 2 || colorTheme == 1) {
                    if (isSelected) {
                        g.setColor(this._selectColor1);
                        g.drawLine(x, y + h, x, y + h);
                        g.drawLine(x - 1, y + h - 1, x - 1, y);
                        g.setColor(this._selectColor2);
                        g.drawLine(x + 1, y + h, x + w - 2, y + h);
                        g.drawLine(x + w - 1, y + h - 1, x + w - 1, y - 1);
                        g.setColor(this._selectColor3);
                        g.drawLine(x + 1, y + h + 1, x + w - 2, y + h + 1);
                        g.drawLine(x + w - 1, y + h, x + w - 1, y + h);
                        g.drawLine(x + w, y + h - 1, x + w, y - 1);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g.setColor(this._unselectColor1);
                        g.drawLine(x, y + h - 2, x, y + h - 2);
                        g.drawLine(x - 1, y + h - 3, x - 1, y);
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + 1, y + h - 2, x + w - 4, y + h - 2);
                        g.drawLine(x + w - 3, y + h - 3, x + w - 3, y - 1);
                        g.setColor(this._unselectColor3);
                        g.drawLine(x + 1, y + h - 1, x + w - 4, y + h - 1);
                        g.drawLine(x + w - 3, y + h - 2, x + w - 3, y + h - 2);
                        g.drawLine(x + w - 2, y + h - 3, x + w - 2, y - 1);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 2, y + h - 2, x + 2, y + h - 2);
                    g.drawLine(x + 1, y + h - 3, x + 1, y);
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + 3, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 1, y + h - 3, x + w - 1, y);
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + 3, y + h - 1, x + w - 2, y + h - 1);
                    g.drawLine(x + w - 1, y + h - 2, x + w - 1, y + h - 2);
                    g.drawLine(x + w, y + h - 3, x + w, y);
                    break;
                }
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x + 1, y + h + 1, x + w, y + h + 1);
                    g.drawLine(x, y + h, x, y + h);
                    g.drawLine(x - 1, y + h - 1, x - 1, y + h - 1);
                    g.drawLine(x + w + 1, y + h, x + w + 1, y + h);
                    g.drawLine(x + w + 2, y + h - 1, x + w + 2, y + h - 1);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + 1, y + h, x + w, y + h);
                    g.drawLine(x, y + h - 1, x + w + 1, y + h - 1);
                    g.setColor(this._selectColor3);
                    g.drawLine(x - 1, y + h - 2, x - 1, y);
                    g.drawLine(x + w + 2, y + h - 2, x + w + 2, y);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 3, y + h - 1, x + w - 3, y + h - 1);
                    g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 1, y + h - 3, x + w - 1, y - 1);
                    g.drawLine(x + 2, y + h - 2, x + 2, y + h - 2);
                    g.drawLine(x + 1, y + h - 3, x + 1, y);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g.setColor(this._unselectColor1);
                g.drawLine(x + 3, y + h - 1, x + w - 3, y + h - 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y + h - 3, x + w - 1, y - 1);
                g.drawLine(x + 2, y + h - 2, x + 2, y + h - 2);
                g.drawLine(x + 1, y + h - 3, x + 1, y);
                break;
            }
            default: {
                if (colorTheme == 2 || colorTheme == 1) {
                    if (isSelected) {
                        g.setColor(this._selectColor1);
                        g.drawLine(x, y - 1, x, y - 1);
                        g.drawLine(x - 1, y, x - 1, y + h - 1);
                        g.drawLine(x + 1, y - 2, x + w + 1, y - 2);
                        g.setColor(this._selectColor2);
                        g.drawLine(x + w + 2, y - 1, x + w + 2, y + h - 1);
                        g.setColor(this._selectColor3);
                        g.drawLine(x + w + 2, y - 1, x + w + 2, y - 1);
                        g.drawLine(x + w + 3, y, x + w + 3, y + h - 1);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g.setColor(this._unselectColor1);
                        g.drawLine(x + 2, y + 1, x + 2, y + 1);
                        g.drawLine(x + 1, y + 2, x + 1, y + h - 1);
                        g.drawLine(x + 3, y, x + w - 2, y);
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
                        g.setColor(this._unselectColor3);
                        g.drawLine(x + w - 1, y + 1, x + w - 1, y + 1);
                        g.drawLine(x + w, y + 2, x + w, y + h - 1);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 2, y + 1, x + 2, y + 1);
                    g.drawLine(x + 1, y + 2, x + 1, y + h - 1);
                    g.drawLine(x + 3, y, x + w - 2, y);
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
                    g.setColor(this._unselectColor3);
                    g.drawLine(x + w - 1, y + 1, x + w - 1, y + 1);
                    g.drawLine(x + w, y + 2, x + w, y + h - 1);
                    break;
                }
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x + 1, y - 2, x + w, y - 2);
                    g.drawLine(x, y - 1, x, y - 1);
                    g.drawLine(x - 1, y, x - 1, y);
                    g.drawLine(x + w + 1, y - 1, x + w + 1, y - 1);
                    g.drawLine(x + w + 2, y, x + w + 2, y);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + 1, y - 1, x + w, y - 1);
                    g.drawLine(x, y, x + w + 1, y);
                    g.setColor(this._selectColor3);
                    g.drawLine(x - 1, y + 1, x - 1, y + h - 1);
                    g.drawLine(x + w + 2, y + 1, x + w + 2, y + h - 1);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 1, y + 2, x + 1, y + h - 1);
                    g.drawLine(x + 2, y + 1, x + 2, y + 1);
                    g.drawLine(x + 3, y, x + w - 3, y);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g.setColor(this._unselectColor1);
                g.drawLine(x + 1, y + 2, x + 1, y + h - 1);
                g.drawLine(x + 2, y + 1, x + 2, y + 1);
                g.drawLine(x + 3, y, x + w - 3, y);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
            }
        }
    }

    protected void paintTabBorderMouseOver(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (this.getTabShape() == 1) {
            switch (tabPlacement) {
                case 2: {
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        y -= 2;
                    }
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y + 4, x, y + h - 2);
                    g.drawLine(x + 1, y + 3, x + 1, y + 3);
                    g.drawLine(x + 2, y + 2, x + 2, y + 2);
                    g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
                    g.drawLine(x + 2, y + h, x + 2, y + h);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + 1, y + 4, x + 1, y + h - 2);
                    g.drawLine(x + 2, y + 3, x + 2, y + h - 1);
                    break;
                }
                case 4: {
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        y -= 2;
                    }
                    g.setColor(this._selectColor1);
                    g.drawLine(x + w - 1, y + 4, x + w - 1, y + h - 2);
                    g.drawLine(x + w - 2, y + 3, x + w - 2, y + 3);
                    g.drawLine(x + w - 3, y + 2, x + w - 3, y + 2);
                    g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
                    g.drawLine(x + w - 3, y + h, x + w - 3, y + h);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + w - 2, y + 4, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 3, y + 3, x + w - 3, y + h - 1);
                    break;
                }
                case 3: {
                    g.setColor(this._selectColor1);
                    g.drawLine(x + 3, y + h - 1, x + w - 3, y + h - 1);
                    g.drawLine(x + 2, y + h - 2, x + 2, y + h - 2);
                    g.drawLine(x + 1, y + h - 3, x + 1, y + h - 3);
                    g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 1, y + h - 3, x + w - 1, y + h - 3);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + 3, y + h - 2, x + w - 3, y + h - 2);
                    g.drawLine(x + 2, y + h - 3, x + w - 2, y + h - 3);
                    break;
                }
                default: {
                    g.setColor(this._selectColor1);
                    g.drawLine(x + 3, y, x + w - 3, y);
                    g.drawLine(x + 2, y + 1, x + 2, y + 1);
                    g.drawLine(x + 1, y + 2, x + 1, y + 2);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + w - 1, y + 2, x + w - 1, y + 2);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + 3, y + 1, x + w - 3, y + 1);
                    g.drawLine(x + 2, y + 2, x + w - 2, y + 2);
                    break;
                }
            }
        } else if (this.getTabShape() == 11) {
            switch (tabPlacement) {
                case 2: {
                    if (this.getColorTheme() == 4) {
                        if (tabIndex > this._tabPane.getSelectedIndex()) {
                            y -= 2;
                        }
                        g.setColor(this._selectColor1);
                        g.drawLine(x, y + 4, x, y + h - 2);
                        g.drawLine(x + 1, y + 3, x + 1, y + 3);
                        g.drawLine(x + 2, y + 2, x + 2, y + 2);
                        g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
                        g.drawLine(x + 2, y + h, x + 2, y + h);
                        g.setColor(this._selectColor2);
                        g.drawLine(x + 1, y + 4, x + 1, y + h - 2);
                        g.drawLine(x + 2, y + 3, x + 2, y + h - 1);
                        g.setColor(this._selectColor3);
                        g.drawLine(x + 3, y + 2, x + w - 1, y + 2);
                        g.drawLine(x + 3, y + h, x + w - 1, y + h);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        --y;
                    }
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y + 3, x, y + h - 2);
                    g.drawLine(x + 1, y + 2, x + 1, y + 2);
                    g.drawLine(x + 2, y + 1, x + w - 1, y + 1);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
                    g.drawLine(x + 2, y + h, x + 2, y + h);
                    g.drawLine(x + 3, y + h - 1, x + w - 1, y + h - 1);
                    g.setColor(this._selectColor3);
                    g.drawLine(x + 2, y + h - 1, x + 2, y + h - 1);
                    g.drawLine(x + 3, y + h, x + w - 1, y + h);
                    break;
                }
                case 4: {
                    if (this.getColorTheme() == 4) {
                        if (tabIndex > this._tabPane.getSelectedIndex()) {
                            y -= 2;
                        }
                        g.setColor(this._selectColor1);
                        g.drawLine(x + w - 1, y + 4, x + w - 1, y + h - 2);
                        g.drawLine(x + w - 2, y + 3, x + w - 2, y + 3);
                        g.drawLine(x + w - 3, y + 2, x + w - 3, y + 2);
                        g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
                        g.drawLine(x + w - 3, y + h, x + w - 3, y + h);
                        g.setColor(this._selectColor2);
                        g.drawLine(x + w - 2, y + 4, x + w - 2, y + h - 2);
                        g.drawLine(x + w - 3, y + 3, x + w - 3, y + h - 1);
                        g.setColor(this._selectColor3);
                        g.drawLine(x + w - 4, y + 2, x, y + 2);
                        g.drawLine(x + w - 4, y + h, x, y + h);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        --y;
                    }
                    g.setColor(this._selectColor3);
                    g.drawLine(x + w - 1, y + 3, x + w - 1, y + h - 2);
                    g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
                    g.drawLine(x + w - 3, y + h, x, y + h);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + w - 2, y + 3, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 3, y + h - 1, x, y + h - 1);
                    g.setColor(this._selectColor1);
                    g.drawLine(x + w - 2, y + 2, x + w - 2, y + 2);
                    g.drawLine(x + w - 3, y + 1, x, y + 1);
                    break;
                }
                case 3: {
                    if (this.getColorTheme() == 4) {
                        g.setColor(this._selectColor1);
                        g.drawLine(x + 3, y + h - 1, x + w - 3, y + h - 1);
                        g.drawLine(x + 2, y + h - 2, x + 2, y + h - 2);
                        g.drawLine(x + 1, y + h - 3, x + 1, y + h - 3);
                        g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                        g.drawLine(x + w - 1, y + h - 3, x + w - 1, y + h - 3);
                        g.setColor(this._selectColor2);
                        g.drawLine(x + 3, y + h - 2, x + w - 3, y + h - 2);
                        g.drawLine(x + 2, y + h - 3, x + w - 2, y + h - 3);
                        g.setColor(this._selectColor3);
                        g.drawLine(x + 1, y, x + 1, y + h - 4);
                        g.drawLine(x + w - 1, y, x + w - 1, y + h - 4);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        x -= 2;
                    }
                    g.setColor(this._selectColor3);
                    g.drawLine(x + 3, y + h - 1, x + w - 2, y + h - 1);
                    g.drawLine(x + w - 1, y + h - 2, x + w - 1, y + h - 2);
                    g.drawLine(x + w, y + h - 3, x + w, y);
                    g.setColor(this._selectColor1);
                    g.drawLine(x + 2, y + h - 2, x + 2, y + h - 2);
                    g.drawLine(x + 1, y + h - 3, x + 1, y);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + 3, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 1, y + h - 3, x + w - 1, y);
                    break;
                }
                default: {
                    if (this.getColorTheme() == 4) {
                        g.setColor(this._selectColor1);
                        g.drawLine(x + 3, y, x + w - 3, y);
                        g.drawLine(x + 2, y + 1, x + 2, y + 1);
                        g.drawLine(x + 1, y + 2, x + 1, y + 2);
                        g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                        g.drawLine(x + w - 1, y + 2, x + w - 1, y + 2);
                        g.setColor(this._selectColor2);
                        g.drawLine(x + 3, y + 1, x + w - 3, y + 1);
                        g.drawLine(x + 2, y + 2, x + w - 2, y + 2);
                        g.setColor(this._selectColor3);
                        g.drawLine(x + 1, y + 3, x + 1, y + h - 1);
                        g.drawLine(x + w - 1, y + 3, x + w - 1, y + h - 1);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        --x;
                    }
                    g.setColor(this._selectColor1);
                    g.drawLine(x + 2, y + 1, x + 2, y + 1);
                    g.drawLine(x + 1, y + 2, x + 1, y + h - 1);
                    g.drawLine(x + 3, y, x + w - 2, y);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
                    g.setColor(this._selectColor3);
                    g.drawLine(x + w - 1, y + 1, x + w - 1, y + 1);
                    g.drawLine(x + w, y + 2, x + w, y + h - 1);
                }
            }
        }
    }

    protected void paintVsnetTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y, x + w - 1, y);
                    g.drawLine(x, y, x, y + h - 2);
                    g.setColor(this._selectColor2);
                    g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                    break;
                }
                g.setColor(this._unselectColor1);
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.drawLine(x + 2, y + h - 2, x + w - 2, y + h - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                g.drawLine(x + 2, y, x + w - 2, y);
                break;
            }
            case 4: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y, x + w - 1, y);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 2);
                    g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                    break;
                }
                g.setColor(this._unselectColor1);
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.drawLine(x + 1, y + h - 2, x + w - 3, y + h - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                g.drawLine(x + 1, y, x + w - 3, y);
                break;
            }
            case 3: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y, x, y + h - 1);
                    g.setColor(this._selectColor2);
                    g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 2);
                    break;
                }
                g.setColor(this._unselectColor1);
                if (leftToRight) {
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 2);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                    g.drawLine(x, y + 2, x, y + h - 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.drawLine(x, y + 2, x, y + h - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == this._tabPane.getTabCount() - 1) break;
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 2);
                break;
            }
            default: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y + 1, x, y + h - 1);
                    g.drawLine(x, y, x + w - 1, y);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
                    break;
                }
                g.setColor(this._unselectColor1);
                if (leftToRight) {
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 2);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                    g.drawLine(x, y + 2, x, y + h - 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.drawLine(x, y + 2, x, y + h - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == this._tabPane.getTabCount() - 1) break;
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 2);
            }
        }
    }

    protected void paintRoundedVsnetTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x + 2, y, x + w - 1, y);
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    g.drawLine(x, y + 2, x, y + h - 3);
                    g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                    g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                    break;
                }
                g.setColor(this._unselectColor1);
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.drawLine(x + 2, y + h - 2, x + w - 2, y + h - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                g.drawLine(x + 2, y + 1, x + w - 2, y + 1);
                break;
            }
            case 4: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y, x + w - 3, y);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                    g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
                    break;
                }
                g.setColor(this._unselectColor1);
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.drawLine(x + 1, y + h - 2, x + w - 3, y + h - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
                break;
            }
            case 3: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y, x, y + h - 3);
                    g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                    g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
                    g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 3);
                    break;
                }
                g.setColor(this._unselectColor1);
                if (leftToRight) {
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 2);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                    g.drawLine(x, y + 2, x, y + h - 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.drawLine(x, y + 2, x, y + h - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == this._tabPane.getTabCount() - 1) break;
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 2);
                break;
            }
            default: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y + 2, x, y + h - 1);
                    g.drawLine(x, y + 2, x + 2, y);
                    g.drawLine(x + 2, y, x + w - 3, y);
                    g.drawLine(x + w - 3, y, x + w - 1, y + 2);
                    g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                    break;
                }
                g.setColor(this._unselectColor1);
                if (leftToRight) {
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 2);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                    g.drawLine(x, y + 2, x, y + h - 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.drawLine(x, y + 2, x, y + h - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == this._tabPane.getTabCount() - 1) break;
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 2);
            }
        }
    }

    protected void paintFlatTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        switch (tabPlacement) {
            case 2: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawRect(x, y, w, h);
                    break;
                }
                g.setColor(this._unselectColor1);
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g.drawRect(x, y, w, h - 1);
                        break;
                    }
                    g.drawRect(x, y, w, h);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g.drawRect(x, y, w, h);
                break;
            }
            case 4: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawRect(x - 1, y, w, h);
                    break;
                }
                g.setColor(this._unselectColor1);
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g.drawRect(x - 1, y, w, h - 1);
                        break;
                    }
                    g.drawRect(x - 1, y, w, h);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g.drawRect(x - 1, y, w, h);
                break;
            }
            case 3: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawRect(x, y - 1, w, h);
                    break;
                }
                g.setColor(this._unselectColor1);
                g.drawRect(x, y - 1, w, h);
                break;
            }
            default: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawRect(x, y, w, h);
                    break;
                }
                g.setColor(this._unselectColor1);
                g.drawRect(x, y, w, h);
            }
        }
    }

    protected void paintRoundedFlatTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        switch (tabPlacement) {
            case 2: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x + 2, y, x + w - 1, y);
                    g.drawLine(x + 2, y + h, x + w - 1, y + h);
                    g.drawLine(x, y + 2, x, y + h - 2);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 2, y, x + w - 1, y);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                        g.drawLine(x, y + 2, x, y + h - 3);
                    } else {
                        g.drawLine(x + 2, y + h, x + w - 1, y + h);
                        g.drawLine(x, y + 2, x, y + h - 2);
                    }
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g.drawLine(x, y + h - 2, x, y + h - 2);
                        g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
                        break;
                    }
                    g.drawLine(x, y + h - 1, x, y + h - 1);
                    g.drawLine(x + 1, y + h, x + 1, y + h);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g.setColor(this._unselectColor1);
                g.drawLine(x + 2, y, x + w - 1, y);
                g.drawLine(x + 2, y + h, x + w - 1, y + h);
                g.drawLine(x, y + 2, x, y + h - 2);
                g.setColor(this._unselectColor2);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
                break;
            }
            case 4: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y, x + w - 3, y);
                    g.drawLine(x, y + h, x + w - 3, y + h);
                    g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 2);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x, y, x + w - 3, y);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
                        g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                    } else {
                        g.drawLine(x, y + h, x + w - 3, y + h);
                        g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 2);
                    }
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                        break;
                    }
                    g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g.setColor(this._unselectColor1);
                g.drawLine(x, y, x + w - 3, y);
                g.drawLine(x, y + h, x + w - 3, y + h);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 2);
                g.setColor(this._unselectColor2);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
                break;
            }
            case 3: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y, x, y + h - 3);
                    g.drawLine(x + 2, y + h - 1, x + w - 2, y + h - 1);
                    g.drawLine(x + w, y, x + w, y + h - 3);
                    g.setColor(this._selectColor2);
                    g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                    g.drawLine(x + w - 1, y + h - 2, x + w - 1, y + h - 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x, y, x, y + h - 3);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
                        g.drawLine(x + w - 1, y, x + w - 1, y + h - 3);
                    } else {
                        g.drawLine(x + 2, y + h - 1, x + w - 2, y + h - 1);
                        g.drawLine(x + w, y, x + w, y + h - 3);
                    }
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                        break;
                    }
                    g.drawLine(x + w - 1, y + h - 2, x + w - 1, y + h - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g.setColor(this._unselectColor1);
                g.drawLine(x, y, x, y + h - 3);
                g.drawLine(x + 2, y + h - 1, x + w - 2, y + h - 1);
                g.drawLine(x + w, y, x + w, y + h - 3);
                g.setColor(this._unselectColor2);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.drawLine(x + w - 1, y + h - 2, x + w - 1, y + h - 2);
                break;
            }
            default: {
                if (isSelected) {
                    g.setColor(this._selectColor1);
                    g.drawLine(x, y + h - 1, x, y + 2);
                    g.drawLine(x + 2, y, x + w - 2, y);
                    g.drawLine(x + w, y + 2, x + w, y + h - 1);
                    g.setColor(this._selectColor2);
                    g.drawLine(x, y + 2, x + 2, y);
                    g.drawLine(x + w - 2, y, x + w, y + 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x, y + h - 1, x, y + 2);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g.drawLine(x + 2, y, x + w - 3, y);
                        g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                    } else {
                        g.drawLine(x + 2, y, x + w - 2, y);
                        g.drawLine(x + w, y + 2, x + w, y + h - 1);
                    }
                    g.setColor(this._unselectColor2);
                    g.drawLine(x, y + 2, x + 2, y);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g.drawLine(x + w - 3, y, x + w - 1, y + 2);
                        break;
                    }
                    g.drawLine(x + w - 2, y, x + w, y + 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g.setColor(this._unselectColor1);
                g.drawLine(x, y + h - 1, x, y + 2);
                g.drawLine(x + 2, y, x + w - 2, y);
                g.drawLine(x + w, y + 2, x + w, y + h - 1);
                g.setColor(this._unselectColor2);
                g.drawLine(x, y + 2, x + 2, y);
                g.drawLine(x + w - 2, y, x + w, y + 2);
            }
        }
    }

    protected void paintBoxTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        if (isSelected) {
            g.setColor(this._selectColor1);
            g.drawLine(x, y, x + w - 2, y);
            g.drawLine(x, y, x, y + h - 2);
            g.setColor(this._selectColor2);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else if (tabIndex != this._tabPane.getSelectedIndex() - 1) {
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    g.setColor(this._unselectColor1);
                    g.drawLine(x + 2, y + h, x + w - 2, y + h);
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + 2, y + h + 1, x + w - 2, y + h + 1);
                    break;
                }
                default: {
                    if (leftToRight) {
                        g.setColor(this._unselectColor1);
                        g.drawLine(x + w, y + 2, x + w, y + h - 2);
                        g.setColor(this._unselectColor2);
                        g.drawLine(x + w + 1, y + 2, x + w + 1, y + h - 2);
                        break;
                    }
                    g.setColor(this._unselectColor1);
                    g.drawLine(x, y + 2, x, y + h - 2);
                    g.setColor(this._unselectColor2);
                    g.drawLine(x + 1, y + 2, x + 1, y + h - 2);
                }
            }
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        switch (this.getTabShape()) {
            case 3: {
                this.paintButtonTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 8: {
                this.paintExcelTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 1: {
                this.paintDefaultTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 11: {
                if (!isSelected) break;
                this.paintDefaultTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 2: 
            case 9: {
                this.paintVsnetTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 5: 
            case 10: {
                this.paintFlatTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            default: {
                this.paintOffice2003TabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
            }
        }
    }

    protected void paintOffice2003TabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                if (!isSelected) {
                    if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                        int[] xp = new int[]{x + w, x + 2, x, x, x + 3, x + w};
                        int[] yp = new int[]{y - w + 2 + 2, y + 2, y + 5, y + h - 5, y + h - 2, y + h - 2};
                        int np = yp.length;
                        this.tabRegion = new Polygon(xp, yp, np);
                        break;
                    }
                    int[] xp = new int[]{x + w, x + 4, x + 2, x, x, x + 3, x + w};
                    int[] yp = new int[]{y, y, y + 2, y + 5, y + h - 5, y + h - 2, y + h - 2};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x + w, x + 2, x, x, x + 3, x + w};
                int[] yp = new int[]{y - w + 2 + 2, y + 2, y + 5, y + h - 5, y + h - 2, y + h - 2};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            case 4: {
                if (!isSelected) {
                    if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                        int[] xp = new int[]{x, x + w - 3, x + w - 1, x + w - 1, x + w - 3, x};
                        int[] yp = new int[]{y - w + 2 + 2, y + 2, y + 5, y + h - 5, y + h - 2, y + h - 2};
                        int np = yp.length;
                        this.tabRegion = new Polygon(xp, yp, np);
                        break;
                    }
                    int[] xp = new int[]{x, x + w - 4, x + w - 3, x + w - 1, x + w - 1, x + w - 3, x};
                    int[] yp = new int[]{y, y, y + 2, y + 5, y + h - 5, y + h - 2, y + h - 2};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x, x + w - 3, x + w - 1, x + w - 1, x + w - 3, x};
                int[] yp = new int[]{y - w + 2 + 2, y + 2, y + 5, y + h - 5, y + h - 2, y + h - 2};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            case 3: {
                if (!isSelected) {
                    if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                        int[] xp = new int[]{x - h + 5, x, x + 4, x + w - 3, x + w - 1, x + w - 1};
                        int[] yp = new int[]{y, y + h - 5, y + h - 1, y + h - 1, y + h - 5, y};
                        int np = yp.length;
                        this.tabRegion = new Polygon(xp, yp, np);
                        break;
                    }
                    int[] xp = new int[]{x, x, x + 4, x + w - 3, x + w - 1, x + w - 1};
                    int[] yp = new int[]{y, y + h - 5, y + h - 1, y + h - 1, y + h - 5, y};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x - h + 5, x, x + 4, x + w - 3, x + w - 1, x + w - 1};
                int[] yp = new int[]{y, y + h - 5, y + h - 1, y + h - 1, y + h - 5, y};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            default: {
                if (!isSelected) {
                    if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                        int[] xp = new int[]{x - h + 5, x, x + 4, x + w - 3, x + w - 1, x + w - 1};
                        int[] yp = new int[]{y + h, y + 3, y + 1, y + 1, y + 3, y + h};
                        int np = yp.length;
                        this.tabRegion = new Polygon(xp, yp, np);
                        break;
                    }
                    int[] xp = new int[]{x, x, x + 4, x + w - 3, x + w - 1, x + w - 1};
                    int[] yp = new int[]{y + h, y + 3, y + 1, y + 1, y + 3, y + h};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x - h + 5, x, x + 4, x + w - 3, x + w - 1, x + w - 1};
                int[] yp = new int[]{y + h, y + 3, y + 1, y + 1, y + 3, y + h};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
            }
        }
    }

    protected void paintExcelTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                if (!isSelected) {
                    if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                        int[] xp = new int[]{x + w, x, x, x + w};
                        int[] yp = new int[]{y - 5, y + 5, y + h - 5, y + h + 6};
                        int np = yp.length;
                        this.tabRegion = new Polygon(xp, yp, np);
                        break;
                    }
                    int[] xp = new int[]{x + w, x + 9, x, x, x + w};
                    int[] yp = new int[]{y + 8, y + 2, y + 6, y + h - 5, y + h + 6};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x + w, x, x, x + w};
                int[] yp = new int[]{y - 5, y + 5, y + h - 5, y + h + 6};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            case 4: {
                if (!isSelected) {
                    if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                        int[] xp = new int[]{x, x + w - 1, x + w - 1, x};
                        int[] yp = new int[]{y - 5, y + 5, y + h - 5, y + h + 6};
                        int np = yp.length;
                        this.tabRegion = new Polygon(xp, yp, np);
                        break;
                    }
                    int[] xp = new int[]{x, x + w - 10, x + w - 1, x + w - 1, x};
                    int[] yp = new int[]{y + 8, y + 2, y + 6, y + h - 5, y + h + 6};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x, x + w - 1, x + w - 1, x};
                int[] yp = new int[]{y - 5, y + 5, y + h - 4, y + h + 6};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            case 3: {
                if (!isSelected) {
                    if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                        int[] xp = new int[]{x - 5, x + 5, x + w - 5, x + w + 5};
                        int[] yp = new int[]{y, y + h - 1, y + h - 1, y};
                        int np = yp.length;
                        this.tabRegion = new Polygon(xp, yp, np);
                        break;
                    }
                    int[] xp = new int[]{x + 7, x + 1, x + 5, x + w - 5, x + w + 5};
                    int[] yp = new int[]{y, y + h - 10, y + h - 1, y + h - 1, y};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x - 5, x + 5, x + w - 5, x + w + 5};
                int[] yp = new int[]{y, y + h - 1, y + h - 1, y};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            default: {
                if (!isSelected) {
                    if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                        int[] xp = new int[]{x - 6, x + 5, x + w - 5, x + w + 5};
                        int[] yp = new int[]{y + h, y, y, y + h};
                        int np = yp.length;
                        this.tabRegion = new Polygon(xp, yp, np);
                        break;
                    }
                    int[] xp = new int[]{x + 7, x + 1, x + 6, x + w - 5, x + w + 5};
                    int[] yp = new int[]{y + h, y + 9, y, y, y + h};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x - 6, x + 5, x + w - 5, x + w + 5};
                int[] yp = new int[]{y + h, y, y, y + h};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
            }
        }
    }

    protected void paintDefaultTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        switch (tabPlacement) {
            case 2: {
                if (isSelected) {
                    int[] xp = new int[]{++x + w, x, x - 2, x - 2, x + w};
                    int[] yp = new int[]{y - 1, y - 1, y + 1, y + h + 2, y + h + 2};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                if (tabIndex < this._tabPane.getSelectedIndex()) {
                    int[] xp = new int[]{x + w, x + 2, x, x, x + w};
                    int[] yp = new int[]{++y + 1, y + 1, y + 3, y + h - 1, y + h - 1};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x + w, x + 2, x, x, x + w};
                int[] yp = new int[]{y + 1, y + 1, y + 3, y + h - 2, y + h - 2};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            case 4: {
                if (isSelected) {
                    int[] xp = new int[]{x, x + w - 1, x + w, x + w, x};
                    int[] yp = new int[]{y - 1, y - 1, y + 1, y + h + 2, y + h + 2};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                if (tabIndex < this._tabPane.getSelectedIndex()) {
                    int[] xp = new int[]{x, x + w - 3, x + w - 1, x + w - 1, x};
                    int[] yp = new int[]{++y + 1, y + 1, y + 3, y + h - 1, y + h - 1};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x, x + w - 2, x + w - 1, x + w - 1, x};
                int[] yp = new int[]{y + 1, y + 1, y + 3, y + h - 2, y + h - 2};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            case 3: {
                if (isSelected) {
                    int[] xp = new int[]{x, x, x + 2, x + w + 2, x + w + 2};
                    int[] yp = new int[]{y + h, y, y - 2, y - 2, y + h};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x + 1, x + 1, x + 1, x + w - 1, x + w - 1};
                int[] yp = new int[]{y + h - 1, y + 2, y, y, y + h - 1};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            default: {
                if (isSelected) {
                    int[] xp = new int[]{x, x, x + 2, x + w + 2, x + w + 2};
                    int[] yp = new int[]{y + h + 1, y, y - 2, y - 2, y + h + 1};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x + 1, x + 1, x + 3, x + w - 1, x + w - 1};
                int[] yp = new int[]{y + h, y + 2, y, y, y + h};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
            }
        }
    }

    protected void paintTabBackgroundMouseOver(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected, Color backgroundUnselectedColorStart, Color backgroundUnselectedColorEnd) {
        Graphics2D g2d = (Graphics2D)g;
        Polygon polygon = null;
        switch (tabPlacement) {
            case 2: {
                if (tabIndex < this._tabPane.getSelectedIndex()) {
                    int[] xp = new int[]{x + w, x + 2, x, x, x + 2, x + w};
                    int[] yp = new int[]{y + 2, y + 2, y + 4, y + h - 1, y + h, y + h};
                    int np = yp.length;
                    polygon = new Polygon(xp, yp, np);
                } else {
                    int[] xp = new int[]{x + w, x + 2, x, x, x + 2, x + w};
                    int[] yp = new int[]{y + 1, y + 1, y + 3, y + h - 3, y + h - 2, y + h - 2};
                    int np = yp.length;
                    polygon = new Polygon(xp, yp, np);
                }
                JideSwingUtilities.fillGradient(g2d, polygon, backgroundUnselectedColorStart, backgroundUnselectedColorEnd, false);
                break;
            }
            case 4: {
                if (tabIndex < this._tabPane.getSelectedIndex()) {
                    int[] xp = new int[]{x, x + w - 3, x + w - 1, x + w - 1, x + w - 3, x};
                    int[] yp = new int[]{y + 2, y + 2, y + 4, y + h - 1, y + h, y + h};
                    int np = yp.length;
                    polygon = new Polygon(xp, yp, np);
                } else {
                    int[] xp = new int[]{x, x + w - 2, x + w - 1, x + w - 1, x + w - 3, x};
                    int[] yp = new int[]{y + 1, y + 1, y + 3, y + h - 3, y + h - 2, y + h - 2};
                    int np = yp.length;
                    polygon = new Polygon(xp, yp, np);
                }
                JideSwingUtilities.fillGradient(g2d, polygon, backgroundUnselectedColorEnd, backgroundUnselectedColorStart, false);
                break;
            }
            case 3: {
                int[] xp = new int[]{x + 1, x + 1, x + 1, x + w - 1, x + w - 1};
                int[] yp = new int[]{y + h - 2, y + 2, y, y, y + h - 2};
                int np = yp.length;
                polygon = new Polygon(xp, yp, np);
                JideSwingUtilities.fillGradient(g2d, polygon, backgroundUnselectedColorEnd, backgroundUnselectedColorStart, true);
                break;
            }
            default: {
                int[] xp1 = new int[]{x + 1, x + 1, x + 3, x + w - 1, x + w - 1};
                int[] yp1 = new int[]{y + h, y + 2, y, y, y + h};
                int np1 = yp1.length;
                polygon = new Polygon(xp1, yp1, np1);
                JideSwingUtilities.fillGradient(g2d, polygon, backgroundUnselectedColorStart, backgroundUnselectedColorEnd, true);
            }
        }
    }

    protected void paintVsnetTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int[] yp;
        int[] xp;
        switch (tabPlacement) {
            case 2: {
                xp = new int[]{x + 1, x + 1, x + w, x + w};
                yp = new int[]{y + h - 1, y + 1, y + 1, y + h - 1};
                break;
            }
            case 4: {
                xp = new int[]{x, x, x + w - 1, x + w - 1};
                yp = new int[]{y + h - 1, y + 1, y + 1, y + h - 1};
                break;
            }
            case 3: {
                xp = new int[]{x + 1, x + 1, x + w - 1, x + w - 1};
                yp = new int[]{y + h - 1, y, y, y + h - 1};
                break;
            }
            default: {
                xp = new int[]{x + 1, x + 1, x + w - 1, x + w - 1};
                yp = new int[]{y + h, y + 1, y + 1, y + h};
            }
        }
        int np = yp.length;
        this.tabRegion = new Polygon(xp, yp, np);
    }

    protected void paintFlatTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        switch (tabPlacement) {
            case 2: {
                int[] xp1 = new int[]{x + 1, x + 1, x + w, x + w};
                int[] yp1 = new int[]{y + h, y + 1, y + 1, y + h};
                int np1 = yp1.length;
                this.tabRegion = new Polygon(xp1, yp1, np1);
                break;
            }
            case 4: {
                int[] xp2 = new int[]{x, x, x + w - 1, x + w - 1};
                int[] yp2 = new int[]{y + h, y + 1, y + 1, y + h};
                int np2 = yp2.length;
                this.tabRegion = new Polygon(xp2, yp2, np2);
                break;
            }
            case 3: {
                int[] xp3 = new int[]{x + 1, x + 1, x + w, x + w};
                int[] yp3 = new int[]{y + h - 1, y, y, y + h - 1};
                int np3 = yp3.length;
                this.tabRegion = new Polygon(xp3, yp3, np3);
                break;
            }
            default: {
                int[] xp4 = new int[]{x, x + 1, x + w, x + w};
                int[] yp4 = new int[]{y + h, y + 1, y + 1, y + h};
                int np4 = yp4.length;
                this.tabRegion = new Polygon(xp4, yp4, np4);
            }
        }
    }

    protected void paintButtonTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int[] xp = new int[]{x, x, x + w, x + w};
        int[] yp = new int[]{y + h, y, y, y + h};
        int np = yp.length;
        this.tabRegion = new Polygon(xp, yp, np);
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this._tabPane.getWidth();
        int height = this._tabPane.getHeight();
        Insets insets = this._tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        int temp = -1;
        Dimension lsize = new Dimension(0, 0);
        Dimension tsize = new Dimension(0, 0);
        if (this.isTabLeadingComponentVisible()) {
            lsize = this._tabLeadingComponent.getPreferredSize();
        }
        if (this.isTabTrailingComponentVisible()) {
            tsize = this._tabTrailingComponent.getPreferredSize();
        }
        switch (tabPlacement) {
            case 2: {
                x += this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth);
                if (this.isTabLeadingComponentVisible() && lsize.width > this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth)) {
                    x = insets.left + lsize.width;
                    temp = this._tabLeadingComponent.getSize().width;
                }
                if (this.isTabTrailingComponentVisible() && this._maxTabWidth < tsize.width && temp < tsize.width) {
                    x = insets.left + tsize.width;
                }
                w -= x - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight);
                break;
            }
            default: {
                y += this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight);
                if (this.isTabLeadingComponentVisible() && lsize.height > this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight)) {
                    y = insets.top + lsize.height;
                    temp = lsize.height;
                }
                if (this.isTabTrailingComponentVisible() && this._maxTabHeight < tsize.height && temp < tsize.height) {
                    y = insets.top + tsize.height;
                }
                h -= y - insets.top;
            }
        }
        if (this.getTabShape() != 3) {
            this.paintContentBorder(g, x, y, w, h);
            switch (tabPlacement) {
                case 2: {
                    this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                    break;
                }
                case 4: {
                    this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                    break;
                }
                case 3: {
                    this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                    break;
                }
                default: {
                    this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                }
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected void paintContentBorder(Graphics g, int x, int y, int w, int h) {
        if (this._tabPane.isOpaque()) {
            g.setColor(this._tabBackground);
            g.fillRect(x, y, w, h);
        }
    }

    protected Color getBorderEdgeColor() {
        if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
            return this._shadow;
        }
        return this._lightHighlight;
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (selectedIndex < 0) {
            return;
        }
        if (!this._tabPane.isTabShown()) {
            return;
        }
        Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
        g.setColor(this.getBorderEdgeColor());
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 1, y);
        } else {
            g.drawLine(x, y, selRect.x, y);
            if (!this.getBorderEdgeColor().equals(this._lightHighlight)) {
                if (selRect.x + selRect.width < x + w - 2) {
                    g.drawLine(selRect.x + selRect.width - 1, y, selRect.x + selRect.width - 1, y);
                    g.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
                } else {
                    g.drawLine(x + w - 2, y, x + w - 1, y);
                }
            } else if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(this._darkShadow);
                g.drawLine(selRect.x + selRect.width - 1, y, selRect.x + selRect.width - 1, y);
                g.setColor(this._lightHighlight);
                g.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
            } else {
                g.setColor(this._selectedColor == null ? this._tabPane.getBackground() : this._selectedColor);
                g.drawLine(x + w - 2, y, x + w - 1, y);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (selectedIndex < 0) {
            return;
        }
        if (!this._tabPane.isTabShown()) {
            return;
        }
        Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.x < x || selRect.x > x + w) {
            g.setColor(this.getBorderEdgeColor());
            g.drawLine(x, y + h - 1, x + w - 2, y + h - 1);
        } else if (!this.getBorderEdgeColor().equals(this._lightHighlight)) {
            g.setColor(this.getBorderEdgeColor());
            g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
            g.drawLine(selRect.x, y + h - 1, selRect.x, y + h - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width - 1, y + h - 1, x + w - 2, y + h - 1);
            }
        } else {
            g.setColor(this._darkShadow);
            g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
            g.setColor(this._lightHighlight);
            g.drawLine(selRect.x, y + h - 1, selRect.x, y + h - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(this._darkShadow);
                g.drawLine(selRect.x + selRect.width - 1, y + h - 1, x + w - 2, y + h - 1);
            }
        }
    }

    protected void ensureCurrentLayout() {
        if (!this._tabPane.isValid()) {
            TabbedPaneLayout layout = (TabbedPaneLayout)this._tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    private void updateCloseButtons() {
        if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab()) {
            for (int i = 0; i < this._closeButtons.length; ++i) {
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (i != this._tabPane.getSelectedIndex()) {
                        this._closeButtons[i].setBounds(0, 0, 0, 0);
                        continue;
                    }
                } else if (i >= this._rects.length) {
                    this._closeButtons[i].setBounds(0, 0, 0, 0);
                    continue;
                }
                if (!this._tabPane.isTabClosableAt(i)) {
                    this._closeButtons[i].setBounds(0, 0, 0, 0);
                    continue;
                }
                Dimension size = this._closeButtons[i].getPreferredSize();
                Rectangle bounds = null;
                if (this._closeButtonAlignment == 11) {
                    if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
                        bounds = new Rectangle(this._rects[i].x + this._rects[i].width - size.width - this._closeButtonRightMargin, this._rects[i].y + (this._rects[i].height - size.height) / 2, size.width, size.height);
                        bounds.x -= this.getTabGap();
                    } else {
                        bounds = new Rectangle(this._rects[i].x + (this._rects[i].width - size.width) / 2, this._rects[i].y + this._rects[i].height - size.height - this._closeButtonRightMargin, size.width, size.height);
                        bounds.y -= this.getTabGap();
                    }
                } else {
                    bounds = this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3 ? new Rectangle(this._rects[i].x + this._closeButtonLeftMargin, this._rects[i].y + (this._rects[i].height - size.height) / 2, size.width, size.height) : (this._tabPane.getTabPlacement() == 2 ? new Rectangle(this._rects[i].x + (this._rects[i].width - size.width) / 2, this._rects[i].y + this._closeButtonLeftMargin, size.width, size.height) : new Rectangle(this._rects[i].x + (this._rects[i].width - size.width) / 2 - 2, this._rects[i].y + this._closeButtonLeftMargin, size.width, size.height));
                }
                this._closeButtons[i].setIndex(i);
                if (!bounds.equals(this._closeButtons[i].getBounds())) {
                    this._closeButtons[i].setBounds(bounds);
                }
                if (this._tabPane.getSelectedIndex() == i) {
                    this._closeButtons[i].setBackground(this._selectedColor == null ? this._tabPane.getBackgroundAt(i) : this._selectedColor);
                    continue;
                }
                this._closeButtons[i].setBackground(this._tabPane.getBackgroundAt(i));
            }
        }
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.ensureCurrentLayout();
        Rectangle tabRect = new Rectangle();
        return this.getTabBounds(i, tabRect);
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        this.ensureCurrentLayout();
        return this._runCount;
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        this.ensureCurrentLayout();
        Point p = new Point(x, y);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(x, y, p);
        }
        int tabCount = this._tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this._rects[i].contains(p.x, p.y)) continue;
            return i;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        if (this._rects.length == 0) {
            return null;
        }
        if (tabIndex > this._rects.length - 1) {
            tabIndex = this._rects.length - 1;
        }
        if (tabIndex < 0) {
            tabIndex = 0;
        }
        dest.width = this._rects[tabIndex].width;
        dest.height = this._rects[tabIndex].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point vpp = this._tabScroller.viewport.getLocation();
            Point viewp = this._tabScroller.viewport.getViewPosition();
            dest.x = this._rects[tabIndex].x + vpp.x - viewp.x;
            dest.y = this._rects[tabIndex].y + vpp.y - viewp.y;
        } else {
            dest.x = this._rects[tabIndex].x;
            dest.y = this._rects[tabIndex].y;
        }
        return dest;
    }

    public int getTabAtLocation(int x, int y) {
        this.ensureCurrentLayout();
        int tabCount = this._tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this._rects[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    private int getClosestTab(int x, int y) {
        int want;
        int tabCount;
        int min = 0;
        int max = tabCount = Math.min(this._rects.length, this._tabPane.getTabCount());
        int tabPlacement = this._tabPane.getTabPlacement();
        boolean useX = tabPlacement == 1 || tabPlacement == 3;
        int n = want = useX ? x : y;
        while (min != max) {
            int maxLoc;
            int minLoc;
            int current = max + min >> 1;
            if (useX) {
                minLoc = this._rects[current].x;
                maxLoc = minLoc + this._rects[current].width;
            } else {
                minLoc = this._rects[current].y;
                maxLoc = minLoc + this._rects[current].height;
            }
            if (want < minLoc) {
                max = current;
                if (min != max) continue;
                return Math.max(0, current - 1);
            }
            if (want >= maxLoc) {
                min = current;
                if (max - min > 1) continue;
                return Math.max(current + 1, tabCount - 1);
            }
            return current;
        }
        return min;
    }

    private Point translatePointToTabPanel(int srcx, int srcy, Point dest) {
        Point vpp = this._tabScroller.viewport.getLocation();
        Point viewp = this._tabScroller.viewport.getViewPosition();
        dest.x = srcx - vpp.x + viewp.x;
        dest.y = srcy - vpp.y + viewp.y;
        return dest;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this._tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int tabCount) {
        int rectArrayLen = this._rects.length;
        if (tabCount != rectArrayLen) {
            Rectangle[] tempRectArray = new Rectangle[tabCount];
            System.arraycopy(this._rects, 0, tempRectArray, 0, Math.min(rectArrayLen, tabCount));
            this._rects = tempRectArray;
            for (int rectIndex = rectArrayLen; rectIndex < tabCount; ++rectIndex) {
                this._rects[rectIndex] = new Rectangle();
            }
        }
    }

    protected void expandTabRunsArray() {
        int rectLen = this._tabRuns.length;
        int[] newArray = new int[rectLen + 10];
        System.arraycopy(this._tabRuns, 0, newArray, 0, this._runCount);
        this._tabRuns = newArray;
    }

    protected int getRunForTab(int tabCount, int tabIndex) {
        for (int i = 0; i < this._runCount; ++i) {
            int first = this._tabRuns[i];
            int last = this.lastTabInRun(tabCount, i);
            if (tabIndex < first || tabIndex > last) continue;
            return i;
        }
        return 0;
    }

    protected int lastTabInRun(int tabCount, int run) {
        int nextRun;
        if (this._runCount == 1) {
            return tabCount - 1;
        }
        int n = nextRun = run == this._runCount - 1 ? 0 : run + 1;
        if (this._tabRuns[nextRun] == 0) {
            return tabCount - 1;
        }
        return this._tabRuns[nextRun] - 1;
    }

    protected int getTabRunOverlay(int tabPlacement) {
        return this._tabRunOverlay;
    }

    protected int getTabRunIndent(int tabPlacement, int run) {
        return 0;
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this._runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    protected View getTextViewForTab(int tabIndex) {
        if (this.htmlViews != null && tabIndex < this.htmlViews.size()) {
            return (View)this.htmlViews.elementAt(tabIndex);
        }
        return null;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int height = 0;
        if (tabPlacement == 1 || tabPlacement == 3) {
            View v = this.getTextViewForTab(tabIndex);
            height = v != null ? (height += (int)v.getPreferredSpan(1)) : (height += metrics.getHeight());
            Icon icon = this._tabPane.getIconForTab(tabIndex);
            Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
            if (icon != null) {
                height = Math.max(height, icon.getIconHeight());
            }
            height += tabInsets.top + tabInsets.bottom + 2;
        } else {
            View v;
            Icon icon = this._tabPane.getIconForTab(tabIndex);
            Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
            height = tabInsets.top + tabInsets.bottom + 3;
            if (icon != null) {
                height += icon.getIconHeight() + this._textIconGap;
            }
            if ((v = this.getTextViewForTab(tabIndex)) != null) {
                height += (int)v.getPreferredSpan(0);
            } else {
                String title = this._tabPane.getDisplayTitleAt(tabIndex);
                height += SwingUtilities.computeStringWidth(metrics, title);
            }
            if (this._tabPane.isShowGripper()) {
                height += this._gripperHeight;
            }
            if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this._tabPane.isTabClosableAt(tabIndex)) {
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (this._tabPane.getSelectedIndex() == tabIndex) {
                        height += this._closeButtons[tabIndex].getPreferredSize().height + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                    }
                } else {
                    height += this._closeButtons[tabIndex].getPreferredSize().height + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                }
            }
        }
        return height;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        int tabCount = this._tabPane.getTabCount();
        int result = 0;
        for (int i = 0; i < tabCount; ++i) {
            FontMetrics metrics = this.getFontMetrics(i);
            result = Math.max(this.calculateTabHeight(tabPlacement, i, metrics), result);
        }
        return result;
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int width = 0;
        if (tabPlacement == 1 || tabPlacement == 3) {
            View v;
            Icon icon = this._tabPane.getIconForTab(tabIndex);
            Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
            width = tabInsets.left + tabInsets.right + 3 + this.getTabGap();
            if (icon != null) {
                width += icon.getIconWidth() + this._textIconGap;
            }
            if ((v = this.getTextViewForTab(tabIndex)) != null) {
                width += (int)v.getPreferredSpan(0);
            } else {
                String title = this._tabPane.getDisplayTitleAt(tabIndex);
                width += SwingUtilities.computeStringWidth(metrics, title);
            }
            if (this._tabPane.isShowGripper()) {
                width += this._gripperWidth;
            }
            if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this._tabPane.isTabClosableAt(tabIndex)) {
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (this._tabPane.getSelectedIndex() == tabIndex) {
                        width += this._closeButtons[tabIndex].getPreferredSize().width + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                    }
                } else {
                    width += this._closeButtons[tabIndex].getPreferredSize().width + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                }
            }
        } else {
            View v = this.getTextViewForTab(tabIndex);
            width = v != null ? (width += (int)v.getPreferredSpan(1)) : (width += metrics.getHeight());
            Icon icon = this._tabPane.getIconForTab(tabIndex);
            Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
            if (icon != null) {
                width = Math.max(width, icon.getIconWidth());
            }
            width += tabInsets.left + tabInsets.right + 2;
        }
        return width;
    }

    protected int calculateMaxTabWidth(int tabPlacement) {
        int tabCount = this._tabPane.getTabCount();
        int result = 0;
        for (int i = 0; i < tabCount; ++i) {
            FontMetrics metrics = this.getFontMetrics(i);
            result = Math.max(this.calculateTabWidth(tabPlacement, i, metrics), result);
        }
        return result;
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        if (!this._tabPane.isTabShown()) {
            return 0;
        }
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return horizRunCount > 0 ? horizRunCount * (maxTabHeight - tabRunOverlay) + tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        if (!this._tabPane.isTabShown()) {
            return 0;
        }
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return vertRunCount > 0 ? vertRunCount * (maxTabWidth - tabRunOverlay) + tabRunOverlay + tabAreaInsets.left + tabAreaInsets.right : 0;
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        BasicJideTabbedPaneUI.rotateInsets(this._tabInsets, this._currentTabInsets, tabPlacement);
        return this._currentTabInsets;
    }

    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        BasicJideTabbedPaneUI.rotateInsets(this._selectedTabPadInsets, this._currentPadInsets, tabPlacement);
        return this._currentPadInsets;
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        BasicJideTabbedPaneUI.rotateInsets(this._tabAreaInsets, this._currentTabAreaInsets, tabPlacement);
        return this._currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        BasicJideTabbedPaneUI.rotateInsets(this._tabPane.getContentBorderInsets(), this._currentContentBorderInsets, tabPlacement);
        if (this._ignoreContentBorderInsetsIfNoTabs && !this._tabPane.isTabShown()) {
            return new Insets(0, 0, 0, 0);
        }
        return this._currentContentBorderInsets;
    }

    protected FontMetrics getFontMetrics(int tab) {
        Font font = null;
        int selectedIndex = this._tabPane.getSelectedIndex();
        font = selectedIndex == tab && this._tabPane.getSelectedTabFont() != null ? this._tabPane.getSelectedTabFont() : this._tabPane.getFont();
        if (selectedIndex == tab && this._tabPane.isBoldActiveTab() && font.getStyle() != 1) {
            font = font.deriveFont(1);
        }
        return this._tabPane.getFontMetrics(font);
    }

    protected void navigateSelectedTab(int direction) {
        int tabPlacement = this._tabPane.getTabPlacement();
        int current = this._tabPane.getSelectedIndex();
        int tabCount = this._tabPane.getTabCount();
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        if (tabCount <= 0) {
            return;
        }
        block0 : switch (tabPlacement) {
            case 12: {
                this.selectNextTab(current);
                break;
            }
            case 13: {
                this.selectPreviousTab(current);
                break;
            }
            case 2: 
            case 4: {
                switch (direction) {
                    case 1: {
                        this.selectPreviousTabInRun(current);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(current);
                        break block0;
                    }
                    case 7: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 3: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (direction) {
                    case 1: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 5: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 3: {
                        if (leftToRight) {
                            this.selectNextTabInRun(current);
                            break block0;
                        }
                        this.selectPreviousTabInRun(current);
                        break block0;
                    }
                    case 7: {
                        if (leftToRight) {
                            this.selectPreviousTabInRun(current);
                            break block0;
                        }
                        this.selectNextTabInRun(current);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int current) {
        int tabCount = this._tabPane.getTabCount();
        int tabIndex = this.getNextTabIndexInRun(tabCount, current);
        while (tabIndex != current && !this._tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndexInRun(tabCount, tabIndex);
        }
        this._tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectPreviousTabInRun(int current) {
        int tabCount = this._tabPane.getTabCount();
        int tabIndex = this.getPreviousTabIndexInRun(tabCount, current);
        while (tabIndex != current && !this._tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndexInRun(tabCount, tabIndex);
        }
        this._tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectNextTab(int current) {
        int tabIndex = this.getNextTabIndex(current);
        while (tabIndex != current && !this._tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndex(tabIndex);
        }
        this._tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectPreviousTab(int current) {
        int tabIndex = this.getPreviousTabIndex(current);
        while (tabIndex != current && !this._tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndex(tabIndex);
        }
        this._tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectAdjacentRunTab(int tabPlacement, int tabIndex, int offset) {
        int newIndex;
        if (this._runCount < 2) {
            return;
        }
        Rectangle r = this._rects[tabIndex];
        switch (tabPlacement) {
            case 2: 
            case 4: {
                newIndex = this.getTabAtLocation(r.x + (r.width >> 1) + offset, r.y + (r.height >> 1));
                break;
            }
            default: {
                newIndex = this.getTabAtLocation(r.x + (r.width >> 1), r.y + (r.height >> 1) + offset);
            }
        }
        if (newIndex != -1) {
            while (!this._tabPane.isEnabledAt(newIndex) && newIndex != tabIndex) {
                newIndex = this.getNextTabIndex(newIndex);
            }
            this._tabPane.setSelectedIndex(newIndex);
        }
    }

    protected int getTabRunOffset(int tabPlacement, int tabCount, int tabIndex, boolean forward) {
        int offset;
        int run = this.getRunForTab(tabCount, tabIndex);
        switch (tabPlacement) {
            case 2: {
                if (run == 0) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth) - this._maxTabWidth) : -this._maxTabWidth;
                    break;
                }
                if (run == this._runCount - 1) {
                    offset = forward ? this._maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth) - this._maxTabWidth;
                    break;
                }
                offset = forward ? this._maxTabWidth : -this._maxTabWidth;
                break;
            }
            case 4: {
                if (run == 0) {
                    offset = forward ? this._maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth) - this._maxTabWidth;
                    break;
                }
                if (run == this._runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth) - this._maxTabWidth) : -this._maxTabWidth;
                    break;
                }
                offset = forward ? this._maxTabWidth : -this._maxTabWidth;
                break;
            }
            case 3: {
                if (run == 0) {
                    offset = forward ? this._maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight) - this._maxTabHeight;
                    break;
                }
                if (run == this._runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight) - this._maxTabHeight) : -this._maxTabHeight;
                    break;
                }
                offset = forward ? this._maxTabHeight : -this._maxTabHeight;
                break;
            }
            default: {
                offset = run == 0 ? (forward ? -(this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight) - this._maxTabHeight) : -this._maxTabHeight) : (run == this._runCount - 1 ? (forward ? this._maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight) - this._maxTabHeight) : (forward ? this._maxTabHeight : -this._maxTabHeight));
            }
        }
        return offset;
    }

    protected int getPreviousTabIndex(int base) {
        int tabIndex = base - 1 >= 0 ? base - 1 : this._tabPane.getTabCount() - 1;
        return tabIndex >= 0 ? tabIndex : 0;
    }

    protected int getNextTabIndex(int base) {
        return (base + 1) % this._tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int tabCount, int base) {
        if (this._runCount < 2) {
            return this.getNextTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        int next = this.getNextTabIndex(base);
        if (next == this._tabRuns[this.getNextTabRun(currentRun)]) {
            return this._tabRuns[currentRun];
        }
        return next;
    }

    protected int getPreviousTabIndexInRun(int tabCount, int base) {
        if (this._runCount < 2) {
            return this.getPreviousTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        if (base == this._tabRuns[currentRun]) {
            int previous = this._tabRuns[this.getNextTabRun(currentRun)] - 1;
            return previous != -1 ? previous : tabCount - 1;
        }
        return this.getPreviousTabIndex(base);
    }

    protected int getPreviousTabRun(int baseRun) {
        int runIndex = baseRun - 1 >= 0 ? baseRun - 1 : this._runCount - 1;
        return runIndex >= 0 ? runIndex : 0;
    }

    protected int getNextTabRun(int baseRun) {
        return (baseRun + 1) % this._runCount;
    }

    public static void rotateInsets(Insets topInsets, Insets targetInsets, int targetPlacement) {
        switch (targetPlacement) {
            case 2: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.top;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.bottom;
                break;
            }
            case 3: {
                targetInsets.top = topInsets.bottom;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.top;
                targetInsets.right = topInsets.right;
                break;
            }
            case 4: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.top;
                break;
            }
            default: {
                targetInsets.top = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.bottom;
                targetInsets.right = topInsets.right;
            }
        }
    }

    protected boolean requestFocusForVisibleComponent() {
        Component visibleComponent = this.getVisibleComponent();
        Component lastFocused = this._tabPane.getLastFocusedComponent(visibleComponent);
        if (lastFocused != null && lastFocused.requestFocusInWindow()) {
            return true;
        }
        if (visibleComponent != null && visibleComponent.isFocusTraversable()) {
            JideSwingUtilities.compositeRequestFocus(visibleComponent);
            return true;
        }
        return visibleComponent instanceof JComponent && ((JComponent)visibleComponent).requestDefaultFocus();
    }

    protected TabCloseButton createNoFocusButton(int type) {
        return new TabCloseButton(type);
    }

    protected void ensureCurrentRects(int leftMargin, int tabCount) {
        int oldWidth;
        int k;
        boolean verticalTabRuns;
        Dimension size = this._tabPane.getSize();
        Insets insets = this._tabPane.getInsets();
        int totalWidth = 0;
        int totalHeight = 0;
        boolean bl = verticalTabRuns = this._tabPane.getTabPlacement() == 2 || this._tabPane.getTabPlacement() == 4;
        if (tabCount == 0) {
            return;
        }
        Rectangle r = this._rects[tabCount - 1];
        Dimension lsize = new Dimension(0, 0);
        Dimension tsize = new Dimension(0, 0);
        if (this.isTabLeadingComponentVisible()) {
            lsize = this._tabLeadingComponent.getPreferredSize();
        }
        if (this.isTabTrailingComponentVisible()) {
            tsize = this._tabTrailingComponent.getPreferredSize();
        }
        if (verticalTabRuns) {
            totalHeight = r.y + r.height;
            if (this._tabLeadingComponent != null) {
                totalHeight -= lsize.height;
            }
        } else {
            totalWidth = r.x + r.width;
            if (this._tabLeadingComponent != null) {
                totalWidth -= lsize.width;
            }
        }
        boolean ltr = this._tabPane.getComponentOrientation().isLeftToRight();
        if (this.getTabResizeMode() == 2) {
            int numberOfButtons;
            if (verticalTabRuns) {
                int availHeight = this.getTabShape() != 3 ? (int)size.getHeight() - this._fitStyleBoundSize - insets.top - insets.bottom - leftMargin - this.getTabRightPadding() : (int)size.getHeight() - this._fitStyleBoundSize - insets.top - insets.bottom;
                if (this._tabPane.isShowCloseButton()) {
                    availHeight -= this._buttonSize;
                }
                if (this.isTabLeadingComponentVisible()) {
                    availHeight -= lsize.height;
                }
                if (this.isTabTrailingComponentVisible()) {
                    availHeight -= tsize.height;
                }
                if (totalHeight > (availHeight -= this._buttonSize * (numberOfButtons = this.getNumberOfTabButtons()))) {
                    int tabHeight = availHeight / tabCount;
                    totalHeight = this._fitStyleFirstTabMargin;
                    for (int k2 = 0; k2 < tabCount; ++k2) {
                        this._rects[k2].height = tabHeight;
                        Rectangle tabRect = this._rects[k2];
                        tabRect.y = this.getTabShape() != 3 ? totalHeight + leftMargin : totalHeight;
                        totalHeight += tabRect.height;
                    }
                }
            } else {
                int availWidth = this.getTabShape() != 3 ? (int)size.getWidth() - this._fitStyleBoundSize - insets.left - insets.right - leftMargin - this.getTabRightPadding() : (int)size.getWidth() - this._fitStyleBoundSize - insets.left - insets.right;
                if (this._tabPane.isShowCloseButton()) {
                    availWidth -= this._buttonSize;
                }
                if (this.isTabLeadingComponentVisible()) {
                    availWidth -= lsize.width;
                }
                if (this.isTabTrailingComponentVisible()) {
                    availWidth -= tsize.width;
                }
                if (totalWidth > (availWidth -= this._buttonSize * (numberOfButtons = this.getNumberOfTabButtons()))) {
                    int gripperWidth;
                    int tabWidth = availWidth / tabCount;
                    int n = gripperWidth = this._tabPane.isShowGripper() ? this._gripperWidth : 0;
                    if (tabWidth < this._textIconGap + this._fitStyleTextMinWidth + this._fitStyleIconMinWidth + gripperWidth && tabWidth > this._fitStyleIconMinWidth + gripperWidth) {
                        tabWidth = this._fitStyleIconMinWidth + gripperWidth;
                    }
                    if (tabWidth < this._fitStyleIconMinWidth + gripperWidth && tabWidth > this._fitStyleFirstTabMargin + gripperWidth) {
                        tabWidth = this._fitStyleFirstTabMargin + gripperWidth;
                    }
                    this.tryTabSpacer.reArrange(this._rects, insets, availWidth);
                }
                totalWidth = this._fitStyleFirstTabMargin;
                for (int k3 = 0; k3 < tabCount; ++k3) {
                    Rectangle tabRect = this._rects[k3];
                    tabRect.x = this.getTabShape() != 3 ? (ltr ? totalWidth + leftMargin : availWidth - totalWidth - tabRect.width + leftMargin) : (ltr ? totalWidth : availWidth - totalWidth - tabRect.width);
                    totalWidth += tabRect.width;
                }
            }
        }
        if (this.getTabResizeMode() == 3) {
            if (verticalTabRuns) {
                for (k = 0; k < tabCount; ++k) {
                    this._rects[k].height = this._fixedStyleRectSize;
                    if (this.isShowCloseButton() && this._tabPane.isShowCloseButtonOnTab()) {
                        this._rects[k].height += this._closeButtons[k].getPreferredSize().height;
                    }
                    if (k != 0) {
                        this._rects[k].y = this._rects[k - 1].y + this._rects[k - 1].height;
                    }
                    totalHeight = this._rects[k].y + this._rects[k].height;
                }
            } else {
                for (k = 0; k < tabCount; ++k) {
                    oldWidth = this._rects[k].width;
                    this._rects[k].width = this._fixedStyleRectSize;
                    if (this.isShowCloseButton() && this._tabPane.isShowCloseButtonOnTab()) {
                        this._rects[k].width += this._closeButtons[k].getPreferredSize().width;
                    }
                    if (k == 0 && !ltr) {
                        this._rects[k].x += oldWidth - this._rects[k].width;
                    }
                    if (k != 0) {
                        this._rects[k].x = ltr ? this._rects[k - 1].x + this._rects[k - 1].width : this._rects[k - 1].x - this._rects[k - 1].width;
                    }
                    totalWidth = this._rects[k].x + this._rects[k].width;
                }
            }
        }
        if (this.getTabResizeMode() == 4) {
            if (verticalTabRuns) {
                for (k = 0; k < tabCount; ++k) {
                    if (k != this._tabPane.getSelectedIndex()) {
                        if (!this._tabPane.isShowIconsOnTab() && !this._tabPane.isUseDefaultShowIconsOnTab()) {
                            this._rects[k].height = this._compressedStyleNoIconRectSize;
                        } else {
                            Icon icon = this._tabPane.getIconForTab(k);
                            this._rects[k].height = icon.getIconHeight() + this._compressedStyleIconMargin;
                        }
                        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab()) {
                            this._rects[k].height = this._rects[k].height + this._closeButtons[k].getPreferredSize().height + this._compressedStyleCloseButtonMarginVertical;
                        }
                    }
                    if (k != 0) {
                        this._rects[k].y = this._rects[k - 1].y + this._rects[k - 1].height;
                    }
                    totalHeight = this._rects[k].y + this._rects[k].height;
                }
            } else {
                for (k = 0; k < tabCount; ++k) {
                    oldWidth = this._rects[k].width;
                    if (k != this._tabPane.getSelectedIndex()) {
                        if (!this._tabPane.isShowIconsOnTab() && !this._tabPane.isUseDefaultShowIconsOnTab()) {
                            this._rects[k].width = this._compressedStyleNoIconRectSize;
                        } else {
                            Icon icon = this._tabPane.getIconForTab(k);
                            this._rects[k].width = icon.getIconWidth() + this._compressedStyleIconMargin;
                        }
                        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab()) {
                            this._rects[k].width = this._rects[k].width + this._closeButtons[k].getPreferredSize().width + this._compressedStyleCloseButtonMarginHorizon;
                        }
                    }
                    if (k == 0 && !ltr) {
                        this._rects[k].x += oldWidth - this._rects[k].width;
                    }
                    if (k != 0) {
                        this._rects[k].x = ltr ? this._rects[k - 1].x + this._rects[k - 1].width : this._rects[k - 1].x - this._rects[k - 1].width;
                    }
                    totalWidth = this._rects[k].x + this._rects[k].width;
                }
            }
        }
        if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
            totalWidth += this.getLayoutSize();
            if (this.isTabLeadingComponentVisible()) {
                totalWidth += lsize.width;
            }
        } else {
            totalHeight += this.getLayoutSize();
            if (this.isTabLeadingComponentVisible()) {
                totalHeight += tsize.height;
            }
        }
        this._tabScroller.tabPanel.setPreferredSize(new Dimension(totalWidth, totalHeight));
    }

    protected ListCellRenderer getTabListCellRenderer() {
        return this._tabPane.getTabListCellRenderer();
    }

    protected void updateCloseAction() {
        this.ensureCloseButtonCreated();
    }

    private Vector createHTMLVector() {
        Vector<View> htmlViews = new Vector<View>();
        int count = this._tabPane.getTabCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                String title = this._tabPane.getDisplayTitleAt(i);
                if (BasicHTML.isHTMLString(title)) {
                    htmlViews.addElement(BasicHTML.createHTMLView(this._tabPane, title));
                    continue;
                }
                htmlViews.addElement(null);
            }
        }
        return htmlViews;
    }

    @Override
    public Component getTabPanel() {
        if (this.scrollableTabLayoutEnabled()) {
            return this._tabScroller.tabPanel;
        }
        return this._tabPane;
    }

    @Override
    public void ensureActiveTabIsVisible(boolean scrollLeft) {
        if (this._tabPane == null || this._tabPane.getWidth() == 0) {
            return;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this.ensureCurrentLayout();
            if (scrollLeft && this._rects.length > 0) {
                this._tabScroller.viewport.setViewPosition(new Point(0, 0));
                this._tabScroller.tabPanel.scrollRectToVisible(this._rects[0]);
            }
            int index = this._tabPane.getSelectedIndex();
            if (!(scrollLeft && index == 0 || index >= this._rects.length || index == -1)) {
                if (index == 0) {
                    this._tabScroller.viewport.setViewPosition(new Point(0, 0));
                } else if (index == this._rects.length - 1) {
                    Rectangle lastRect = this._rects[index];
                    lastRect.width = this._tabScroller.tabPanel.getWidth() - lastRect.x;
                    this._tabScroller.tabPanel.scrollRectToVisible(lastRect);
                } else if (index == 0) {
                    Rectangle firstRect = this._rects[index];
                    firstRect.x = 0;
                    this._tabScroller.tabPanel.scrollRectToVisible(firstRect);
                } else {
                    this._tabScroller.tabPanel.scrollRectToVisible(this._rects[index]);
                }
                this._tabScroller.tabPanel.getParent().doLayout();
            }
            this._tabPane.revalidate();
            this._tabPane.repaintTabAreaAndContentBorder();
        }
    }

    protected boolean isShowCloseButtonOnTab() {
        if (this._tabPane.isUseDefaultShowCloseButtonOnTab()) {
            return this._showCloseButtonOnTab;
        }
        return this._tabPane.isShowCloseButtonOnTab();
    }

    protected boolean isShowCloseButton() {
        return this._tabPane.isShowCloseButton();
    }

    public void ensureCloseButtonCreated() {
        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this.scrollableTabLayoutEnabled()) {
            int i;
            TabCloseButton[] temp;
            if (this._closeButtons == null) {
                this._closeButtons = new TabCloseButton[this._tabPane.getTabCount()];
            } else if (this._closeButtons.length > this._tabPane.getTabCount()) {
                temp = new TabCloseButton[this._tabPane.getTabCount()];
                System.arraycopy(this._closeButtons, 0, temp, 0, temp.length);
                for (i = temp.length; i < this._closeButtons.length; ++i) {
                    TabCloseButton tabCloseButton = this._closeButtons[i];
                    this._tabScroller.tabPanel.remove(tabCloseButton);
                }
                this._closeButtons = temp;
            } else if (this._closeButtons.length < this._tabPane.getTabCount()) {
                temp = new TabCloseButton[this._tabPane.getTabCount()];
                System.arraycopy(this._closeButtons, 0, temp, 0, this._closeButtons.length);
                this._closeButtons = temp;
            }
            ActionMap am = this.getActionMap();
            for (i = 0; i < this._closeButtons.length; ++i) {
                TabCloseButton closeButton = this._closeButtons[i];
                if (closeButton == null) {
                    closeButton = this.createNoFocusButton(0);
                    closeButton.setName(BUTTON_NAME_CLOSE);
                    this._closeButtons[i] = closeButton;
                    closeButton.setBounds(0, 0, 0, 0);
                    Action action = this._tabPane.getCloseAction();
                    closeButton.setAction(am.get("closeTabAction"));
                    this.updateButtonFromAction(closeButton, action);
                    this._tabScroller.tabPanel.add(closeButton);
                }
                closeButton.setIndex(i);
            }
        }
    }

    private void updateButtonFromAction(TabCloseButton closeButton, Action action) {
        Object icon;
        if (action == null) {
            return;
        }
        closeButton.setEnabled(action.isEnabled());
        Object desc = action.getValue("ShortDescription");
        if (desc instanceof String) {
            closeButton.setToolTipText((String)desc);
        }
        if ((icon = action.getValue("SmallIcon")) instanceof Icon) {
            closeButton.setIcon((Icon)icon);
        }
    }

    protected boolean isShowTabButtons() {
        return this._tabPane.getTabCount() != 0 && this._tabPane.isShowTabArea() && this._tabPane.isShowTabButtons();
    }

    protected boolean isShrinkTabs() {
        return this._tabPane.getTabCount() != 0 && this._tabPane.getTabResizeMode() == 2;
    }

    @Override
    public boolean isTabEditing() {
        return this._isEditing;
    }

    protected TabEditor createDefaultTabEditor() {
        TabEditor editor = new TabEditor();
        editor.getDocument().addDocumentListener(this);
        editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (BasicJideTabbedPaneUI.this._tabPane != null && BasicJideTabbedPaneUI.this._tabPane.isTabEditing()) {
                    BasicJideTabbedPaneUI.this._tabPane.stopTabEditing();
                }
            }
        });
        editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicJideTabbedPaneUI.this._tabPane.stopTabEditing();
            }
        });
        editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BasicJideTabbedPaneUI.this._isEditing && e.getKeyCode() == 27) {
                    if (BasicJideTabbedPaneUI.this._editingTab >= 0 && BasicJideTabbedPaneUI.this._editingTab < BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                        BasicJideTabbedPaneUI.this._tabPane.setTitleAt(BasicJideTabbedPaneUI.this._editingTab, BasicJideTabbedPaneUI.this._oldValue);
                    }
                    BasicJideTabbedPaneUI.this._tabPane.cancelTabEditing();
                }
            }
        });
        editor.setFont(this._tabPane.getFont());
        return editor;
    }

    @Override
    public void stopTabEditing() {
        if (this._editingTab >= 0 && this._editingTab < this._tabPane.getTabCount()) {
            this._tabPane.setTitleAt(this._editingTab, this._oldPrefix + this._tabEditor.getText() + this._oldPostfix);
        }
        this.cancelTabEditing();
    }

    @Override
    public void cancelTabEditing() {
        if (this._tabEditor != null) {
            this._isEditing = false;
            ((Container)this.getTabPanel()).remove(this._tabEditor);
            if (this._editingTab >= 0 && this._editingTab < this._tabPane.getTabCount()) {
                Rectangle tabRect = this._tabPane.getBoundsAt(this._editingTab);
                this.getTabPanel().repaint(tabRect.x, tabRect.y, tabRect.width, tabRect.height);
            } else {
                this.getTabPanel().repaint();
            }
            this._tabPane.requestFocusInWindow();
            this._editingTab = -1;
            this._oldValue = null;
        }
    }

    @Override
    public boolean editTabAt(int tabIndex) {
        if (this._isEditing) {
            return false;
        }
        if (this._tabEditor == null) {
            this._tabEditor = this.createDefaultTabEditor();
        }
        if (this._tabEditor != null) {
            this.prepareEditor(this._tabEditor, tabIndex);
            ((Container)this.getTabPanel()).add(this._tabEditor);
            Rectangle tabsTextBoundsAt = this.getTabsTextBoundsAt(tabIndex);
            if (tabsTextBoundsAt.isEmpty()) {
                return false;
            }
            this._tabEditor.setBounds(SwingUtilities.convertRectangle(this._tabPane, tabsTextBoundsAt, this.getTabPanel()));
            this._tabEditor.invalidate();
            this._tabEditor.validate();
            this._editingTab = tabIndex;
            this._isEditing = true;
            this.getTabPanel().repaint();
            this._tabEditor.requestFocusInWindow();
            this._tabEditor.selectAll();
            return true;
        }
        return false;
    }

    @Override
    public int getEditingTabIndex() {
        return this._editingTab;
    }

    protected void prepareEditor(TabEditor e, int tabIndex) {
        this._oldValue = this._tabPane.getTitleAt(tabIndex);
        if (this._oldValue.startsWith("<HTML>") && this._oldValue.endsWith("/HTML>")) {
            this._oldPrefix = "<HTML>";
            this._oldPostfix = "</HTML>";
            String title = this._oldValue.substring("<HTML>".length(), this._oldValue.length() - "</HTML>".length());
            if (title.startsWith("<B>") && title.endsWith("/B>")) {
                title = title.substring("<B>".length(), title.length() - "</B>".length());
                this._oldPrefix = this._oldPrefix + "<B>";
                this._oldPostfix = "</B>" + this._oldPostfix;
            }
            e.setText(title);
        } else {
            this._oldPrefix = "";
            this._oldPostfix = "";
            e.setText(this._oldValue);
        }
        e.selectAll();
        e.setForeground(this._tabPane.getForegroundAt(tabIndex));
    }

    protected Rectangle getTabsTextBoundsAt(int tabIndex) {
        Rectangle tabRect = this._tabPane.getBoundsAt(tabIndex);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        String title = this._tabPane.getDisplayTitleAt(tabIndex);
        if (title == null || title.length() < 3) {
            title = "    ";
        }
        Icon icon = this._tabPane.getIconForTab(tabIndex);
        Font font = this._tabPane.getFont();
        if (tabIndex == this._tabPane.getSelectedIndex() && this._tabPane.isBoldActiveTab()) {
            font = font.deriveFont(1);
        }
        SwingUtilities.layoutCompoundLabel(this._tabPane, this._tabPane.getGraphics().getFontMetrics(font), title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, icon == null ? 0 : this._textIconGap);
        if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
            iconRect.x = tabRect.x + this._iconMargin;
            textRect.x = icon != null ? iconRect.x + iconRect.width + this._textIconGap : tabRect.x + this._textPadding;
            textRect.width += 2;
        } else {
            iconRect.y = tabRect.y + this._iconMargin;
            textRect.y = icon != null ? iconRect.y + iconRect.height + this._textIconGap : tabRect.y + this._textPadding;
            iconRect.x = tabRect.x + 2;
            textRect.x = tabRect.x + 2;
            textRect.height += 2;
        }
        return textRect;
    }

    private void updateTab() {
        if (this._isEditing) {
            this.getTabPanel().invalidate();
            this._tabEditor.validate();
            this._tabEditor.repaint();
            this.getTabPanel().repaint();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTab();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTab();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTab();
    }

    public void startEditing(MouseEvent e) {
        int tabIndex = this.tabForCoordinate(this._tabPane, e.getX(), e.getY());
        if (!e.isPopupTrigger() && tabIndex >= 0 && this._tabPane.isEnabledAt(tabIndex) && this._tabPane.isTabEditingAllowed() && e.getClickCount() == 2) {
            e.consume();
            this._tabPane.editTabAt(tabIndex);
        }
        if (e.getClickCount() == 1 && this._tabPane.isTabEditing()) {
            this._tabPane.stopTabEditing();
        }
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRect = rects[tabIndex];
        if (this._tabPane.hasFocus() && isSelected) {
            int h;
            int w;
            int y;
            int x;
            g.setColor(this._focus);
            switch (tabPlacement) {
                case 2: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h = tabRect.height - 6 - this.getTabGap();
                    break;
                }
                case 4: {
                    x = tabRect.x + 2;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h = tabRect.height - 6 - this.getTabGap();
                    break;
                }
                case 3: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 2;
                    w = tabRect.width - 6 - this.getTabGap();
                    h = tabRect.height - 5;
                    break;
                }
                default: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 6 - this.getTabGap();
                    h = tabRect.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    protected boolean isRoundedCorner() {
        return "true".equals(SecurityUtils.getProperty("shadingtheme", "false"));
    }

    protected int getTabShape() {
        return this._tabPane.getTabShape();
    }

    protected int getTabResizeMode() {
        return this._tabPane.getTabResizeMode();
    }

    protected int getColorTheme() {
        return this._tabPane.getColorTheme();
    }

    protected int getLeftMargin() {
        if (this.getTabShape() == 4) {
            return 18;
        }
        if (this.getTabShape() == 8) {
            return 6;
        }
        return 0;
    }

    protected int getTabGap() {
        if (this.getTabShape() == 4) {
            return 4;
        }
        return 0;
    }

    protected int getLayoutSize() {
        int tabShape = this.getTabShape();
        if (tabShape == 8) {
            return 6;
        }
        if (tabShape == 7) {
            return 15;
        }
        if (this._tabPane.getTabShape() == 5 || this._tabPane.getTabShape() == 10) {
            return 2;
        }
        if (tabShape == 1 || tabShape == 11) {
            return 6;
        }
        return 0;
    }

    protected int getTabRightPadding() {
        if (this.getTabShape() == 8) {
            return 4;
        }
        return 0;
    }

    protected MouseListener createMouseListener() {
        if (this.getTabShape() == 1 || this.getTabShape() == 11) {
            return new RolloverMouseHandler();
        }
        return new MouseHandler();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        if (this.getTabShape() == 1 || this.getTabShape() == 11) {
            return new RolloverMouseMotionHandler();
        }
        return new MouseMotionHandler();
    }

    protected boolean isTabLeadingComponentVisible() {
        return this._tabPane.isTabShown() && this._tabLeadingComponent != null && this._tabLeadingComponent.isVisible();
    }

    protected boolean isTabTrailingComponentVisible() {
        return this._tabPane.isTabShown() && this._tabTrailingComponent != null && this._tabTrailingComponent.isVisible();
    }

    protected boolean isTabTopVisible(int tabPlacement) {
        switch (tabPlacement) {
            case 2: 
            case 4: {
                return this.isTabLeadingComponentVisible() && this._tabLeadingComponent.getPreferredSize().width > this.calculateMaxTabWidth(tabPlacement) || this.isTabTrailingComponentVisible() && this._tabTrailingComponent.getPreferredSize().width > this.calculateMaxTabWidth(tabPlacement);
            }
        }
        return this.isTabLeadingComponentVisible() && this._tabLeadingComponent.getPreferredSize().height > this.calculateMaxTabHeight(tabPlacement) || this.isTabTrailingComponentVisible() && this._tabTrailingComponent.getPreferredSize().height > this.calculateMaxTabHeight(tabPlacement);
    }

    protected boolean showFocusIndicator() {
        return this._tabPane.hasFocusComponent() && this._showFocusIndicator;
    }

    private int getNumberOfTabButtons() {
        int numberOfButtons;
        int n = numberOfButtons = !this.isShowTabButtons() || this.isShrinkTabs() ? 1 : 4;
        if (!this.isShowCloseButton() || this.isShowCloseButtonOnTab()) {
            --numberOfButtons;
        }
        return numberOfButtons;
    }

    protected String getResourceString(String key) {
        return Resource.getResourceBundle(this._tabPane != null ? this._tabPane.getLocale() : Locale.getDefault()).getString(key);
    }

    public class RolloverMouseHandler
    extends MouseHandler {
        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            int tabIndex = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, e.getX(), e.getY());
            BasicJideTabbedPaneUI.this._mouseEnter = true;
            BasicJideTabbedPaneUI.this._indexMouseOver = tabIndex;
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            BasicJideTabbedPaneUI.this._indexMouseOver = -1;
            BasicJideTabbedPaneUI.this._mouseEnter = false;
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }
    }

    public class RolloverMouseMotionHandler
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            int tabIndex = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, e.getX(), e.getY());
            if (tabIndex != BasicJideTabbedPaneUI.this._indexMouseOver) {
                BasicJideTabbedPaneUI.this._indexMouseOver = tabIndex;
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            }
        }
    }

    public class DefaultMouseHandler
    extends MouseHandler {
        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            int tabIndex = BasicJideTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            BasicJideTabbedPaneUI.this._mouseEnter = true;
            BasicJideTabbedPaneUI.this._indexMouseOver = tabIndex;
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            BasicJideTabbedPaneUI.this._indexMouseOver = -1;
            BasicJideTabbedPaneUI.this._mouseEnter = false;
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }
    }

    public class DefaultMouseMotionHandler
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            int tabIndex = BasicJideTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex != BasicJideTabbedPaneUI.this._indexMouseOver) {
                BasicJideTabbedPaneUI.this._indexMouseOver = tabIndex;
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            }
        }
    }

    private class DropListener
    implements DropTargetListener {
        private DragOverTimer _timer;
        int _index = -1;

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (!BasicJideTabbedPaneUI.this._tabPane.isEnabled()) {
                return;
            }
            int tabIndex = BasicJideTabbedPaneUI.this.getTabAtLocation(dtde.getLocation().x, dtde.getLocation().y);
            if (tabIndex >= 0 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex != BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() && tabIndex != this._index) {
                    this.stopTimer();
                    this.startTimer(tabIndex);
                    this._index = tabIndex;
                }
            } else {
                this.stopTimer();
            }
            dtde.rejectDrag();
        }

        private void startTimer(int tabIndex) {
            this._timer = new DragOverTimer(tabIndex);
            this._timer.start();
        }

        private void stopTimer() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
                this._index = -1;
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.stopTimer();
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            this.stopTimer();
        }
    }

    private class DragOverTimer
    extends Timer
    implements ActionListener {
        private int _index;

        public DragOverTimer(int index) {
            super(500, null);
            this._index = index;
            this.addActionListener(this);
            this.setRepeats(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicJideTabbedPaneUI.this._tabPane.getTabCount() == 0) {
                return;
            }
            if (this._index == BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex()) {
                if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                    BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow();
                    BasicJideTabbedPaneUI.this._tabPane.repaint(BasicJideTabbedPaneUI.this.getTabBounds(BasicJideTabbedPaneUI.this._tabPane, this._index));
                }
            } else {
                if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                    BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow();
                }
                BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(this._index);
            }
            this.stop();
        }
    }

    protected class TabEditor
    extends JTextField
    implements UIResource {
        TabEditor() {
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        public boolean stopEditing() {
            return true;
        }
    }

    public static class TabSpaceAllocator {
        static final int startOffset = 4;
        private Insets insets = null;
        static final int tabWidth = 24;
        static final int textIconGap = 8;
        private AbstractTab[] tabs;

        private void setInsets(Insets insets) {
            this.insets = (Insets)insets.clone();
        }

        private void init(Rectangle[] rects, Insets insets) {
            this.setInsets(insets);
            this.tabs = new AbstractTab[rects.length];
            for (int i = 0; i < rects.length; ++i) {
                this.tabs[i] = new AbstractTab();
                this.tabs[i].id = i;
                this.tabs[i].width = rects[i].width;
            }
            this.tabSort();
        }

        private void bestfit(AbstractTab[] tabs, int freeWidth, int startTab) {
            int tabCount = tabs.length;
            int currentTabWidth = tabs[startTab].width;
            int initialPos = startTab;
            if (startTab == tabCount - 1) {
                tabs[startTab].width = freeWidth;
                return;
            }
            int worstWidth = freeWidth / (tabCount - startTab);
            while (currentTabWidth < worstWidth) {
                freeWidth -= currentTabWidth;
                if (++startTab < tabCount - 1) {
                    currentTabWidth = tabs[startTab].width;
                    continue;
                }
                tabs[startTab].width = worstWidth;
                return;
            }
            if (startTab == initialPos) {
                for (int i = startTab; i < tabCount; ++i) {
                    tabs[i].width = worstWidth;
                }
            } else if (startTab < tabCount - 1) {
                this.bestfit(tabs, freeWidth, startTab);
            }
        }

        private void tabSort() {
            int tabCount = this.tabs.length;
            AbstractTab tempTab = new AbstractTab();
            for (int i = 0; i < tabCount - 1; ++i) {
                for (int j = i + 1; j < tabCount; ++j) {
                    if (this.tabs[i].width <= this.tabs[j].width) continue;
                    tempTab.copy(this.tabs[j]);
                    this.tabs[j].copy(this.tabs[i]);
                    this.tabs[i].copy(tempTab);
                }
            }
        }

        private void outpush(Rectangle[] rects) {
            for (AbstractTab tab : this.tabs) {
                rects[tab.id].width = tab.width;
            }
            rects[0].x = 4;
            for (int i = 1; i < rects.length; ++i) {
                rects[i].x = rects[i - 1].x + rects[i - 1].width;
            }
        }

        public void reArrange(Rectangle[] rects, Insets insets, int totalAvailableSpace) {
            this.init(rects, insets);
            this.bestfit(this.tabs, totalAvailableSpace, 0);
            this.outpush(rects);
            this.clearup();
        }

        private void clearup() {
            for (int i = 0; i < this.tabs.length; ++i) {
                this.tabs[i] = null;
            }
            this.tabs = null;
        }
    }

    static class AbstractTab {
        int width;
        int id;

        AbstractTab() {
        }

        public void copy(AbstractTab tab) {
            this.width = tab.width;
            this.id = tab.id;
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            JideTabbedPane tp = (JideTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource || child == tp.getTabLeadingComponent() || child == tp.getTabTrailingComponent()) {
                return;
            }
            int index = tp.indexOfComponent(child);
            String title = tp.getDisplayTitleAt(index);
            boolean isHTML = BasicHTML.isHTMLString(title);
            if (isHTML) {
                if (BasicJideTabbedPaneUI.this.htmlViews == null) {
                    BasicJideTabbedPaneUI.this.htmlViews = BasicJideTabbedPaneUI.this.createHTMLVector();
                } else {
                    View v = BasicHTML.createHTMLView(tp, title);
                    BasicJideTabbedPaneUI.this.htmlViews.insertElementAt(v, index);
                }
            } else if (BasicJideTabbedPaneUI.this.htmlViews != null) {
                BasicJideTabbedPaneUI.this.htmlViews.insertElementAt(null, index);
            }
            if (BasicJideTabbedPaneUI.this._tabPane.isTabEditing()) {
                BasicJideTabbedPaneUI.this._tabPane.stopTabEditing();
            }
            BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            JideTabbedPane tp = (JideTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource || child == tp.getTabLeadingComponent() || child == tp.getTabTrailingComponent()) {
                return;
            }
            Integer index = (Integer)tp.getClientProperty("__index_to_remove__");
            if (index != null) {
                if (BasicJideTabbedPaneUI.this.htmlViews != null && BasicJideTabbedPaneUI.this.htmlViews.size() >= index) {
                    BasicJideTabbedPaneUI.this.htmlViews.removeElementAt(index);
                }
                tp.putClientProperty("__index_to_remove__", null);
            }
            if (BasicJideTabbedPaneUI.this._tabPane.isTabEditing()) {
                BasicJideTabbedPaneUI.this._tabPane.stopTabEditing();
            }
            BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
        }
    }

    private class ComponentHandler
    implements ComponentListener {
        private ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                BasicJideTabbedPaneUI.this._tabScroller.viewport.setViewSize(new Dimension(BasicJideTabbedPaneUI.this._tabPane.getWidth(), BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewSize().height));
                BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(true);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    public class MouseWheelHandler
    implements MouseWheelListener {
        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            block3: {
                block4: {
                    block2: {
                        if (!BasicJideTabbedPaneUI.this._tabPane.isScrollSelectedTabOnWheel()) break block2;
                        BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(Math.min(BasicJideTabbedPaneUI.this._tabPane.getTabCount() - 1, Math.max(0, BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() + e.getWheelRotation())));
                        break block3;
                    }
                    if (!BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled() || e.getWheelRotation() == 0) break block3;
                    if (e.getWheelRotation() <= 0) break block4;
                    for (int i = 0; i < e.getScrollAmount(); ++i) {
                        BasicJideTabbedPaneUI.this._tabScroller.scrollForward(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement());
                    }
                    break block3;
                }
                if (e.getWheelRotation() >= 0) break block3;
                for (int i = 0; i < e.getScrollAmount(); ++i) {
                    BasicJideTabbedPaneUI.this._tabScroller.scrollBackward(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement());
                }
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            int tabIndex;
            if (!BasicJideTabbedPaneUI.this._tabPane.isEnabled()) {
                return;
            }
            if ((SwingUtilities.isLeftMouseButton(e) || BasicJideTabbedPaneUI.this._tabPane.isRightClickSelect()) && (tabIndex = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, e.getX(), e.getY())) >= 0 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex == BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() && JideSwingUtilities.isAncestorOfFocusOwner(BasicJideTabbedPaneUI.this._tabPane)) {
                    if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled() && !BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow()) {
                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                    }
                } else {
                    BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(tabIndex);
                    final Component comp = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(tabIndex);
                    if (!comp.isVisible() && SystemInfo.isJdk15Above() && !SystemInfo.isJdk6Above()) {
                        comp.addComponentListener(new ComponentAdapter(){

                            @Override
                            public void componentShown(ComponentEvent e) {
                                comp.removeComponentListener(this);
                                Component lastFocused = BasicJideTabbedPaneUI.this._tabPane.getLastFocusedComponent(comp);
                                if (lastFocused != null) {
                                    if (!lastFocused.requestFocusInWindow()) {
                                        lastFocused.requestFocus();
                                    }
                                } else if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled() && !BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow()) {
                                    BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                                }
                            }
                        });
                    } else {
                        Component lastFocused = BasicJideTabbedPaneUI.this._tabPane.getLastFocusedComponent(comp);
                        if (lastFocused != null) {
                            if (!lastFocused.requestFocusInWindow()) {
                                lastFocused.requestFocus();
                            }
                        } else if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled() && !BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow()) {
                            BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                        }
                    }
                }
            }
            BasicJideTabbedPaneUI.this.startEditing(e);
        }
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
    }

    public class TabFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            this.repaintSelectedTab();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.repaintSelectedTab();
        }

        private void repaintSelectedTab() {
            Rectangle rect;
            if (BasicJideTabbedPaneUI.this._tabPane.getTabCount() > 0 && (rect = BasicJideTabbedPaneUI.this.getTabBounds(BasicJideTabbedPaneUI.this._tabPane, BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex())) != null) {
                BasicJideTabbedPaneUI.this._tabPane.repaint(rect);
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            String name = e.getPropertyName();
            if ("mnemonicAt".equals(name)) {
                BasicJideTabbedPaneUI.this.updateMnemonics();
                pane.repaint();
            } else if ("displayedMnemonicIndexAt".equals(name)) {
                pane.repaint();
            } else if (name.equals("indexForTitle")) {
                int index = (Integer)e.getNewValue();
                String title = BasicJideTabbedPaneUI.this._tabPane.getDisplayTitleAt(index);
                if (BasicHTML.isHTMLString(title)) {
                    if (BasicJideTabbedPaneUI.this.htmlViews == null) {
                        BasicJideTabbedPaneUI.this.htmlViews = BasicJideTabbedPaneUI.this.createHTMLVector();
                    } else {
                        View v = BasicHTML.createHTMLView(BasicJideTabbedPaneUI.this._tabPane, title);
                        BasicJideTabbedPaneUI.this.htmlViews.setElementAt(v, index);
                    }
                } else if (BasicJideTabbedPaneUI.this.htmlViews != null && BasicJideTabbedPaneUI.this.htmlViews.elementAt(index) != null) {
                    BasicJideTabbedPaneUI.this.htmlViews.setElementAt(null, index);
                }
                BasicJideTabbedPaneUI.this.updateMnemonics();
            } else if (name.equals("tabLayoutPolicy")) {
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (name.equals("closeTabAction")) {
                BasicJideTabbedPaneUI.this.updateCloseAction();
            } else if (name.equals("dragOverDisabled")) {
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (name.equals("tabColorProvider")) {
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            } else if (name.equals("locale")) {
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (name.equals("boldActiveTab")) {
                BasicJideTabbedPaneUI.this.getTabPanel().invalidate();
                BasicJideTabbedPaneUI.this._tabPane.invalidate();
                if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                    BasicJideTabbedPaneUI.this._tabScroller.viewport.setViewSize(new Dimension(BasicJideTabbedPaneUI.this._tabPane.getWidth(), BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewSize().height));
                    BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(true);
                }
            } else if (name.equals("tabLeadingComponent")) {
                BasicJideTabbedPaneUI.this.ensureCurrentLayout();
                if (BasicJideTabbedPaneUI.this._tabLeadingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setVisible(false);
                    BasicJideTabbedPaneUI.this._tabPane.remove(BasicJideTabbedPaneUI.this._tabLeadingComponent);
                }
                BasicJideTabbedPaneUI.this._tabLeadingComponent = (Component)e.getNewValue();
                if (BasicJideTabbedPaneUI.this._tabLeadingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setVisible(true);
                    BasicJideTabbedPaneUI.this._tabPane.add(BasicJideTabbedPaneUI.this._tabLeadingComponent);
                }
                BasicJideTabbedPaneUI.this._tabScroller.tabPanel.updateUI();
            } else if (name.equals("tabTrailingComponent")) {
                BasicJideTabbedPaneUI.this.ensureCurrentLayout();
                if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(false);
                    BasicJideTabbedPaneUI.this._tabPane.remove(BasicJideTabbedPaneUI.this._tabTrailingComponent);
                }
                BasicJideTabbedPaneUI.this._tabTrailingComponent = (Component)e.getNewValue();
                if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabPane.add(BasicJideTabbedPaneUI.this._tabTrailingComponent);
                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(true);
                }
                BasicJideTabbedPaneUI.this._tabScroller.tabPanel.updateUI();
            } else if (name.equals("shrinkTab") || name.equals("hideIfOneTab") || name.equals("showTabArea") || name.equals("showTabContent") || name.equals("boxStyle") || name.equals("showIconsOnTab") || name.equals("showCloseButton") || name.equals("useDefaultShowIconsOnTab") || name.equals("showCloseButtonOnTab") || name.equals("useDefaultShowCloseButtonOnTab") || name.equals("tabClosable") || name.equals("tabShape") || name.equals("colorTheme") || name.equals("tabResizeMode") || name.equals("showTabButtons")) {
                if ((name.equals("useDefaultShowCloseButtonOnTab") || name.equals("showCloseButtonOnTab")) && BasicJideTabbedPaneUI.this.isShowCloseButton() && BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab()) {
                    BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                }
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            }
        }
    }

    public class TabCloseButton
    extends JButton
    implements MouseMotionListener,
    MouseListener,
    UIResource {
        public static final int CLOSE_BUTTON = 0;
        public static final int EAST_BUTTON = 1;
        public static final int WEST_BUTTON = 2;
        public static final int NORTH_BUTTON = 3;
        public static final int SOUTH_BUTTON = 4;
        public static final int LIST_BUTTON = 5;
        private int _type;
        private int _index = -1;
        private boolean _mouseOver = false;
        private boolean _mousePressed = false;

        @Override
        public void updateUI() {
            super.updateUI();
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
            String name = this.getName();
            if (name != null) {
                this.setToolTipText(BasicJideTabbedPaneUI.this.getResourceString(name));
            }
        }

        public TabCloseButton() {
            this(0);
        }

        public TabCloseButton(int type) {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setType(type);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int index) {
            this._index = index;
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!this.isEnabled()) {
                this.setMouseOver(false);
                this.setMousePressed(false);
            }
            if (this.isMouseOver() && this.isMousePressed()) {
                g.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                g.drawLine(0, 0, this.getWidth() - 1, 0);
                g.drawLine(0, this.getHeight() - 2, 0, 1);
                g.setColor(UIDefaultsLookup.getColor("control"));
                g.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                g.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
            } else if (this.isMouseOver()) {
                g.setColor(UIDefaultsLookup.getColor("control"));
                g.drawLine(0, 0, this.getWidth() - 1, 0);
                g.drawLine(0, this.getHeight() - 2, 0, 1);
                g.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                g.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                g.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
            }
            g.setColor(UIDefaultsLookup.getColor("controlShadow").darker());
            int centerX = this.getWidth() >> 1;
            int centerY = this.getHeight() >> 1;
            switch (this.getType()) {
                case 0: {
                    if (this.isEnabled()) {
                        g.drawLine(centerX - 3, centerY - 3, centerX + 3, centerY + 3);
                        g.drawLine(centerX - 4, centerY - 3, centerX + 2, centerY + 3);
                        g.drawLine(centerX + 3, centerY - 3, centerX - 3, centerY + 3);
                        g.drawLine(centerX + 2, centerY - 3, centerX - 4, centerY + 3);
                        break;
                    }
                    g.drawLine(centerX - 3, centerY - 3, centerX + 3, centerY + 3);
                    g.drawLine(centerX + 3, centerY - 3, centerX - 3, centerY + 3);
                    break;
                }
                case 1: {
                    if (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int x = centerX + 2;
                        int y = centerY;
                        if (this.isEnabled()) {
                            g.drawLine(x - 4, y - 4, x - 4, y + 4);
                            g.drawLine(x - 3, y - 3, x - 3, y + 3);
                            g.drawLine(x - 2, y - 2, x - 2, y + 2);
                            g.drawLine(x - 1, y - 1, x - 1, y + 1);
                            g.drawLine(x, y, x, y);
                            break;
                        }
                        g.drawLine(x - 4, y - 4, x, y);
                        g.drawLine(x - 4, y - 4, x - 4, y + 4);
                        g.drawLine(x - 4, y + 4, x, y);
                        break;
                    }
                    int x = centerX + 3;
                    int y = centerY - 2;
                    if (this.isEnabled()) {
                        g.drawLine(x - 8, y, x, y);
                        g.drawLine(x - 7, y + 1, x - 1, y + 1);
                        g.drawLine(x - 6, y + 2, x - 2, y + 2);
                        g.drawLine(x - 5, y + 3, x - 3, y + 3);
                        g.drawLine(x - 4, y + 4, x - 4, y + 4);
                        break;
                    }
                    g.drawLine(x - 8, y, x, y);
                    g.drawLine(x - 8, y, x - 4, y + 4);
                    g.drawLine(x - 4, y + 4, x, y);
                    break;
                }
                case 2: {
                    if (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int x = centerX - 3;
                        int y = centerY;
                        if (this.isEnabled()) {
                            g.drawLine(x, y, x, y);
                            g.drawLine(x + 1, y - 1, x + 1, y + 1);
                            g.drawLine(x + 2, y - 2, x + 2, y + 2);
                            g.drawLine(x + 3, y - 3, x + 3, y + 3);
                            g.drawLine(x + 4, y - 4, x + 4, y + 4);
                            break;
                        }
                        g.drawLine(x, y, x + 4, y - 4);
                        g.drawLine(x, y, x + 4, y + 4);
                        g.drawLine(x + 4, y - 4, x + 4, y + 4);
                        break;
                    }
                    int x = centerX - 5;
                    int y = centerY + 3;
                    if (this.isEnabled()) {
                        g.drawLine(x, y, x + 8, y);
                        g.drawLine(x + 1, y - 1, x + 7, y - 1);
                        g.drawLine(x + 2, y - 2, x + 6, y - 2);
                        g.drawLine(x + 3, y - 3, x + 5, y - 3);
                        g.drawLine(x + 4, y - 4, x + 4, y - 4);
                        break;
                    }
                    g.drawLine(x, y, x + 8, y);
                    g.drawLine(x, y, x + 4, y - 4);
                    g.drawLine(x + 8, y, x + 4, y - 4);
                    break;
                }
                case 5: {
                    int x = centerX + 2;
                    int y = centerY;
                    g.drawLine(x - 6, y - 4, x - 6, y + 4);
                    g.drawLine(x + 1, y - 4, x + 1, y + 4);
                    g.drawLine(x - 6, y - 4, x + 1, y - 4);
                    g.drawLine(x - 4, y - 2, x - 1, y - 2);
                    g.drawLine(x - 4, y, x - 1, y);
                    g.drawLine(x - 4, y + 2, x - 1, y + 2);
                    g.drawLine(x - 6, y + 4, x + 1, y + 4);
                    break;
                }
            }
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        public boolean scrollsForward() {
            return this.getType() == 1 || this.getType() == 4;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.setMousePressed(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMousePressed(true);
            this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMousePressed(false);
            this.setMouseOver(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(false);
            this.setMousePressed(false);
            this.repaint();
            BasicJideTabbedPaneUI.this._tabScroller.tabPanel.repaint();
        }

        public int getType() {
            return this._type;
        }

        public void setType(int type) {
            this._type = type;
        }

        protected boolean isMouseOver() {
            return this._mouseOver;
        }

        protected void setMouseOver(boolean mouseOver) {
            this._mouseOver = mouseOver;
        }

        protected boolean isMousePressed() {
            return this._mousePressed;
        }

        protected void setMousePressed(boolean mousePressed) {
            this._mousePressed = mousePressed;
        }
    }

    public class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (BasicJideTabbedPaneUI.this._tabPane.isOpaque()) {
                if (BasicJideTabbedPaneUI.this.getTabShape() == 3) {
                    g.setColor(UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground"));
                } else {
                    g.setColor(UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackground"));
                }
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            BasicJideTabbedPaneUI.this.paintTabArea(g, BasicJideTabbedPaneUI.this._tabPane.getTabPlacement(), BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex(), this);
        }

        @Override
        public void setToolTipText(String text) {
            BasicJideTabbedPaneUI.this._tabPane.setToolTipText(text);
        }

        @Override
        public String getToolTipText() {
            return BasicJideTabbedPaneUI.this._tabPane.getToolTipText();
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return BasicJideTabbedPaneUI.this._tabPane.getToolTipText(SwingUtilities.convertMouseEvent(this, event, BasicJideTabbedPaneUI.this._tabPane));
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            return BasicJideTabbedPaneUI.this._tabPane.getToolTipLocation(SwingUtilities.convertMouseEvent(this, event, BasicJideTabbedPaneUI.this._tabPane));
        }

        @Override
        public JToolTip createToolTip() {
            return BasicJideTabbedPaneUI.this._tabPane.createToolTip();
        }
    }

    public class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setScrollMode(0);
            this.setOpaque(false);
        }

        @Override
        public Color getBackground() {
            return UIDefaultsLookup.getColor("JideTabbedPane.background");
        }
    }

    public class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public TabCloseButton scrollForwardButton;
        public TabCloseButton scrollBackwardButton;
        public TabCloseButton listButton;
        public TabCloseButton closeButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);
        public JidePopup _popup;

        ScrollableTabSupport(int tabPlacement) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.scrollForwardButton = BasicJideTabbedPaneUI.this.createNoFocusButton(1);
            this.scrollForwardButton.setName(BasicJideTabbedPaneUI.BUTTON_NAME_SCROLL_FORWARD);
            this.scrollBackwardButton = BasicJideTabbedPaneUI.this.createNoFocusButton(2);
            this.scrollBackwardButton.setName(BasicJideTabbedPaneUI.BUTTON_NAME_SCROLL_BACKWARD);
            this.scrollForwardButton.setBackground(this.viewport.getBackground());
            this.scrollBackwardButton.setBackground(this.viewport.getBackground());
            this.listButton = BasicJideTabbedPaneUI.this.createNoFocusButton(5);
            this.listButton.setName(BasicJideTabbedPaneUI.BUTTON_NAME_TAB_LIST);
            this.listButton.setBackground(this.viewport.getBackground());
            this.closeButton = BasicJideTabbedPaneUI.this.createNoFocusButton(0);
            this.closeButton.setName(BasicJideTabbedPaneUI.BUTTON_NAME_CLOSE);
            this.closeButton.setBackground(this.viewport.getBackground());
        }

        public void createPopupMenu(int tabPlacement) {
            JPopupMenu popup = new JPopupMenu();
            int totalCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            int selectedIndex = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            for (int i = 0; i < totalCount; ++i) {
                if (!BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(i)) continue;
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(new ActivateTabAction(BasicJideTabbedPaneUI.this._tabPane.getTitleAt(i), BasicJideTabbedPaneUI.this._tabPane.getIconForTab(i), i));
                popup.add(item);
                item.setToolTipText(BasicJideTabbedPaneUI.this._tabPane.getToolTipTextAt(i));
                item.setSelected(selectedIndex == i);
                item.setHorizontalTextPosition(4);
            }
            Dimension preferredSize = popup.getPreferredSize();
            Rectangle bounds = this.listButton.getBounds();
            switch (tabPlacement) {
                case 1: {
                    popup.show(BasicJideTabbedPaneUI.this._tabPane, bounds.x + bounds.width - preferredSize.width, bounds.y + bounds.height);
                    break;
                }
                case 3: {
                    popup.show(BasicJideTabbedPaneUI.this._tabPane, bounds.x + bounds.width - preferredSize.width, bounds.y - preferredSize.height);
                    break;
                }
                case 2: {
                    popup.show(BasicJideTabbedPaneUI.this._tabPane, bounds.x + bounds.width, bounds.y + bounds.height - preferredSize.height);
                    break;
                }
                case 4: {
                    popup.show(BasicJideTabbedPaneUI.this._tabPane, bounds.x - preferredSize.width, bounds.y + bounds.height - preferredSize.height);
                }
            }
        }

        public void createPopup(int tabPlacement) {
            int y;
            int x;
            final JList list = new JList(){

                @Override
                public void removeSelectionInterval(int index0, int index1) {
                    super.removeSelectionInterval(index0, index1);
                    if (this.getSelectedIndex() == -1) {
                        this.setSelectedIndex(index0);
                    }
                }

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension preferredScrollableViewportSize = super.getPreferredScrollableViewportSize();
                    if (preferredScrollableViewportSize.width < 150) {
                        preferredScrollableViewportSize.width = 150;
                    }
                    return preferredScrollableViewportSize;
                }
            };
            new Sticky(list);
            list.setBackground(BasicJideTabbedPaneUI.this._tabListBackground);
            JScrollPane scroller = new JScrollPane(list);
            scroller.setBorder(BorderFactory.createEmptyBorder());
            scroller.getViewport().setOpaque(false);
            scroller.setOpaque(false);
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBackground(BasicJideTabbedPaneUI.this._tabListBackground);
            panel.setOpaque(true);
            panel.add(scroller);
            panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            if (this._popup != null) {
                if (this._popup.isPopupVisible()) {
                    this._popup.hidePopupImmediately();
                }
                this._popup = null;
            }
            this._popup = JidePopupFactory.getSharedInstance().createPopup();
            this._popup.setPopupBorder(BorderFactory.createLineBorder(BasicJideTabbedPaneUI.this._darkShadow));
            this._popup.add(panel);
            this._popup.addExcludedComponent(this.listButton);
            this._popup.setDefaultFocusComponent(list);
            DefaultListModel<JideTabbedPane> listModel = new DefaultListModel<JideTabbedPane>();
            int selectedIndex = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            int totalCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            for (int i = 0; i < totalCount; ++i) {
                listModel.addElement(BasicJideTabbedPaneUI.this._tabPane);
            }
            list.setCellRenderer(BasicJideTabbedPaneUI.this.getTabListCellRenderer());
            list.setModel(listModel);
            list.setSelectedIndex(selectedIndex);
            list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    int index = list.getSelectedIndex();
                    if (index != -1 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(index)) {
                        BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(index);
                        BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(false);
                        ScrollableTabSupport.this._popup.hidePopupImmediately();
                        ScrollableTabSupport.this._popup = null;
                    }
                }
            });
            list.setSelectionMode(0);
            Insets insets = panel.getInsets();
            int max = (PortingUtils.getLocalScreenSize((Component)BasicJideTabbedPaneUI.this._tabPane).height - insets.top - insets.bottom) / list.getCellBounds((int)0, (int)0).height;
            if (listModel.getSize() > max) {
                list.setVisibleRowCount(max);
            } else {
                list.setVisibleRowCount(listModel.getSize());
            }
            this._popup.setOwner(BasicJideTabbedPaneUI.this._tabPane);
            this._popup.removeExcludedComponent(BasicJideTabbedPaneUI.this._tabPane);
            Dimension size = this._popup.getPreferredSize();
            Rectangle bounds = this.listButton.getBounds();
            Point p = this.listButton.getLocationOnScreen();
            bounds.x = p.x;
            bounds.y = p.y;
            switch (tabPlacement) {
                default: {
                    x = bounds.x + bounds.width - size.width;
                    y = bounds.y + bounds.height + 2;
                    break;
                }
                case 3: {
                    x = bounds.x + bounds.width - size.width;
                    y = bounds.y - size.height - 2;
                    break;
                }
                case 2: {
                    x = bounds.x + bounds.width + 2;
                    y = bounds.y + bounds.height - size.height;
                    break;
                }
                case 4: {
                    x = bounds.x - size.width - 2;
                    y = bounds.y + bounds.height - size.height;
                }
            }
            Rectangle screenBounds = PortingUtils.getScreenBounds(BasicJideTabbedPaneUI.this._tabPane);
            int right = x + size.width + 3;
            int bottom = y + size.height + 3;
            if (right > screenBounds.x + screenBounds.width) {
                x -= right - screenBounds.x - screenBounds.width;
            }
            if (x < screenBounds.x) {
                x = screenBounds.x;
            }
            if (bottom > screenBounds.height) {
                y -= bottom - screenBounds.height;
            }
            if (y < screenBounds.y) {
                y = screenBounds.y;
            }
            this._popup.showPopup(x, y);
        }

        public void scrollForward(int tabPlacement) {
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            if (tabPlacement == 1 || tabPlacement == 3 ? viewRect.width >= viewSize.width - viewRect.x : viewRect.height >= viewSize.height - viewRect.y) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int tabPlacement) {
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex > 0 ? this.leadingTabIndex - 1 : 0);
        }

        public void setLeadingTabIndex(int tabPlacement, int index) {
            if (index < 0 || index >= BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                return;
            }
            this.leadingTabIndex = index;
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            switch (tabPlacement) {
                case 1: 
                case 3: {
                    this.tabViewPosition.y = 0;
                    int n = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].x;
                    if (viewSize.width - this.tabViewPosition.x >= viewRect.width) break;
                    this.tabViewPosition.x = viewSize.width - viewRect.width;
                    break;
                }
                case 2: 
                case 4: {
                    this.tabViewPosition.x = 0;
                    int n = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].y;
                    if (viewSize.height - this.tabViewPosition.y >= viewRect.height) break;
                    this.tabViewPosition.y = viewSize.height - viewRect.height;
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (BasicJideTabbedPaneUI.this._tabPane == null) {
                return;
            }
            BasicJideTabbedPaneUI.this.ensureCurrentLayout();
            JViewport viewport = (JViewport)e.getSource();
            int tabPlacement = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            int tabCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            Rectangle vpRect = viewport.getBounds();
            Dimension viewSize = viewport.getViewSize();
            Rectangle viewRect = viewport.getViewRect();
            this.leadingTabIndex = BasicJideTabbedPaneUI.this.getClosestTab(viewRect.x, viewRect.y);
            if (this.leadingTabIndex < BasicJideTabbedPaneUI.this._rects.length && this.leadingTabIndex >= BasicJideTabbedPaneUI.this._rects.length) {
                switch (tabPlacement) {
                    case 1: 
                    case 3: {
                        if (BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].x >= viewRect.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].y >= viewRect.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets contentInsets = BasicJideTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            switch (tabPlacement) {
                case 2: {
                    BasicJideTabbedPaneUI.this._tabPane.repaint(vpRect.x + vpRect.width, vpRect.y, contentInsets.left, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0 || this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 4: {
                    BasicJideTabbedPaneUI.this._tabPane.repaint(vpRect.x - contentInsets.right, vpRect.y, contentInsets.right, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0 || this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 3: {
                    BasicJideTabbedPaneUI.this._tabPane.repaint(vpRect.x, vpRect.y - contentInsets.bottom, vpRect.width, contentInsets.bottom);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0 || this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                    break;
                }
                default: {
                    BasicJideTabbedPaneUI.this._tabPane.repaint(vpRect.x, vpRect.y + vpRect.height, vpRect.width, contentInsets.top);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0 || this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                }
            }
            if (SystemInfo.isJdk15Above()) {
                BasicJideTabbedPaneUI.this._tabPane.setComponentZOrder(BasicJideTabbedPaneUI.this._tabScroller.scrollForwardButton, 0);
                BasicJideTabbedPaneUI.this._tabPane.setComponentZOrder(BasicJideTabbedPaneUI.this._tabScroller.scrollBackwardButton, 0);
            }
            BasicJideTabbedPaneUI.this._tabScroller.scrollForwardButton.repaint();
            BasicJideTabbedPaneUI.this._tabScroller.scrollBackwardButton.repaint();
            int selectedIndex = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                this.closeButton.setEnabled(BasicJideTabbedPaneUI.this._tabPane.isTabClosableAt(selectedIndex));
            }
        }

        public String toString() {
            return "viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition;
        }
    }

    protected class ActivateTabAction
    extends AbstractAction {
        int _tabIndex;

        public ActivateTabAction(String name, Icon icon, int tabIndex) {
            super(name, icon);
            this._tabIndex = tabIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(this._tabIndex);
        }
    }

    protected class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        protected TabbedPaneScrollLayout() {
        }

        @Override
        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return BasicJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
        }

        @Override
        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
        }

        @Override
        public void layoutContainer(Container parent) {
            int tabPlacement = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            int tabCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            int selectedIndex = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            Component visibleComponent = BasicJideTabbedPaneUI.this.getVisibleComponent();
            boolean leftToRight = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight();
            this.calculateLayoutInfo();
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    BasicJideTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component selectedComponent = selectedIndex >= BasicJideTabbedPaneUI.this._tabPane.getTabCount() ? null : BasicJideTabbedPaneUI.this._tabPane.getComponentAt(selectedIndex);
                boolean shouldChangeFocus = false;
                if (selectedComponent != null) {
                    if (selectedComponent != visibleComponent && visibleComponent != null && JideSwingUtilities.isAncestorOfFocusOwner(visibleComponent) && BasicJideTabbedPaneUI.this._tabPane.isAutoRequestFocus()) {
                        shouldChangeFocus = true;
                    }
                    BasicJideTabbedPaneUI.this.setVisibleComponent(selectedComponent);
                }
                Insets contentInsets = BasicJideTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
                Rectangle bounds = BasicJideTabbedPaneUI.this._tabPane.getBounds();
                int numChildren = BasicJideTabbedPaneUI.this._tabPane.getComponentCount();
                Dimension lsize = new Dimension(0, 0);
                Dimension tsize = new Dimension(0, 0);
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                    lsize = BasicJideTabbedPaneUI.this._tabLeadingComponent.getPreferredSize();
                }
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                    tsize = BasicJideTabbedPaneUI.this._tabTrailingComponent.getPreferredSize();
                }
                if (numChildren > 0) {
                    int ch;
                    int cw;
                    int cy;
                    int cx;
                    int ty;
                    int tx;
                    int th;
                    int tw;
                    switch (tabPlacement) {
                        case 2: {
                            tw = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(1, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                            th = bounds.height - insets.top - insets.bottom;
                            tx = insets.left;
                            ty = insets.top;
                            if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                ty += lsize.height;
                                th -= lsize.height;
                                if (lsize.width > tw) {
                                    tw = lsize.width;
                                }
                            }
                            if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                th -= tsize.height;
                                if (tsize.width > tw) {
                                    tw = tsize.width;
                                }
                            }
                            cx = tx + tw + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        case 4: {
                            tw = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(1, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                            th = bounds.height - insets.top - insets.bottom;
                            tx = bounds.width - insets.right - tw;
                            ty = insets.top;
                            if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                ty += lsize.height;
                                th -= lsize.height;
                                if (lsize.width > tw) {
                                    tw = lsize.width;
                                    tx = bounds.width - insets.right - tw;
                                }
                            }
                            if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                th -= tsize.height;
                                if (tsize.width > tw) {
                                    tw = tsize.width;
                                    tx = bounds.width - insets.right - tw;
                                }
                            }
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        case 3: {
                            tw = bounds.width - insets.left - insets.right;
                            th = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                            tx = insets.left;
                            ty = bounds.height - insets.bottom - th;
                            if (leftToRight) {
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    tx += lsize.width;
                                    tw -= lsize.width;
                                    if (lsize.height > th) {
                                        th = lsize.height;
                                        ty = bounds.height - insets.bottom - th;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    tw -= tsize.width;
                                    if (tsize.height > th) {
                                        th = tsize.height;
                                        ty = bounds.height - insets.bottom - th;
                                    }
                                }
                            } else {
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    tx += tsize.width;
                                    tw -= tsize.width;
                                    if (tsize.height > th) {
                                        th = tsize.height;
                                        ty = bounds.height - insets.bottom - th;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    tw -= lsize.width;
                                    if (lsize.height > th) {
                                        th = lsize.height;
                                        ty = bounds.height - insets.bottom - th;
                                    }
                                }
                            }
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        default: {
                            tw = bounds.width - insets.left - insets.right;
                            th = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                            tx = insets.left;
                            ty = insets.top;
                            if (leftToRight) {
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    tx += lsize.width;
                                    tw -= lsize.width;
                                    if (lsize.height > th) {
                                        th = lsize.height;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    tw -= tsize.width;
                                    if (tsize.height > th) {
                                        th = tsize.height;
                                    }
                                }
                            } else {
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    tx += tsize.width;
                                    tw -= tsize.width;
                                    if (tsize.height > th) {
                                        th = tsize.height;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    tw -= lsize.width;
                                    if (lsize.height > th) {
                                        th = lsize.height;
                                    }
                                }
                            }
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + th + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                        }
                    }
                    for (int i = 0; i < numChildren; ++i) {
                        Component child = BasicJideTabbedPaneUI.this._tabPane.getComponent(i);
                        if (child instanceof ScrollableTabViewport) {
                            JViewport viewport = (JViewport)child;
                            int vw = tw;
                            int vh = th;
                            int numberOfButtons = BasicJideTabbedPaneUI.this.getNumberOfTabButtons();
                            switch (tabPlacement) {
                                case 2: 
                                case 4: {
                                    int totalTabHeight = BasicJideTabbedPaneUI.this._rects[tabCount - 1].y + BasicJideTabbedPaneUI.this._rects[tabCount - 1].height;
                                    if (totalTabHeight > th || BasicJideTabbedPaneUI.this.isShowTabButtons()) {
                                        if (!BasicJideTabbedPaneUI.this.isShowTabButtons()) {
                                            numberOfButtons += 3;
                                        }
                                        vh = Math.max(th - BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons, 0);
                                    } else {
                                        vh = Math.max(th - BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons, 0);
                                    }
                                    if (vh + BasicJideTabbedPaneUI.this.getLayoutSize() >= th - BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons) break;
                                    vh += BasicJideTabbedPaneUI.this.getLayoutSize();
                                    break;
                                }
                                default: {
                                    int totalTabWidth = BasicJideTabbedPaneUI.this._rects[tabCount - 1].x + BasicJideTabbedPaneUI.this._rects[tabCount - 1].width;
                                    if (BasicJideTabbedPaneUI.this.isShowTabButtons() || totalTabWidth > tw) {
                                        if (!BasicJideTabbedPaneUI.this.isShowTabButtons()) {
                                            numberOfButtons += 3;
                                        }
                                        vw = Math.max(tw - BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons, 0);
                                    } else {
                                        vw = Math.max(tw - BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons, 0);
                                    }
                                    if (vw + BasicJideTabbedPaneUI.this.getLayoutSize() >= tw - BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons) break;
                                    vw += BasicJideTabbedPaneUI.this.getLayoutSize();
                                }
                            }
                            child.setBounds(tx, ty, vw, vh);
                            continue;
                        }
                        if (child instanceof TabCloseButton) {
                            TabCloseButton scrollbutton = (TabCloseButton)child;
                            if (BasicJideTabbedPaneUI.this._tabPane.isTabShown() && (scrollbutton.getType() != 0 || !BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab())) {
                                Dimension bsize = scrollbutton.getPreferredSize();
                                int bx = 0;
                                int by = 0;
                                int bw = bsize.width;
                                int bh = bsize.height;
                                boolean visible = false;
                                switch (tabPlacement) {
                                    case 2: 
                                    case 4: {
                                        int dir;
                                        int totalTabHeight = BasicJideTabbedPaneUI.this._rects[tabCount - 1].y + BasicJideTabbedPaneUI.this._rects[tabCount - 1].height;
                                        if (BasicJideTabbedPaneUI.this._tabPane.isTabShown() && (BasicJideTabbedPaneUI.this.isShowTabButtons() || totalTabHeight > th)) {
                                            dir = scrollbutton.getType();
                                            scrollbutton.setType(dir);
                                            switch (dir) {
                                                case 0: {
                                                    if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                        visible = true;
                                                        by = bounds.height - insets.top - bsize.height - 5;
                                                        break;
                                                    }
                                                    visible = false;
                                                    by = 0;
                                                    break;
                                                }
                                                case 5: {
                                                    visible = true;
                                                    by = bounds.height - insets.top - (2 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.height - 5;
                                                    break;
                                                }
                                                case 1: {
                                                    visible = !BasicJideTabbedPaneUI.this.isShrinkTabs();
                                                    by = bounds.height - insets.top - (3 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.height - 5;
                                                    break;
                                                }
                                                case 2: {
                                                    visible = !BasicJideTabbedPaneUI.this.isShrinkTabs();
                                                    by = bounds.height - insets.top - (4 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.height - 5;
                                                }
                                            }
                                            bx = tx + 2;
                                        } else {
                                            dir = scrollbutton.getType();
                                            scrollbutton.setType(dir);
                                            if (dir == 0) {
                                                if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                    visible = true;
                                                    by = bounds.height - insets.top - bsize.height - 5;
                                                } else {
                                                    visible = false;
                                                    by = 0;
                                                }
                                                bx = tx + 2;
                                            }
                                        }
                                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                            by -= tsize.height;
                                        }
                                        int temp = -1;
                                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && lsize.width >= BasicJideTabbedPaneUI.this._rects[0].width && tabPlacement == 2) {
                                            bx += lsize.width - BasicJideTabbedPaneUI.this._rects[0].width;
                                            temp = lsize.width;
                                        }
                                        if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || tsize.width < BasicJideTabbedPaneUI.this._rects[0].width || temp >= tsize.width || tabPlacement != 2) break;
                                        bx += tsize.width - BasicJideTabbedPaneUI.this._rects[0].width;
                                        break;
                                    }
                                    default: {
                                        int dir;
                                        int totalTabWidth = BasicJideTabbedPaneUI.this._rects[tabCount - 1].x + BasicJideTabbedPaneUI.this._rects[tabCount - 1].width;
                                        if (BasicJideTabbedPaneUI.this._tabPane.isTabShown() && (BasicJideTabbedPaneUI.this.isShowTabButtons() || totalTabWidth > tw)) {
                                            dir = scrollbutton.getType();
                                            scrollbutton.setType(dir);
                                            switch (dir) {
                                                case 0: {
                                                    if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                        visible = true;
                                                        bx = bounds.width - insets.left - bsize.width - 5;
                                                        break;
                                                    }
                                                    visible = false;
                                                    bx = 0;
                                                    break;
                                                }
                                                case 5: {
                                                    visible = true;
                                                    bx = bounds.width - insets.left - (2 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.width - 5;
                                                    break;
                                                }
                                                case 1: {
                                                    visible = !BasicJideTabbedPaneUI.this.isShrinkTabs();
                                                    bx = bounds.width - insets.left - (3 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.width - 5;
                                                    break;
                                                }
                                                case 2: {
                                                    visible = !BasicJideTabbedPaneUI.this.isShrinkTabs();
                                                    bx = bounds.width - insets.left - (4 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.width - 5;
                                                }
                                            }
                                            by = (th - bsize.height >> 1) + ty;
                                        } else {
                                            dir = scrollbutton.getType();
                                            scrollbutton.setType(dir);
                                            if (dir == 0) {
                                                if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                    visible = true;
                                                    bx = bounds.width - insets.left - bsize.width - 5;
                                                } else {
                                                    visible = false;
                                                    bx = 0;
                                                }
                                                by = (th - bsize.height >> 1) + ty;
                                            }
                                        }
                                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                            bx -= tsize.width;
                                        }
                                        int temp = -1;
                                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && lsize.height >= BasicJideTabbedPaneUI.this._rects[0].height) {
                                            if (tabPlacement == 1) {
                                                by = ty + 2 + lsize.height - BasicJideTabbedPaneUI.this._rects[0].height;
                                                temp = lsize.height;
                                            } else {
                                                by = ty + 2;
                                            }
                                        }
                                        if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || tsize.height < BasicJideTabbedPaneUI.this._rects[0].height || temp >= tsize.height) break;
                                        by = tabPlacement == 1 ? ty + 2 + tsize.height - BasicJideTabbedPaneUI.this._rects[0].height : ty + 2;
                                    }
                                }
                                child.setVisible(visible);
                                if (!visible) continue;
                                child.setBounds(bx, by, bw, bh);
                                continue;
                            }
                            scrollbutton.setBounds(0, 0, 0, 0);
                            continue;
                        }
                        if (child == BasicJideTabbedPaneUI.this._tabPane.getTabLeadingComponent() || child == BasicJideTabbedPaneUI.this._tabPane.getTabTrailingComponent()) continue;
                        if (BasicJideTabbedPaneUI.this._tabPane.isShowTabContent()) {
                            child.setBounds(cx, cy, cw, ch);
                            continue;
                        }
                        child.setBounds(0, 0, 0, 0);
                    }
                    if (leftToRight) {
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx + tw - lsize.width, ty - lsize.height, lsize.width, lsize.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx, ty - lsize.height, lsize.width, lsize.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx - lsize.width, ty, lsize.width, lsize.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx - lsize.width, ty + th - lsize.height, lsize.width, lsize.height);
                                }
                            }
                        }
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx + tw - tsize.width, ty + th, tsize.width, tsize.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx, ty + th, tsize.width, tsize.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx + tw, ty, tsize.width, tsize.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx + tw, ty + th - tsize.height, tsize.width, tsize.height);
                                    break;
                                }
                            }
                        }
                    } else {
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx + tw - tsize.width, ty - tsize.height, tsize.width, tsize.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx, ty - tsize.height, tsize.width, tsize.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx - tsize.width, ty, tsize.width, tsize.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx - tsize.width, ty + th - tsize.height, tsize.width, tsize.height);
                                }
                            }
                        }
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx + tw - lsize.width, ty + th, lsize.width, lsize.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx, ty + th, lsize.width, lsize.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx + tw, ty, lsize.width, lsize.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx + tw, ty + th - lsize.height, lsize.width, lsize.height);
                                }
                            }
                        }
                    }
                    BasicJideTabbedPaneUI.this.updateCloseButtons();
                    if (shouldChangeFocus && !BasicJideTabbedPaneUI.this.requestFocusForVisibleComponent() && !BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow()) {
                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                    }
                }
            }
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Dimension size = BasicJideTabbedPaneUI.this._tabPane.getSize();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            Insets tabAreaInsets = BasicJideTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight();
            int x = tabAreaInsets.left;
            int y = tabAreaInsets.top;
            Dimension lsize = new Dimension(0, 0);
            Dimension tsize = new Dimension(0, 0);
            if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                lsize = BasicJideTabbedPaneUI.this._tabLeadingComponent.getPreferredSize();
            }
            if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                tsize = BasicJideTabbedPaneUI.this._tabTrailingComponent.getPreferredSize();
            }
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && tabPlacement == 4 && BasicJideTabbedPaneUI.this._maxTabWidth < lsize.width) {
                        BasicJideTabbedPaneUI.this._maxTabWidth = lsize.width;
                    }
                    if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || tabPlacement != 4 || BasicJideTabbedPaneUI.this._maxTabWidth >= tsize.width) break;
                    BasicJideTabbedPaneUI.this._maxTabWidth = tsize.width;
                    break;
                }
                default: {
                    BasicJideTabbedPaneUI.this._maxTabHeight = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && tabPlacement == 3 && BasicJideTabbedPaneUI.this._maxTabHeight < lsize.height) {
                        BasicJideTabbedPaneUI.this._maxTabHeight = lsize.height;
                    }
                    if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || tabPlacement != 3 || BasicJideTabbedPaneUI.this._maxTabHeight >= tsize.height) break;
                    BasicJideTabbedPaneUI.this._maxTabHeight = tsize.height;
                }
            }
            BasicJideTabbedPaneUI.this._runCount = 0;
            BasicJideTabbedPaneUI.this._selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            BasicJideTabbedPaneUI.this._selectedRun = 0;
            BasicJideTabbedPaneUI.this._runCount = 1;
            for (int i = 0; i < tabCount; ++i) {
                int temp;
                FontMetrics metrics = BasicJideTabbedPaneUI.this.getFontMetrics(i);
                Rectangle rect = BasicJideTabbedPaneUI.this._rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = BasicJideTabbedPaneUI.this._rects[i - 1].x + BasicJideTabbedPaneUI.this._rects[i - 1].width;
                    } else {
                        BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                        BasicJideTabbedPaneUI.this._maxTabWidth = 0;
                        rect.x = BasicJideTabbedPaneUI.this.getTabShape() != 3 ? x + BasicJideTabbedPaneUI.this.getLeftMargin() : x;
                    }
                    rect.width = BasicJideTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics) + BasicJideTabbedPaneUI.this._rectSizeExtend;
                    BasicJideTabbedPaneUI.this._maxTabWidth = Math.max(BasicJideTabbedPaneUI.this._maxTabWidth, rect.width);
                    rect.y = y;
                    temp = -1;
                    if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && tabPlacement == 1 && BasicJideTabbedPaneUI.this._maxTabHeight < lsize.height) {
                        rect.y = y + lsize.height - BasicJideTabbedPaneUI.this._maxTabHeight - 2;
                        temp = lsize.height;
                        if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                            rect.y += 2;
                        }
                    }
                    if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() && tabPlacement == 1 && BasicJideTabbedPaneUI.this._maxTabHeight < tsize.height && temp < tsize.height) {
                        rect.y = y + tsize.height - BasicJideTabbedPaneUI.this._maxTabHeight - 2;
                        if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                            rect.y += 2;
                        }
                    }
                    rect.height = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    continue;
                }
                if (i > 0) {
                    rect.y = BasicJideTabbedPaneUI.this._rects[i - 1].y + BasicJideTabbedPaneUI.this._rects[i - 1].height;
                } else {
                    BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                    BasicJideTabbedPaneUI.this._maxTabHeight = 0;
                    rect.y = BasicJideTabbedPaneUI.this.getTabShape() != 3 ? y + BasicJideTabbedPaneUI.this.getLeftMargin() : y;
                }
                rect.height = BasicJideTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, metrics) + BasicJideTabbedPaneUI.this._rectSizeExtend;
                BasicJideTabbedPaneUI.this._maxTabHeight = Math.max(BasicJideTabbedPaneUI.this._maxTabHeight, rect.height);
                rect.x = x;
                temp = -1;
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && tabPlacement == 2 && BasicJideTabbedPaneUI.this._maxTabWidth < lsize.width) {
                    rect.x = x + lsize.width - BasicJideTabbedPaneUI.this._maxTabWidth - 2;
                    temp = lsize.width;
                    if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                        rect.x += 2;
                    }
                }
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() && tabPlacement == 2 && BasicJideTabbedPaneUI.this._maxTabWidth < tsize.width && temp < tsize.width) {
                    rect.x = x + tsize.width - BasicJideTabbedPaneUI.this._maxTabWidth - 2;
                    if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                        rect.x += 2;
                    }
                }
                rect.width = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
            }
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                    rightMargin -= lsize.width;
                }
                int offset = 0;
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                    offset += tsize.width;
                }
                for (int i = 0; i < tabCount; ++i) {
                    BasicJideTabbedPaneUI.this._rects[i].x = rightMargin - BasicJideTabbedPaneUI.this._rects[i].x - BasicJideTabbedPaneUI.this._rects[i].width - offset + BasicJideTabbedPaneUI.this.getLeftMargin();
                }
            }
            BasicJideTabbedPaneUI.this.ensureCurrentRects(BasicJideTabbedPaneUI.this.getLeftMargin(), tabCount);
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dimension = this.calculateSize(false);
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Dimension calculateSize(boolean minimum) {
            int tabPlacement = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            Insets contentInsets = BasicJideTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            Insets tabAreaInsets = BasicJideTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Dimension zeroSize = new Dimension(0, 0);
            int height = contentInsets.top + contentInsets.bottom;
            int width = contentInsets.left + contentInsets.right;
            int cWidth = 0;
            int cHeight = 0;
            TabbedPaneLayout tabbedPaneLayout = this;
            synchronized (tabbedPaneLayout) {
                BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                this.calculateLayoutInfo();
                if (BasicJideTabbedPaneUI.this._tabPane.isShowTabContent()) {
                    for (int i = 0; i < BasicJideTabbedPaneUI.this._tabPane.getTabCount(); ++i) {
                        Component component = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(i);
                        if (component == null) continue;
                        Dimension size = zeroSize;
                        Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
                        if (size == null) continue;
                        cHeight = Math.max(size.height, cHeight);
                        cWidth = Math.max(size.width, cWidth);
                    }
                    width += cWidth;
                    height += cHeight;
                }
                int tabExtent = 0;
                Dimension lsize = new Dimension(0, 0);
                Dimension tsize = new Dimension(0, 0);
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                    lsize = BasicJideTabbedPaneUI.this._tabLeadingComponent.getPreferredSize();
                }
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                    tsize = BasicJideTabbedPaneUI.this._tabTrailingComponent.getPreferredSize();
                }
                switch (tabPlacement) {
                    case 2: 
                    case 4: {
                        height = Math.max(height, (minimum ? 0 : BasicJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement)) + tabAreaInsets.top + tabAreaInsets.bottom);
                        tabExtent = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            tabExtent = Math.max(lsize.width, tabExtent);
                        }
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            tabExtent = Math.max(tsize.width, tabExtent);
                        }
                        width += tabExtent;
                        break;
                    }
                    default: {
                        width = BasicJideTabbedPaneUI.this._tabPane.getTabResizeMode() == 2 ? Math.max(width, (BasicJideTabbedPaneUI.this._tabPane.getTabCount() << 2) + tabAreaInsets.left + tabAreaInsets.right) : Math.max(width, (minimum ? 0 : BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement)) + tabAreaInsets.left + tabAreaInsets.right);
                        if (!BasicJideTabbedPaneUI.this._tabPane.isTabShown()) break;
                        tabExtent = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            tabExtent = Math.max(lsize.height, tabExtent);
                        }
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            tabExtent = Math.max(tsize.height, tabExtent);
                        }
                        height += tabExtent;
                    }
                }
            }
            return new Dimension(width + insets.left + insets.right, height + insets.bottom + insets.top);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            int tabCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int rows = 1;
                int x = 0;
                int maxTabHeight = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                for (int i = 0; i < tabCount; ++i) {
                    FontMetrics metrics = BasicJideTabbedPaneUI.this.getFontMetrics(i);
                    int tabWidth = BasicJideTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    if (x != 0 && x + tabWidth > width) {
                        ++rows;
                        x = 0;
                    }
                    x += tabWidth;
                }
                total = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, rows, maxTabHeight);
            }
            return total;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            int tabCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int columns = 1;
                int y = 0;
                BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                for (int i = 0; i < tabCount; ++i) {
                    FontMetrics metrics = BasicJideTabbedPaneUI.this.getFontMetrics(i);
                    int tabHeight = BasicJideTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, metrics);
                    if (y != 0 && y + tabHeight > height) {
                        ++columns;
                        y = 0;
                    }
                    y += tabHeight;
                }
                total = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, columns, BasicJideTabbedPaneUI.this._maxTabWidth);
            }
            return total;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            int tabPlacement = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            int selectedIndex = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            Component visibleComponent = BasicJideTabbedPaneUI.this.getVisibleComponent();
            TabbedPaneLayout tabbedPaneLayout = this;
            synchronized (tabbedPaneLayout) {
                BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                this.calculateLayoutInfo();
                if (selectedIndex < 0) {
                    if (visibleComponent != null) {
                        BasicJideTabbedPaneUI.this.setVisibleComponent(null);
                    }
                } else {
                    int totalTabWidth = 0;
                    int totalTabHeight = 0;
                    Insets contentInsets = BasicJideTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
                    Component selectedComponent = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(selectedIndex);
                    boolean shouldChangeFocus = false;
                    if (selectedComponent != null) {
                        if (selectedComponent != visibleComponent && visibleComponent != null && JideSwingUtilities.isAncestorOfFocusOwner(visibleComponent) && BasicJideTabbedPaneUI.this._tabPane.isAutoRequestFocus()) {
                            shouldChangeFocus = true;
                        }
                        BasicJideTabbedPaneUI.this.setVisibleComponent(selectedComponent);
                    }
                    Rectangle bounds = BasicJideTabbedPaneUI.this._tabPane.getBounds();
                    int numChildren = BasicJideTabbedPaneUI.this._tabPane.getComponentCount();
                    if (numChildren > 0) {
                        int cy;
                        int cx;
                        switch (tabPlacement) {
                            case 2: {
                                totalTabWidth = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                                cx = insets.left + totalTabWidth + contentInsets.left;
                                cy = insets.top + contentInsets.top;
                                break;
                            }
                            case 4: {
                                totalTabWidth = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                                cx = insets.left + contentInsets.left;
                                cy = insets.top + contentInsets.top;
                                break;
                            }
                            case 3: {
                                totalTabHeight = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                                cx = insets.left + contentInsets.left;
                                cy = insets.top + contentInsets.top;
                                break;
                            }
                            default: {
                                totalTabHeight = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                                cx = insets.left + contentInsets.left;
                                cy = insets.top + totalTabHeight + contentInsets.top;
                            }
                        }
                        int cw = bounds.width - totalTabWidth - insets.left - insets.right - contentInsets.left - contentInsets.right;
                        int ch = bounds.height - totalTabHeight - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                        for (int i = 0; i < numChildren; ++i) {
                            Component child = BasicJideTabbedPaneUI.this._tabPane.getComponent(i);
                            child.setBounds(cx, cy, cw, ch);
                        }
                    }
                    if (shouldChangeFocus && !BasicJideTabbedPaneUI.this.requestFocusForVisibleComponent() && !BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow()) {
                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                    }
                }
            }
        }

        public void calculateLayoutInfo() {
            int tabCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            BasicJideTabbedPaneUI.this.assureRectsCreated(tabCount);
            this.calculateTabRects(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement(), tabCount);
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Rectangle rect;
            int i;
            int returnAt;
            int y;
            int x;
            Dimension size = BasicJideTabbedPaneUI.this._tabPane.getSize();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            Insets tabAreaInsets = BasicJideTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int selectedIndex = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight();
            switch (tabPlacement) {
                case 2: {
                    BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = size.width - insets.right - tabAreaInsets.right - BasicJideTabbedPaneUI.this._maxTabWidth;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    BasicJideTabbedPaneUI.this._maxTabHeight = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = size.height - insets.bottom - tabAreaInsets.bottom - BasicJideTabbedPaneUI.this._maxTabHeight;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                    break;
                }
                default: {
                    BasicJideTabbedPaneUI.this._maxTabHeight = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                }
            }
            int tabRunOverlay = BasicJideTabbedPaneUI.this.getTabRunOverlay(tabPlacement);
            BasicJideTabbedPaneUI.this._runCount = 0;
            BasicJideTabbedPaneUI.this._selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            for (i = 0; i < tabCount; ++i) {
                FontMetrics metrics = BasicJideTabbedPaneUI.this.getFontMetrics(i);
                rect = BasicJideTabbedPaneUI.this._rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = BasicJideTabbedPaneUI.this._rects[i - 1].x + BasicJideTabbedPaneUI.this._rects[i - 1].width;
                    } else {
                        BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                        BasicJideTabbedPaneUI.this._runCount = 1;
                        BasicJideTabbedPaneUI.this._maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = BasicJideTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    BasicJideTabbedPaneUI.this._maxTabWidth = Math.max(BasicJideTabbedPaneUI.this._maxTabWidth, rect.width);
                    if (rect.x != 2 + insets.left && rect.x + rect.width > returnAt) {
                        if (BasicJideTabbedPaneUI.this._runCount > BasicJideTabbedPaneUI.this._tabRuns.length - 1) {
                            BasicJideTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicJideTabbedPaneUI.this._tabRuns[BasicJideTabbedPaneUI.this._runCount] = i;
                        ++BasicJideTabbedPaneUI.this._runCount;
                        rect.x = x;
                    }
                    rect.y = y;
                    rect.height = BasicJideTabbedPaneUI.this._maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = BasicJideTabbedPaneUI.this._rects[i - 1].y + BasicJideTabbedPaneUI.this._rects[i - 1].height;
                    } else {
                        BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                        BasicJideTabbedPaneUI.this._runCount = 1;
                        BasicJideTabbedPaneUI.this._maxTabHeight = 0;
                        rect.y = y;
                    }
                    rect.height = BasicJideTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, metrics);
                    BasicJideTabbedPaneUI.this._maxTabHeight = Math.max(BasicJideTabbedPaneUI.this._maxTabHeight, rect.height);
                    if (rect.y != 2 + insets.top && rect.y + rect.height > returnAt) {
                        if (BasicJideTabbedPaneUI.this._runCount > BasicJideTabbedPaneUI.this._tabRuns.length - 1) {
                            BasicJideTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicJideTabbedPaneUI.this._tabRuns[BasicJideTabbedPaneUI.this._runCount] = i;
                        ++BasicJideTabbedPaneUI.this._runCount;
                        rect.y = y;
                    }
                    rect.x = x;
                    rect.width = BasicJideTabbedPaneUI.this._maxTabWidth;
                }
                if (i != selectedIndex) continue;
                BasicJideTabbedPaneUI.this._selectedRun = BasicJideTabbedPaneUI.this._runCount - 1;
            }
            if (BasicJideTabbedPaneUI.this._runCount > 1) {
                this.normalizeTabRuns(tabPlacement, tabCount, verticalTabRuns ? y : x, returnAt);
                BasicJideTabbedPaneUI.this._selectedRun = BasicJideTabbedPaneUI.this.getRunForTab(tabCount, selectedIndex);
                if (BasicJideTabbedPaneUI.this.shouldRotateTabRuns(tabPlacement)) {
                    this.rotateTabRuns(tabPlacement, BasicJideTabbedPaneUI.this._selectedRun);
                }
            }
            for (i = BasicJideTabbedPaneUI.this._runCount - 1; i >= 0; --i) {
                int j;
                int end;
                int start = BasicJideTabbedPaneUI.this._tabRuns[i];
                int next = BasicJideTabbedPaneUI.this._tabRuns[i == BasicJideTabbedPaneUI.this._runCount - 1 ? 0 : i + 1];
                int n = end = next != 0 ? next - 1 : tabCount - 1;
                if (!verticalTabRuns) {
                    for (j = start; j <= end; ++j) {
                        rect = BasicJideTabbedPaneUI.this._rects[j];
                        rect.y = y;
                        rect.x += BasicJideTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                    }
                    if (BasicJideTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, returnAt);
                    }
                    if (tabPlacement == 3) {
                        y -= BasicJideTabbedPaneUI.this._maxTabHeight - tabRunOverlay;
                        continue;
                    }
                    y += BasicJideTabbedPaneUI.this._maxTabHeight - tabRunOverlay;
                    continue;
                }
                for (j = start; j <= end; ++j) {
                    rect = BasicJideTabbedPaneUI.this._rects[j];
                    rect.x = x;
                    rect.y += BasicJideTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                }
                if (BasicJideTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                    this.padTabRun(tabPlacement, start, end, returnAt);
                }
                if (tabPlacement == 4) {
                    x -= BasicJideTabbedPaneUI.this._maxTabWidth - tabRunOverlay;
                    continue;
                }
                x += BasicJideTabbedPaneUI.this._maxTabWidth - tabRunOverlay;
            }
            this.padSelectedTab(tabPlacement, selectedIndex);
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (i = 0; i < tabCount; ++i) {
                    BasicJideTabbedPaneUI.this._rects[i].x = rightMargin - BasicJideTabbedPaneUI.this._rects[i].x - BasicJideTabbedPaneUI.this._rects[i].width;
                }
            }
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            for (int i = 0; i < selectedRun; ++i) {
                int save = BasicJideTabbedPaneUI.this._tabRuns[0];
                for (int j = 1; j < BasicJideTabbedPaneUI.this._runCount; ++j) {
                    BasicJideTabbedPaneUI.this._tabRuns[j - 1] = BasicJideTabbedPaneUI.this._tabRuns[j];
                }
                BasicJideTabbedPaneUI.this._tabRuns[BasicJideTabbedPaneUI.this._runCount - 1] = save;
            }
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            int run = BasicJideTabbedPaneUI.this._runCount - 1;
            boolean keepAdjusting = true;
            double weight = 1.25;
            while (keepAdjusting) {
                int prevLastLen;
                int end;
                int last = BasicJideTabbedPaneUI.this.lastTabInRun(tabCount, run);
                int prevLast = BasicJideTabbedPaneUI.this.lastTabInRun(tabCount, run - 1);
                if (!verticalTabRuns) {
                    end = BasicJideTabbedPaneUI.this._rects[last].x + BasicJideTabbedPaneUI.this._rects[last].width;
                    prevLastLen = (int)((double)BasicJideTabbedPaneUI.this._maxTabWidth * weight);
                } else {
                    end = BasicJideTabbedPaneUI.this._rects[last].y + BasicJideTabbedPaneUI.this._rects[last].height;
                    prevLastLen = (int)((double)BasicJideTabbedPaneUI.this._maxTabHeight * weight * 2.0);
                }
                if (max - end > prevLastLen) {
                    BasicJideTabbedPaneUI.this._tabRuns[run] = prevLast;
                    if (!verticalTabRuns) {
                        BasicJideTabbedPaneUI.this._rects[prevLast].x = start;
                    } else {
                        BasicJideTabbedPaneUI.this._rects[prevLast].y = start;
                    }
                    for (int i = prevLast + 1; i <= last; ++i) {
                        if (!verticalTabRuns) {
                            BasicJideTabbedPaneUI.this._rects[i].x = BasicJideTabbedPaneUI.this._rects[i - 1].x + BasicJideTabbedPaneUI.this._rects[i - 1].width;
                            continue;
                        }
                        BasicJideTabbedPaneUI.this._rects[i].y = BasicJideTabbedPaneUI.this._rects[i - 1].y + BasicJideTabbedPaneUI.this._rects[i - 1].height;
                    }
                } else if (run == BasicJideTabbedPaneUI.this._runCount - 1) {
                    keepAdjusting = false;
                }
                if (run - 1 > 0) {
                    --run;
                    continue;
                }
                run = BasicJideTabbedPaneUI.this._runCount - 1;
                weight += 0.25;
            }
        }

        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            Rectangle lastRect = BasicJideTabbedPaneUI.this._rects[end];
            if (tabPlacement == 1 || tabPlacement == 3) {
                int runWidth = lastRect.x + lastRect.width - BasicJideTabbedPaneUI.this._rects[start].x;
                int deltaWidth = max - (lastRect.x + lastRect.width);
                float factor = (float)deltaWidth / (float)runWidth;
                for (int j = start; j <= end; ++j) {
                    Rectangle pastRect = BasicJideTabbedPaneUI.this._rects[j];
                    if (j > start) {
                        pastRect.x = BasicJideTabbedPaneUI.this._rects[j - 1].x + BasicJideTabbedPaneUI.this._rects[j - 1].width;
                    }
                    pastRect.width += Math.round((float)pastRect.width * factor);
                }
                lastRect.width = max - lastRect.x;
            } else {
                int runHeight = lastRect.y + lastRect.height - BasicJideTabbedPaneUI.this._rects[start].y;
                int deltaHeight = max - (lastRect.y + lastRect.height);
                float factor = (float)deltaHeight / (float)runHeight;
                for (int j = start; j <= end; ++j) {
                    Rectangle pastRect = BasicJideTabbedPaneUI.this._rects[j];
                    if (j > start) {
                        pastRect.y = BasicJideTabbedPaneUI.this._rects[j - 1].y + BasicJideTabbedPaneUI.this._rects[j - 1].height;
                    }
                    pastRect.height += Math.round((float)pastRect.height * factor);
                }
                lastRect.height = max - lastRect.y;
            }
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
            if (selectedIndex >= 0) {
                Rectangle selRect = BasicJideTabbedPaneUI.this._rects[selectedIndex];
                Insets padInsets = BasicJideTabbedPaneUI.this.getSelectedTabPadInsets(tabPlacement);
                selRect.x -= padInsets.left;
                selRect.width += padInsets.left + padInsets.right;
                selRect.y -= padInsets.top;
                selRect.height += padInsets.top + padInsets.bottom;
            }
        }
    }

    private static class CloseTabAction
    extends AbstractAction {
        public CloseTabAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_CLOSE));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JideTabbedPane pane = null;
            Object src = e.getSource();
            boolean closeSelected = false;
            if (src instanceof JideTabbedPane) {
                pane = (JideTabbedPane)src;
            } else if (src instanceof TabCloseButton && ((TabCloseButton)src).getParent() instanceof JideTabbedPane) {
                pane = (JideTabbedPane)((TabCloseButton)src).getParent();
                closeSelected = true;
            } else if (src instanceof TabCloseButton && ((TabCloseButton)src).getParent() instanceof ScrollableTabPanel) {
                pane = (JideTabbedPane)SwingUtilities.getAncestorOfClass(JideTabbedPane.class, (TabCloseButton)src);
                closeSelected = false;
            } else {
                return;
            }
            if (pane.isTabEditing()) {
                pane.stopTabEditing();
            }
            if (pane.getCloseAction() != null) {
                if (closeSelected) {
                    pane.getCloseAction().actionPerformed(e);
                } else {
                    int i = ((TabCloseButton)src).getIndex();
                    if (i != -1) {
                        pane.setSelectedIndex(i);
                        pane.getCloseAction().actionPerformed(e);
                    }
                }
            } else if (closeSelected) {
                if (pane.getSelectedIndex() >= 0) {
                    pane.removeTabAt(pane.getSelectedIndex());
                }
                if (pane.getTabCount() == 0) {
                    pane.updateUI();
                }
            } else {
                int i = ((TabCloseButton)src).getIndex();
                if (i != -1) {
                    int tabIndex = pane.getSelectedIndex();
                    pane.removeTabAt(i);
                    if (i < tabIndex) {
                        pane.setSelectedIndex(tabIndex - 1);
                    }
                    if (pane.getTabCount() == 0) {
                        pane.updateUI();
                    }
                }
            }
        }
    }

    private static class ScrollTabsListAction
    extends AbstractAction {
        public ScrollTabsListAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_TAB_LIST));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicJideTabbedPaneUI ui;
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof TabCloseButton) {
                pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, (TabCloseButton)src);
            }
            if (pane != null && (ui = (BasicJideTabbedPaneUI)pane.getUI()).scrollableTabLayoutEnabled()) {
                if (ui._tabScroller._popup != null && ui._tabScroller._popup.isPopupVisible()) {
                    ui._tabScroller._popup.hidePopupImmediately();
                    ui._tabScroller._popup = null;
                } else {
                    ui._tabScroller.createPopup(pane.getTabPlacement());
                }
            }
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        public ScrollTabsBackwardAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_SCROLL_BACKWARD));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicJideTabbedPaneUI ui;
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof TabCloseButton) {
                pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, (TabCloseButton)src);
            }
            if (pane != null && (ui = (BasicJideTabbedPaneUI)pane.getUI()).scrollableTabLayoutEnabled()) {
                ui._tabScroller.scrollBackward(pane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        public ScrollTabsForwardAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_SCROLL_FORWARD));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicJideTabbedPaneUI ui;
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof TabCloseButton) {
                pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, (TabCloseButton)src);
            }
            if (pane != null && (ui = (BasicJideTabbedPaneUI)pane.getUI()).scrollableTabLayoutEnabled()) {
                ui._tabScroller.scrollForward(pane.getTabPlacement());
            }
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            if (pane != null && pane.getUI() instanceof BasicJideTabbedPaneUI) {
                BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
                String command = e.getActionCommand();
                if (command != null && command.length() > 0) {
                    Integer index;
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    if ((index = (Integer)ui._mnemonicToIndexMap.get(new Integer(mnemonic))) != null && pane.isEnabledAt(index)) {
                        pane.setSelectedIndex(index);
                    }
                }
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.requestFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            if (!pane.requestFocusInWindow()) {
                pane.requestFocus();
            }
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(3);
            } else {
                ui.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(7);
            } else {
                ui.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(13);
        }
    }

    private static class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(12);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(5);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(1);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(7);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(3);
        }
    }
}

