/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch.geometry;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import net.sourceforge.napkinlaf.sketch.AbstractSketcher;
import net.sourceforge.napkinlaf.sketch.geometry.CubicLine;
import net.sourceforge.napkinlaf.sketch.geometry.Point;
import net.sourceforge.napkinlaf.sketch.geometry.QuadLine;
import net.sourceforge.napkinlaf.sketch.geometry.SketchShape;
import net.sourceforge.napkinlaf.sketch.geometry.StraightLine;

public class Path
implements SketchShape {
    private GeneralPath generalPath;

    public Path() {
        this.generalPath = new GeneralPath();
    }

    public Path(Shape s) {
        this.generalPath = new GeneralPath(s);
    }

    public void append(Shape s, boolean connect) {
        this.generalPath.append(s, connect);
    }

    public void closePath() {
        this.generalPath.closePath();
    }

    public boolean contains(double x, double y) {
        return this.generalPath.contains(x, y);
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.generalPath.contains(x, y, w, h);
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.generalPath.curveTo(x1, y1, x2, y2, x3, y3);
    }

    public void lineTo(float x, float y) {
        this.generalPath.lineTo(x, y);
    }

    public void moveTo(float x, float y) {
        this.generalPath.moveTo(x, y);
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        this.generalPath.quadTo(x1, y1, x2, y2);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.generalPath.intersects(x, y, w, h);
    }

    public Rectangle getBounds() {
        return this.generalPath.getBounds();
    }

    public boolean contains(Point2D p) {
        return this.generalPath.contains(p);
    }

    public Rectangle2D getBounds2D() {
        return this.generalPath.getBounds();
    }

    public boolean contains(Rectangle2D r) {
        return this.generalPath.contains(r);
    }

    public boolean intersects(Rectangle2D r) {
        return this.generalPath.intersects(r);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.generalPath.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.generalPath.getPathIterator(at, flatness);
    }

    public SketchShape magnify(double scaleFactor) {
        Path ret = new Path();
        double[] points = new double[6];
        PathIterator i = this.getPathIterator(new AffineTransform());
        block7: while (!i.isDone()) {
            int type = i.currentSegment(points);
            switch (type) {
                case 0: {
                    Point current = new Point(points[0], points[1]).magnify(scaleFactor);
                    ret.moveTo(current.floatX(), current.floatY());
                    continue block7;
                }
                case 1: {
                    Point current = new Point(points[0], points[1]).magnify(scaleFactor);
                    ret.lineTo(current.floatX(), current.floatY());
                    continue block7;
                }
                case 2: {
                    Point control1 = new Point(points[0], points[1]).magnify(scaleFactor);
                    Point current = new Point(points[2], points[3]).magnify(scaleFactor);
                    ret.quadTo(control1.floatX(), control1.floatY(), current.floatX(), current.floatY());
                    continue block7;
                }
                case 3: {
                    Point control1 = new Point(points[0], points[1]).magnify(scaleFactor);
                    Point control2 = new Point(points[2], points[3]).magnify(scaleFactor);
                    Point current = new Point(points[4], points[5]).magnify(scaleFactor);
                    ret.curveTo(control1.floatX(), control1.floatY(), control2.floatX(), control2.floatY(), current.floatX(), current.floatY());
                    continue block7;
                }
                case 4: {
                    ret.closePath();
                    continue block7;
                }
            }
            throw new IllegalStateException(type + ": unknown");
        }
        return ret;
    }

    public CubicLine transformToCubic() {
        throw new UnsupportedOperationException();
    }

    public Path transformToPath() {
        return new Path(this);
    }

    public StraightLine[] transformToLine() {
        SketchShape[] elements;
        LinkedList<StraightLine> ret = new LinkedList<StraightLine>();
        for (SketchShape element : elements = this.simplify()) {
            StraightLine[] temp;
            for (StraightLine line : temp = element.transformToLine()) {
                ret.addLast(line);
            }
        }
        return ret.toArray(new StraightLine[ret.size()]);
    }

    public QuadLine[] transformToQuad() {
        SketchShape[] elements;
        LinkedList<QuadLine> ret = new LinkedList<QuadLine>();
        for (SketchShape element : elements = this.simplify()) {
            QuadLine[] temp;
            for (QuadLine line : temp = element.transformToQuad()) {
                ret.addLast(line);
            }
        }
        return ret.toArray(new QuadLine[ret.size()]);
    }

    public SketchShape deform(AbstractSketcher r) {
        return r.deformPath(this);
    }

    public SketchShape[] simplify() {
        LinkedList<SketchShape> ret = new LinkedList<SketchShape>();
        Point initial = new Point(0.0, 0.0);
        Point current = new Point(initial);
        double[] coords = new double[6];
        PathIterator iter = this.getPathIterator(new AffineTransform());
        block7: while (!iter.isDone()) {
            int curseg = iter.currentSegment(coords);
            iter.next();
            switch (curseg) {
                case 0: {
                    current = new Point(coords[0], coords[1]);
                    initial = new Point(current);
                    continue block7;
                }
                case 1: {
                    Point far = new Point(coords[0], coords[1]);
                    ret.addLast(new StraightLine(current, far));
                    current = far;
                    continue block7;
                }
                case 2: {
                    Point control1 = new Point(coords[0], coords[1]);
                    Point far = new Point(coords[2], coords[3]);
                    ret.addLast(new QuadLine(current, control1, far));
                    current = far;
                    continue block7;
                }
                case 3: {
                    Point control1 = new Point(coords[0], coords[1]);
                    Point control2 = new Point(coords[2], coords[3]);
                    Point far = new Point(coords[4], coords[5]);
                    ret.addLast(new CubicLine(current, control1, control2, far));
                    current = far;
                    continue block7;
                }
                case 4: {
                    ret.addLast(new StraightLine(current, initial));
                    current = initial;
                    continue block7;
                }
            }
            throw new IllegalStateException(curseg + ": unknown seg type");
        }
        return ret.toArray(new SketchShape[ret.size()]);
    }

    public double approximateLength() {
        SketchShape[] elements;
        double ret = 0.0;
        for (SketchShape element : elements = this.simplify()) {
            ret += element.approximateLength();
        }
        return ret;
    }

    public CubicLine[] transformToCubicList() {
        SketchShape[] elements;
        LinkedList<CubicLine> ret = new LinkedList<CubicLine>();
        for (SketchShape element : elements = this.simplify()) {
            ret.addLast(element.transformToCubic());
        }
        return ret.toArray(new CubicLine[ret.size()]);
    }

    public Path clone() {
        try {
            Path clone = (Path)super.clone();
            clone.generalPath = (GeneralPath)this.generalPath.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("cannot clone?", e);
        }
    }
}

