/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;

public class SizeGripIcon
implements Icon {
    private static final int SIZE = 20;
    private int style;

    public SizeGripIcon() {
        this(-1);
    }

    public SizeGripIcon(int style) {
        this.setStyle(style);
    }

    public int getIconHeight() {
        return 20;
    }

    public int getIconWidth() {
        return 20;
    }

    public int getStyle() {
        return this.style;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Dimension dim = c.getSize();
        Color c1 = UIManager.getColor("Label.disabledShadow");
        Color c2 = UIManager.getColor("Label.disabledForeground");
        ComponentOrientation orientation = c.getComponentOrientation();
        switch (this.style) {
            case 0: {
                int width = dim.width;
                int height = dim.height;
                g.setColor(c1.brighter());
                g.drawLine(7, height, width, 7);
                g.drawLine(11, height, width, 11);
                g.drawLine(15, height, width, 15);
                g.setColor(c2.darker());
                g.drawLine(8, height, width, 8);
                g.drawLine(12, height, width, 12);
                g.drawLine(16, height, width, 16);
                break;
            }
            default: {
                if (orientation.isLeftToRight()) {
                    int width = dim.width -= 3;
                    int height = dim.height -= 3;
                    g.setColor(c1);
                    g.fillRect(width - 9, height - 1, 3, 3);
                    g.fillRect(width - 5, height - 1, 3, 3);
                    g.fillRect(width - 1, height - 1, 3, 3);
                    g.fillRect(width - 5, height - 5, 3, 3);
                    g.fillRect(width - 1, height - 5, 3, 3);
                    g.fillRect(width - 1, height - 9, 3, 3);
                    g.setColor(c2);
                    g.fillRect(width - 9, height - 1, 2, 2);
                    g.fillRect(width - 5, height - 1, 2, 2);
                    g.fillRect(width - 1, height - 1, 2, 2);
                    g.fillRect(width - 5, height - 5, 2, 2);
                    g.fillRect(width - 1, height - 5, 2, 2);
                    g.fillRect(width - 1, height - 9, 2, 2);
                    break;
                }
                int height = dim.height -= 3;
                g.setColor(c1);
                g.fillRect(10, height - 1, 3, 3);
                g.fillRect(6, height - 1, 3, 3);
                g.fillRect(2, height - 1, 3, 3);
                g.fillRect(6, height - 5, 3, 3);
                g.fillRect(2, height - 5, 3, 3);
                g.fillRect(2, height - 9, 3, 3);
                g.setColor(c2);
                g.fillRect(10, height - 1, 2, 2);
                g.fillRect(6, height - 1, 2, 2);
                g.fillRect(2, height - 1, 2, 2);
                g.fillRect(6, height - 5, 2, 2);
                g.fillRect(2, height - 5, 2, 2);
                g.fillRect(2, height - 9, 2, 2);
            }
        }
    }

    public void setStyle(int style) {
        this.style = style;
    }
}

