/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.z.IntSet;

public class CombinedNodeTest
extends NodeTest {
    private NodeTest nodetest1;
    private NodeTest nodetest2;
    private int operator;

    public CombinedNodeTest(NodeTest nt1, int operator, NodeTest nt2) {
        this.nodetest1 = nt1;
        this.operator = operator;
        this.nodetest2 = nt2;
    }

    public boolean matches(int nodeKind, NodeName name, int annotation) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(nodeKind, name, annotation) || this.nodetest2.matches(nodeKind, name, annotation);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(nodeKind, name, annotation) || this.nodetest2 != null && !this.nodetest2.matches(nodeKind, name, annotation));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(nodeKind, name, annotation)) && this.nodetest2 != null && !this.nodetest2.matches(nodeKind, name, annotation);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(tree, nodeNr) || this.nodetest2.matches(tree, nodeNr);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(tree, nodeNr) || this.nodetest2 != null && !this.nodetest2.matches(tree, nodeNr));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(tree, nodeNr)) && this.nodetest2 != null && !this.nodetest2.matches(tree, nodeNr);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public boolean matches(NodeInfo node) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(node) || this.nodetest2.matches(node);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(node) || this.nodetest2 != null && !this.nodetest2.matches(node));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(node)) && this.nodetest2 != null && !this.nodetest2.matches(node);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public String toString() {
        if (this.nodetest1 instanceof NameTest && this.operator == 23) {
            int kind = this.nodetest1.getPrimitiveType();
            String skind = kind == 1 ? "element(" : "attribute(";
            String content = "";
            if (this.nodetest2 instanceof ContentTypeTest) {
                SchemaType schemaType = ((ContentTypeTest)this.nodetest2).getSchemaType();
                content = ", " + schemaType.getDisplayName();
            }
            String name = this.nodetest1 instanceof NameTest ? ((NameTest)this.nodetest1).getNodeName().getDisplayName() : this.nodetest1.toString();
            return skind + name + content + ')';
        }
        String nt1 = this.nodetest1 == null ? "true()" : this.nodetest1.toString();
        String nt2 = this.nodetest2 == null ? "true()" : this.nodetest2.toString();
        return '(' + nt1 + ' ' + Token.tokens[this.operator] + ' ' + nt2 + ')';
    }

    public ItemType getSuperType(TypeHierarchy th) {
        switch (this.operator) {
            case 1: {
                return Type.getCommonSuperType(this.nodetest1, this.nodetest2, th);
            }
            case 23: {
                return this.nodetest1;
            }
            case 24: {
                return this.nodetest1;
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public int getNodeKindMask() {
        switch (this.operator) {
            case 1: {
                return this.nodetest1.getNodeKindMask() | this.nodetest2.getNodeKindMask();
            }
            case 23: {
                return this.nodetest1.getNodeKindMask() & this.nodetest2.getNodeKindMask();
            }
            case 24: {
                return this.nodetest1.getNodeKindMask();
            }
        }
        return 0;
    }

    public int getPrimitiveType() {
        int mask = this.getNodeKindMask();
        if (mask == 2) {
            return 1;
        }
        if (mask == 4) {
            return 2;
        }
        if (mask == 512) {
            return 9;
        }
        return 0;
    }

    public IntSet getRequiredNodeNames() {
        IntSet s1 = this.nodetest1.getRequiredNodeNames();
        IntSet s2 = this.nodetest2.getRequiredNodeNames();
        switch (this.operator) {
            case 1: {
                return s1.union(s2);
            }
            case 23: {
                return s1.intersect(s2);
            }
            case 24: {
                return s1.except(s2);
            }
        }
        throw new IllegalStateException();
    }

    public SchemaType getContentType() {
        SchemaType type2;
        SchemaType type1 = this.nodetest1.getContentType();
        if (type1.isSameType(type2 = this.nodetest2.getContentType())) {
            return type1;
        }
        if (this.operator == 23) {
            if (type2 instanceof AnyType) {
                return type1;
            }
            if (type1 instanceof AnyType) {
                return type2;
            }
        }
        return AnyType.getInstance();
    }

    public AtomicType getAtomizedItemType() {
        AtomicType type2;
        AtomicType type1 = this.nodetest1.getAtomizedItemType();
        if (type1.isSameType(type2 = this.nodetest2.getAtomizedItemType())) {
            return type1;
        }
        if (this.operator == 23) {
            if (type2.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                return type1;
            }
            if (type1.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                return type2;
            }
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public boolean isAtomizable() {
        return this.nodetest1.isAtomizable() && this.nodetest2.isAtomizable();
    }

    public int getFingerprint() {
        int fp2;
        int fp1 = this.nodetest1.getFingerprint();
        if (fp1 == (fp2 = this.nodetest2.getFingerprint())) {
            return fp1;
        }
        if (fp2 == -1 && this.operator == 23) {
            return fp1;
        }
        if (fp1 == -1 && this.operator == 23) {
            return fp2;
        }
        return -1;
    }

    public boolean isNillable() {
        return this.nodetest1.isNillable() && this.nodetest2.isNillable();
    }

    public int hashCode() {
        return this.nodetest1.hashCode() ^ this.nodetest2.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof CombinedNodeTest && ((CombinedNodeTest)other).nodetest1.equals(this.nodetest1) && ((CombinedNodeTest)other).nodetest2.equals(this.nodetest2) && ((CombinedNodeTest)other).operator == this.operator;
    }

    public double getDefaultPriority() {
        if (this.operator == 1) {
            return this.nodetest1.getDefaultPriority();
        }
        return 0.25;
    }

    public NodeTest[] getComponentNodeTests() {
        return new NodeTest[]{this.nodetest1, this.nodetest2};
    }

    public int getOperator() {
        return this.operator;
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
        this.nodetest1.visitNamedSchemaComponents(visitor);
        this.nodetest2.visitNamedSchemaComponents(visitor);
    }
}

