/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;

public abstract class Line2D
implements Shape,
Cloneable {
    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setLine(double var1, double var3, double var5, double var7);

    public void setLine(Point2D p1, Point2D p2) {
        this.setLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setLine(Line2D l) {
        this.setLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    public static int relativeCCW(double x1, double y1, double x2, double y2, double px, double py) {
        if (x1 == x2 && y1 == y2 || x1 == px && y1 == py) {
            return 0;
        }
        double slope2 = (y2 -= y1) / (x2 -= x1);
        double slopep = (py -= y1) / (px -= x1);
        if (slope2 == slopep || x2 == 0.0 && px == 0.0) {
            int n;
            if (y2 > 0.0) {
                if (py < 0.0) {
                    n = -1;
                } else {
                    n = 0;
                    if (py > y2) {
                        n = 1;
                    }
                }
            } else if (py > 0.0) {
                n = -1;
            } else {
                n = 0;
                if (py < y2) {
                    n = 1;
                }
            }
            return n;
        }
        if (x2 >= 0.0 && slope2 >= 0.0) {
            return px >= 0.0 ? (slope2 > slopep ? 1 : -1) : (slope2 < slopep ? 1 : -1);
        }
        if (y2 > 0.0) {
            return px < 0.0 ? (slope2 > slopep ? 1 : -1) : (slope2 < slopep ? 1 : -1);
        }
        if (slope2 >= 0.0) {
            return px >= 0.0 ? (slope2 < slopep ? 1 : -1) : (slope2 > slopep ? 1 : -1);
        }
        return px < 0.0 ? (slope2 < slopep ? 1 : -1) : (slope2 > slopep ? 1 : -1);
    }

    public int relativeCCW(double px, double py) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public int relativeCCW(Point2D p) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    private static final double area2(double x1, double y1, double x2, double y2, double x3, double y3) {
        return (x2 - x1) * (y3 - y1) - (x3 - x1) * (y2 - y1);
    }

    private static final boolean between(double x1, double y1, double x2, double y2, double x3, double y3) {
        if (x1 != x2) {
            boolean bl = false;
            if (x1 <= x3 && x3 <= x2 || x1 >= x3 && x3 >= x2) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (y1 <= y3 && y3 <= y2 || y1 >= y3 && y3 >= y2) {
            bl = true;
        }
        return bl;
    }

    public static boolean linesIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double a1 = Line2D.area2(x1, y1, x2, y2, x3, y3);
        if (a1 == 0.0) {
            if (Line2D.between(x1, y1, x2, y2, x3, y3)) {
                return true;
            }
            if (Line2D.area2(x1, y1, x2, y2, x4, y4) == 0.0) {
                boolean bl = false;
                if (Line2D.between(x3, y3, x4, y4, x1, y1) || Line2D.between(x3, y3, x4, y4, x2, y2)) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }
        double a2 = Line2D.area2(x1, y1, x2, y2, x4, y4);
        if (a2 == 0.0) {
            return Line2D.between(x1, y1, x2, y2, x4, y4);
        }
        double a3 = Line2D.area2(x3, y3, x4, y4, x1, y1);
        if (a3 == 0.0) {
            if (Line2D.between(x3, y3, x4, y4, x1, y1)) {
                return true;
            }
            if (Line2D.area2(x3, y3, x4, y4, x2, y2) == 0.0) {
                boolean bl = false;
                if (Line2D.between(x1, y1, x2, y2, x3, y3) || Line2D.between(x1, y1, x2, y2, x4, y4)) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }
        double a4 = Line2D.area2(x3, y3, x4, y4, x2, y2);
        if (a4 == 0.0) {
            return Line2D.between(x3, y3, x4, y4, x2, y2);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (a1 > 0.0) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (a2 > 0.0) {
            bl3 = true;
        }
        if (bl2 != bl3) {
            boolean bl4 = false;
            if (a3 > 0.0) {
                bl4 = true;
            }
            boolean bl5 = false;
            if (a4 > 0.0) {
                bl5 = true;
            }
            if (bl4 != bl5) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        return Line2D.linesIntersect(this.getX1(), this.getY1(), this.getX2(), this.getY2(), x1, y1, x2, y2);
    }

    public boolean intersectsLine(Line2D l) {
        return Line2D.linesIntersect(this.getX1(), this.getY1(), this.getX2(), this.getY2(), l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    public static double ptSegDistSq(double x1, double y1, double x2, double y2, double px, double py) {
        double y;
        double x;
        double pd2 = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
        if (pd2 == 0.0) {
            x = x1;
            y = y2;
        } else {
            double u = ((px - x1) * (x2 - x1) + (py - y1) * (y2 - y1)) / pd2;
            if (u < 0.0) {
                x = x1;
                y = y1;
            } else if (u > 1.0) {
                x = x2;
                y = y2;
            } else {
                x = x1 + u * (x2 - x1);
                y = y1 + u * (y2 - y1);
            }
        }
        return (x - px) * (x - px) + (y - py) * (y - py);
    }

    public static double ptSegDist(double x1, double y1, double x2, double y2, double px, double py) {
        return Math.sqrt(Line2D.ptSegDistSq(x1, y1, x2, y2, px, py));
    }

    public double ptSegDistSq(double px, double py) {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public double ptSegDistSq(Point2D p) {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public double ptSegDist(double px, double py) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public double ptSegDist(Point2D p) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public static double ptLineDistSq(double x1, double y1, double x2, double y2, double px, double py) {
        double y;
        double x;
        double pd2 = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
        if (pd2 == 0.0) {
            x = x1;
            y = y2;
        } else {
            double u = ((px - x1) * (x2 - x1) + (py - y1) * (y2 - y1)) / pd2;
            x = x1 + u * (x2 - x1);
            y = y1 + u * (y2 - y1);
        }
        return (x - px) * (x - px) + (y - py) * (y - py);
    }

    public static double ptLineDist(double x1, double y1, double x2, double y2, double px, double py) {
        return Math.sqrt(Line2D.ptLineDistSq(x1, y1, x2, y2, px, py));
    }

    public double ptLineDistSq(double px, double py) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public double ptLineDistSq(Point2D p) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public double ptLineDist(double px, double py) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public double ptLineDist(Point2D p) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public boolean contains(double x, double y) {
        return false;
    }

    public boolean contains(Point2D p) {
        return false;
    }

    public boolean intersects(double x, double y, double w, double h) {
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x1 = this.getX1();
        double y1 = this.getY1();
        double x2 = this.getX2();
        double y2 = this.getY2();
        if (x1 >= x && x1 <= x + w && y1 >= y && y1 <= y + h) {
            return true;
        }
        if (x2 >= x && x2 <= x + w && y2 >= y && y2 <= y + h) {
            return true;
        }
        double x3 = x + w;
        double y3 = y + h;
        boolean bl = false;
        if (Line2D.linesIntersect(x1, y1, x2, y2, x, y, x, y3) || Line2D.linesIntersect(x1, y1, x2, y2, x, y3, x3, y3) || Line2D.linesIntersect(x1, y1, x2, y2, x3, y3, x3, y) || Line2D.linesIntersect(x1, y1, x2, y2, x3, y, x, y)) {
            bl = true;
        }
        return bl;
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public boolean contains(Rectangle2D r) {
        return false;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(final AffineTransform at) {
        return new PathIterator(){
            private int current;

            public final int getWindingRule() {
                return 1;
            }

            public final boolean isDone() {
                boolean bl = false;
                if (this.current >= 2) {
                    bl = true;
                }
                return bl;
            }

            public final void next() {
                ++this.current;
            }

            public final int currentSegment(float[] coords) {
                int result;
                switch (this.current) {
                    case 0: {
                        coords[0] = (float)Line2D.this.getX1();
                        coords[1] = (float)Line2D.this.getY1();
                        result = 0;
                        break;
                    }
                    case 1: {
                        coords[0] = (float)Line2D.this.getX2();
                        coords[1] = (float)Line2D.this.getY2();
                        result = 1;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException("line iterator out of bounds");
                    }
                }
                if (at != null) {
                    at.transform(coords, 0, coords, 0, 1);
                }
                return result;
            }

            public final int currentSegment(double[] coords) {
                int result;
                switch (this.current) {
                    case 0: {
                        coords[0] = Line2D.this.getX1();
                        coords[1] = Line2D.this.getY1();
                        result = 0;
                        break;
                    }
                    case 1: {
                        coords[0] = Line2D.this.getX2();
                        coords[1] = Line2D.this.getY2();
                        result = 1;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException("line iterator out of bounds");
                    }
                }
                if (at != null) {
                    at.transform(coords, 0, coords, 0, 1);
                }
                return result;
            }

            private final /* synthetic */ void this() {
                this.current = 0;
            }
            {
                this.this();
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }

    protected Line2D() {
    }

    public static class Float
    extends Line2D {
        public float x1;
        public float y1;
        public float x2;
        public float y2;

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }

        public void setLine(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            float x = Math.min(this.x1, this.x2);
            float y = Math.min(this.y1, this.y2);
            float w = Math.abs(this.x1 - this.x2);
            float h = Math.abs(this.y1 - this.y2);
            return new Rectangle2D.Float(x, y, w, h);
        }

        public Float() {
        }

        public Float(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Float(Point2D p1, Point2D p2) {
            this.x1 = (float)p1.getX();
            this.y1 = (float)p1.getY();
            this.x2 = (float)p2.getX();
            this.y2 = (float)p2.getY();
        }
    }

    public static class Double
    extends Line2D {
        public double x1;
        public double y1;
        public double x2;
        public double y2;

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            double x = Math.min(this.x1, this.x2);
            double y = Math.min(this.y1, this.y2);
            double w = Math.abs(this.x1 - this.x2);
            double h = Math.abs(this.y1 - this.y2);
            return new Rectangle2D.Double(x, y, w, h);
        }

        public Double() {
        }

        public Double(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Double(Point2D p1, Point2D p2) {
            this.x1 = p1.getX();
            this.y1 = p1.getY();
            this.x2 = p2.getX();
            this.y2 = p2.getY();
        }
    }
}

