var matcher = require('../../../helpers/package-version-range-matcher/semver-range-matcher');
var assert = require('assert');

describe('Version range matcher', function () {
  it('should match', function () {
    expect(true, undefined, undefined, '^1.0.0', '1.0.0');
    expect(true, undefined, undefined, '^1.0.0', '1.0.1');
    expect(true, undefined, undefined, '^1.0.0', '1.1.1');
    expect(false, undefined, undefined, '^1.0.0', '2.1.1');
    expect(false, undefined, undefined, '>=2.5.10 <= 3.0.1', '2.1.1');
    expect(false, undefined, undefined, '>=2.5.10 <= 3.0.1', '3.0.2');
    expect(true, undefined, undefined, '>=2.5.10 <= 3.0.1', '2.6.0');
    expect(true, undefined, undefined, '', '2.6.0');
    expect(true, undefined, undefined, '*', '2.6.0');
    expect(true, undefined, undefined, '3.3.x', '3.3.80');
    expect(true, undefined, undefined, '2.x', '2.36.0');
    expect(true, undefined, undefined, '1.0.0 - 2.9999.9999', '2.36.10');
    expect(true, undefined, undefined, '~1.2.3', '1.2.4');
    expect(false, undefined, undefined, '~1.2.3', '1.3.4');
  });

  it('should report invalid version', function () {
    expect(undefined, true, undefined, '^1.0.0', '294r8af092b');
    expect(undefined, true, undefined, '^1.0.0', 'test');
    expect(undefined, true, undefined, '^1.0.0', '');
    expect(undefined, true, undefined, '^1.0.0', '1.0');
    expect(undefined, true, undefined, '^1.0.0', '1.0.a');
  });

  it('should report invalid version range', function () {
    expect(undefined, undefined, true, 'http://asdf.com/asdf.tar.gz', '1.0.0');
    expect(undefined, undefined, true, 'latest', '1.0.0');
    expect(undefined, undefined, true, 'file:../dyl', '1.0.0');
    expect(undefined, undefined, true, 'git://github.com/markdalgleish/gh-pages#cli-message', '1.0.0');
    expect(undefined, undefined, true, 'mochajs/mocha#4727d357ea', '1.0.0');
  });
});

function expect(expectedMatched, expectedInvalidVersion, expectedInvalidVersionRange, range, version) {
  var result = matcher.match([{
    packageName:'qqq',
    versionRange: range,
    version: version
  }]);
  assert.equal(result.length, 1);
  var response = result[0];
  assert.equal(response.packageName, 'qqq');
  assert.equal(response.versionRange, range);
  assert.equal(response.version, version);
  assert.equal(response.matched, expectedMatched);
  assert.equal(response.invalidVersionRange, expectedInvalidVersionRange);
  assert.equal(response.invalidVersion, expectedInvalidVersion);
}