/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeImpl
extends ExternalizableSchemeAdapter
implements CodeStyleScheme,
SerializableScheme {
    private static final Logger LOG = Logger.getInstance(CodeStyleSchemeImpl.class);
    private SchemeDataHolder<? super CodeStyleSchemeImpl> myDataHolder;
    private String myParentSchemeName;
    private final boolean myIsDefault;
    private volatile CodeStyleSettings myCodeStyleSettings;
    private final Object lock;

    CodeStyleSchemeImpl(@NotNull String name, String parentSchemeName, @NotNull SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder) {
        if (name == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(0);
        }
        if (dataHolder == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(1);
        }
        this.lock = new Object();
        this.setName(name);
        this.myDataHolder = dataHolder;
        this.myIsDefault = "Default".equals(name);
        this.myParentSchemeName = parentSchemeName;
    }

    public CodeStyleSchemeImpl(@NotNull String name, boolean isDefault, CodeStyleScheme parentScheme) {
        if (name == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(2);
        }
        this.lock = new Object();
        this.setName(name);
        this.myIsDefault = isDefault;
        this.init(parentScheme, null);
    }

    @NotNull
    private CodeStyleSettings init(@Nullable CodeStyleScheme parentScheme, @Nullable Element root) {
        CodeStyleSettings settings;
        if (parentScheme == null) {
            settings = new CodeStyleSettings();
        } else {
            CodeStyleSettings parentSettings = parentScheme.getCodeStyleSettings();
            settings = parentSettings.clone();
            while (parentSettings.getParentSettings() != null) {
                parentSettings = parentSettings.getParentSettings();
            }
            settings.setParentSettings(parentSettings);
        }
        if (root != null) {
            try {
                settings.readExternal(root);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myCodeStyleSettings = settings;
        CodeStyleSettings codeStyleSettings = settings;
        if (codeStyleSettings == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(3);
        }
        return codeStyleSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public CodeStyleSettings getCodeStyleSettings() {
        CodeStyleSettings settings = this.myCodeStyleSettings;
        if (settings != null) {
            CodeStyleSettings codeStyleSettings = settings;
            if (codeStyleSettings == null) {
                CodeStyleSchemeImpl.$$$reportNull$$$0(4);
            }
            return codeStyleSettings;
        }
        Object object = this.lock;
        synchronized (object) {
            SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder = this.myDataHolder;
            if (dataHolder == null) {
                CodeStyleSettings codeStyleSettings = this.myCodeStyleSettings;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                if (codeStyleSettings == null) {
                    CodeStyleSchemeImpl.$$$reportNull$$$0(5);
                }
                return codeStyleSettings;
            }
            this.myDataHolder = null;
            settings = this.init(this.myParentSchemeName == null ? null : CodeStyleSchemesImpl.getSchemeManager().findSchemeByName(this.myParentSchemeName), dataHolder.read());
            dataHolder.updateDigest(this);
            this.myParentSchemeName = null;
        }
        CodeStyleSettings codeStyleSettings = settings;
        if (codeStyleSettings == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(6);
        }
        return codeStyleSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodeStyleSettings(@NotNull CodeStyleSettings codeStyleSettings) {
        if (codeStyleSettings == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(7);
        }
        this.myCodeStyleSettings = codeStyleSettings;
        Object object = this.lock;
        synchronized (object) {
            this.myParentSchemeName = null;
            this.myDataHolder = null;
        }
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SchemeState getSchemeState() {
        Object object = this.lock;
        synchronized (object) {
            return this.myDataHolder == null ? SchemeState.POSSIBLY_CHANGED : SchemeState.UNCHANGED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Element writeScheme() {
        SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder;
        Object object = this.lock;
        synchronized (object) {
            dataHolder = this.myDataHolder;
        }
        if (dataHolder == null) {
            Element newElement = new Element("code_scheme");
            newElement.setAttribute("name", this.getName());
            this.myCodeStyleSettings.writeExternal(newElement);
            Element element = newElement;
            if (element == null) {
                CodeStyleSchemeImpl.$$$reportNull$$$0(8);
            }
            return element;
        }
        Element element = dataHolder.read();
        if (element == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(9);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeStyleSettings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "writeScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCodeStyleSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

