/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.SelectedCommittedStuffChecker;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesActionPerformer;

public abstract class AbstractIntegrateChangesAction<T extends SelectedCommittedStuffChecker>
extends AnAction
implements DumbAware {
    private final boolean myCheckUseCase;

    protected AbstractIntegrateChangesAction(boolean checkUseCase) {
        this.myCheckUseCase = checkUseCase;
    }

    @NotNull
    protected abstract MergerFactory createMergerFactory(T var1);

    @NotNull
    protected abstract T createChecker();

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractIntegrateChangesAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        CommittedChangesBrowserUseCase useCase = (CommittedChangesBrowserUseCase)CommittedChangesBrowserUseCase.DATA_KEY.getData(e.getDataContext());
        Presentation presentation = e.getPresentation();
        if (project == null || this.myCheckUseCase && (useCase == null || !CommittedChangesBrowserUseCase.COMMITTED.equals((Object)useCase))) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        presentation.setText(SvnBundle.message("action.Subversion.integrate.changes.actionname", new Object[0]));
        presentation.setDescription(SvnBundle.message("action.Subversion.integrate.changes.description", new Object[0]));
        T checker = this.createChecker();
        checker.execute(e);
        presentation.setVisible(true);
        presentation.setEnabled(checker.isValid());
        if (presentation.isVisible() && presentation.isEnabled() && ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning()) {
            presentation.setEnabled(false);
        }
        this.updateWithChecker(e, (SelectedCommittedStuffChecker)checker);
    }

    protected void updateWithChecker(AnActionEvent e, SelectedCommittedStuffChecker checker) {
    }

    @Nullable
    protected abstract Url getSelectedBranchUrl(SelectedCommittedStuffChecker var1);

    @Nullable
    protected abstract String getSelectedBranchLocalPath(SelectedCommittedStuffChecker var1);

    @Nullable
    protected abstract String getDialogTitle();

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractIntegrateChangesAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        T checker = this.createChecker();
        checker.execute(e);
        if (!checker.isValid()) {
            Messages.showErrorDialog((String)SvnBundle.message("action.Subversion.integrate.changes.error.no.available.files.text", new Object[0]), (String)SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]));
            return;
        }
        SvnIntegrateChangesActionPerformer changesActionPerformer = new SvnIntegrateChangesActionPerformer(project, checker.getSameBranch(), this.createMergerFactory(checker));
        Url selectedBranchUrl = this.getSelectedBranchUrl((SelectedCommittedStuffChecker)checker);
        if (selectedBranchUrl == null) {
            SelectBranchPopup.showForBranchRoot(project, checker.getRoot(), changesActionPerformer, SvnBundle.message("action.Subversion.integrate.changes.select.branch.text", new Object[0]));
        } else {
            changesActionPerformer.onBranchSelected(selectedBranchUrl, this.getSelectedBranchLocalPath((SelectedCommittedStuffChecker)checker), this.getDialogTitle());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/idea/svn/actions/AbstractIntegrateChangesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

