/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.SqlDialects;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.Change;
import com.intellij.sql.formatter.SqlFormattingModelBuilder;
import com.intellij.sql.formatter.SqlPreFormatHelper;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreFormatProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range) {
        PsiElement psiElement;
        PsiFile file;
        if (node == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = file = (psiElement = node.getPsi()) == null || !psiElement.isValid() ? null : psiElement.getContainingFile();
        if (!(file instanceof SqlFile)) {
            TextRange textRange = range;
            if (textRange == null) {
                SqlPreFormatProcessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        if (SqlPreFormatProcessor.fileIsFrankensteinInjection(file)) {
            TextRange textRange = range;
            if (textRange == null) {
                SqlPreFormatProcessor.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        if (file.getTextLength() < 1024 && SqlImplUtil.sqlTraverser((PsiElement)file).filter(SqlStatement.class).isEmpty()) {
            TextRange textRange = range;
            if (textRange == null) {
                SqlPreFormatProcessor.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        CodeStyleSettings css = SqlFormattingModelBuilder.findAppropriateCodeStyleSettings((PsiElement)file);
        if (css == null) {
            css = CodeStyle.getSettings((PsiFile)file);
        }
        if (language == SqlDialects.getGenericDialect() || ((SqlCodeStyleSettings)css.getCustomSettings(SqlCodeStyleSettings.class)).DISABLE_FORMATTING) {
            TextRange textRange = range;
            if (textRange == null) {
                SqlPreFormatProcessor.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        MyFormatter formatter = new MyFormatter(psiElement, language);
        TextRange textRange = formatter.process(range);
        if (textRange == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    private static boolean fileIsFrankensteinInjection(PsiFile file) {
        Boolean frankenstein = (Boolean)file.getUserData(InjectedLanguageManager.FRANKENSTEIN_INJECTION);
        return frankenstein != null && frankenstein != false;
    }

    @Nullable
    private static PsiElement[] findSubSequence(@Nullable PsiElement begin, Predicate<PsiElement> ... predicates) {
        if (predicates == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(7);
        }
        int n = predicates.length;
        PsiElement[] found = new PsiElement[n];
        PsiElement p2 = SqlPreFormatProcessor.skipSpaces(begin);
        while (p2 != null) {
            boolean ok;
            PsiElement q = p2;
            for (int i2 = 0; i2 < n && (ok = predicates[i2].test(q)); ++i2) {
                found[i2] = q;
                if (i2 == n - 1) {
                    return found;
                }
                if ((q = SqlPreFormatProcessor.skipSpaces(q.getNextSibling())) == null) break;
            }
            p2 = SqlPreFormatProcessor.skipSpaces(p2.getNextSibling());
        }
        return null;
    }

    @Nullable
    private static PsiElement skipSpaces(@Nullable PsiElement element2) {
        PsiElement e = element2;
        while (e instanceof PsiWhiteSpace) {
            e = e.getNextSibling();
        }
        return e;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/SqlPreFormatProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/SqlPreFormatProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSubSequence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFormatter {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final PsiElement myElement;
        @NotNull
        protected final PsiDocumentManager myDocumentManager;
        @NotNull
        protected final SqlLanguageDialectEx myLanguage;
        @NotNull
        private final DatabaseDialectEx myDialect;
        @Nullable
        protected final Document myDocument;
        protected final SqlCodeStyleSettings mySqlCodeStyleSettings;

        MyFormatter(@NotNull PsiElement element2, @NotNull SqlLanguageDialectEx language) {
            if (element2 == null) {
                MyFormatter.$$$reportNull$$$0(0);
            }
            if (language == null) {
                MyFormatter.$$$reportNull$$$0(1);
            }
            this.myLanguage = language;
            this.myDialect = language.getDatabaseDialect();
            this.myProject = element2.getProject();
            this.myElement = element2;
            CodeStyleSettings css = SqlFormattingModelBuilder.findAppropriateCodeStyleSettings(element2);
            if (css == null) {
                css = CodeStyle.getSettings((PsiFile)element2.getContainingFile());
            }
            this.mySqlCodeStyleSettings = (SqlCodeStyleSettings)css.getCustomSettings(SqlCodeStyleSettings.class);
            this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            PsiFile file = element2.getContainingFile();
            Document hardRef = (Document)file.getUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY);
            this.myDocument = hardRef != null ? hardRef : (ApplicationManager.getApplication().isReadAccessAllowed() ? file.getViewProvider().getDocument() : null);
        }

        @NotNull
        private TextRange process(final @NotNull TextRange range) {
            if (range == null) {
                MyFormatter.$$$reportNull$$$0(2);
            }
            if (this.myDocument == null || this.mySqlCodeStyleSettings == null) {
                TextRange textRange = range;
                if (textRange == null) {
                    MyFormatter.$$$reportNull$$$0(3);
                }
                return textRange;
            }
            if (PostprocessReformattingAspect.getInstance((Project)this.myProject).isDisabled()) {
                TextRange textRange = range;
                if (textRange == null) {
                    MyFormatter.$$$reportNull$$$0(4);
                }
                return textRange;
            }
            final ArrayList keywords = ContainerUtil.newArrayList();
            final ArrayList types = ContainerUtil.newArrayList();
            final ArrayList identifiers = ContainerUtil.newArrayList();
            final ArrayList selects = ContainerUtil.newArrayList();
            ArrayList<Change> changes = new ArrayList<Change>();
            final List readOnlyFragments = this.myDocument instanceof DocumentWindow ? InjectedLanguageManager.getInstance((Project)this.myProject).getNonEditableFragments((DocumentWindow)this.myDocument) : ContainerUtil.emptyList();
            this.myElement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.process(element2);
                    if (element2 instanceof IsExternal) {
                        this.process(element2.getFirstChild());
                        return;
                    }
                    super.visitElement(element2);
                }

                public void process(@Nullable PsiElement element2) {
                    TextRange nodeRange;
                    if (element2 == null) {
                        return;
                    }
                    IElementType elementType = PsiUtilCore.getElementType((PsiElement)element2);
                    if (elementType == SqlCompositeElementTypes.SQL_SELECT_CLAUSE) {
                        selects.add(element2);
                    }
                    if (range.intersects(nodeRange = element2.getNode().getTextRange()) && !this.intersect(readOnlyFragments, nodeRange)) {
                        boolean parameter;
                        boolean isKeyword = element2.getNode().getElementType() instanceof SqlKeywordTokenType;
                        PsiElement parent2 = element2.getParent();
                        boolean isRemapped = parent2 instanceof SqlIdentifier;
                        ASTNode parentNode = parent2 != null ? parent2.getNode() : null;
                        IElementType parentType = parentNode != null ? parentNode.getElementType() : null;
                        PsiElement grandpa = parent2 instanceof SqlReferenceExpression ? parent2.getParent() : null;
                        ASTNode grandpaNode = grandpa == null ? null : grandpa.getNode();
                        IElementType grandpaType = grandpaNode != null ? grandpaNode.getElementType() : null;
                        boolean insideSpecialLiteral = parentType == SqlCompositeElementTypes.SQL_SPECIAL_LITERAL && !"null".equalsIgnoreCase(element2.getText());
                        boolean functionName = parentType == SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE || parentType == SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE || grandpaType == SqlCompositeElementTypes.SQL_FUNCTION_CALL;
                        boolean bl = parameter = parentType == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
                        if (isKeyword && !isRemapped && !insideSpecialLiteral) {
                            if (element2.getParent() instanceof SqlTypeElement) {
                                types.add(nodeRange);
                            } else {
                                keywords.add(nodeRange);
                            }
                        } else {
                            boolean identifier = element2 instanceof SqlIdentifier;
                            boolean asterisk = "*".equals(element2.getText());
                            if (!(!identifier || functionName || parameter || range.getLength() <= 1 && asterisk)) {
                                if (parentType == SqlCompositeElementTypes.SQL_TYPE_REFERENCE) {
                                    types.add(nodeRange);
                                } else {
                                    identifiers.add((SqlIdentifier)element2);
                                }
                            }
                        }
                    }
                }

                private boolean intersect(@NotNull List<TextRange> trs, @NotNull TextRange r) {
                    if (trs == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (r == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    for (TextRange tr : trs) {
                        if (!tr.intersects(r)) continue;
                        return true;
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "trs";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "r";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitElement";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "intersect";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            int start = range.getStartOffset();
            int end = range.getEndOffset();
            if (!keywords.isEmpty()) {
                start = Math.min(start, ((TextRange)keywords.get(0)).getStartOffset());
                end = Math.max(end, ((TextRange)keywords.get(keywords.size() - 1)).getEndOffset());
            }
            if (!identifiers.isEmpty()) {
                start = Math.min(start, ((SqlIdentifier)identifiers.get(0)).getTextRange().getStartOffset());
                end = Math.max(end, ((SqlIdentifier)identifiers.get(identifiers.size() - 1)).getTextRange().getEndOffset());
            }
            TextRange fixedRange = new TextRange(start, end);
            CharSequence charSequence = this.myDocument.getCharsSequence();
            this.processSelects(selects, changes);
            this.processIdentifiers(identifiers, changes);
            this.processKeywords(keywords, charSequence, changes);
            this.processTypes(types, charSequence, changes);
            DocumentUtil.executeInBulk((Document)this.myDocument, (boolean)true, () -> {
                PairProcessor processor = (r, replacement) -> {
                    String text2 = this.myDocument.getText(r);
                    if (text2.equals(replacement)) {
                        return true;
                    }
                    if (this.myDocument.getRangeGuard(r.getStartOffset(), r.getEndOffset()) != null) {
                        return true;
                    }
                    this.myDocument.replaceString(r.getStartOffset(), r.getEndOffset(), (CharSequence)replacement);
                    return true;
                };
                SqlPreFormatHelper.applyChangesInReversedOrder(changes, (PairProcessor<TextRange, String>)processor);
            });
            if (this.myDocumentManager.isUncommited(this.myDocument)) {
                this.myDocumentManager.commitDocument(this.myDocument);
            }
            int delta = 0;
            for (Change change : changes) {
                delta += change.delta();
            }
            TextRange textRange = fixedRange.grown(delta);
            if (textRange == null) {
                MyFormatter.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        private void processSelects(@NotNull List<PsiElement> selects, @NotNull Collection<Change> changes) {
            String AS;
            if (selects == null) {
                MyFormatter.$$$reportNull$$$0(6);
            }
            if (changes == null) {
                MyFormatter.$$$reportNull$$$0(7);
            }
            boolean comma1st = this.mySqlCodeStyleSettings.SELECT_EL_COMMA == 1;
            boolean commaLast = this.mySqlCodeStyleSettings.SELECT_EL_COMMA == 2;
            boolean processCommas = comma1st || commaLast;
            int useAsWord = this.mySqlCodeStyleSettings.SELECT_USE_AS_WORD;
            switch (this.mySqlCodeStyleSettings.KEYWORD_CASE) {
                case 0: {
                    AS = "AS";
                    break;
                }
                case 1: {
                    AS = "as";
                    break;
                }
                default: {
                    AS = null;
                }
            }
            for (PsiElement select : selects) {
                PsiElement[] s;
                if (useAsWord > 0) {
                    for (PsiElement e = select.getFirstChild(); e != null; e = e.getNextSibling()) {
                        if (PsiUtilCore.getElementType((PsiElement)e) != SqlCompositeElementTypes.SQL_AS_EXPRESSION) continue;
                        if (useAsWord == 1) {
                            String word;
                            s = SqlPreFormatProcessor.findSubSequence(e.getFirstChild(), new Predicate[]{x -> x instanceof SqlExpression, y -> PsiUtilCore.getElementType((PsiElement)y) == SqlCompositeElementTypes.SQL_IDENTIFIER});
                            if (s == null) continue;
                            String string = AS != null ? AS : (word = MyFormatter.whetherKeywordsUpper(select) ? "AS" : "as");
                            assert (s.length == 2);
                            changes.add(Change.insert(s[1].getTextRange().getStartOffset(), word + ' '));
                            continue;
                        }
                        if (useAsWord != 2 || (s = SqlPreFormatProcessor.findSubSequence(e.getFirstChild(), new Predicate[]{x -> x instanceof SqlExpression, z -> PsiUtilCore.getElementType((PsiElement)z) == SqlCommonKeywords.SQL_AS, y -> PsiUtilCore.getElementType((PsiElement)y) == SqlCompositeElementTypes.SQL_IDENTIFIER})) == null) continue;
                        assert (s.length == 3);
                        TextRange r = s[1].getTextRange();
                        changes.add(Change.delete(r.getStartOffset(), r.getEndOffset()));
                    }
                }
                if (!processCommas) continue;
                PsiElement begin = select.getFirstChild();
                if (comma1st) {
                    while (begin != null && (s = SqlPreFormatProcessor.findSubSequence(begin, new Predicate[]{element2 -> element2 instanceof SqlExpression, element2 -> PsiUtilCore.getElementType((PsiElement)element2) == SqlTokens.SQL_COMMA, element2 -> PsiUtilCore.getElementType((PsiElement)element2) == SqlTokens.SQL_LINE_COMMENT, element2 -> element2 instanceof SqlExpression})) != null) {
                        assert (s.length == 4);
                        changes.add(Change.delete(s[1].getTextRange()));
                        changes.add(Change.insertAfter(s[2].getTextRange(), "\n,"));
                        begin = s[3];
                    }
                }
                if (!commaLast) continue;
                while (begin != null && (s = SqlPreFormatProcessor.findSubSequence(begin, new Predicate[]{element2 -> element2 instanceof SqlExpression, element2 -> PsiUtilCore.getElementType((PsiElement)element2) == SqlTokens.SQL_LINE_COMMENT, element2 -> PsiUtilCore.getElementType((PsiElement)element2) == SqlTokens.SQL_COMMA, element2 -> element2 instanceof SqlExpression})) != null) {
                    assert (s.length == 4);
                    changes.add(Change.insertBefore(s[1].getTextRange(), ", "));
                    changes.add(Change.delete(s[2].getTextRange()));
                    begin = s[3];
                }
            }
        }

        private static boolean whetherKeywordsUpper(PsiElement select) {
            PsiElement e;
            PsiElement kw = select;
            while ((e = kw.getFirstChild()) != null) {
                kw = e;
            }
            String text2 = kw.getText();
            if (text2 == null || text2.length() < 2) {
                return false;
            }
            return Character.isUpperCase(text2.charAt(1));
        }

        private void processKeywords(List<TextRange> keywords, CharSequence charSequence, Collection<Change> changes) {
            MyFormatter.processRanges(keywords, charSequence, changes, SqlCodeStyleSettings.getCaseMode((int)this.mySqlCodeStyleSettings.KEYWORD_CASE));
        }

        private void processTypes(List<TextRange> types, CharSequence charSequence, Collection<Change> changes) {
            Case casing = this.isExactCasedDialect() ? Case.EXACT : this.mySqlCodeStyleSettings.getCaseModeExt(this.mySqlCodeStyleSettings.TYPE_CASE);
            MyFormatter.processRanges(types, charSequence, changes, casing);
        }

        private static void processRanges(List<TextRange> ranges, CharSequence charSequence, Collection<Change> changes, Case mode) {
            if (mode == Case.MIXED) {
                return;
            }
            for (TextRange range : ranges) {
                String text2 = charSequence.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
                String newText = mode.apply(text2);
                changes.add(Change.replace(range, newText));
            }
        }

        private void processIdentifiers(List<SqlIdentifier> identifiers, Collection<Change> changes) {
            Case quotedMode = SqlCodeStyleSettings.getCaseMode((int)this.mySqlCodeStyleSettings.QUOTED_IDENTIFIER_CASE);
            Case plainMode = SqlCodeStyleSettings.getCaseMode((int)this.mySqlCodeStyleSettings.IDENTIFIER_CASE);
            if (this.isExactCasedDialect()) {
                plainMode = Case.EXACT;
            }
            if (quotedMode == Case.MIXED && plainMode == Case.MIXED && this.mySqlCodeStyleSettings.QUOTE_IDENTIFIER == 2) {
                return;
            }
            for (SqlIdentifier identifier : identifiers) {
                String newText;
                boolean isQuoted = !identifier.isPlainIdentifier();
                String identifierName = identifier.getName();
                String prefix = identifier.getNamePrefix();
                String text2 = identifier.getText();
                if (this.mySqlCodeStyleSettings.QUOTE_IDENTIFIER == 0 && !isQuoted) {
                    newText = this.myDialect.quoteIdentifier(identifierName, true, false);
                    newText = quotedMode.apply(newText);
                } else if (this.mySqlCodeStyleSettings.QUOTE_IDENTIFIER == 1 && isQuoted) {
                    boolean canUnquote;
                    if (SqlImplUtil.getElementType(identifier.getParent()) == SqlCompositeElementTypes.SQL_AS_EXPRESSION) {
                        boolean afterAS;
                        LeafPsiElement followedToken = (LeafPsiElement)SqlImplUtil.getSiblingToTheLeftOfType((PsiElement)identifier, true, LeafPsiElement.class);
                        switch (this.mySqlCodeStyleSettings.SELECT_USE_AS_WORD) {
                            case 1: {
                                afterAS = true;
                                break;
                            }
                            case 2: {
                                afterAS = false;
                                break;
                            }
                            default: {
                                afterAS = followedToken != null && SqlImplUtil.getElementType((PsiElement)followedToken) == SqlCommonKeywords.SQL_AS;
                            }
                        }
                        canUnquote = this.myDialect.canUnquoteAlias(identifierName, afterAS);
                    } else {
                        canUnquote = SqlImplUtil.canUnquote(identifierName, this.myDialect);
                    }
                    newText = canUnquote ? plainMode.apply(identifierName) : quotedMode.apply(text2);
                } else {
                    newText = (isQuoted ? quotedMode : plainMode).apply(prefix == null ? text2 : text2.replaceFirst(prefix, ""));
                }
                if (newText == null) continue;
                if (prefix != null) {
                    newText = prefix + newText;
                }
                TextRange range = identifier.getTextRange();
                Change change = Change.replace(range.getStartOffset(), range.getEndOffset(), newText);
                changes.add(change);
            }
        }

        private boolean isExactCasedDialect() {
            Casing casing = this.myDialect.getCasing(ObjectKind.NONE, null);
            return casing.plain == Case.EXACT;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selects";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processSelects";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

