/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DbTreeStructureProvider
implements TreeStructureProvider {
    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent2, @NotNull Collection<AbstractTreeNode> children2, ViewSettings settings) {
        if (parent2 == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children2 == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(1);
        }
        Collection<AbstractTreeNode> collection = children2;
        if (collection == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Nullable
    public Object getData(@NotNull Collection<AbstractTreeNode> selected, @NotNull String dataId) {
        if (selected == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(3);
        }
        if (dataId == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(4);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List result2 = JBIterable.from(selected).filter(PsiFileNode.class).filterMap(AbstractTreeNode::getValue).filterMap(it -> {
                final Project project = it.getProject();
                final VirtualFile vFile = it.getVirtualFile();
                final FileType fileType = vFile.getFileType();
                if (!(fileType instanceof DbStorageFileType)) {
                    return null;
                }
                return new NavigatableWithText(){

                    public String getNavigateActionText(boolean focusEditor) {
                        return "Open " + ((DbStorageFileType)fileType).getDbms().getDisplayName() + " database";
                    }

                    public void navigate(boolean requestFocus) {
                        DbTreeStructureProvider.navigateToDataSource(project, vFile);
                    }

                    public boolean canNavigate() {
                        return true;
                    }

                    public boolean canNavigateToSource() {
                        return true;
                    }
                };
            }).toList();
            return result2.isEmpty() ? null : result2.toArray(new Navigatable[0]);
        }
        return null;
    }

    private static void navigateToDataSource(@NotNull Project project, @NotNull VirtualFile file) {
        ArrayList toSelect;
        Promise<?> promise;
        DbDataSource existing;
        if (project == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(6);
        }
        if ((existing = DbImplUtil.findDataSourceByFile(project, file)) != null) {
            promise = Promises.resolvedPromise();
            toSelect = Collections.singletonList(existing);
        } else {
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
            promise = DataSourceUiUtil.promiseFacadeUpdate(facade, null);
            toSelect = ContainerUtil.newArrayList();
            for (DataSourceManager manager : DataSourceManager.getManagers((Project)project)) {
                for (DasDataSource system : manager.createDataSourceByFiles(Collections.singletonList(file))) {
                    ContainerUtil.addIfNotNull((Collection)toSelect, (Object)facade.findDataSource(system.getUniqueId()));
                }
            }
        }
        if (DatabaseSettings.getSettings().navigateToSchema) {
            promise.onProcessed(o -> {
                if (project == null) {
                    DbTreeStructureProvider.$$$reportNull$$$0(7);
                }
                DatabaseView.select(project, true, toSelect);
            });
        } else {
            for (DbDataSource o2 : toSelect) {
                PsiElement element2 = TargetElementUtil.getInstance().getGotoDeclarationTarget((PsiElement)o2, (PsiElement)o2);
                Navigatable navigatable = element2 instanceof Navigatable ? (Navigatable)element2 : EditSourceUtil.getDescriptor((PsiElement)element2);
                if (navigatable == null || !navigatable.canNavigate()) continue;
                navigatable.navigate(true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DbTreeStructureProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DbTreeStructureProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "navigateToDataSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$navigateToDataSource$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

