/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DatabaseColorPanel;
import com.intellij.database.dataSource.EntityWithNameAndComment;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseNameComponent {
    private static final String NON_UNIQUE_NAME = "NON_UNIQUE_NAME";
    private JComponent myPanel;
    private ExtendableTextField myName;
    private JPanel myResetPanel;
    private EditorTextField myComment;
    private final AbstractDatabaseConfigurable myConfigurable;
    private final DatabaseConfigEditor myController;
    private static final boolean INLINE_COLOR_CONTROL = true;
    @Nullable
    private final DatabaseColorPanel myColorPanel;

    public DatabaseNameComponent(@NotNull AbstractDatabaseConfigurable configurable, @NotNull DatabaseConfigEditor controller) {
        if (configurable == null) {
            DatabaseNameComponent.$$$reportNull$$$0(0);
        }
        if (controller == null) {
            DatabaseNameComponent.$$$reportNull$$$0(1);
        }
        this(configurable, controller, null);
    }

    public DatabaseNameComponent(@NotNull AbstractDatabaseConfigurable configurable, @NotNull DatabaseConfigEditor controller, @Nullable DatabaseColorPanel colorPanel) {
        if (configurable == null) {
            DatabaseNameComponent.$$$reportNull$$$0(2);
        }
        if (controller == null) {
            DatabaseNameComponent.$$$reportNull$$$0(3);
        }
        this.myConfigurable = configurable;
        this.myController = controller;
        this.myColorPanel = colorPanel;
        this.$$$setupUI$$$();
        this.myName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String name = DatabaseNameComponent.this.getNameValue();
                if (!DatabaseNameComponent.this.myController.isObjectNameUnique(DatabaseNameComponent.this.myConfigurable.getTarget(), name)) {
                    DatabaseNameComponent.this.myController.showErrorNotification(DatabaseNameComponent.this.myConfigurable, DatabaseNameComponent.NON_UNIQUE_NAME, "Name is Not Unique", String.format("Object with the name '%s' already exists. Please choose another name.", name), new Object[0]);
                } else {
                    DatabaseNameComponent.this.myController.showErrorNotification(DatabaseNameComponent.this.myConfigurable, DatabaseNameComponent.NON_UNIQUE_NAME, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DatabaseNameComponent$1", "textChanged"));
            }
        });
        this.customizeNameComponent(this.myName);
        this.myPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        JComponent reset = this.myController.createResetAction(this.myConfigurable);
        if (reset != null) {
            this.myResetPanel.add(reset);
        }
        new ExpandableEditorSupport(this.myComment);
        this.myComment.setBackground(UIUtil.getPanelBackground());
        this.myComment.setForeground(UIUtil.getActiveTextColor());
    }

    private void customizeNameComponent(@NotNull ExtendableTextField textField) {
        if (textField == null) {
            DatabaseNameComponent.$$$reportNull$$$0(4);
        }
        if (this.myColorPanel == null) {
            return;
        }
        textField.addExtension(this.myColorPanel.createExtension(textField));
        KeyboardShortcut shortcut = DatabaseColorPanel.getExtensionKeyboardShortcut();
        if (shortcut != null && shortcut.getSecondKeyStroke() == null) {
            textField.registerKeyboardAction(event -> {
                ExtendableTextComponent.Extension extension;
                if (textField == null) {
                    DatabaseNameComponent.$$$reportNull$$$0(11);
                }
                if ((extension = DatabaseColorPanel.getExtension(textField)) != null) {
                    extension.getActionOnClick().run();
                }
            }, shortcut.getFirstKeyStroke(), 0);
        }
    }

    @NotNull
    private static GridConstraints createTrivialGridConstraints(int column2) {
        GridConstraints gridConstraints = new GridConstraints(0, column2, 1, 1, 0, 3, 0, 0, null, null, null);
        if (gridConstraints == null) {
            DatabaseNameComponent.$$$reportNull$$$0(5);
        }
        return gridConstraints;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            DatabaseNameComponent.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    public void reset(@NotNull EntityWithNameAndComment dataSource) {
        if (dataSource == null) {
            DatabaseNameComponent.$$$reportNull$$$0(7);
        }
        this.reset(dataSource, null);
    }

    public void reset(@NotNull EntityWithNameAndComment dataSource, @Nullable Computable<String> nameGenerator) {
        if (dataSource == null) {
            DatabaseNameComponent.$$$reportNull$$$0(8);
        }
        String adjustedName = !StringUtil.isEmptyOrSpaces((String)dataSource.getName()) ? dataSource.getName() : (nameGenerator != null ? (String)nameGenerator.compute() : null);
        this.setNameValue(adjustedName);
        this.setCommentValue(dataSource.getComment());
        if (this.myColorPanel != null && dataSource instanceof AbstractDataSource) {
            this.myColorPanel.reset((AbstractDataSource)dataSource);
        }
    }

    public void apply(@NotNull EntityWithNameAndComment dataSource) {
        if (dataSource == null) {
            DatabaseNameComponent.$$$reportNull$$$0(9);
        }
        dataSource.setName(this.getNameValue());
        dataSource.setComment(StringUtil.nullize((String)this.myComment.getText(), (boolean)true));
        if (this.myColorPanel != null && dataSource instanceof AbstractDataSource) {
            this.myColorPanel.apply((AbstractDataSource)dataSource);
        }
    }

    public boolean isModified() {
        return this.myColorPanel != null && this.myColorPanel.isModified();
    }

    @NotNull
    public String getNameValue() {
        String string = this.myName.getText().trim();
        if (string == null) {
            DatabaseNameComponent.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setGeneratedName(String name) {
        if (Comparing.equal((String)name, (String)this.myName.getText())) {
            return;
        }
        this.myName.setText(name);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myName;
    }

    public void setNameValue(@Nullable String name) {
        this.myName.setText(StringUtil.notNullize((String)name));
    }

    void setCommentValue(@Nullable String comment) {
        String s = StringUtil.notNullize((String)comment);
        this.myComment.setText(s);
        this.myComment.setToolTipText(StringUtil.shortenTextWithEllipsis((String)s, (int)2000, (int)0, (boolean)true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseNameComponent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseNameComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrivialGridConstraints";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customizeNameComponent";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$customizeNameComponent$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EditorTextField editorTextField;
        ExtendableTextField extendableTextField;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        this.myPanel = jPanel2;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setHorizontalTextPosition(11);
        jBLabel.setText("Name:");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myResetPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 4, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myName = extendableTextField = new ExtendableTextField();
        extendableTextField.setColumns(30);
        jPanel2.add((Component)extendableTextField, new GridConstraints(0, 1, 1, 2, 0, 3, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Comment:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myComment = editorTextField = new EditorTextField();
        jPanel2.add((Component)editorTextField, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        jBLabel.setLabelFor((Component)extendableTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

