/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.MultipleRunLocationsProvider;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConfigurationFromContextWrapper;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreferredProducerFind {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.actions.PreferredProducerFind");

    private PreferredProducerFind() {
    }

    @Nullable
    public static RunnerAndConfigurationSettings createConfiguration(@NotNull Location location, ConfigurationContext context) {
        ConfigurationFromContext fromContext;
        if (location == null) {
            PreferredProducerFind.$$$reportNull$$$0(0);
        }
        return (fromContext = PreferredProducerFind.findConfigurationFromContext(location, context)) != null ? fromContext.getConfigurationSettings() : null;
    }

    @Deprecated
    @Nullable
    public static List<RuntimeConfigurationProducer> findPreferredProducers(Location location, ConfigurationContext context, boolean strict) {
        if (location == null) {
            return null;
        }
        List<RuntimeConfigurationProducer> producers = PreferredProducerFind.findAllProducers(location, context);
        if (producers.isEmpty()) {
            return null;
        }
        Collections.sort(producers, RuntimeConfigurationProducer.COMPARATOR);
        if (strict) {
            RuntimeConfigurationProducer first = producers.get(0);
            Iterator<RuntimeConfigurationProducer> it = producers.iterator();
            while (it.hasNext()) {
                RuntimeConfigurationProducer producer = it.next();
                if (producer == first || RuntimeConfigurationProducer.COMPARATOR.compare(producer, first) < 0) continue;
                it.remove();
            }
        }
        return producers;
    }

    private static List<RuntimeConfigurationProducer> findAllProducers(Location location, ConfigurationContext context) {
        ArrayList<RuntimeConfigurationProducer> producers = new ArrayList<RuntimeConfigurationProducer>();
        for (RuntimeConfigurationProducer prototype : RuntimeConfigurationProducer.RUNTIME_CONFIGURATION_PRODUCER.getExtensionList()) {
            RuntimeConfigurationProducer producer;
            try {
                producer = prototype.createProducer(location, context);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error((Throwable)new ExtensionException(prototype.getClass(), e));
                continue;
            }
            if (producer.getConfiguration() == null) continue;
            LOG.assertTrue(producer.getSourceElement() != null, (Object)producer);
            producers.add(producer);
        }
        return producers;
    }

    @Nullable
    public static List<ConfigurationFromContext> getConfigurationsFromContext(Location location, ConfigurationContext context, boolean strict) {
        if (location == null) {
            return null;
        }
        MultipleRunLocationsProvider.AlternativeLocationsInfo alternativeLocations = MultipleRunLocationsProvider.findAlternativeLocations(location);
        if (alternativeLocations == null) {
            return PreferredProducerFind.doGetConfigurationsFromContext(location, context, strict);
        }
        return PreferredProducerFind.getConfigurationsFromAlternativeLocations(alternativeLocations, location, strict);
    }

    @Nullable
    private static List<ConfigurationFromContext> doGetConfigurationsFromContext(@NotNull Location location, @NotNull ConfigurationContext context, boolean strict) {
        if (location == null) {
            PreferredProducerFind.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PreferredProducerFind.$$$reportNull$$$0(2);
        }
        ArrayList<ConfigurationFromContext> configurationsFromContext = new ArrayList<ConfigurationFromContext>();
        for (RuntimeConfigurationProducer runtimeConfigurationProducer : PreferredProducerFind.findAllProducers(location, context)) {
            configurationsFromContext.add(new ConfigurationFromContextWrapper(runtimeConfigurationProducer));
        }
        for (RunConfigurationProducer runConfigurationProducer : RunConfigurationProducer.getProducers(context.getProject())) {
            ConfigurationFromContext fromContext = runConfigurationProducer.findOrCreateConfigurationFromContext(context);
            if (fromContext == null) continue;
            configurationsFromContext.add(fromContext);
        }
        if (configurationsFromContext.isEmpty()) {
            return null;
        }
        Collections.sort(configurationsFromContext, ConfigurationFromContext.COMPARATOR);
        if (strict) {
            ConfigurationFromContext first = configurationsFromContext.get(0);
            Iterator<ConfigurationFromContext> iterator = configurationsFromContext.iterator();
            while (iterator.hasNext()) {
                ConfigurationFromContext producer = iterator.next();
                if (producer == first || ConfigurationFromContext.COMPARATOR.compare(producer, first) <= 0) continue;
                iterator.remove();
            }
        }
        return configurationsFromContext;
    }

    @Nullable
    private static ConfigurationFromContext findConfigurationFromContext(Location location, ConfigurationContext context) {
        List<ConfigurationFromContext> producers = PreferredProducerFind.getConfigurationsFromContext(location, context, true);
        if (producers != null) {
            return producers.get(0);
        }
        return null;
    }

    @Nullable
    private static List<ConfigurationFromContext> getConfigurationsFromAlternativeLocations(@NotNull MultipleRunLocationsProvider.AlternativeLocationsInfo alternativeLocationsInfo, @NotNull Location originalLocation, boolean strict) {
        if (alternativeLocationsInfo == null) {
            PreferredProducerFind.$$$reportNull$$$0(3);
        }
        if (originalLocation == null) {
            PreferredProducerFind.$$$reportNull$$$0(4);
        }
        SmartList result2 = new SmartList();
        for (Location<?> alternativeLocation : alternativeLocationsInfo.getAlternativeLocations()) {
            ConfigurationContext fakeContextForAlternativeLocation;
            List<ConfigurationFromContext> configurationsForLocation = PreferredProducerFind.doGetConfigurationsFromContext(alternativeLocation, fakeContextForAlternativeLocation = ConfigurationContext.createEmptyContextForLocation(alternativeLocation), strict);
            if (configurationsForLocation == null) continue;
            for (ConfigurationFromContext configurationFromContext : configurationsForLocation) {
                configurationFromContext.setFromAlternativeLocation(true);
                String locationDisplayName = alternativeLocationsInfo.getProvider().getLocationDisplayName(alternativeLocation, originalLocation);
                configurationFromContext.setAlternativeLocationDisplayName(locationDisplayName);
                RunConfiguration configuration = configurationFromContext.getConfiguration();
                if (!(configuration instanceof LocatableConfigurationBase) || !((LocatableConfiguration)configuration).isGeneratedName()) continue;
                configuration.setName(configuration.getName() + " " + locationDisplayName);
                ((LocatableConfigurationBase)configuration).setNameChangedByUser(true);
            }
            result2.addAll(configurationsForLocation);
        }
        if (result2.isEmpty()) {
            return null;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alternativeLocationsInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalLocation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/actions/PreferredProducerFind";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetConfigurationsFromContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigurationsFromAlternativeLocations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

