/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.services.EditorConfigFileHierarchyService;
import org.editorconfig.language.services.EditorConfigServiceLoaded;
import org.editorconfig.language.services.EditorConfigServiceResult;
import org.editorconfig.language.util.EditorConfigPresentationUtil;
import org.jetbrains.annotations.NotNull;

public class EditorConfigNavigationActionsFactory {
    @NotNull
    public static List<DumbAwareAction> getNavigationActions(@NotNull PsiFile file) {
        if (file == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(0);
        }
        ArrayList actions = ContainerUtil.newArrayList();
        List<EditorConfigPsiFile> parentFiles = EditorConfigNavigationActionsFactory.getParentFiles(file.getVirtualFile(), file.getProject());
        for (EditorConfigPsiFile parentFile : parentFiles) {
            NavigatablePsiElement target = parentFile.findRelevantNavigatable();
            actions.add(DumbAwareAction.create((String)EditorConfigNavigationActionsFactory.getActionName(parentFile, parentFiles.size() > 1), event -> target.navigate(true)));
        }
        ArrayList arrayList = actions;
        if (arrayList == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static String getActionName(@NotNull EditorConfigPsiFile file, boolean withFolder) {
        if (file == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(2);
        }
        return EditorConfigBundle.message("action.open.file", EditorConfigPresentationUtil.getFileName(file, withFolder));
    }

    @NotNull
    static List<EditorConfigPsiFile> getParentFiles(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        EditorConfigFileHierarchyService hierarchyService;
        EditorConfigServiceResult serviceResult;
        if (virtualFile == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(3);
        }
        if (project == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(4);
        }
        List<EditorConfigPsiFile> list = (serviceResult = (hierarchyService = EditorConfigFileHierarchyService.getInstance(project)).getParentEditorConfigFiles(virtualFile)) instanceof EditorConfigServiceLoaded ? ((EditorConfigServiceLoaded)serviceResult).getList() : Collections.emptyList();
        if (list == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/EditorConfigNavigationActionsFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigNavigationActionsFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationActions";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParentFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

