/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TypeScriptSuspiciousConstructorParameterAssignmentInspection
extends JSInspection {
    public static final String SHORT_NAME = "TypeScriptSuspiciousConstructorParameterAssignment";

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"typescript.suspicious.constructor.parameter.assignment", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptSuspiciousConstructorParameterAssignmentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            TypeScriptSuspiciousConstructorParameterAssignmentInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionDeclaration(JSFunction node) {
                if (!node.isConstructor()) {
                    return;
                }
                if (node instanceof TypeScriptFunction && ((TypeScriptFunction)node).isOverloadDeclaration()) {
                    return;
                }
                JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)node);
                if (containingClass == null) {
                    return;
                }
                JSAttributeList list = containingClass.getAttributeList();
                if (list != null && TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)containingClass)) {
                    return;
                }
                this.checkSuspiciousFieldParamAssignments(node);
            }

            private void checkSuspiciousFieldParamAssignments(final @NotNull JSFunction constructor) {
                Set fieldParamNames;
                if (constructor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((fieldParamNames = Arrays.stream(constructor.getParameterVariables()).filter(TypeScriptPsiUtil::isFieldParameter).map(v -> v.getName()).filter(n -> n != null).collect(Collectors.toSet())).size() == 0) {
                    return;
                }
                constructor.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

                    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
                        JSExpression lOperand = node.getLOperand();
                        if (lOperand instanceof JSDefinitionExpression) {
                            lOperand = ((JSDefinitionExpression)lOperand).getExpression();
                        }
                        if (!(lOperand instanceof JSReferenceExpression) || ((JSReferenceExpression)lOperand).getQualifier() != null) {
                            return;
                        }
                        String name = ((JSReferenceExpression)lOperand).getReferenceName();
                        if (!fieldParamNames.contains(name)) {
                            return;
                        }
                        JSFunction function = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class});
                        while (JSPsiImplUtils.isArrowFunction(function)) {
                            function = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)function, (Class[])new Class[]{JSFunction.class});
                        }
                        if (function != constructor) {
                            return;
                        }
                        holder.registerProblem((PsiElement)lOperand, JSBundle.message((String)"typescript.suspicious.constructor.parameter.assignment", (Object[])new Object[0]), new LocalQuickFix[]{new JSInsertThisFix(lOperand)});
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/lang/typescript/inspections/TypeScriptSuspiciousConstructorParameterAssignmentInspection$1", "checkSuspiciousFieldParamAssignments"));
            }
        };
        if (jSElementVisitor == null) {
            TypeScriptSuspiciousConstructorParameterAssignmentInspection.$$$reportNull$$$0(2);
        }
        return jSElementVisitor;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            TypeScriptSuspiciousConstructorParameterAssignmentInspection.$$$reportNull$$$0(3);
        }
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/typescript/inspections/TypeScriptSuspiciousConstructorParameterAssignmentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

