/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlComment;
import org.jetbrains.annotations.Nullable;

public class JavascriptCommenter
implements CodeDocumentationAwareCommenter {
    public String getLineCommentPrefix() {
        return "//";
    }

    public String getBlockCommentPrefix() {
        return "/*";
    }

    public String getBlockCommentSuffix() {
        return "*/";
    }

    public String getCommentedBlockCommentPrefix() {
        return "/!*";
    }

    public String getCommentedBlockCommentSuffix() {
        return "*!/";
    }

    @Nullable
    public IElementType getLineCommentTokenType() {
        return JSTokenTypes.END_OF_LINE_COMMENT;
    }

    @Nullable
    public IElementType getBlockCommentTokenType() {
        return JSTokenTypes.C_STYLE_COMMENT;
    }

    public String getDocumentationCommentPrefix() {
        return "/**";
    }

    public String getDocumentationCommentLinePrefix() {
        return "*";
    }

    public String getDocumentationCommentSuffix() {
        return "*/";
    }

    public boolean isDocumentationComment(PsiComment element) {
        PsiElement context = element.getContainingFile().getContext();
        if (context instanceof XmlComment) {
            return false;
        }
        return element.getTokenType() == JSTokenTypes.DOC_COMMENT;
    }

    @Nullable
    public IElementType getDocumentationCommentTokenType() {
        return JSTokenTypes.DOC_COMMENT;
    }
}

