/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

class InstrumentedMethodsFilter {
    private final String myClassName;
    private boolean myEnum;

    InstrumentedMethodsFilter(String className) {
        this.myClassName = className;
    }

    void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myEnum = (access & 0x4000) != 0;
    }

    Decision shouldVisitMethod(int access, String name, String desc, String signature, String[] exceptions, boolean instrumentConstructorsForce) {
        if ((access & 0x40) != 0) {
            return Decision.NO;
        }
        if ((access & 0x400) != 0) {
            return Decision.NO;
        }
        if ("<clinit>".equals(name) || (access & 0x1000) != 0) {
            return Decision.NO;
        }
        if (name.equals("<init>") && desc.equals("()V")) {
            return instrumentConstructorsForce ? Decision.YES : Decision.CHECK_IS_CONSTRUCTOR_DEFAULT;
        }
        if (this.myEnum && InstrumentedMethodsFilter.isDefaultEnumMethod(name, desc, signature, this.myClassName)) {
            return Decision.NO;
        }
        return Decision.YES;
    }

    private static boolean isDefaultEnumMethod(String name, String desc, String signature, String className) {
        return name.equals("values") && desc.equals("()[L" + className + ";") || name.equals("valueOf") && desc.equals("(Ljava/lang/String;)L" + className + ";") || name.equals("<init>") && signature != null && signature.equals("()V");
    }

    static enum Decision {
        YES,
        NO,
        CHECK_IS_CONSTRUCTOR_DEFAULT;

    }
}

