/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.actions;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.adapters.PuppetDependencyManagerAdapter;
import com.intellij.lang.puppet.ide.actions.PuppetBaseAction;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetInstallDependenciesAction
extends PuppetBaseAction {
    public PuppetInstallDependenciesAction() {
        super(PuppetBundle.message("puppet.action.install.dependencies.default", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PuppetInstallDependenciesAction.$$$reportNull$$$0(0);
        }
        PuppetEntity puppetEntity = PuppetInstallDependenciesAction.getPuppetEntityFromEvent(e);
        assert (puppetEntity != null);
        PuppetDependencyManagerAdapter dependencyManager = puppetEntity.getDependencyManager();
        assert (dependencyManager != null);
        dependencyManager.installDependencies(puppetEntity);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PuppetInstallDependenciesAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        PuppetEntity puppetEntity = PuppetInstallDependenciesAction.getPuppetEntityFromEvent(e);
        if (puppetEntity == null || puppetEntity.getDependencyManager() == null) {
            presentation.setEnabledAndVisible(false);
        } else {
            presentation.setEnabledAndVisible(true);
            presentation.setText(PuppetBundle.message("puppet.action.install.dependencies", puppetEntity.getDescriptiveName(), puppetEntity.getName()));
        }
    }

    @Nullable
    protected static PuppetEntity getPuppetEntityFromEvent(@NotNull AnActionEvent e) {
        VirtualFile eventFile;
        if (e == null) {
            PuppetInstallDependenciesAction.$$$reportNull$$$0(2);
        }
        if ((eventFile = PuppetInstallDependenciesAction.getFileFromEvent(e)) == null || e.getProject() == null) {
            return null;
        }
        return PuppetProjectManager.getInstance(e.getProject()).findModuleOrEnvironmentForFile(eventFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/lang/puppet/ide/actions/PuppetInstallDependenciesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPuppetEntityFromEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

