/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.editing;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.psi.PsiPuppetResourceDeclaration;
import com.intellij.lang.puppet.psi.PsiPuppetResourceInstanceDeclaration;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class PuppetResourceEnterHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            PuppetResourceEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PuppetResourceEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            PuppetResourceEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            PuppetResourceEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            PuppetResourceEnterHandler.$$$reportNull$$$0(4);
        }
        if (file.getLanguage() != PuppetLanguage.INSTANCE) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement element = file.findElementAt(((Integer)caretOffset.get()).intValue());
        PsiPuppetResourceDeclaration resource = (PsiPuppetResourceDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, PsiPuppetResourceDeclaration.class);
        if (resource == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!PuppetResourceEnterHandler.ensureTextually(editor.getDocument().getCharsSequence(), (Integer)caretOffset.get())) {
            return EnterHandlerDelegate.Result.Continue;
        }
        while ((element = PsiTreeUtil.prevVisibleLeaf((PsiElement)element)) instanceof PsiComment) {
        }
        if (element == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (element.getNode().getElementType() == PuppetTokenTypes.COLON && PsiTreeUtil.getParentOfType((PsiElement)element, PsiPuppetResourceInstanceDeclaration.class) != null) {
            Document document = editor.getDocument();
            int offsetWithRBrace = (Integer)caretOffset.get();
            while (document.getCharsSequence().charAt(offsetWithRBrace) != '}') {
                ++offsetWithRBrace;
            }
            document.insertString(offsetWithRBrace, (CharSequence)"\n");
            Project project = editor.getProject();
            if (project != null) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, 1 + offsetWithRBrace);
            }
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return super.preprocessEnter(file, editor, caretOffset, caretAdvance, dataContext, originalHandler);
    }

    private static boolean ensureTextually(CharSequence text, int position) {
        int colonPos = StringUtil.lastIndexOf((CharSequence)text, (char)':', (int)0, (int)position);
        if (colonPos == -1) {
            return false;
        }
        int nextPos = StringUtil.indexOfAny((CharSequence)text, (String)"\n}", (int)colonPos, (int)text.length());
        return nextPos != -1 && text.charAt(nextPos) == '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/puppet/editing/PuppetResourceEnterHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

