require 'test/unit'

module Borges; end
require 'Borges/HTML/HtmlAttributes'
require 'Borges/HTML/HtmlElement'

class HtmlElmentTest < Test::Unit::TestCase

  def setup
    @element = Borges::HtmlElement.new :p

    anchor_attributes = Borges::HtmlAttributes.new
    anchor_attributes.href = "http://www.reddwarf.co.uk"
    anchor = Borges::HtmlElement.new :a, anchor_attributes

    rule = Borges::HtmlElement.new :hr

    @element.add anchor
    @element.add rule
  end

  def test_initialize
    @element = Borges::HtmlElement.new :p
    assert_equal :p, @element.name
  end

  def test_to_s
    assert_equal "<p><a href=\"http://www.reddwarf.co.uk\"></a><hr></p>",
                 @element.to_s
  end

end # class HtmlElmentTest

