/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewVirtualFile
extends VirtualFile
implements VirtualFileWithId {
    @Override
    public boolean isValid() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.exists();
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        throw new IOException("Cannot get content of " + this);
    }

    @Override
    @NotNull
    public abstract NewVirtualFileSystem getFileSystem();

    @Override
    public abstract NewVirtualFile getParent();

    @Override
    @Nullable
    public abstract NewVirtualFile getCanonicalFile();

    @Override
    @Nullable
    public abstract NewVirtualFile findChild(@NotNull @NonNls String var1);

    @Nullable
    public abstract NewVirtualFile refreshAndFindChild(@NotNull String var1);

    @Nullable
    public abstract NewVirtualFile findChildIfCached(@NotNull String var1);

    public abstract void setTimeStamp(long var1) throws IOException;

    @Override
    @NotNull
    public abstract CharSequence getNameSequence();

    @Override
    public abstract int getId();

    @Deprecated
    @Nullable
    public NewVirtualFile findChildById(int id) {
        return null;
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        RefreshQueue.getInstance().refresh(asynchronous, recursive, postRunnable, this);
    }

    @Override
    public abstract void setWritable(boolean var1) throws IOException;

    public abstract void markDirty();

    public abstract void markDirtyRecursively();

    public abstract boolean isDirty();

    public abstract void markClean();

    @Override
    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            NewVirtualFile.$$$reportNull$$$0(0);
        }
        if (!this.exists()) {
            throw new IOException("File to move does not exist: " + this.getPath());
        }
        if (!newParent.exists()) {
            throw new IOException("Destination folder does not exist: " + newParent.getPath());
        }
        if (!newParent.isDirectory()) {
            throw new IOException("Destination is not a folder: " + newParent.getPath());
        }
        VirtualFile child = newParent.findChild(this.getName());
        if (child != null) {
            throw new IOException("Destination already exists: " + newParent.getPath() + "/" + this.getName());
        }
        EncodingRegistry.doActionAndRestoreEncoding(this, () -> {
            if (newParent == null) {
                NewVirtualFile.$$$reportNull$$$0(2);
            }
            this.getFileSystem().moveFile(requestor, this, newParent);
            return this;
        });
    }

    @NotNull
    public abstract Collection<VirtualFile> getCachedChildren();

    @NotNull
    public abstract Iterable<VirtualFile> iterInDbChildren();

    @Deprecated
    @NotNull
    @ApiStatus.Experimental
    public Iterable<VirtualFile> iterInDbChildrenWithoutLoadingVfsFromOtherProjects() {
        Iterable<VirtualFile> iterable = this.iterInDbChildren();
        if (iterable == null) {
            NewVirtualFile.$$$reportNull$$$0(1);
        }
        return iterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/NewVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/NewVirtualFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "iterInDbChildrenWithoutLoadingVfsFromOtherProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lambda$move$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

