/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterInput<T extends JSLinterState> {
    private final Project myProject;
    private final PsiFile myPsiFile;
    private final String myFileContent;
    private final T myState;
    private final EditorColorsScheme myColorsScheme;

    protected JSLinterInput(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull String fileContent, @NotNull T state, @Nullable EditorColorsScheme colorsScheme) {
        if (project == null) {
            JSLinterInput.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            JSLinterInput.$$$reportNull$$$0(1);
        }
        if (fileContent == null) {
            JSLinterInput.$$$reportNull$$$0(2);
        }
        if (state == null) {
            JSLinterInput.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myPsiFile = psiFile;
        this.myFileContent = JSLinterUtil.convertLineSeparatorsToFileOriginal(project, fileContent, this.myPsiFile.getViewProvider().getVirtualFile());
        this.myState = state;
        this.myColorsScheme = colorsScheme;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JSLinterInput.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            JSLinterInput.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myPsiFile.getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            JSLinterInput.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @NotNull
    public String getFileContent() {
        String string = this.myFileContent;
        if (string == null) {
            JSLinterInput.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public T getState() {
        T t = this.myState;
        if (t == null) {
            JSLinterInput.$$$reportNull$$$0(8);
        }
        return t;
    }

    @Nullable
    public EditorColorsScheme getColorsScheme() {
        return this.myColorsScheme;
    }

    @NotNull
    public static <T extends JSLinterState> JSLinterInput<T> create(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull String fileContent, @NotNull T state, @Nullable EditorColorsScheme colorsScheme) {
        if (project == null) {
            JSLinterInput.$$$reportNull$$$0(9);
        }
        if (psiFile == null) {
            JSLinterInput.$$$reportNull$$$0(10);
        }
        if (fileContent == null) {
            JSLinterInput.$$$reportNull$$$0(11);
        }
        if (state == null) {
            JSLinterInput.$$$reportNull$$$0(12);
        }
        JSLinterInput<T> jSLinterInput = new JSLinterInput<T>(project, psiFile, fileContent, state, colorsScheme);
        if (jSLinterInput == null) {
            JSLinterInput.$$$reportNull$$$0(13);
        }
        return jSLinterInput;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterInput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterInput";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

