/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativeRectangle;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.RemoteMoveProvider;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MyDnDTarget
implements DnDTarget {
    private final ServerTree myTree;

    public MyDnDTarget(ServerTree tree) {
        this.myTree = tree;
    }

    public boolean update(DnDEvent aEvent) {
        boolean dropPossible = this.myTree == aEvent.getHandlerComponent();
        String message = null;
        if (dropPossible) {
            ServerTreeNode targetNode = this.getTargetNode(aEvent);
            if (targetNode == null) {
                dropPossible = false;
            } else {
                TreeNode[] nodes = RemoteMoveProvider.extractNodes(aEvent);
                Collection<WebServerConfig.RemotePath> paths = RemoteMoveProvider.extractPaths(nodes, this.myTree.getProject());
                Collection<VirtualFile> elements = RemoteMoveProvider.extractVirtualFiles(nodes);
                if (paths != null && !RemoteMoveProvider.isRemoteTargetValid(paths, targetNode.getPath(), this.myTree.getServer().isCaseSensitive())) {
                    dropPossible = false;
                    message = WDBundle.message("can.t.move.folder.into.its.descendant.folder", new Object[0]);
                } else if (elements != null && !RemoteMoveProvider.isValidLocalSource(elements)) {
                    dropPossible = false;
                } else if (paths == null && elements == null) {
                    dropPossible = false;
                } else {
                    message = WDBundle.message("0.selected.items.here", WDBundle.message(paths != null ? "action.move" : "action.upload", new Object[0]));
                }
            }
        }
        if (dropPossible) {
            Point point = aEvent.getPoint();
            Rectangle pathBounds = this.myTree.getPathBounds(this.myTree.getClosestPathForLocation(point.x, point.y));
            if (pathBounds != null) {
                aEvent.setHighlighting(new RelativeRectangle((Component)((Object)this.myTree), pathBounds), 1);
            }
        }
        if (message != null) {
            aEvent.setDropPossible(dropPossible, message);
        } else {
            aEvent.setDropPossible(dropPossible);
        }
        return false;
    }

    private ServerTreeNode getTargetNode(DnDEvent aEvent) {
        Point point = aEvent.getPointOn((Component)((Object)this.myTree));
        TreePath targetPath = this.myTree.getClosestPathForLocation(point.x, point.y);
        return ServerTree.getServerTreeNode(targetPath);
    }

    public void drop(DnDEvent aEvent) {
        ServerTreeNode targetNode = this.getTargetNode(aEvent);
        TreeNode[] nodes = RemoteMoveProvider.extractNodes(aEvent);
        Collection<WebServerConfig.RemotePath> sourcePaths = RemoteMoveProvider.extractPaths(nodes, this.myTree.getProject());
        Collection<VirtualFile> sourceElements = RemoteMoveProvider.extractVirtualFiles(nodes);
        if (sourcePaths != null) {
            RemoteMoveProvider.performRemoteToRemotePaste(sourcePaths, targetNode, this.myTree, this.myTree.getProject(), this.myTree.getServer(), DnDAction.MOVE == aEvent.getAction(), true);
        } else if (sourceElements != null) {
            RemoteMoveProvider.performLocalToRemotePaste(sourceElements, targetNode, this.myTree, this.myTree.getProject(), this.myTree.getServer(), false);
        }
    }

    public void cleanUpOnLeave() {
    }

    public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
    }
}

