/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ExcludingActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WeighingActionGroup
extends ActionGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.WeighingActionGroup");
    private final PresentationFactory myPresentationFactory = new PresentationFactory();

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            WeighingActionGroup.$$$reportNull$$$0(0);
        }
        this.getDelegate().update(e);
    }

    protected abstract ActionGroup getDelegate();

    private static void getAllChildren(@Nullable AnActionEvent e, ActionGroup group, List<? super AnAction> result2) {
        for (AnAction action : group.getChildren(e)) {
            if (action == null) {
                LOG.error("Null child for " + group + " of class " + group.getClass());
                continue;
            }
            if (action instanceof ActionGroup && !((ActionGroup)action).isPopup()) {
                WeighingActionGroup.getAllChildren(e, (ActionGroup)action, result2);
                continue;
            }
            result2.add((AnAction)action);
        }
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] children2 = this.getDelegate().getChildren(e);
        if (e == null) {
            if (children2 == null) {
                WeighingActionGroup.$$$reportNull$$$0(1);
            }
            return children2;
        }
        ArrayList all = new ArrayList();
        WeighingActionGroup.getAllChildren(e, this.getDelegate(), all);
        LinkedHashSet<AnAction> heaviest = null;
        double maxWeight = 0.0;
        for (AnAction action : all) {
            Presentation presentation = this.myPresentationFactory.getPresentation(action);
            presentation.setWeight(0.0);
            Utils.updateGroupChild(e.getDataContext(), e.getPlace(), action, presentation);
            if (!presentation.isEnabled() || !presentation.isVisible()) continue;
            if (presentation.getWeight() > maxWeight) {
                maxWeight = presentation.getWeight();
                heaviest = new LinkedHashSet<AnAction>();
            }
            if (presentation.getWeight() != maxWeight || heaviest == null) continue;
            heaviest.add(action);
        }
        if (heaviest == null) {
            if (children2 == null) {
                WeighingActionGroup.$$$reportNull$$$0(2);
            }
            return children2;
        }
        DefaultActionGroup chosen = new DefaultActionGroup();
        boolean prevSeparator = true;
        for (AnAction action : all) {
            boolean separator = action instanceof Separator;
            if (separator && !prevSeparator) {
                chosen.add(action);
            }
            prevSeparator = separator;
            if (this.shouldBeChosenAnyway(action)) {
                heaviest.add(action);
            }
            if (!heaviest.contains(action)) continue;
            chosen.add(action);
        }
        ExcludingActionGroup other = new ExcludingActionGroup(this.getDelegate(), heaviest);
        other.setPopup(true);
        other.getTemplatePresentation().setText("Other...");
        AnAction[] anActionArray = new AnAction[]{chosen, new Separator(), other};
        if (anActionArray == null) {
            WeighingActionGroup.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    protected boolean shouldBeChosenAnyway(AnAction action) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/WeighingActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/WeighingActionGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

