/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LanguageTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.XmlAttributeInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.AdvancedXmlPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.LanguagePanel;
import org.intellij.plugins.intelliLang.inject.config.ui.TagPanel;

public class XmlAttributePanel
extends AbstractInjectionPanel<XmlAttributeInjection> {
    private JPanel myRoot;
    LanguagePanel myLanguagePanel;
    TagPanel myTagPanel;
    AdvancedXmlPanel myAdvancedPanel;
    private EditorTextField myLocalName;
    private ComboBox myNamespace;
    private JTextField myNameTextField;
    private boolean myUseGeneratedName;

    public XmlAttributePanel(XmlAttributeInjection injection, Project project) {
        super(injection, project);
        this.$$$setupUI$$$();
        this.myNamespace.setModel(TagPanel.createNamespaceUriModel(project));
        this.init(injection.copy());
    }

    @Override
    public JPanel getComponent() {
        return this.myRoot;
    }

    @Override
    protected void resetImpl() {
        this.myNameTextField.setText(((XmlAttributeInjection)this.myOrigInjection).getDisplayName());
        this.myLocalName.setText(((XmlAttributeInjection)this.myOrigInjection).getAttributeName());
        this.myNamespace.getEditor().setItem(((XmlAttributeInjection)this.myOrigInjection).getAttributeNamespace());
        this.myUseGeneratedName = Comparing.equal((String)((XmlAttributeInjection)this.myOrigInjection).getDisplayName(), (String)((XmlAttributeInjection)this.myOrigInjection).getGeneratedName());
    }

    @Override
    protected void apply(XmlAttributeInjection other) {
        other.setAttributeName(this.myLocalName.getText());
        other.setAttributeNamespace(this.getNamespace());
        String name = this.myNameTextField.getText();
        boolean useGenerated = this.myUseGeneratedName && Comparing.equal((String)((XmlAttributeInjection)this.myOrigInjection).getDisplayName(), (String)name);
        String newName = useGenerated || StringUtil.isEmptyOrSpaces((String)name) ? other.getGeneratedName() : name;
        other.setDisplayName(newName);
    }

    private String getNamespace() {
        String s = (String)this.myNamespace.getEditor().getItem();
        return s != null ? s : "";
    }

    private void createUIComponents() {
        this.myLanguagePanel = new LanguagePanel(this.myProject, this.myOrigInjection);
        this.myTagPanel = new TagPanel(this.myProject, (AbstractTagInjection)this.myOrigInjection);
        this.myAdvancedPanel = new AdvancedXmlPanel(this.myProject, (AbstractTagInjection)this.myOrigInjection);
        this.myLocalName = new LanguageTextField((Language)RegExpLanguage.INSTANCE, this.myProject, ((XmlAttributeInjection)this.myOrigInjection).getAttributeName());
        this.myNamespace = new ComboBox(200);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        TagPanel tagPanel = this.myTagPanel;
        JComponent jComponent = tagPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(2, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"XML Attribute", (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Local name:");
        jLabel.setDisplayedMnemonic('O');
        jLabel.setDisplayedMnemonicIndex(1);
        jLabel.setToolTipText("Regular expression to match the attribute name, e.g. \"on.*\"");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Namespace:");
        jLabel2.setDisplayedMnemonic('M');
        jLabel2.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myLocalName;
        jPanel2.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        ComboBox comboBox = this.myNamespace;
        comboBox.setEditable(true);
        jPanel2.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        LanguagePanel languagePanel = this.myLanguagePanel;
        JComponent jComponent2 = languagePanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent2, new GridConstraints(1, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        AdvancedXmlPanel advancedXmlPanel = this.myAdvancedPanel;
        JComponent jComponent3 = advancedXmlPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent3, new GridConstraints(4, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Name:");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor((Component)editorTextField);
        jLabel2.setLabelFor((Component)comboBox);
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

