/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class SdkLeakTracker {
    @NotNull
    private final Sdk[] oldSdks;

    public SdkLeakTracker() {
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        this.oldSdks = table == null ? new Sdk[]{} : table.getAllJdks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForJdkTableLeaks() {
        Sdk[] jdks;
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        if (table != null && (jdks = table.getAllJdks()).length != 0) {
            THashSet leaked = new THashSet(Arrays.asList(jdks));
            THashSet old = new THashSet(Arrays.asList(this.oldSdks));
            leaked.removeAll((Collection<?>)old);
            try {
                if (!leaked.isEmpty()) {
                    Assert.fail((String)("Leaked SDKs: " + leaked));
                }
            }
            finally {
                for (Sdk jdk : leaked) {
                    WriteAction.run(() -> table.removeJdk(jdk));
                }
            }
        }
    }
}

