/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.nodejs.run.profile.V8IndexCatalogManager;
import com.jetbrains.nodejs.run.profile.V8IndexManager;
import com.jetbrains.nodejs.run.profile.cpu.calculation.CallTreesSerializer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.TickIndexer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LogIndexesWriter;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8TickProcessor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.FlatTopCalls;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.io.LongRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import com.jetbrains.nodejs.run.profile.heap.io.StringRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class V8CpuIndexManager
extends V8IndexManager<V8LogIndexesWriter.Category> {
    public V8CpuIndexManager(@NotNull File snapshotFile) throws IOException {
        if (snapshotFile == null) {
            V8CpuIndexManager.$$$reportNull$$$0(0);
        }
        super(snapshotFile, (Enum[])V8CpuIndexManager.getCategoryValues());
    }

    private static V8LogIndexesWriter.Category[] getCategoryValues() {
        ArrayList<V8LogIndexesWriter.Category> categories = new ArrayList<V8LogIndexesWriter.Category>(Arrays.asList(V8LogIndexesWriter.Category.values()));
        categories.remove((Object)V8LogIndexesWriter.Category.durationByTick1);
        categories.remove((Object)V8LogIndexesWriter.Category.numDurationByTick1);
        return categories.toArray(new V8LogIndexesWriter.Category[0]);
    }

    @Override
    public byte[] createDigest(@NotNull File snapshotFile) throws IOException {
        if (snapshotFile == null) {
            V8CpuIndexManager.$$$reportNull$$$0(1);
        }
        return V8IndexCatalogManager.digestFile(snapshotFile, new byte[0][]);
    }

    @Override
    protected V8LogIndexesWriter.Category getDescriptionCategory() {
        return V8LogIndexesWriter.Category.description;
    }

    public V8LogCachingReader initReader(@NotNull ByteArrayWrapper digest, File v8log, @NotNull CompositeCloseable resources) throws IOException {
        if (digest == null) {
            V8CpuIndexManager.$$$reportNull$$$0(2);
        }
        if (resources == null) {
            V8CpuIndexManager.$$$reportNull$$$0(3);
        }
        LinksReaderFactory<Long> stackReader = new LinksReaderFactory<Long>(new LongRawSerializer(), this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.numStack), this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.stack));
        LinksReaderFactory<String> stringsReader = new LinksReaderFactory<String>(new StringRawSerializer(), this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.numStrings), this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.strings));
        LinksReaderFactory<V8LogIndexesWriter.TimerEvent> timerEventReader = new LinksReaderFactory<V8LogIndexesWriter.TimerEvent>(new V8LogIndexesWriter.TimerEvent.MyRawSerializer(), this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.numEvents), this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.events));
        LinksReaderFactory<Long> durationFactory = new LinksReaderFactory<Long>(new LongRawSerializer(), this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.numDurationByTick2), this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.durationByTick2));
        FlatTopCalls flatTopCalls = this.read(V8LogIndexesWriter.Category.flatTree, new FlatTopCalls.MySerializer());
        TickIndexer eventsIndex = this.read(V8LogIndexesWriter.Category.eventsIndex, new TickIndexer.MySerializer());
        TickIndexer eventsEndsIndex = this.read(V8LogIndexesWriter.Category.eventsEndsIndex, new TickIndexer.MySerializer());
        Map<String, V8TickProcessor.CodeType> typeMap = this.read(V8LogIndexesWriter.Category.codeTypes, new CodeTypesSerializer());
        return new V8LogCachingReader(digest, v8log, this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.header), this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.timeForTick), this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.stackSize), stackReader, stringsReader, timerEventReader, this.myIndexFiles.getFiles(V8LogIndexesWriter.Category.overviewScale), durationFactory, this.read(V8LogIndexesWriter.Category.bottomUp, new CallTreesSerializer()), this.read(V8LogIndexesWriter.Category.topDown, new CallTreesSerializer()), flatTopCalls, resources, eventsIndex, eventsEndsIndex, typeMap, this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.distribution), this.myIndexFiles.getOneFile(V8LogIndexesWriter.Category.selfDistribution));
    }

    public void recordReader(V8LogCachingReader reader) throws IOException {
        if (this.myDoNotSerialize) {
            return;
        }
        Map map = this.myIndexFiles.getFilesMap();
        map.remove((Object)V8LogIndexesWriter.Category.durationByTick1);
        map.remove((Object)V8LogIndexesWriter.Category.numDurationByTick1);
        this.record(V8LogIndexesWriter.Category.bottomUp, new CallTreesSerializer(), reader.getBottomUp());
        this.record(V8LogIndexesWriter.Category.topDown, new CallTreesSerializer(), reader.getTopDown());
        this.record(V8LogIndexesWriter.Category.flatTree, new FlatTopCalls.MySerializer(), reader.getFlat());
        this.record(V8LogIndexesWriter.Category.eventsIndex, new TickIndexer.MySerializer(), reader.getEventsTickIndexer());
        this.record(V8LogIndexesWriter.Category.eventsEndsIndex, new TickIndexer.MySerializer(), reader.getEventsEndTickIndexer());
        this.record(V8LogIndexesWriter.Category.codeTypes, new CodeTypesSerializer(), reader.getCodeTypes());
        V8IndexCatalogManager.writeDigests(map, this.categoryFile(V8LogIndexesWriter.Category.description));
    }

    private <T> void record(V8LogIndexesWriter.Category category, RawSerializer<T> serializer, T value) throws IOException {
        File file = this.myIndexFiles.generate(category, null);
        SequentialRawWriter<T> writer = new SequentialRawWriter<T>(file, serializer);
        writer.write(value);
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T read(V8LogIndexesWriter.Category category, RawSerializer<T> serializer) throws IOException {
        File file = this.myIndexFiles.getOneFile(category);
        try (SequentialRawReader<T> reader = new SequentialRawReader<T>(file, serializer);){
            T t = reader.read();
            return t;
        }
    }

    @Override
    protected boolean checkAllTypesArePresent(Map<V8LogIndexesWriter.Category, List<Pair<String, byte[]>>> digests) {
        V8LogIndexesWriter.Category[] values = V8CpuIndexManager.getCategoryValues();
        if (digests.size() == values.length - 1) {
            return true;
        }
        int len = values.length - 1;
        if (!digests.containsKey((Object)V8LogIndexesWriter.Category.overviewScale)) {
            --len;
        }
        if (!digests.containsKey((Object)V8LogIndexesWriter.Category.eventsOverview)) {
            --len;
        }
        return digests.size() == len;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/V8CpuIndexManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createDigest";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "initReader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CodeTypesSerializer
    implements RawSerializer<Map<String, V8TickProcessor.CodeType>> {
        private CodeTypesSerializer() {
        }

        @Override
        public long getRecordSize() {
            return -1L;
        }

        @Override
        public void write(@NotNull DataOutput os, @NotNull Map<String, V8TickProcessor.CodeType> map) throws IOException {
            if (os == null) {
                CodeTypesSerializer.$$$reportNull$$$0(0);
            }
            if (map == null) {
                CodeTypesSerializer.$$$reportNull$$$0(1);
            }
            os.writeInt(map.size());
            for (Map.Entry<String, V8TickProcessor.CodeType> entry : map.entrySet()) {
                os.writeUTF(entry.getKey());
                os.writeUTF(entry.getValue().name());
            }
        }

        @Override
        public Map<String, V8TickProcessor.CodeType> read(@NotNull DataInput is) throws IOException {
            if (is == null) {
                CodeTypesSerializer.$$$reportNull$$$0(2);
            }
            HashMap map = new HashMap();
            int size = is.readInt();
            for (int i = 0; i < size; ++i) {
                String key = is.readUTF();
                V8TickProcessor.CodeType value = V8TickProcessor.CodeType.valueOf(is.readUTF());
                map.put(key, value);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "os";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "is";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/V8CpuIndexManager$CodeTypesSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

