/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.lang.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.smarty.SmartyCompletionContributor;
import com.jetbrains.smarty.lang.SmartyElementTypes;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SmartyCustomDelimiterLexer
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(SmartyCustomDelimiterLexer.class);
    private final String myStartDelimiter;
    private final String myEndDelimiter;
    private final boolean myAllowWhiteSpaces;
    protected CharSequence myBuffer;
    private int myBufferEnd;
    private int myState;
    private int myLexerState;
    private IElementType myTokenType;
    protected int myTokenStart;
    private int myTokenEnd;
    public static final int YYINITIAL_STATE = 0;
    public static final int DOUBLE_QUOTE_STRING_STATE = 1;
    public static final int CID_STATE = 2;
    public static final int SINGLE_QUOTE_STRING_STATE = 3;
    public static final int LITERAL1_STATE = 4;
    public static final int LITERAL2_STATE = 5;
    public static final int LITERAL3_STATE = 6;
    public static final int START_TAG_STATE = 7;
    public static final int USER_FUNCTION_STATE = 8;
    public static final int LEFT_DELIMITER_STATE_STATE = 9;
    public static final int RIGHT_DELIMITER_STATE_STATE = 10;
    public static final int END_TAG_STATE = 11;
    public static final int TAG_CLOSING_STATE = 12;
    public static final int SMARTY_STATE = 13;
    private static final Map<String, IElementType> mySimpleTokens = new LinkedHashMap<String, IElementType>();
    private int myStateToReturnFromExpression = 0;
    private int myTagsReturnStack = 0;
    private int myNestingDepth = 0;
    public static final String LITERAL_TAG = "literal";
    public static final String LEFT_DELIMITER_TAG = "ldelim";
    public static final String RIGHT_DELIMITER_TAG = "rdelim";
    private final String myCommentStart;
    private final String myCommentEnd;

    public static String[] FOR_PROPERTIES() {
        return new String[]{"iteration", "total", "first", "last"};
    }

    public static String[] FOR_EACH_PROPERTIES() {
        return new String[]{"key", "iteration", "index", "total", "first", "last"};
    }

    public SmartyCustomDelimiterLexer(String startDelimiter, String endDelimiter, boolean allowWhiteSpaces) {
        this.myStartDelimiter = startDelimiter;
        this.myEndDelimiter = endDelimiter;
        this.myAllowWhiteSpaces = allowWhiteSpaces;
        this.myCommentStart = this.myStartDelimiter + "*";
        this.myCommentEnd = "*" + this.myEndDelimiter;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            SmartyCustomDelimiterLexer.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myTokenType = null;
        this.myTokenStart = startOffset;
        this.myTokenEnd = startOffset;
        this.myBufferEnd = endOffset;
        this.myLexerState = this.myState = initialState >> 5 & 0x1F;
        this.myStateToReturnFromExpression = initialState & 0x1F;
        this.myNestingDepth = initialState >> 10 & 0x1F;
        this.myTagsReturnStack = initialState >> 15;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            SmartyCustomDelimiterLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public int getState() {
        return (this.myTagsReturnStack << 15) + (this.myNestingDepth << 10) + (this.myLexerState << 5) + this.myStateToReturnFromExpression;
    }

    public int getTokenStart() {
        this.locateToken();
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEnd;
    }

    public void advance() {
        this.myTokenType = null;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    private int popNested() {
        if (this.myNestingDepth <= 0) {
            return 0;
        }
        --this.myNestingDepth;
        if ((this.myTagsReturnStack & 1 << this.myNestingDepth) != 0) {
            return 13;
        }
        return 1;
    }

    private void pushNested(boolean doReturnToSmarty) {
        this.myTagsReturnStack |= (doReturnToSmarty ? 1 : 0) << this.myNestingDepth;
        ++this.myNestingDepth;
    }

    private void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        this.myLexerState = this.myState;
        this.myTokenStart = this.myTokenEnd;
        int offset = this.myTokenStart;
        int end = this.myBufferEnd;
        if (offset >= end) {
            this.myTokenType = null;
            return;
        }
        if (this.myLexerState == 0) {
            if (this.matches(this.myCommentStart, this.myCommentEnd, offset, end, SmartyTokenTypes.COMMENT)) {
                return;
            }
            if (this.matchesStartWithLookAhead(this.myStartDelimiter, LEFT_DELIMITER_TAG, offset, end, SmartyElementTypes.TEMPLATE_HTML_TEXT)) {
                this.myState = 9;
                return;
            }
            if (this.matchesStartWithLookAhead(this.myStartDelimiter, RIGHT_DELIMITER_TAG, offset, end, SmartyTokenTypes.SKIP)) {
                this.myState = 10;
                return;
            }
            if (this.matchesStartOrEndDelimiter(offset, end, true)) {
                return;
            }
        } else if (this.myLexerState == 11 || this.myLexerState == 7) {
            if (this.matchesIdentifier(offset, end, SmartyTokenTypes.IDENTIFIER)) {
                String text = this.myBuffer.subSequence(offset, this.myTokenEnd).toString();
                this.myState = this.myLexerState == 11 ? 12 : 13;
                if (SmartyCompletionContributor.getPredefinedFunctions().contains(text)) {
                    this.myTokenType = SmartyTokenTypes.PREDEFINED_FUNCTION;
                    if (LITERAL_TAG.equals(text) && this.myState == 13) {
                        this.myState = 4;
                    }
                }
                return;
            }
            if (this.matchesStart(this.myEndDelimiter, offset, end, SmartyTokenTypes.TAG_END)) {
                this.myState = this.popNested();
                return;
            }
            if (this.matchesStartOrEndDelimiter(offset, end, true)) {
                this.pushNested(true);
                return;
            }
            if (this.matchesWhiteSpaces(offset, end, SmartyTokenTypes.WHITE_SPACE)) {
                LOG.debug("Read whitespace where there should not be one: \nTexct: " + this.myBuffer.subSequence(0, this.myTokenEnd < this.myBuffer.length() ? this.myTokenEnd + 1 : this.myBuffer.length()));
                return;
            }
            if (this.matchesStart("$", offset, end, SmartyTokenTypes.DOLLAR)) {
                this.myState = 13;
                return;
            }
            if (this.matchesStart("(", offset, end, SmartyTokenTypes.L_PAR)) {
                this.myState = 13;
                return;
            }
            if (this.matchesStart("-", offset, end, SmartyTokenTypes.SUB)) {
                this.myState = 13;
                return;
            }
            if (this.matchesStart("!", offset, end, SmartyTokenTypes.NOT)) {
                this.myState = 13;
                return;
            }
            if (this.matchesStart("~", offset, end, SmartyTokenTypes.NOT)) {
                this.myState = 13;
                return;
            }
            if (this.matchesStart("++", offset, end, SmartyTokenTypes.PLUS_PLUS)) {
                this.myState = 13;
                return;
            }
            if (this.matchesStart("--", offset, end, SmartyTokenTypes.MINUS_MINUS)) {
                this.myState = 13;
                return;
            }
            if (this.matchesStart("ne", offset, end, SmartyTokenTypes.NE)) {
                this.myState = 13;
                return;
            }
            if (this.matchesStart("not", offset, end, SmartyTokenTypes.NOT)) {
                this.myState = 13;
                return;
            }
            if (this.matchesStart("#", offset, end, SmartyTokenTypes.SHARP)) {
                this.myState = 13;
                return;
            }
            if (this.matchesStart("'", offset, end, SmartyTokenTypes.SINGLE_QUOTE)) {
                this.myState = 3;
                return;
            }
            if (this.matchesStart("\"", offset, end, SmartyTokenTypes.DOUBLE_QUOTE)) {
                this.pushNested(true);
                this.myState = 1;
                return;
            }
        } else {
            if (this.myLexerState == 4) {
                if (this.matchesWhiteSpaces(offset, end, SmartyTokenTypes.WHITE_SPACE)) {
                    return;
                }
                if (this.matchesStart(this.myEndDelimiter, offset, end, SmartyTokenTypes.TAG_END)) {
                    this.myState = 5;
                    return;
                }
                this.myTokenType = SmartyTokenTypes.BAD_CHARACTER;
                this.myState = 0;
                return;
            }
            if (this.myLexerState == 5) {
                int nextSmartyPiece = CharArrayUtil.indexOf((CharSequence)this.myBuffer, (CharSequence)(this.myStartDelimiter + "/" + LITERAL_TAG + this.myEndDelimiter), (int)this.myTokenStart);
                this.myState = 0;
                this.myTokenEnd = nextSmartyPiece == -1 ? end : nextSmartyPiece;
                this.myTokenType = SmartyElementTypes.TEMPLATE_HTML_TEXT;
                return;
            }
            if (this.myLexerState == 12) {
                if (this.matchesWhiteSpaces(offset, end, SmartyTokenTypes.WHITE_SPACE)) {
                    return;
                }
                if (this.matchesStart(this.myEndDelimiter, offset, end, SmartyTokenTypes.TAG_END)) {
                    this.myState = this.popNested();
                    return;
                }
            } else if (this.myLexerState == 13) {
                Set<Map.Entry<String, IElementType>> entries = mySimpleTokens.entrySet();
                if (this.matchesStart(this.myEndDelimiter, offset, end, SmartyTokenTypes.TAG_END)) {
                    this.myState = this.popNested();
                    return;
                }
                if (this.matchesWhiteSpaces(offset, end, SmartyTokenTypes.WHITE_SPACE)) {
                    return;
                }
                if (this.matchesNumeric(offset, end, SmartyTokenTypes.NUMERIC_LITERAL)) {
                    return;
                }
                int identifierLength = 0;
                IElementType idTokenType = null;
                int idTokenEnd = this.myTokenStart;
                if (this.matchesIdentifier(offset, end, SmartyTokenTypes.IDENTIFIER)) {
                    identifierLength = this.myTokenEnd - this.myTokenStart;
                    idTokenEnd = this.myTokenEnd;
                    idTokenType = this.myTokenType;
                }
                if (this.myTokenStart - 1 >= 0 && this.myBuffer.charAt(this.myTokenStart - 1) != '$') {
                    for (Map.Entry<String, IElementType> entry : entries) {
                        if (!this.matchesStartIgnoreCase(entry.getKey(), offset, end, entry.getValue()) || this.myTokenEnd - this.myTokenStart < identifierLength) continue;
                        return;
                    }
                }
                if (identifierLength != 0) {
                    this.myTokenEnd = idTokenEnd;
                    this.myTokenType = idTokenType;
                    return;
                }
                if (this.matchesStart("\"", offset, end, SmartyTokenTypes.DOUBLE_QUOTE)) {
                    this.pushNested(true);
                    this.myState = 1;
                    return;
                }
                if (this.matchesStart("'", offset, end, SmartyTokenTypes.SINGLE_QUOTE)) {
                    this.myState = 3;
                    return;
                }
                if (this.myStateToReturnFromExpression == 1) {
                    if (this.matchesStart("`", offset, end, SmartyTokenTypes.BACK_QUOTE)) {
                        this.myStateToReturnFromExpression = 0;
                        this.myState = 1;
                        return;
                    }
                } else if (this.matchesStart("`", offset, end, SmartyTokenTypes.BACK_QUOTE)) {
                    this.myStateToReturnFromExpression = 13;
                    return;
                }
                if (this.matchesStartOrEndDelimiter(offset, end, true)) {
                    this.pushNested(true);
                    return;
                }
            } else if (this.myLexerState == 1) {
                if (this.matchesStartOrEndDelimiter(offset, end, true)) {
                    this.pushNested(false);
                    return;
                }
                if (this.matchesStart("\"", offset, end, SmartyTokenTypes.DOUBLE_QUOTE)) {
                    this.popNested();
                    this.myState = 13;
                    return;
                }
                if (this.matchesStart("`", offset, end, SmartyTokenTypes.BACK_QUOTE)) {
                    this.myState = 13;
                    this.myStateToReturnFromExpression = 1;
                    return;
                }
                if (this.matchesStart("$", offset, end, SmartyTokenTypes.DOLLAR)) {
                    this.myState = 2;
                    return;
                }
                if (this.matchesString(offset, end, SmartyTokenTypes.STRING_LITERAL, false)) {
                    return;
                }
            } else if (this.myLexerState == 3) {
                if (this.matchesStart("'", offset, end, SmartyTokenTypes.SINGLE_QUOTE)) {
                    this.myState = 13;
                    return;
                }
                if (this.matchesString(offset, end, SmartyTokenTypes.STRING_LITERAL, true)) {
                    return;
                }
            } else {
                if (this.myLexerState == 2) {
                    if (this.matchesIdentifier(offset, end, SmartyTokenTypes.IDENTIFIER)) {
                        return;
                    }
                    if (this.matchesNumeric(offset, end, SmartyTokenTypes.NUMERIC_LITERAL)) {
                        return;
                    }
                    if (this.matchesStart("[", offset, end, SmartyTokenTypes.L_BRACKET)) {
                        return;
                    }
                    if (this.matchesStart("]", offset, end, SmartyTokenTypes.R_BRACKET)) {
                        return;
                    }
                    if (this.matchesStart("\"", offset, end, SmartyTokenTypes.DOUBLE_QUOTE)) {
                        this.popNested();
                        this.myState = 13;
                        return;
                    }
                    if (this.matchesStart("`", offset, end, SmartyTokenTypes.BACK_QUOTE)) {
                        this.myState = 13;
                        return;
                    }
                    if (this.matchesStart("$", offset, end, SmartyTokenTypes.DOLLAR)) {
                        return;
                    }
                    this.myTokenEnd = offset + 1;
                    this.myState = 1;
                    this.myTokenType = SmartyTokenTypes.STRING_LITERAL;
                    return;
                }
                if (this.myLexerState == 9) {
                    if (this.matchesStart(LEFT_DELIMITER_TAG, offset, end, SmartyTokenTypes.LDELIM)) {
                        return;
                    }
                    if (this.matchesStart(this.myEndDelimiter, offset, end, SmartyTokenTypes.SKIP)) {
                        this.myState = 0;
                        return;
                    }
                } else if (this.myLexerState == 10) {
                    if (this.matchesStart(RIGHT_DELIMITER_TAG, offset, end, SmartyTokenTypes.RDELIM)) {
                        return;
                    }
                    if (this.matchesStart(this.myEndDelimiter, offset, end, SmartyElementTypes.TEMPLATE_HTML_TEXT)) {
                        this.myState = 0;
                        return;
                    }
                }
            }
        }
        if (this.myLexerState == 0) {
            int nextSmartyPiece = this.findSmartyTagOffset(this.myTokenStart);
            this.myTokenEnd = nextSmartyPiece >= 0 ? nextSmartyPiece : end;
            this.myTokenType = SmartyElementTypes.TEMPLATE_HTML_TEXT;
        } else {
            this.myTokenEnd = this.myTokenStart + 1;
            this.myTokenType = SmartyTokenTypes.BAD_CHARACTER;
        }
    }

    private int findSmartyTagOffset(int from) {
        int offset = from;
        while ((offset = CharArrayUtil.indexOf((CharSequence)this.myBuffer, (CharSequence)this.myStartDelimiter, (int)offset)) >= 0) {
            if (this.isValidStarDelimiterAt(offset)) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    private boolean matchesStartOrEndDelimiter(int offset, int end, boolean assignFields) {
        if (CharArrayUtil.regionMatches((CharSequence)this.myBuffer, (int)offset, (int)end, (CharSequence)this.myStartDelimiter) && this.isValidStarDelimiterAt(offset)) {
            int tokenEnd;
            if (assignFields) {
                this.myTokenType = SmartyTokenTypes.START_TAG_START;
            }
            if (assignFields) {
                this.myTokenEnd = offset + this.myStartDelimiter.length();
            }
            if (this.myAllowWhiteSpaces) {
                for (tokenEnd = this.myTokenEnd; tokenEnd < end && Character.isWhitespace(this.myBuffer.charAt(tokenEnd)); ++tokenEnd) {
                }
                if (assignFields) {
                    this.myState = 7;
                }
            } else {
                if (!this.nextNotAWhiteSpace(end)) {
                    if (assignFields) {
                        this.myTokenType = SmartyElementTypes.TEMPLATE_HTML_TEXT;
                    }
                    if (assignFields) {
                        this.myState = 0;
                    }
                    return true;
                }
                if (assignFields) {
                    this.myState = 7;
                }
            }
            if (tokenEnd < end && this.myBuffer.charAt(tokenEnd) == '/') {
                ++tokenEnd;
                if (assignFields) {
                    this.myState = 11;
                }
                if (assignFields) {
                    this.myTokenType = SmartyTokenTypes.END_TAG_START;
                }
                if (assignFields) {
                    this.myTokenEnd = tokenEnd;
                }
                if (!this.myAllowWhiteSpaces && !this.nextNotAWhiteSpace(end)) {
                    if (assignFields) {
                        this.myTokenType = SmartyElementTypes.TEMPLATE_HTML_TEXT;
                    }
                    if (assignFields) {
                        this.myState = 0;
                    }
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    private boolean nextNotAWhiteSpace(int end) {
        return this.myTokenEnd >= end || !Character.isWhitespace(this.myBuffer.charAt(this.myTokenEnd));
    }

    private boolean matchesString(int offset, int end, IElementType tokenType, boolean isSingleQuoted) {
        char c;
        boolean returnValue = false;
        while (offset < end && (c = this.myBuffer.charAt(offset)) != '\r' && c != '\n' && (c != '\\' || offset + 1 < end)) {
            if (c == '\\' && offset + 1 < this.myBuffer.length()) {
                char c2 = this.myBuffer.charAt(offset + 1);
                if (isSingleQuoted && c2 == '\'' || !isSingleQuoted && (c2 == '\"' || c2 == '\\' || c2 == '$')) {
                    offset += 2;
                    returnValue = true;
                    continue;
                }
            }
            if (isSingleQuoted && c == '\'' || !isSingleQuoted && (c == '`' || c == '$' || c == '\"' || this.matchesStartOrEndDelimiter(offset, end, false))) break;
            ++offset;
            returnValue = true;
        }
        if (returnValue) {
            this.myTokenEnd = offset;
            this.myTokenType = tokenType;
        }
        return returnValue;
    }

    private boolean matchesNumeric(int offset, int end, IElementType tokenType) {
        char c = this.myBuffer.charAt(offset);
        if (c == '0') {
            this.matchesPointAndNumeric(++offset, end, tokenType);
            return true;
        }
        if (Character.isDigit(c)) {
            ++offset;
            while (offset < end && Character.isDigit(this.myBuffer.charAt(offset))) {
                ++offset;
            }
            this.myTokenType = tokenType;
            this.myTokenEnd = offset;
            this.matchesPointAndNumeric(offset, end, tokenType);
            return true;
        }
        return false;
    }

    private void matchesPointAndNumeric(int offset, int end, IElementType tokenType) {
        if (offset >= end || this.myBuffer.charAt(offset) != '.') {
            this.myTokenType = tokenType;
            this.myTokenEnd = offset;
        } else {
            ++offset;
            while (offset < end && Character.isDigit(this.myBuffer.charAt(offset))) {
                ++offset;
            }
            this.myTokenType = tokenType;
            this.myTokenEnd = offset;
        }
    }

    private boolean matchesWhiteSpaces(int offset, int end, IElementType tokenType) {
        char c = this.myBuffer.charAt(offset);
        if (Character.isWhitespace(c)) {
            while (++offset < end && Character.isWhitespace(c = this.myBuffer.charAt(offset))) {
            }
            this.myTokenType = tokenType;
            this.myTokenEnd = offset;
            return true;
        }
        return false;
    }

    private boolean matchesIdentifier(int offset, int end, IElementType tokenType) {
        char c = this.myBuffer.charAt(offset);
        if (Character.isLetter(c) || c == '_') {
            while (++offset < end && (Character.isLetterOrDigit(c = this.myBuffer.charAt(offset)) || c == '_')) {
            }
            this.myTokenType = tokenType;
            this.myTokenEnd = offset;
            return true;
        }
        return false;
    }

    private boolean matchesStartWithLookAhead(String prefix, String lookAhead, int offset, int end, IElementType tokenType) {
        boolean returnValue = false;
        if (CharArrayUtil.regionMatches((CharSequence)this.myBuffer, (int)offset, (int)end, (CharSequence)prefix) && this.isValidStarDelimiterAt(offset)) {
            offset += prefix.length();
            if (StringUtil.isEmpty((String)lookAhead)) {
                returnValue = true;
            } else {
                while (offset < end && Character.isWhitespace(this.myBuffer.charAt(offset))) {
                    ++offset;
                }
                returnValue = CharArrayUtil.regionMatches((CharSequence)this.myBuffer, (int)offset, (int)end, (CharSequence)lookAhead);
            }
        }
        if (returnValue) {
            this.myTokenType = tokenType;
            this.myTokenEnd = offset;
        }
        return returnValue;
    }

    private boolean matchesStart(String prefix, int offset, int end, IElementType tokenType) {
        if (CharArrayUtil.regionMatches((CharSequence)this.myBuffer, (int)offset, (int)end, (CharSequence)prefix)) {
            this.myTokenType = tokenType;
            this.myTokenEnd = offset + prefix.length();
            return true;
        }
        return false;
    }

    private boolean matchesStartIgnoreCase(String prefix, int offset, int end, IElementType tokenType) {
        int len = prefix.length();
        if (offset + len > end) {
            return false;
        }
        int prefixEnd = offset + len;
        String region = this.myBuffer.subSequence(offset, prefixEnd).toString();
        if (region.equalsIgnoreCase(prefix)) {
            this.myTokenType = tokenType;
            this.myTokenEnd = offset + prefix.length();
            return true;
        }
        return false;
    }

    private boolean matches(String prefix, String suffix, int offset, int end, IElementType tokenType) {
        if (CharArrayUtil.regionMatches((CharSequence)this.myBuffer, (int)offset, (int)end, (CharSequence)prefix)) {
            offset += prefix.length();
            char firstCharInSuffix = suffix.charAt(0);
            while (offset < end) {
                char c = this.myBuffer.charAt(offset);
                if (c == firstCharInSuffix && CharArrayUtil.regionMatches((CharSequence)this.myBuffer, (int)offset, (int)end, (CharSequence)suffix)) {
                    this.myTokenType = tokenType;
                    this.myTokenEnd = offset + suffix.length();
                    return true;
                }
                ++offset;
            }
        }
        return false;
    }

    private boolean isValidStarDelimiterAt(int offset) {
        int nextOffset;
        if ("{".equals(this.myStartDelimiter) && !this.myAllowWhiteSpaces && (nextOffset = offset + 1) < this.myBuffer.length()) {
            char next = this.myBuffer.charAt(nextOffset);
            if (Character.isWhitespace(next)) {
                return false;
            }
            if (next == '/' && ++nextOffset < this.myBuffer.length() && Character.isWhitespace(this.myBuffer.charAt(nextOffset))) {
                return false;
            }
        }
        return true;
    }

    static {
        mySimpleTokens.put("is not even by", SmartyTokenTypes.IS_NOT_EVEN_BY);
        mySimpleTokens.put("is not div by", SmartyTokenTypes.IS_NOT_DIV_BY);
        mySimpleTokens.put("is not odd by", SmartyTokenTypes.IS_NOT_ODD_BY);
        mySimpleTokens.put("is not even", SmartyTokenTypes.IS_NOT_EVEN);
        mySimpleTokens.put("is even by", SmartyTokenTypes.IS_EVEN_BY);
        mySimpleTokens.put("is not odd", SmartyTokenTypes.IS_NOT_ODD);
        mySimpleTokens.put("is odd by", SmartyTokenTypes.IS_ODD_BY);
        mySimpleTokens.put("is div by", SmartyTokenTypes.IS_DIV_BY);
        mySimpleTokens.put("is even", SmartyTokenTypes.IS_EVEN);
        mySimpleTokens.put("is odd", SmartyTokenTypes.IS_ODD);
        mySimpleTokens.put("false", SmartyTokenTypes.BOOLEAN_VALUE);
        mySimpleTokens.put("true", SmartyTokenTypes.BOOLEAN_VALUE);
        mySimpleTokens.put("===", SmartyTokenTypes.IDENTICAL);
        mySimpleTokens.put("!==", SmartyTokenTypes.NOT_IDENTICAL);
        mySimpleTokens.put("and", SmartyTokenTypes.AND_KEYWORD);
        mySimpleTokens.put("xor", SmartyTokenTypes.XOR_KEYWORD);
        mySimpleTokens.put("neq", SmartyTokenTypes.NEQ_KEYWORD);
        mySimpleTokens.put("lte", SmartyTokenTypes.LTE_KEYWORD);
        mySimpleTokens.put("gte", SmartyTokenTypes.GTE_KEYWORD);
        mySimpleTokens.put("not", SmartyTokenTypes.NOT_KEYWORD);
        mySimpleTokens.put("mod", SmartyTokenTypes.MOD_KEYWORD);
        mySimpleTokens.put("yes", SmartyTokenTypes.BOOLEAN_VALUE);
        mySimpleTokens.put("off", SmartyTokenTypes.BOOLEAN_VALUE);
        mySimpleTokens.put("or", SmartyTokenTypes.OR_KEYWORD);
        mySimpleTokens.put("eq", SmartyTokenTypes.EQ_KEYWORD);
        mySimpleTokens.put("ne", SmartyTokenTypes.NE_KEYWORD);
        mySimpleTokens.put("lt", SmartyTokenTypes.LT_KEYWORD);
        mySimpleTokens.put("gt", SmartyTokenTypes.GT_KEYWORD);
        mySimpleTokens.put("ge", SmartyTokenTypes.GE_KEYWORD);
        mySimpleTokens.put("le", SmartyTokenTypes.LE_KEYWORD);
        mySimpleTokens.put("on", SmartyTokenTypes.BOOLEAN_VALUE);
        mySimpleTokens.put("no", SmartyTokenTypes.BOOLEAN_VALUE);
        mySimpleTokens.put("as", SmartyTokenTypes.AS_KEYWORD);
        mySimpleTokens.put("!=", SmartyTokenTypes.NE);
        mySimpleTokens.put(">=", SmartyTokenTypes.GE);
        mySimpleTokens.put("<=", SmartyTokenTypes.LE);
        mySimpleTokens.put("==", SmartyTokenTypes.EQ_EQ);
        mySimpleTokens.put("=>", SmartyTokenTypes.ARRAY_ASSIGNMENT);
        mySimpleTokens.put("++", SmartyTokenTypes.PLUS_PLUS);
        mySimpleTokens.put("--", SmartyTokenTypes.MINUS_MINUS);
        mySimpleTokens.put(">>", SmartyTokenTypes.R_SHIFT);
        mySimpleTokens.put("<<", SmartyTokenTypes.L_SHIFT);
        mySimpleTokens.put("->", SmartyTokenTypes.ARROW);
        mySimpleTokens.put("&&", SmartyTokenTypes.AND_AND);
        mySimpleTokens.put("||", SmartyTokenTypes.OR_OR);
        mySimpleTokens.put("::", SmartyTokenTypes.COLON_COLON);
        mySimpleTokens.put(":", SmartyTokenTypes.DOT_DOT);
        mySimpleTokens.put(";", SmartyTokenTypes.SEMICOLON);
        mySimpleTokens.put("#", SmartyTokenTypes.SHARP);
        mySimpleTokens.put("[", SmartyTokenTypes.L_BRACKET);
        mySimpleTokens.put("]", SmartyTokenTypes.R_BRACKET);
        mySimpleTokens.put("(", SmartyTokenTypes.L_PAR);
        mySimpleTokens.put(")", SmartyTokenTypes.R_PAR);
        mySimpleTokens.put("$", SmartyTokenTypes.DOLLAR);
        mySimpleTokens.put("=", SmartyTokenTypes.EQ);
        mySimpleTokens.put(">", SmartyTokenTypes.GT);
        mySimpleTokens.put("<", SmartyTokenTypes.LT);
        mySimpleTokens.put(".", SmartyTokenTypes.DOT);
        mySimpleTokens.put("+", SmartyTokenTypes.ADD);
        mySimpleTokens.put("-", SmartyTokenTypes.SUB);
        mySimpleTokens.put("*", SmartyTokenTypes.MUL);
        mySimpleTokens.put("/", SmartyTokenTypes.DIV);
        mySimpleTokens.put("%", SmartyTokenTypes.MOD);
        mySimpleTokens.put("@", SmartyTokenTypes.SILENCE);
        mySimpleTokens.put("!", SmartyTokenTypes.NOT);
        mySimpleTokens.put("|", SmartyTokenTypes.OR);
        mySimpleTokens.put("&", SmartyTokenTypes.AND);
        mySimpleTokens.put("^", SmartyTokenTypes.XOR);
        mySimpleTokens.put(",", SmartyTokenTypes.COMMA);
        mySimpleTokens.put("~", SmartyTokenTypes.BIT_NOT);
        mySimpleTokens.put("?", SmartyTokenTypes.QUESTION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/smarty/lang/lexer/SmartyCustomDelimiterLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/smarty/lang/lexer/SmartyCustomDelimiterLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

