/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolValidationInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityToolAnnotatorInfo {
    private String myTempFile;
    private final VirtualFile myOriginalFile;
    private final PsiFile myPsiFile;
    @NotNull
    private final QualityToolValidationInspection myInspection;
    @NotNull
    private final Project myProject;
    private boolean myIsOnTheFly;
    private PsiElement myContextElement;
    private final String myInterpreterId;
    private final String myToolPath;
    private final int myMaxMessagesPerFile;
    private final int myTimeout;

    public QualityToolAnnotatorInfo(@NotNull PsiFile psiFile, @NotNull QualityToolValidationInspection inspection, @NotNull Project project, @Nullable String interpreterId, @NotNull String toolPath, int maxMessagesPerFile, int timeout, boolean isOnTheFly) {
        if (psiFile == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(0);
        }
        if (inspection == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(1);
        }
        if (project == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(2);
        }
        if (toolPath == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(3);
        }
        this.myIsOnTheFly = true;
        this.myInspection = inspection;
        this.myProject = project;
        this.myPsiFile = psiFile;
        this.myOriginalFile = psiFile.getVirtualFile();
        this.myInterpreterId = interpreterId;
        this.myToolPath = toolPath;
        this.myMaxMessagesPerFile = maxMessagesPerFile;
        this.myTimeout = timeout;
        this.myIsOnTheFly = isOnTheFly;
    }

    public QualityToolAnnotatorInfo(@NotNull PsiFile psiFile, @NotNull QualityToolValidationInspection inspection, @NotNull Project project, @NotNull QualityToolConfiguration configuration, boolean isOnTheFly) {
        if (psiFile == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(4);
        }
        if (inspection == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(5);
        }
        if (project == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(6);
        }
        if (configuration == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(7);
        }
        this(psiFile, inspection, project, configuration.getInterpreterId(), configuration.getToolPath(), configuration.getMaxMessagesPerFile(), configuration.getTimeout(), isOnTheFly);
    }

    public String getFile() {
        return this.myTempFile;
    }

    public String getFilePath() {
        return PathUtil.toSystemIndependentName((String)this.myTempFile);
    }

    public PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    @NotNull
    public QualityToolValidationInspection getInspection() {
        QualityToolValidationInspection qualityToolValidationInspection = this.myInspection;
        if (qualityToolValidationInspection == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(8);
        }
        return qualityToolValidationInspection;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(9);
        }
        return project;
    }

    @Nullable
    public String getInterpreterId() {
        return this.myInterpreterId;
    }

    @NotNull
    public String getToolPath() {
        String string = this.myToolPath;
        if (string == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(10);
        }
        return string;
    }

    public VirtualFile getOriginalFile() {
        return this.myOriginalFile;
    }

    public String getFileName() {
        return QualityToolAnnotatorInfo.truncateExtension(PathUtil.getFileName((String)this.myTempFile));
    }

    public String getOriginalFileName() {
        return QualityToolAnnotatorInfo.truncateExtension(this.myOriginalFile.getName());
    }

    private static String truncateExtension(@NotNull String fileName) {
        int extPos;
        if (fileName == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(11);
        }
        return (extPos = fileName.lastIndexOf(".")) >= 0 ? fileName.substring(0, extPos) : fileName;
    }

    public boolean isOnTheFly() {
        return this.myIsOnTheFly;
    }

    public void setTempFile(@NotNull String tempFile) {
        if (tempFile == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(12);
        }
        this.myTempFile = tempFile;
    }

    public PsiElement getContextElement() {
        return this.myContextElement;
    }

    public void setContextElement(PsiElement contextElement) {
        this.myContextElement = contextElement;
    }

    public int getMaxMessagesPerFile() {
        return this.myMaxMessagesPerFile;
    }

    public int getTimeout() {
        return this.myTimeout;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolAnnotatorInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolAnnotatorInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "truncateExtension";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTempFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

