/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.run.PhpCommandLineSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PhpCommandLineConfigurationEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.run.PhpCommandLineConfigurationEditor");
    public static final String INTERPRETER_OPTIONS_HELP_URL = "http://php.net/manual/en/features.commandline.options.php";
    private RawCommandLineEditor myInterpreterOptionsEditor;
    private TextFieldWithBrowseButton myCustomWorkingDirectoryTextField;
    private EnvironmentVariablesComponent myEnvVariablesEditor;
    private JPanel myMainPanel;
    private FixedSizeButton myInterpreterOptionsHelpButton;
    private boolean myInitialized = false;

    public PhpCommandLineConfigurationEditor() {
        this.$$$setupUI$$$();
        this.myInterpreterOptionsEditor.setDialogCaption(PhpBundle.message("PhpCommandLineConfigurationEditor.interpreter.options.editor.dialog.caption", new Object[0]));
    }

    public void init(@NotNull Project project) {
        if (project == null) {
            PhpCommandLineConfigurationEditor.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(!this.myInitialized, (Object)"component is already initialized");
        this.myInitialized = true;
        this.myInterpreterOptionsHelpButton.setIcon(UIUtil.getBalloonInformationIcon());
        this.myInterpreterOptionsHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.browse((String)PhpCommandLineConfigurationEditor.INTERPRETER_OPTIONS_HELP_URL);
            }
        });
        this.myCustomWorkingDirectoryTextField.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
    }

    public void resetEditorFrom(@NotNull PhpCommandLineSettings commandLineSettings) {
        if (commandLineSettings == null) {
            PhpCommandLineConfigurationEditor.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(this.myInitialized, (Object)"component is not initialized");
        this.myInterpreterOptionsEditor.setText(commandLineSettings.getParameters());
        this.myCustomWorkingDirectoryTextField.setText(commandLineSettings.getWorkingDirectory());
        this.myEnvVariablesEditor.setEnvs(commandLineSettings.getEnvs());
        this.myEnvVariablesEditor.setPassParentEnvs(commandLineSettings.isPassParentEnvs());
    }

    public void applyEditorTo(@NotNull PhpCommandLineSettings commandLineSettings) throws ConfigurationException {
        if (commandLineSettings == null) {
            PhpCommandLineConfigurationEditor.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(this.myInitialized, (Object)"component is not initialized");
        commandLineSettings.setParameters(this.myInterpreterOptionsEditor.getText());
        commandLineSettings.setWorkingDirectory(this.myCustomWorkingDirectoryTextField.getText());
        commandLineSettings.setEnvs(this.myEnvVariablesEditor.getEnvs());
        commandLineSettings.setPassParentEnvs(this.myEnvVariablesEditor.isPassParentEnvs());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineSettings";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/run/PhpCommandLineConfigurationEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EnvironmentVariablesComponent environmentVariablesComponent;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        FixedSizeButton fixedSizeButton;
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/PhpBundle").getString("PhpCommandLineConfigurationEditor.command.line"), (int)0, (int)0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpCommandLineConfigurationEditor.field.interpreter.options"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myInterpreterOptionsEditor = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel4.add((Component)rawCommandLineEditor, "Center");
        this.myInterpreterOptionsHelpButton = fixedSizeButton = new FixedSizeButton();
        jPanel4.add((Component)fixedSizeButton, "East");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpCommandLineConfigurationEditor.field.custom.working.directory"));
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCustomWorkingDirectoryTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myEnvVariablesEditor = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        environmentVariablesComponent.setPassParentEnvs(false);
        environmentVariablesComponent.setText(ResourceBundle.getBundle("messages/PhpBundle").getString("PhpCommandLineConfigurationEditor.field.environment.variables"));
        jPanel6.add((Component)environmentVariablesComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        environmentVariablesComponent.setAnchor((JComponent)jLabel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

