/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.impl.httpclient.TaskResponseUtil;
import com.intellij.tasks.trello.TrelloTask;
import com.intellij.tasks.trello.TrelloUtil;
import com.intellij.tasks.trello.model.TrelloBoard;
import com.intellij.tasks.trello.model.TrelloCard;
import com.intellij.tasks.trello.model.TrelloList;
import com.intellij.tasks.trello.model.TrelloUser;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="Trello")
public final class TrelloRepository
extends NewBaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance(TrelloRepository.class);
    static final TrelloBoard UNSPECIFIED_BOARD = new TrelloBoard(){

        @Override
        @NotNull
        public String getName() {
            if ("-- from all boards --" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "-- from all boards --";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository$1", "getName"));
        }
    };
    static final TrelloList UNSPECIFIED_LIST = new TrelloList(){

        @Override
        @NotNull
        public String getName() {
            if ("-- from all lists --" == null) {
                2.$$$reportNull$$$0(0);
            }
            return "-- from all lists --";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository$2", "getName"));
        }
    };
    private TrelloUser myCurrentUser;
    private TrelloBoard myCurrentBoard;
    private TrelloList myCurrentList;
    private boolean myIncludeAllCards;

    public TrelloRepository() {
    }

    public TrelloRepository(TaskRepositoryType type) {
        super(type);
    }

    public TrelloRepository(TrelloRepository other) {
        super(other);
        this.myCurrentUser = other.myCurrentUser;
        this.myCurrentBoard = other.myCurrentBoard;
        this.myCurrentList = other.myCurrentList;
        this.myIncludeAllCards = other.myIncludeAllCards;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        TrelloRepository repository = (TrelloRepository)((Object)o);
        if (!Comparing.equal((Object)this.myCurrentUser, (Object)repository.myCurrentUser)) {
            return false;
        }
        if (!Comparing.equal((Object)this.myCurrentBoard, (Object)repository.myCurrentBoard)) {
            return false;
        }
        if (!Comparing.equal((Object)this.myCurrentList, (Object)repository.myCurrentList)) {
            return false;
        }
        return this.myIncludeAllCards == repository.myIncludeAllCards;
    }

    @NotNull
    public BaseRepository clone() {
        TrelloRepository trelloRepository = new TrelloRepository(this);
        if (trelloRepository == null) {
            TrelloRepository.$$$reportNull$$$0(0);
        }
        return trelloRepository;
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed) throws Exception {
        List<TrelloCard> cards = this.fetchCards(offset + limit, withClosed);
        return (Task[])ContainerUtil.map2Array(cards, Task.class, card -> new TrelloTask((TrelloCard)card, (TaskRepository)this));
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        TrelloCard card;
        if (id == null) {
            TrelloRepository.$$$reportNull$$$0(1);
        }
        return (card = this.fetchCardById(id)) != null ? new TrelloTask(card, (TaskRepository)this) : null;
    }

    @Nullable
    public TrelloCard fetchCardById(@NotNull String id) throws Exception {
        if (id == null) {
            TrelloRepository.$$$reportNull$$$0(2);
        }
        try {
            URIBuilder url = new URIBuilder(this.getRestApiUrl("cards", id)).addParameter("actions", "commentCard").addParameter("fields", "closed,desc,idMembers,idBoard,idList,idShort,labels,name,url,dateLastActivity");
            return this.executeMethod((HttpUriRequest)new HttpGet(url.build()), new TaskResponseUtil.GsonSingleObjectDeserializer<TrelloCard>(TrelloUtil.GSON, TrelloCard.class, true));
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    @Nullable
    public TrelloUser getCurrentUser() {
        return this.myCurrentUser;
    }

    public void setCurrentUser(TrelloUser currentUser) {
        this.myCurrentUser = currentUser;
    }

    @Nullable
    public TrelloBoard getCurrentBoard() {
        return this.myCurrentBoard;
    }

    public void setCurrentBoard(@Nullable TrelloBoard board) {
        this.myCurrentBoard = board != null && board.getId().equals(UNSPECIFIED_BOARD.getId()) ? UNSPECIFIED_BOARD : board;
    }

    @Nullable
    public TrelloList getCurrentList() {
        return this.myCurrentList;
    }

    public void setCurrentList(@Nullable TrelloList list) {
        this.myCurrentList = list != null && list.getId().equals(UNSPECIFIED_LIST.getId()) ? UNSPECIFIED_LIST : list;
    }

    @Nullable
    public String extractId(@NotNull String taskName) {
        if (taskName == null) {
            TrelloRepository.$$$reportNull$$$0(3);
        }
        return TrelloUtil.TRELLO_ID_PATTERN.matcher(taskName).matches() ? taskName : null;
    }

    @NotNull
    public TrelloUser fetchUserByToken() throws Exception {
        TrelloUser trelloUser;
        try {
            URIBuilder url = new URIBuilder(this.getRestApiUrl("members", "me")).addParameter("fields", "username");
            trelloUser = (TrelloUser)ObjectUtils.assertNotNull((Object)this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloUser.class));
        }
        catch (Exception e) {
            LOG.warn("Error while fetching initial user info", (Throwable)e);
            this.myCurrentBoard = null;
            this.myCurrentList = null;
            throw e;
        }
        if (trelloUser == null) {
            TrelloRepository.$$$reportNull$$$0(4);
        }
        return trelloUser;
    }

    @NotNull
    public TrelloBoard fetchBoardById(@NotNull String id) throws Exception {
        TrelloBoard trelloBoard;
        if (id == null) {
            TrelloRepository.$$$reportNull$$$0(5);
        }
        URIBuilder url = new URIBuilder(this.getRestApiUrl("boards", id)).addParameter("fields", "closed,name,idOrganization");
        try {
            trelloBoard = (TrelloBoard)ObjectUtils.assertNotNull((Object)this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloBoard.class));
        }
        catch (Exception e) {
            LOG.warn("Error while fetching initial board info", (Throwable)e);
            throw e;
        }
        if (trelloBoard == null) {
            TrelloRepository.$$$reportNull$$$0(6);
        }
        return trelloBoard;
    }

    @NotNull
    public TrelloList fetchListById(@NotNull String id) throws Exception {
        TrelloList trelloList;
        if (id == null) {
            TrelloRepository.$$$reportNull$$$0(7);
        }
        URIBuilder url = new URIBuilder(this.getRestApiUrl("lists", id)).addParameter("fields", "closed,name,idBoard");
        try {
            trelloList = (TrelloList)ObjectUtils.assertNotNull((Object)this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloList.class));
        }
        catch (Exception e) {
            LOG.warn("Error while fetching initial list info" + id, (Throwable)e);
            throw e;
        }
        if (trelloList == null) {
            TrelloRepository.$$$reportNull$$$0(8);
        }
        return trelloList;
    }

    @NotNull
    public List<TrelloList> fetchBoardLists() throws Exception {
        if (this.myCurrentBoard == null || this.myCurrentBoard == UNSPECIFIED_BOARD) {
            throw new IllegalStateException("Board not set");
        }
        List<TrelloList> list = this.fetchBoardLists(this.myCurrentBoard.getId());
        if (list == null) {
            TrelloRepository.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private List<TrelloList> fetchBoardLists(@NotNull String boardId) throws Exception {
        if (boardId == null) {
            TrelloRepository.$$$reportNull$$$0(10);
        }
        URIBuilder url = new URIBuilder(this.getRestApiUrl("boards", boardId, "lists")).addParameter("fields", "closed,name,idBoard");
        List<TrelloList> list = this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloUtil.LIST_OF_LISTS_TYPE);
        if (list == null) {
            TrelloRepository.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<TrelloBoard> fetchUserBoards() throws Exception {
        if (this.myCurrentUser == null) {
            throw new IllegalStateException("User not set");
        }
        URIBuilder url = new URIBuilder(this.getRestApiUrl("members", "me", "boards")).addParameter("filter", "open").addParameter("fields", "closed,name,idOrganization");
        List<TrelloBoard> list = this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloUtil.LIST_OF_BOARDS_TYPE);
        if (list == null) {
            TrelloRepository.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<TrelloCard> fetchCards(int limit, boolean withClosed) throws Exception {
        String baseUrl;
        boolean fromList = false;
        if (this.myCurrentList != null && this.myCurrentList != UNSPECIFIED_LIST) {
            baseUrl = this.getRestApiUrl("lists", this.myCurrentList.getId(), "cards");
            fromList = true;
        } else if (this.myCurrentBoard != null && this.myCurrentBoard != UNSPECIFIED_BOARD) {
            baseUrl = this.getRestApiUrl("boards", this.myCurrentBoard.getId(), "cards");
        } else if (this.myCurrentUser != null) {
            baseUrl = this.getRestApiUrl("members", "me", "cards");
        } else {
            throw new IllegalStateException("Not configured");
        }
        URIBuilder fetchCardUrl = new URIBuilder(baseUrl).addParameter("fields", "closed,desc,idMembers,idBoard,idList,idShort,labels,name,url,dateLastActivity").addParameter("limit", String.valueOf(limit));
        if (withClosed || fromList) {
            fetchCardUrl.addParameter("filter", "all");
        } else {
            fetchCardUrl.addParameter("filter", "visible");
        }
        List cards = this.makeRequestAndDeserializeJsonResponse(fetchCardUrl.build(), TrelloUtil.LIST_OF_CARDS_TYPE);
        LOG.debug("Total " + cards.size() + " cards downloaded");
        if (!this.myIncludeAllCards) {
            cards = ContainerUtil.filter(cards, card -> card.getIdMembers().contains(this.myCurrentUser.getId()));
            LOG.debug("Total " + cards.size() + " cards after filtering");
        }
        if (!cards.isEmpty()) {
            if (fromList) {
                baseUrl = this.getRestApiUrl("boards", ((TrelloCard)cards.get(0)).getIdBoard(), "cards");
            }
            URIBuilder visibleCardsUrl = new URIBuilder(baseUrl).addParameter("filter", "visible").addParameter("fields", "none");
            List<TrelloCard> visibleCards = this.makeRequestAndDeserializeJsonResponse(visibleCardsUrl.build(), TrelloUtil.LIST_OF_CARDS_TYPE);
            LOG.debug("Total " + visibleCards.size() + " visible cards");
            Set visibleCardsIDs = ContainerUtil.map2Set(visibleCards, card -> card.getId());
            for (TrelloCard card2 : cards) {
                card2.setVisible(visibleCardsIDs.contains(card2.getId()));
            }
        }
        List list = cards;
        if (list == null) {
            TrelloRepository.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    private <T> T executeMethod(@NotNull HttpUriRequest method, @NotNull ResponseHandler<T> handler) throws Exception {
        HttpClient client;
        HttpResponse response;
        StatusLine statusLine;
        if (method == null) {
            TrelloRepository.$$$reportNull$$$0(14);
        }
        if (handler == null) {
            TrelloRepository.$$$reportNull$$$0(15);
        }
        if ((statusLine = (response = (client = this.getHttpClient()).execute(method)).getStatusLine()).getStatusCode() != 200) {
            Header header = response.getFirstHeader("Content-Type");
            if (header != null && header.getValue().startsWith("text/plain")) {
                String entityContent = TaskResponseUtil.getResponseContentAsString(response);
                throw new Exception(TaskBundle.message((String)"failure.server.message", (Object[])new Object[]{StringUtil.capitalize((String)entityContent)}));
            }
            throw new Exception(TaskBundle.message((String)"failure.http.error", (Object[])new Object[]{statusLine.getStatusCode(), statusLine.getStatusCode()}));
        }
        return (T)handler.handleResponse(response);
    }

    @NotNull
    private <T> List<T> makeRequestAndDeserializeJsonResponse(@NotNull URI url, @NotNull TypeToken<List<T>> type) throws Exception {
        if (url == null) {
            TrelloRepository.$$$reportNull$$$0(16);
        }
        if (type == null) {
            TrelloRepository.$$$reportNull$$$0(17);
        }
        List result = (List)this.executeMethod((HttpUriRequest)new HttpGet(url), new TaskResponseUtil.GsonMultipleObjectsDeserializer<T>(TrelloUtil.GSON, type));
        List list = (List)ObjectUtils.assertNotNull((Object)result);
        if (list == null) {
            TrelloRepository.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Nullable
    private <T> T makeRequestAndDeserializeJsonResponse(@NotNull URI url, @NotNull Class<T> cls) throws Exception {
        if (url == null) {
            TrelloRepository.$$$reportNull$$$0(19);
        }
        if (cls == null) {
            TrelloRepository.$$$reportNull$$$0(20);
        }
        return this.executeMethod((HttpUriRequest)new HttpGet(url), new TaskResponseUtil.GsonSingleObjectDeserializer<T>(TrelloUtil.GSON, cls));
    }

    public String getPresentableName() {
        String pseudoUrl = "trello.com";
        if (this.myCurrentBoard != null && this.myCurrentBoard != UNSPECIFIED_BOARD) {
            pseudoUrl = pseudoUrl + "/" + this.myCurrentBoard.getName();
        }
        if (this.myCurrentList != null && this.myCurrentList != UNSPECIFIED_LIST) {
            pseudoUrl = pseudoUrl + "/" + this.myCurrentList.getName();
        }
        return pseudoUrl;
    }

    public boolean isIncludeAllCards() {
        return this.myIncludeAllCards;
    }

    public void setIncludeAllCards(boolean includeAllCards) {
        this.myIncludeAllCards = includeAllCards;
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new NewBaseRepositoryImpl.HttpTestConnection((HttpRequestBase)new HttpGet(this.getRestApiUrl("members", "me", "cards") + "?limit=1"));
    }

    @Override
    @Nullable
    protected HttpRequestInterceptor createRequestInterceptor() {
        return new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (request instanceof HttpRequestWrapper) {
                    HttpRequestWrapper wrapper = (HttpRequestWrapper)request;
                    try {
                        wrapper.setURI(new URIBuilder(wrapper.getURI()).addParameter("token", TrelloRepository.this.myPassword).addParameter("key", "d6ec3709f7141007e150de64d4701181").build());
                    }
                    catch (URISyntaxException e) {
                        LOG.error("Illegal URL: " + wrapper.getURI(), (Throwable)e);
                    }
                } else {
                    LOG.error("Cannot add required authentication query parameters to request: " + request);
                }
            }
        };
    }

    public boolean isConfigured() {
        return super.isConfigured() && StringUtil.isNotEmpty((String)this.myPassword);
    }

    @Override
    @NotNull
    public String getRestApiPathPrefix() {
        if ("/1" == null) {
            TrelloRepository.$$$reportNull$$$0(21);
        }
        return "/1";
    }

    public String getUrl() {
        return "https://api.trello.com";
    }

    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        TrelloCard card;
        if (task == null) {
            TrelloRepository.$$$reportNull$$$0(22);
        }
        if ((card = this.fetchCardById(task.getId())) != null) {
            List<TrelloList> lists = this.fetchBoardLists(card.getIdBoard());
            HashSet<CustomTaskState> result = new HashSet<CustomTaskState>();
            for (TrelloList list : lists) {
                if (list.getId().equals(card.getIdList())) continue;
                result.add(new CustomTaskState(list.getId(), list.getName()));
            }
            HashSet<CustomTaskState> hashSet = result;
            if (hashSet == null) {
                TrelloRepository.$$$reportNull$$$0(23);
            }
            return hashSet;
        }
        Set<CustomTaskState> set = Collections.emptySet();
        if (set == null) {
            TrelloRepository.$$$reportNull$$$0(24);
        }
        return set;
    }

    public void setTaskState(@NotNull Task task, @NotNull CustomTaskState state) throws Exception {
        if (task == null) {
            TrelloRepository.$$$reportNull$$$0(25);
        }
        if (state == null) {
            TrelloRepository.$$$reportNull$$$0(26);
        }
        URI url = new URIBuilder(this.getRestApiUrl("cards", task.getId(), "idList")).addParameter("value", state.getId()).build();
        HttpResponse response = this.getHttpClient().execute((HttpUriRequest)new HttpPut(url));
        if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 401 && EntityUtils.toString((HttpEntity)response.getEntity()).trim().equals("unauthorized card permission requested")) {
            throw new Exception(TaskBundle.message((String)"trello.failure.write.access.required", (Object[])new Object[0]));
        }
    }

    protected int getFeatures() {
        return super.getFeatures() & 0xFFFFFFEF | 8;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/trello/TrelloRepository";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boardId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/trello/TrelloRepository";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchUserByToken";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchBoardById";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchListById";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchBoardLists";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchUserBoards";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCards";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "makeRequestAndDeserializeJsonResponse";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestApiPathPrefix";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTaskStates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fetchCardById";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fetchBoardById";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fetchListById";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fetchBoardLists";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeMethod";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "makeRequestAndDeserializeJsonResponse";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTaskStates";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setTaskState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

