/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.injection.BladeInjectionMappingService;
import com.jetbrains.php.blade.psi.BladeTokenSets;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.lang.lexer.PhpLexer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeCustomizedLexer
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(BladeCustomizedLexer.class);
    private static final int IN_PHP_STATE_CONSTANT;
    private static final int NOT_IN_HTML_STATE_CONSTANT;
    private static final int MAX_STATE_CONSTANT;
    private final Matcher[] myInitialMatchers;
    private final char[] myHtmlStopChars;
    private final String myTextBlockEndDelimiter;
    private final String myRawTextBlockEndDelimiter;
    private final String myEscapedTextBlockEndDelimiter;
    protected CharSequence myBuffer;
    private int myBufferEnd;
    private State myState;
    private State myNextState;
    private IElementType myTokenType;
    protected int myTokenStart;
    private int myTokenEnd;
    private boolean inPhp;
    private boolean insideHtmlText;
    private int directiveParenCounter;
    private PhpLexer myPhpLexer;

    public static BladeCustomizedLexer newInstance(@Nullable Project project) {
        BladeInjectionMappingService service = BladeInjectionMappingService.getInstance(project);
        BladeInjectionMappingService.BladeState state = service.getState();
        return new BladeCustomizedLexer(state.getTextBlockStart(), state.getTextBlockEnd(), state.getRawTextBlockStart(), state.getRawTextBlockEnd(), state.getEscapedTextBlockStart(), state.getEscapedTextBlockEnd(), service.getDirectiveInfos());
    }

    /*
     * WARNING - void declaration
     */
    private BladeCustomizedLexer(String textBlockStartDelimiter, String textBlockEndDelimiter, String rawTextBlockStartDelimiter, String rawTextBlockEndDelimiter, String escapedTextBlockStartDelimiter, String escapedTextBlockEndDelimiter, Map<String, BladeInjectionInfo> list) {
        this.myTextBlockEndDelimiter = textBlockEndDelimiter;
        this.myRawTextBlockEndDelimiter = rawTextBlockEndDelimiter;
        this.myEscapedTextBlockEndDelimiter = escapedTextBlockEndDelimiter;
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        matchers.add(new CommentMatcher());
        matchers.add(new PhpBeginningMatcher());
        matchers.add(new PhpFinalMatcher());
        HashSet directives = new HashSet();
        for (String string : list.keySet()) {
            directives.add(string.toLowerCase(Locale.ENGLISH));
        }
        matchers.add(new DirectiveMatcher((Set)directives));
        if (BladeCustomizedLexer.isMatcherReasonable(textBlockStartDelimiter, textBlockEndDelimiter)) {
            matchers.add(0, new SomeTextBlockMatcher(textBlockStartDelimiter, BladeTokenTypes.TEXT_BLOCK_START, State.TEXT_BLOCK));
        }
        if (BladeCustomizedLexer.isMatcherReasonable(escapedTextBlockStartDelimiter, escapedTextBlockEndDelimiter)) {
            matchers.add(0, new SomeTextBlockMatcher(escapedTextBlockStartDelimiter, BladeTokenTypes.ESCAPED_TEXT_BLOCK_START, State.ESCAPED_TEXT_BLOCK));
        }
        if (BladeCustomizedLexer.isMatcherReasonable(rawTextBlockStartDelimiter, rawTextBlockEndDelimiter)) {
            matchers.add(0, new SomeTextBlockMatcher(rawTextBlockStartDelimiter, BladeTokenTypes.RAW_TEXT_BLOCK_START, State.RAW_TEXT_BLOCK));
        }
        this.myInitialMatchers = matchers.toArray(new Matcher[0]);
        HashSet htmlStopChars = new HashSet();
        for (Matcher matcher : this.myInitialMatchers) {
            matcher.registerHtmlStopChars((Collection<Character>)htmlStopChars);
        }
        this.myHtmlStopChars = new char[htmlStopChars.size()];
        boolean bl = false;
        for (Character aChar : htmlStopChars) {
            void var11_14;
            this.myHtmlStopChars[var11_14] = aChar.charValue();
            ++var11_14;
        }
    }

    private static boolean isMatcherReasonable(@Nullable String start, @Nullable String end) {
        return BladeCustomizedLexer.isDelimiterReasonable(start) && BladeCustomizedLexer.isDelimiterReasonable(end);
    }

    public static boolean isDelimiterReasonable(@Nullable String delimiter) {
        return !StringUtil.isEmptyOrSpaces((String)delimiter);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            BladeCustomizedLexer.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myTokenType = null;
        this.myTokenStart = startOffset;
        this.myTokenEnd = startOffset;
        this.myBufferEnd = endOffset;
        int state = initialState;
        if (initialState >= NOT_IN_HTML_STATE_CONSTANT) {
            this.insideHtmlText = false;
            initialState -= NOT_IN_HTML_STATE_CONSTANT;
        } else {
            this.insideHtmlText = true;
        }
        if (initialState >= IN_PHP_STATE_CONSTANT) {
            this.startPhpPart();
            initialState -= IN_PHP_STATE_CONSTANT;
        } else {
            this.inPhp = false;
        }
        this.myNextState = this.myState = State.getByCode(initialState, state);
    }

    public int getState() {
        if (this.myTokenType == null) {
            this.locateToken();
            if (this.myTokenStart < this.myBufferEnd) {
                LOG.assertTrue(this.myTokenType != null);
                LOG.assertTrue(this.myState != null);
            }
        }
        int state = this.myState.getCode();
        if (!this.insideHtmlText) {
            state += NOT_IN_HTML_STATE_CONSTANT;
        }
        if (this.inPhp) {
            state += IN_PHP_STATE_CONSTANT;
        }
        return state;
    }

    public static int getMaximumState() {
        return MAX_STATE_CONSTANT;
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenType;
    }

    public int getTokenStart() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenEnd;
    }

    public void advance() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        this.myTokenType = null;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            BladeCustomizedLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    protected void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        this.myTokenStart = this.myTokenEnd;
        if (this.myTokenStart >= this.myBufferEnd) {
            this.myTokenType = null;
            return;
        }
        this.myState = this.myNextState;
        switch (this.myState) {
            case ESCAPED_TEXT_BLOCK: {
                if (BladeCustomizedLexer.isDelimiterReasonable(this.myEscapedTextBlockEndDelimiter)) {
                    this.matchInTextBlock(this.myEscapedTextBlockEndDelimiter, BladeTokenTypes.ESCAPED_TEXT_BLOCK_CONTENT, BladeTokenTypes.ESCAPED_TEXT_BLOCK_END);
                    return;
                }
            }
            case TEXT_BLOCK: {
                if (BladeCustomizedLexer.isDelimiterReasonable(this.myTextBlockEndDelimiter)) {
                    this.matchInTextBlock(this.myTextBlockEndDelimiter, BladeTokenTypes.TEXT_BLOCK_CONTENT, BladeTokenTypes.TEXT_BLOCK_END);
                    return;
                }
            }
            case RAW_TEXT_BLOCK: {
                if (BladeCustomizedLexer.isDelimiterReasonable(this.myRawTextBlockEndDelimiter)) {
                    this.matchInTextBlock(this.myRawTextBlockEndDelimiter, BladeTokenTypes.RAW_TEXT_BLOCK_CONTENT, BladeTokenTypes.RAW_TEXT_BLOCK_END);
                    return;
                }
            }
            case AFTER_DIRECTIVE: {
                if (!this.handleAfterDirective()) break;
                return;
            }
            case AFTER_PHP_DIRECTIVE: {
                this.handleAfterDirective();
                if (this.myNextState == State.IN_DIRECTIVE_PARAMETERS) {
                    return;
                }
                this.myNextState = State.AFTER_PHP_DIRECTIVE;
                if (!this.handleAfterPhpDirective()) break;
                return;
            }
            case IN_DIRECTIVE_PARAMETERS: {
                if (!this.handleInDirectiveParameters()) break;
                return;
            }
            case YYINITIAL: {
                if (!this.handleInitial()) break;
                return;
            }
        }
        this.myTokenEnd = this.myTokenStart + 1;
        this.myTokenType = BladeTokenTypes.BAD_CHARACTER;
        this.myNextState = State.YYINITIAL;
    }

    private boolean handleInitial() {
        int bestLength = 0;
        Matcher bestMatcher = null;
        if (this.inPhp) {
            int currentTokenEnd = this.myPhpLexer.getTokenEnd();
            this.advancePhpLexer(this.myPhpLexer, false, true);
            if (currentTokenEnd != this.myPhpLexer.getTokenEnd()) {
                return this.setMatchBasedOnPhpLexer();
            }
        }
        for (Matcher matcher : this.myInitialMatchers) {
            int length = matcher.match();
            if (length <= bestLength) continue;
            bestLength = length;
            bestMatcher = matcher;
        }
        if (bestMatcher == null) {
            if (this.inPhp) {
                this.advancePhpLexer(this.myPhpLexer, true, true);
                return this.setMatchBasedOnPhpLexer();
            }
            if (!this.inPhp && !this.insideHtmlText) {
                char firstChar = this.myBuffer.charAt(this.myTokenStart);
                if (firstChar == ' ' || firstChar == '\n' || firstChar == '\r' || firstChar == '\t') {
                    return this.setMatch(this.myTokenStart + 1, BladeTokenTypes.WHITESPACE);
                }
                this.insideHtmlText = true;
            }
            if (!this.inPhp && this.insideHtmlText) {
                int offset;
                for (offset = this.myTokenStart; offset < this.myBufferEnd && !this.isSuspiciousChar(this.myBuffer.charAt(offset)); ++offset) {
                }
                if (offset > this.myTokenStart) {
                    return this.setMatch(offset, BladeTokenTypes.TEMPLATE_HTML_TEXT);
                }
            }
            return this.setMatch(this.myTokenStart + 1, this.inPhp ? BladeTokenTypes.TEMPLATE_PHP_TEXT : BladeTokenTypes.TEMPLATE_HTML_TEXT);
        }
        this.myTokenEnd = this.myTokenStart + bestLength;
        bestMatcher.apply(bestLength);
        return true;
    }

    private boolean isSuspiciousChar(char c) {
        for (char aChar : this.myHtmlStopChars) {
            if (aChar != c) continue;
            return true;
        }
        return false;
    }

    private boolean setMatchBasedOnPhpLexer() {
        IElementType type = this.myPhpLexer.getTokenType();
        if (type == PhpTokenTypes.HTML) {
            this.finishPhpPart();
            this.insideHtmlText = true;
            return this.setMatch(this.myPhpLexer.getTokenEnd(), BladeTokenTypes.TEMPLATE_HTML_TEXT);
        }
        if (type == PhpTokenTypes.PHP_CLOSING_TAG) {
            this.finishPhpPart();
        }
        return this.setMatch(this.myPhpLexer.getTokenEnd(), BladeTokenTypes.TEMPLATE_PHP_TEXT);
    }

    private void startPhpPart() {
        this.inPhp = true;
        this.myPhpLexer = this.initializePhpLexerFromCurrentState();
    }

    private PhpLexer initializePhpLexerFromCurrentState() {
        PhpLexer lexer = new PhpLexer(false);
        lexer.start(this.myBuffer, this.myTokenStart, this.myBufferEnd);
        return lexer;
    }

    private void finishPhpPart() {
        this.inPhp = false;
    }

    private void advancePhpLexer(PhpLexer phpLexer, boolean atLeastOnce, boolean validateStateFromTheEnd) {
        if (this.myTokenStart != (validateStateFromTheEnd ? phpLexer.getTokenEnd() : phpLexer.getTokenStart())) {
            LOG.error("Blade lexing problem. Please report the problem to JetBrains with the file attached.", new Throwable(), new Attachment[]{new Attachment("problem.blade.php", this.myBuffer.subSequence(0, this.myBufferEnd).toString())});
        }
        if (atLeastOnce || BladeCustomizedLexer.isPhpLexerStateUnresetable(phpLexer)) {
            phpLexer.advance();
        }
    }

    private static boolean isPhpLexerStateUnresetable(PhpLexer lexer) {
        int state = lexer.getDelegate().getState();
        return state != 3 && state % 2 == 1 && lexer.getTokenEnd() < lexer.getBufferEnd();
    }

    private boolean handleInDirectiveParameters() {
        int offset = this.myTokenStart;
        char c = this.myBuffer.charAt(offset);
        if (c == '(') {
            ++this.directiveParenCounter;
            if (this.directiveParenCounter == 1) {
                return this.setMatch(offset + 1, BladeTokenTypes.DIRECTIVE_LBRACE);
            }
            return this.setMatch(offset + 1, BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
        }
        if (c == ')') {
            --this.directiveParenCounter;
            if (this.directiveParenCounter <= 0) {
                this.myNextState = State.YYINITIAL;
                return this.setMatch(offset + 1, BladeTokenTypes.DIRECTIVE_RBRACE);
            }
            return this.setMatch(offset + 1, BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
        }
        while (++offset < this.myBufferEnd && (c = this.myBuffer.charAt(offset)) != '(' && c != ')') {
        }
        return this.setMatch(offset, BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
    }

    private boolean handleAfterDirective() {
        char c;
        int offset = this.myTokenStart;
        do {
            c = this.myBuffer.charAt(offset);
        } while (++offset < this.myBufferEnd && Character.isWhitespace(c));
        if (c == '(' || c == ')') {
            this.myNextState = State.IN_DIRECTIVE_PARAMETERS;
            this.directiveParenCounter = 0;
        } else {
            this.myNextState = State.YYINITIAL;
        }
        return this.setMatch(offset == this.myBufferEnd && Character.isWhitespace(c) ? offset : offset - 1, BladeTokenTypes.WHITESPACE);
    }

    private boolean handleAfterPhpDirective() {
        int offset;
        for (offset = this.myTokenStart; offset < this.myBufferEnd && Character.isWhitespace(this.myBuffer.charAt(offset)); ++offset) {
        }
        if (offset > this.myTokenStart) {
            return this.setMatch(offset, BladeTokenTypes.WHITESPACE);
        }
        while (offset < this.myBufferEnd && !this.bufferMatches(offset, "@endphp")) {
            ++offset;
        }
        if (offset == this.myTokenStart) {
            this.myState = State.YYINITIAL;
            return this.handleInitial();
        }
        if (this.bufferMatches(offset, "@endphp")) {
            while (offset > this.myTokenStart && Character.isWhitespace(this.myBuffer.charAt(offset - 1))) {
                --offset;
            }
        }
        this.myNextState = State.YYINITIAL;
        return this.setMatch(offset, BladeTokenTypes.PHP_DIRECTIVE_CONTENT);
    }

    private boolean bufferMatches(int offset, String text) {
        if (offset > this.myBufferEnd - text.length()) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (this.myBuffer.charAt(offset + i) == text.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void matchInTextBlock(String endDelimiter, IElementType contentType, IElementType endType) {
        int offset;
        if (CharArrayUtil.regionMatches((CharSequence)this.myBuffer, (int)this.myTokenStart, (int)this.myBufferEnd, (CharSequence)endDelimiter)) {
            this.setMatch(this.myTokenStart + endDelimiter.length(), endType);
            this.myNextState = State.YYINITIAL;
            return;
        }
        for (offset = this.myTokenStart + 1; offset < this.myBufferEnd && !CharArrayUtil.regionMatches((CharSequence)this.myBuffer, (int)offset, (int)this.myBufferEnd, (CharSequence)endDelimiter); ++offset) {
        }
        this.setMatch(offset, contentType);
    }

    private boolean setMatch(int endOffset, IElementType tokenType) {
        this.myTokenEnd = endOffset;
        this.myTokenType = tokenType;
        return true;
    }

    static {
        int max = 0;
        for (State state : State.values()) {
            max = Math.max(max, state.code);
        }
        IN_PHP_STATE_CONSTANT = max + 1;
        NOT_IN_HTML_STATE_CONSTANT = IN_PHP_STATE_CONSTANT * 2;
        MAX_STATE_CONSTANT = max + IN_PHP_STATE_CONSTANT + NOT_IN_HTML_STATE_CONSTANT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/lexer/BladeCustomizedLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/lexer/BladeCustomizedLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SomeTextBlockMatcher
    implements Matcher {
        private final String prefix;
        private final IElementType type;
        private final State newState;

        private SomeTextBlockMatcher(String prefix, IElementType type, State newState) {
            this.prefix = prefix;
            this.type = type;
            this.newState = newState;
        }

        @Override
        public int match() {
            if (CharArrayUtil.regionMatches((CharSequence)BladeCustomizedLexer.this.myBuffer, (int)BladeCustomizedLexer.this.myTokenStart, (int)BladeCustomizedLexer.this.myBufferEnd, (CharSequence)this.prefix)) {
                if (BladeCustomizedLexer.this.myTokenStart > 0 && BladeCustomizedLexer.this.myBuffer.charAt(BladeCustomizedLexer.this.myTokenStart - 1) == '@') {
                    return -1;
                }
                return this.prefix.length();
            }
            return -1;
        }

        @Override
        public void apply(int length) {
            BladeCustomizedLexer.this.finishPhpPart();
            BladeCustomizedLexer.this.insideHtmlText = false;
            BladeCustomizedLexer.this.myNextState = this.newState;
            BladeCustomizedLexer.this.myTokenType = this.type;
        }

        @Override
        public void registerHtmlStopChars(Collection<Character> chars) {
            chars.add(Character.valueOf(this.prefix.charAt(0)));
        }
    }

    private class PhpFinalMatcher
    implements Matcher {
        @NonNls
        private final String[] parts = new String[]{"?>", "__halt_compiler();", "%>"};

        private PhpFinalMatcher() {
        }

        @Override
        public int match() {
            for (String part : this.parts) {
                if (!CharArrayUtil.regionMatches((CharSequence)BladeCustomizedLexer.this.myBuffer, (int)BladeCustomizedLexer.this.myTokenStart, (int)BladeCustomizedLexer.this.myBufferEnd, (CharSequence)part)) continue;
                return part.length();
            }
            return -1;
        }

        @Override
        public void apply(int length) {
            if (BladeCustomizedLexer.this.inPhp) {
                BladeCustomizedLexer.this.finishPhpPart();
                BladeCustomizedLexer.this.insideHtmlText = false;
                BladeCustomizedLexer.this.myTokenType = BladeTokenTypes.TEMPLATE_PHP_TEXT;
            } else {
                BladeCustomizedLexer.this.myTokenType = BladeTokenTypes.TEMPLATE_HTML_TEXT;
            }
        }

        @Override
        public void registerHtmlStopChars(Collection<Character> chars) {
            for (String part : this.parts) {
                chars.add(Character.valueOf(part.charAt(0)));
            }
        }
    }

    private class PhpBeginningMatcher
    implements Matcher {
        private final String[] parts = new String[]{"<?=", "<%=", "<?"};

        private PhpBeginningMatcher() {
        }

        @Override
        public int match() {
            for (String part : this.parts) {
                if (!CharArrayUtil.regionMatches((CharSequence)BladeCustomizedLexer.this.myBuffer, (int)BladeCustomizedLexer.this.myTokenStart, (int)BladeCustomizedLexer.this.myBufferEnd, (CharSequence)part)) continue;
                PhpLexer phpLexer = BladeCustomizedLexer.this.initializePhpLexerFromCurrentState();
                int start = BladeCustomizedLexer.this.myTokenStart;
                BladeCustomizedLexer.this.advancePhpLexer(phpLexer, true, false);
                return phpLexer.getTokenEnd() - start;
            }
            return -1;
        }

        @Override
        public void apply(int length) {
            BladeCustomizedLexer.this.startPhpPart();
            BladeCustomizedLexer.this.advancePhpLexer(BladeCustomizedLexer.this.myPhpLexer, true, false);
            BladeCustomizedLexer.this.insideHtmlText = false;
            BladeCustomizedLexer.this.myTokenType = BladeTokenTypes.TEMPLATE_PHP_TEXT;
        }

        @Override
        public void registerHtmlStopChars(Collection<Character> chars) {
            for (String part : this.parts) {
                chars.add(Character.valueOf(part.charAt(0)));
            }
        }
    }

    private class DirectiveMatcher
    implements Matcher {
        private final Set<String> myDirectives;

        private DirectiveMatcher(Set<String> directives) {
            this.myDirectives = directives;
        }

        @Override
        public int match() {
            String directiveText;
            int offset = BladeCustomizedLexer.this.myTokenStart;
            char c = BladeCustomizedLexer.this.myBuffer.charAt(offset);
            if (c != '@') {
                return -1;
            }
            while (++offset < BladeCustomizedLexer.this.myBufferEnd && ((c = BladeCustomizedLexer.this.myBuffer.charAt(offset)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-')) {
            }
            if (offset > BladeCustomizedLexer.this.myTokenStart && !this.myDirectives.contains((directiveText = BladeCustomizedLexer.this.myBuffer.subSequence(BladeCustomizedLexer.this.myTokenStart, offset).toString()).toLowerCase(Locale.ENGLISH))) {
                return -1;
            }
            return offset - BladeCustomizedLexer.this.myTokenStart;
        }

        @Override
        public void apply(int length) {
            String directiveText = BladeCustomizedLexer.this.myBuffer.subSequence(BladeCustomizedLexer.this.myTokenStart, BladeCustomizedLexer.this.myTokenEnd).toString();
            BladeCustomizedLexer.this.finishPhpPart();
            BladeCustomizedLexer.this.insideHtmlText = false;
            IElementType result = BladeTokenSets.getDirectiveType(directiveText);
            if (result == BladeTokenTypes.PHP_DIRECTIVE) {
                BladeCustomizedLexer.this.myNextState = State.AFTER_PHP_DIRECTIVE;
            } else {
                BladeCustomizedLexer.this.myNextState = State.AFTER_DIRECTIVE;
            }
            BladeCustomizedLexer.this.myTokenType = result == null ? BladeTokenTypes.CUSTOM_DIRECTIVE : result;
        }

        @Override
        public void registerHtmlStopChars(Collection<Character> chars) {
            chars.add(Character.valueOf('@'));
        }
    }

    private class CommentMatcher
    implements Matcher {
        public static final String START_DELIMITER = "{{--";

        private CommentMatcher() {
        }

        @Override
        public int match() {
            int offset = BladeCustomizedLexer.this.myTokenStart;
            String startDelimiter = START_DELIMITER;
            String endDelimiter = "--}}";
            if (CharArrayUtil.regionMatches((CharSequence)BladeCustomizedLexer.this.myBuffer, (int)offset, (int)BladeCustomizedLexer.this.myBufferEnd, (CharSequence)startDelimiter)) {
                offset += startDelimiter.length();
                char firstCharInSuffix = endDelimiter.charAt(0);
                while (offset < BladeCustomizedLexer.this.myBufferEnd) {
                    char c = BladeCustomizedLexer.this.myBuffer.charAt(offset);
                    if (c == firstCharInSuffix && CharArrayUtil.regionMatches((CharSequence)BladeCustomizedLexer.this.myBuffer, (int)offset, (int)BladeCustomizedLexer.this.myBufferEnd, (CharSequence)endDelimiter)) {
                        return offset + endDelimiter.length() - BladeCustomizedLexer.this.myTokenStart;
                    }
                    ++offset;
                }
                return BladeCustomizedLexer.this.myBufferEnd - BladeCustomizedLexer.this.myTokenStart;
            }
            return -1;
        }

        @Override
        public void apply(int length) {
            BladeCustomizedLexer.this.finishPhpPart();
            BladeCustomizedLexer.this.insideHtmlText = false;
            BladeCustomizedLexer.this.myTokenType = BladeTokenTypes.COMMENT;
        }

        @Override
        public void registerHtmlStopChars(Collection<Character> chars) {
            chars.add(Character.valueOf(START_DELIMITER.charAt(0)));
        }
    }

    private static interface Matcher {
        public int match();

        public void apply(int var1);

        public void registerHtmlStopChars(Collection<Character> var1);
    }

    private static enum State {
        YYINITIAL(0),
        TEXT_BLOCK(2),
        ESCAPED_TEXT_BLOCK(4),
        RAW_TEXT_BLOCK(6),
        AFTER_DIRECTIVE(8),
        IN_DIRECTIVE_PARAMETERS(10),
        AFTER_PHP_DIRECTIVE(12);

        private final int code;

        private State(int code) {
            this.code = code;
        }

        static State getByCode(int code, int initialCode) throws IllegalStateException {
            for (State state : State.values()) {
                if (code != state.code) continue;
                return state;
            }
            LOG.error("Unexpected code " + code + ", initial code " + initialCode);
            throw new IllegalStateException("Unexpected code " + code + ", initial code " + initialCode);
        }

        public int getCode() {
            return this.code;
        }
    }
}

