require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_AARCH64_PTRACE_H_)) {
    eval 'sub _AARCH64_PTRACE_H_ () {1;}' unless defined(&_AARCH64_PTRACE_H_);
    if(defined(&__aarch64__)) {
	eval 'sub PT_GETREGS () {( &PT_FIRSTMACH + 0);}' unless defined(&PT_GETREGS);
	eval 'sub PT_SETREGS () {( &PT_FIRSTMACH + 1);}' unless defined(&PT_SETREGS);
	eval 'sub PT_GETFPREGS () {( &PT_FIRSTMACH + 2);}' unless defined(&PT_GETFPREGS);
	eval 'sub PT_SETFPREGS () {( &PT_FIRSTMACH + 3);}' unless defined(&PT_SETFPREGS);
	eval 'sub PT_STEP () {( &PT_FIRSTMACH + 4);}' unless defined(&PT_STEP);
	eval 'sub PT_SETSTEP () {( &PT_FIRSTMACH + 5);}' unless defined(&PT_SETSTEP);
	eval 'sub PT_CLEARSTEP () {( &PT_FIRSTMACH + 6);}' unless defined(&PT_CLEARSTEP);
	eval 'sub PT_MACHDEP_STRINGS () {"PT_GETREGS", "PT_SETREGS", "PT_GETFPREGS", "PT_SETFPREGS", "PT_STEP", "PT_SETSTEP", "PT_CLEARSTEP",;}' unless defined(&PT_MACHDEP_STRINGS);
	require 'machine/reg.ph';
	eval 'sub PTRACE_REG_PC {
	    my($r) = @_;
    	    eval q(($r)-> &r_pc);
	}' unless defined(&PTRACE_REG_PC);
	eval 'sub PTRACE_REG_FP {
	    my($r) = @_;
    	    eval q(($r)-> $r_reg[29]);
	}' unless defined(&PTRACE_REG_FP);
	eval 'sub PTRACE_REG_SET_PC {
	    my($r, $v) = @_;
    	    eval q(($r)-> &r_pc = ($v));
	}' unless defined(&PTRACE_REG_SET_PC);
	eval 'sub PTRACE_REG_SP {
	    my($r) = @_;
    	    eval q(($r)-> &r_sp);
	}' unless defined(&PTRACE_REG_SP);
	eval 'sub PTRACE_REG_INTRV {
	    my($r) = @_;
    	    eval q(($r)-> $r_reg[0]);
	}' unless defined(&PTRACE_REG_INTRV);
	eval 'sub PTRACE_BREAKPOINT () {(( &const  $uint8_t[]) { 0xa0, 0x1, 0x20, 0xd4 });}' unless defined(&PTRACE_BREAKPOINT);
	eval 'sub PTRACE_BREAKPOINT_ASM () { &__asm  &__volatile("brk #13" ::: "memory");}' unless defined(&PTRACE_BREAKPOINT_ASM);
	eval 'sub PTRACE_BREAKPOINT_SIZE () {4;}' unless defined(&PTRACE_BREAKPOINT_SIZE);
	if(defined(&_KERNEL_OPT)) {
	    require './aarch64/opt_compat_netbsd32.ph';
	}
	if(defined(&COMPAT_NETBSD32)) {
	    require 'machine/netbsd32_machdep.ph';
	    eval 'sub process_read_regs32 () { &netbsd32_process_read_regs;}' unless defined(&process_read_regs32);
	    eval 'sub process_read_fpregs32 () { &netbsd32_process_read_fpregs;}' unless defined(&process_read_fpregs32);
	    eval 'sub process_write_regs32 () { &netbsd32_process_write_regs;}' unless defined(&process_write_regs32);
	    eval 'sub process_write_fpregs32 () { &netbsd32_process_write_fpregs;}' unless defined(&process_write_fpregs32);
	    eval 'sub process_reg32 () {\'struct reg32\';}' unless defined(&process_reg32);
	    eval 'sub process_fpreg32 () {\'struct fpreg32\';}' unless defined(&process_fpreg32);
	    eval 'sub PTRACE_TRANSLATE_REQUEST32 {
	        my($x) = @_;
    		eval q( &netbsd32_ptrace_translate_request($x));
	    }' unless defined(&PTRACE_TRANSLATE_REQUEST32);
	}
    }
 elsif(defined(&__arm__)) {
	require 'arm/ptrace.ph';
    }
}
1;
